package avatar.ui
{
	import avatar.CItem;
	import avatar.CUser;
	import avatar.KConsts;
	
	import fl.containers.ScrollPane;
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;

	public class CBuyEntry extends MovieClip
	{
		[Embed(source="../objects/content/AvatarShop.swf", symbol="BuyEntry")]
		private var BuyEntryClass:Class;

		private var m_screen:MovieClip;
		private var m_scrollPane:ScrollPane;
		private var m_item:CItem;
		
		public function get item():CItem	{	return m_item;	}
		
		public function CBuyEntry( _item:CItem )
		{
			m_item 		= _item;
			// create screen
			m_screen 	= new BuyEntryClass() as MovieClip;
			
			m_screen.m_itemId.text = m_item.id;
			
			
			m_screen.m_jojuCoins.text = m_item.jojuCoins;
			m_screen.m_coins.text = m_item.coins;
			
			m_screen.m_attribute1.text = "speed " + m_item.attribute1;
			m_screen.m_attribute2.text = "armor " + m_item.attribute2;
			
			var currentUserItem:CItem = CUser.instance().getItemByCategory( m_item.categoryId );

			var improvement1:int = m_item.attribute1 - currentUserItem.attribute1;			 			
			if ( 0 >=  improvement1 )
			{
				m_screen.m_improvement1.text = "(" + improvement1.toString() + ")";	
			}
			else
			{
				m_screen.m_improvement1.text = "(+" + improvement1.toString() + ")";
			}
			var improvement2:int = m_item.attribute2 - currentUserItem.attribute2;
			if ( 0 >= improvement2 )
			{
				m_screen.m_improvement2.text = "(" + improvement2.toString() + ")";	
			}
			else
			{
				m_screen.m_improvement2.text = "(+" + improvement2.toString() + ")";
			}										
			this.addChild( m_screen );
			
			if ( CUser.instance().coins >= m_item.coins && CUser.instance().jojuCoins >= m_item.jojuCoins )
			{
				m_screen.m_buyBtn.addEventListener( MouseEvent.MOUSE_DOWN, onBuyMouseDown );
			}
			else
			{
				m_screen.m_buyBtn.enabled = false;				
			}
			
		}		
		
		private function onBuyMouseDown( _event:MouseEvent ):void
		{
//			if ( CUser.instance().coins >= m_item.coins && CUser.instance().jojuCoins >= m_item.jojuCoins )
//			{
//				trace( "buy" );
				CUser.instance().coins 		= CUser.instance().coins -  m_item.coins;
				CUser.instance().jojuCoins	= CUser.instance().jojuCoins - m_item.jojuCoins;
				dispatchEvent( new Event( KConsts.ItemBought ) );
//			}
//			else
//			{
//				trace( "item to expensive" );
//			}
		}
	}
}