package avatar.ui
{
	import avatar.CItem;
	import avatar.CItemsManager;
	import avatar.CUser;
	import avatar.KConsts;
	
	import fl.containers.ScrollPane;
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;

	public class CAvatarShop extends MovieClip
	{
		[Embed(source="../objects/content/AvatarShop.swf", symbol="AvatarShop")]
		private var AvatarShopClass:Class;

		[Embed(source="../objects/content/AvatarShop.swf", symbol="ThankYou")]
		private var ThankYouClass:Class;

		private var m_screen:MovieClip;
		private var m_thankYou:MovieClip;
		private var m_scrollPane:ScrollPane;
		private var m_buyEntries:MovieClip;
		private var m_lastItemBought:CItem;
		
		public function CAvatarShop()
		{
			// create screen
			m_screen = new AvatarShopClass() as MovieClip;
			// create scroll pane, put it in place of holder
			m_scrollPane = new ScrollPane();			
			setHolderProperties( m_screen.m_scrollPaneHolder, m_scrollPane );
			
			m_buyEntries = new MovieClip();			
//			m_scrollPane.source = m_buyEntries;			
			this.addChild( m_screen );			
			
			m_thankYou = new ThankYouClass() as MovieClip;
			m_thankYou.visible = false;
			m_thankYou.m_yesBtn.addEventListener( MouseEvent.MOUSE_DOWN, onYesBtnMouseDown );
			m_thankYou.m_noBtn.addEventListener( MouseEvent.MOUSE_DOWN, onNoBtnMouseDown );
			m_lastItemBought = null;
			this.addChild( m_thankYou );
			
			super();			
			m_screen.m_backBtn.addEventListener( MouseEvent.MOUSE_DOWN, onBackBtnMouseDown );
		}
		
		private function onYesBtnMouseDown( _event:MouseEvent ):void
		{
			CUser.instance().setCurrentItem( m_lastItemBought );
			m_thankYou.visible = false;
		}		
		
		private function onNoBtnMouseDown( _event:MouseEvent ):void
		{
			m_thankYou.visible = false;
		}		
		
		private function onBackBtnMouseDown( _event:MouseEvent ):void
		{
			this.dispatchEvent( new Event( KConsts.BackToConfig ) );
		}		
		
		private function setHolderProperties( _holder:Object, _control:Object ):void
		{
			_control.x		= _holder.x;
			_control.y		= _holder.y;
			_control.width	= _holder.width;
			_control.height = _holder.height;
			_holder.parent.addChild( _control );			
		}
		
		public function populateList():void
		{			
			while ( 0 < m_buyEntries.numChildren )
			{
				m_buyEntries.removeChildAt( 0 );
			}
			var counterY:int = 0;		
			for ( var index:int = 0; index < CItemsManager.instance().itemCount; index++ )
			{
				var item:CItem = CItemsManager.instance().getItem( index );
				if ( item.isCloth && !CUser.instance().canUse( item.id ) )
				{
					var buyEntry:CBuyEntry = new CBuyEntry( CItemsManager.instance().getItem( index ) );
					buyEntry.addEventListener( KConsts.ItemBought, onItemBought );
					buyEntry.y = counterY;
					counterY += buyEntry.height + 1;
					m_buyEntries.addChild( buyEntry );
				}			
			}
			m_scrollPane.source = m_buyEntries;
			m_screen.m_jojuCoins.text = CUser.instance().jojuCoins;
			m_screen.m_coins.text = CUser.instance().coins;
		}	
		
		private function onItemBought( _event:Event ):void
		{			
			var item:CItem = _event.currentTarget.item;
			CUser.instance().addItem( item.id );
			m_lastItemBought = item;
			populateList();
			m_thankYou.visible = true;
		}
	}
}