package avatar.ui
{
	import avatar.CItem;
	import avatar.CItemsManager;
	import avatar.CUser;
	import avatar.KConsts;
	
	import fl.controls.TileList;
	import fl.events.ListEvent;
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;

	public class CAvatarConfig extends MovieClip
	{
		[Embed(source="../objects/content/AvatarConfig.swf", symbol="AvatarConfig")]
		private var AvatarConfigClass:Class;

		private var m_screen:MovieClip;
		private var m_tileList:TileList;
		private var m_selectedItemIndex:int;
		private var m_mouseIsDown:Boolean;
		
		public function set selectedItemIndex( _index:int ):void	{	m_selectedItemIndex = _index;	}
		public function set mouseIsDown( _isDown:Boolean ):void		{	m_mouseIsDown = _isDown;		}
		
		public function get selectedItemIndex():int					{	return m_selectedItemIndex;		}
		
		public function get selectedItem():CItem
		{	
			if ( -1 != m_selectedItemIndex )
			{
				return m_tileList.getItemAt( m_selectedItemIndex ).data as CItem;
			}
			return null;				
		}
		
		public function CAvatarConfig()
		{
			// create screen
			m_screen = new AvatarConfigClass() as MovieClip;
			// create scroll pane, put it in place of holder
			m_tileList = new TileList();
//			m_tileList.columnWidth	= 100;
//			m_tileList.rowHeight 	= 100;
			setHolderProperties( m_screen.m_tileListHolder, m_tileList );
			
			this.addChild( m_screen );			
			super();
			
			m_selectedItemIndex = -1;
			m_mouseIsDown		= false;						
			m_tileList.addEventListener( ListEvent.ITEM_ROLL_OVER, onItemRollOver );
			m_tileList.addEventListener( ListEvent.ITEM_ROLL_OUT, onItemRollOut );			
			m_tileList.addEventListener( MouseEvent.MOUSE_DOWN, onListMouseDown ); 
//			m_tileList.addEventListener( ListEvent.ITEM_CLICK, onItemMouseClick );	

			m_screen.m_shopBtn.addEventListener( MouseEvent.MOUSE_DOWN, onShopBtnMouseDown );
		}
		
		private function onShopBtnMouseDown( _event:MouseEvent ):void
		{
			this.dispatchEvent( new Event( KConsts.GoToShop ) );
		}	
		
		private function setHolderProperties( _holder:Object, _control:Object ):void
		{
			_control.x		= _holder.x;
			_control.y		= _holder.y;
			_control.width	= _holder.width;
			_control.height = _holder.height;
			_holder.parent.addChild( _control );			
		}
		
		private function addItem( _item:CItem ):void
		{
			m_tileList.addItem( { label:_item.id, source:_item.thumbnailPath, data:_item } );						
		}
		
		private function onListMouseDown( _event:MouseEvent ):void
		{
			m_mouseIsDown = true;
		}

		private function onItemRollOver( _event:ListEvent ):void
		{
			if ( !m_mouseIsDown )
			{
				m_selectedItemIndex = _event.index;
//				trace ( m_selectedItemIndex );
			}
		}

		private function onItemRollOut( _event:ListEvent ):void
		{
			if ( !m_mouseIsDown )
			{
				m_selectedItemIndex = -1;
//				trace ( m_selectedItemIndex );
			}
		}
		
		public function populateList():void
		{
			m_tileList.removeAll();
			for ( var index:int = 0; index < CItemsManager.instance().itemCount; index++ )
			{
				var item:CItem = CItemsManager.instance().getItem( index );
				if ( item.isCloth && CUser.instance().canUse( item.id ) )
				{
					addItem( item );
				}			
			}
		}
		
//		private function onItemMouseClick( _event:ListEvent ):void
//		{
//			trace( _event.index );
//		}
		
	}
}