package avatar
{
	public class CUser
	{
		private static var 	s_instance:CUser = null;
		
		private var m_allowedItems:Array;
		private var m_currentItems:Array;
		private var m_coins:int;
		private var m_jojuCoins:int;
				
		public static function instance():CUser	{	return s_instance;	}
		
		public function get coins():int				{	return m_coins;			}
		public function get jojuCoins():int			{	return m_jojuCoins;		}

		public function set coins( _coins:int ):void		{	m_coins		= _coins;	}
		public function set jojuCoins( _coins:int ):void	{	m_jojuCoins	= _coins;	}
		
		public function CUser()
		{
			s_instance		= this;
			m_allowedItems	= new Array();
			for each ( var id:String in KConsts.CategoryList )
			{
				for ( var i:int = 0; i < KConsts.TotalSkins - 1; i++ )
				{
					m_allowedItems.push( id + i );
				}	
			}			
			m_currentItems	= new Array();			
			for each ( var id2:String in KConsts.CategoryList )
			{
				m_currentItems[ id2 ] = CItemsManager.instance().getItemById( id2 + 0 );
			}			
			m_coins 	= 3;
			m_jojuCoins	= 3;
		}
		
		public function getItemByCategory( _categoryId:String ):CItem
		{
			if ( null != m_currentItems[ _categoryId ] )
			{
				return m_currentItems[ _categoryId ];
			}
			return null;
		}
		
		public function canUse( _itemId:String ):Boolean
		{
			return -1 != m_allowedItems.lastIndexOf( _itemId );
		}
		
		public function addItem( _itemId:String ):void
		{
			m_allowedItems.push( _itemId );
		}
		
		public function setCurrentItem( _item:CItem ):void
		{
			m_currentItems[ _item.categoryId ] = _item;
		}

	}
}