package avatar
{
	import flash.events.Event;
	import flash.events.EventDispatcher;
	
	public class CItemsManager extends EventDispatcher
	{
		private static var 	s_instance:CItemsManager = null;
				
		public static function instance():CItemsManager	{	return s_instance;	}
		
		private var m_items:Array;
		
		private var m_loadIndex:int;
		
		public function get ready():Boolean					{	return m_loadIndex + 1 == m_items.length;	}
		public function get itemCount():int					{	return m_items.length;						}
		
		public function CItemsManager()
		{
			s_instance		= this;			
			// hardcoding items
			m_items = new Array();
			
			for ( var i:int = 0; i < KConsts.TotalSkins; i++ )
			{
						addItem( new CItem( KConsts.CatSkin + i, KConsts.ItemTypeBitmap, 
						 "../objects/categories/skin/" + i + ".png", KConsts.CatSkin, 
						 "../objects/categories/skin/" + i + ".png", false,
						 0, 0, 0, 0 ) );

				addItem( new CItem( KConsts.CatEyes + i, KConsts.ItemTypeBitmap, 
						 "../objects/categories/eyes/" + i + ".png", KConsts.CatEyes, 
						 "../objects/categories/eyes/" + i + ".png", false,
						  0, 0, 0, 0 ) );
										 
				addItem( new CItem( KConsts.CatMouth + i, KConsts.ItemTypeBitmap, 
						 "../objects/categories/mouth/" + i + ".png", KConsts.CatMouth,
						 "../objects/categories/mouth/" + i + ".png", false,
						 0, 0, 0, 0 ) );

				addItem( new CItem( KConsts.CatEars + i, KConsts.ItemTypeModel, 
						 "../objects/categories/ears/" + i + ".dae", KConsts.CatEars, 
						 "../objects/categories/mouth/" + i + ".png", false,
						 0, 0, 0, 0 ) );

				addItem( new CItem( KConsts.CatShirt + i, KConsts.ItemTypeBitmap, 
						 "../objects/categories/shirt/" + i + ".png", KConsts.CatShirt, 
						 "../objects/categories/shirt/" + i + ".png", true,
						 1, 0, i, i ) );
										 
				addItem( new CItem( KConsts.CatJacket + i, KConsts.ItemTypeBitmap, 
						 "../objects/categories/jacket/" + i + ".png", KConsts.CatJacket,
						 "../objects/categories/jacket/" + i + ".png",  true,
						 0, 1, i*2, i*2 ) );

				addItem( new CItem( KConsts.CatPants + i, KConsts.ItemTypeBitmap, 
						 "../objects/categories/pants/" + i + ".png", KConsts.CatPants,
						 "../objects/categories/pants/" + i + ".png",  true,
						 1, 0, 2, 2 ) );

				addItem( new CItem( KConsts.CatShoes + i, KConsts.ItemTypeBitmap, 
						 "../objects/categories/shoes/" + i + ".png", KConsts.CatShoes,
						 "../objects/categories/shoes/" + i + ".png", true,
						 1, 1, 3-i, 3-i ) );

				addItem( new CItem( KConsts.CatHat + i, KConsts.ItemTypeModel, 
						 "../objects/categories/hat/" + i + ".dae", KConsts.CatHat,
						 "../objects/categories/mouth/" + i + ".png", true,
						 1, 0, 1, i ) );

				addItem( new CItem( KConsts.CatBat + i, KConsts.ItemTypeModel, 
						 "../objects/categories/bat/" + i + ".dae", KConsts.CatBat,
						 "../objects/categories/mouth/" + i + ".png", true,
						 0, 1, i, 1 ) );
			}
		}
		
				
		public function addItem( _item:CItem ):void
		{
			m_items.push( _item );
		}
		
		public function getItemById( _id:String ):CItem
		{
			for each ( var item:CItem in m_items )
			{
				if ( _id == item.id )
				{
					return item;
				}
			}
			return null;
		}
		
		public function getItem( _index:int ):CItem
		{
			if ( _index < m_items.length )
			{
				return m_items[ _index ];
			}
			return null;
		}
		
		public function startLoading():void
		{
			if ( m_items.length > 0 )
			{
				m_loadIndex = 0;
				loadNext();
			}
		}
		
		private function loadNext():void
		{
			var item:CItem = m_items[ m_loadIndex ];
			item.addEventListener( Event.COMPLETE, onItemComplete );
			item.startLoading();
		}
		
		private function onItemComplete( _event:Event ):void
		{
			if ( m_items.length > m_loadIndex + 1 )
			{
				m_loadIndex++;
				loadNext();		
				dispatchEvent( new Event( KConsts.ItemComplete ) );		
			}			
			else
			{
				s_instance.dispatchEvent( _event );
			}
		}
	}
}