package avatar
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.net.URLRequest;
	
	import org.papervision3d.core.animation.enum.InfinityType;
	import org.papervision3d.events.FileLoadEvent;
	import org.papervision3d.objects.parsers.DAE;
	
	public class CItem extends EventDispatcher
	{
		protected var m_id:String;
		protected var m_type:String;
		protected var m_resourcePath:String;
		protected var m_thumbnailPath:String;
		protected var m_coins:int;
		protected var m_jojuCoins:int;
		protected var m_categoryId:String;
		
		protected var m_loader:Loader;
		protected var m_bitmap:Bitmap;
		protected var m_model:DAE;
		
		protected var m_attribute1:int;
		protected var m_attribute2:int;
		
		protected var m_isCloth:Boolean;
		
		public function get id():String				{	return m_id;			}
		public function get type():String			{	return m_type;			}
		public function get resourcePath():String	{	return m_resourcePath;	}
		public function get thumbnailPath():String	{	return m_thumbnailPath;	}
		public function get coins():int				{	return m_coins;			}
		public function get jojuCoins():int			{	return m_jojuCoins;		}
		public function get categoryId():String		{	return m_categoryId;	}
		public function get isCloth():Boolean		{	return m_isCloth;		}
		
		public function get bitmap():Bitmap			
		{	
			if ( null != m_bitmap )
			{
				return m_bitmap;
			}
			return new Bitmap( new BitmapData(50, 50, true, 0xffff0000 ) );		
		}
		public function get model():DAE				{	return m_model;			}

		public function get attribute1():int		{	return m_attribute1;	}
		public function get attribute2():int		{	return m_attribute2;	}
		
		public function set attribute1( _att:int ):void	{	m_attribute1 = _att;	}		
		public function set attribute2( _att:int ):void	{	m_attribute2 = _att;	}		
		
		public function CItem(	_id:String, _type:String,
								_resourcePath:String, _categoryId:String, 
								_thumbnailPath:String, _isCloth:Boolean,
								_coins:int,	_jojuCoins:int,
								_attribute1:int, _attribute2:int )
		{
			m_id 			= _id;
			m_type 			= _type;
			m_resourcePath	= _resourcePath;
			m_categoryId	= _categoryId;		
			m_isCloth		= _isCloth;
			m_thumbnailPath	= _thumbnailPath;
			m_coins 		= _coins;
			m_jojuCoins 	= _jojuCoins;
			m_attribute1	= _attribute1;
			m_attribute2	= _attribute2;
			
			m_loader		= new Loader();			
			m_loader.contentLoaderInfo.addEventListener( Event.COMPLETE, bitmapComplete );
			
			m_model 		= new DAE();			
			m_model.addEventListener( FileLoadEvent.LOAD_COMPLETE, modelLoaded );			
		}
		
		public function startLoading():void
		{
			if ( m_type == KConsts.ItemTypeBitmap  )
			{
				m_loader.load( new URLRequest( m_resourcePath ) );
			}
			else
			{
				m_model.load( m_resourcePath );
//				this.dispatchEvent( new Event( Event.COMPLETE ) );
			}
		}
		
		private function bitmapComplete( _event:Event ):void
		{			
			m_bitmap = Bitmap( m_loader.content );			
			this.dispatchEvent( _event );
		}

		private function modelLoaded( _event:Event ):void
		{			
			this.dispatchEvent( new Event( Event.COMPLETE ) );
		}		
	}
}