package avatar
{
	import avatar.KConsts;
	
	public class CCategoryManager
	{		
		private static var 	s_instance:CCategoryManager = null;
		
		public static function instance():CCategoryManager	{	return s_instance;	}
		
		private var m_categories:Array; // CCategory
		
		public function CCategoryManager()
		{
			s_instance		= this;	
			m_categories 	= new Array();
			
			// hardcoding categories. will actually populate m_categories from de database info retrieved.			
			for each ( var id:String in KConsts.CategoryList )
			{
				addCategory( new CCategory( id ) );	
			}			
		}
		
		public function addCategory( _category:CCategory ):void
		{
			m_categories.push( _category );
		}
		
		public function getCategoryById( _id:String ):CCategory
		{
			for each ( var category:CCategory in m_categories )
			{
				if ( _id == category.id )
				{
					return category;
				}
			}
			return null;
		}

	}
}