package avatar
{
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	
	import org.papervision3d.events.FileLoadEvent;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.parsers.DAE;
	
	public class CBody extends EventDispatcher
	{
//		[Embed(source="../objects/models/body.dae", mimeType="application/octet-stream")]
//		private var BodyModelClass:Class;	
		
		private var m_model:DAE;	
		private var m_materialsList:MaterialsList;
	
		public function get model():DAE	{	return m_model;	}
		
		private var m_materials:Array;
		
		private var m_items:Array;
		
		public function CBody()
		{

			m_items = new Array();

//			var defaultSkin:int = 0;			
//			for each ( var id:String in KConsts.CategoryList )
//			{
//				m_items[ id ] = CItemsManager.instance().getItemById( id + defaultSkin );
//			}
			for each ( var id:String in KConsts.CategoryList )
			{
				m_items[ id ] = CUser.instance().getItemByCategory( id );
			}
			
			m_materialsList = new MaterialsList();
			m_materialsList.addMaterial( new ColorMaterial(),	"head" );
			m_materialsList.addMaterial( new ColorMaterial(),	"jacket" );
			m_materialsList.addMaterial( new ColorMaterial(),	"pants" );
			m_materialsList.addMaterial( new ColorMaterial(),	"shoes" );
						
			m_model = new DAE();			
			m_model.addEventListener( FileLoadEvent.LOAD_COMPLETE, onModelLoaded );			
		}
		
		public function build():void
		{
			// remove previous models first if they exist
			//	bat
			var batItem:CItem = m_items[ KConsts.CatBat ];
			var batPivot:DisplayObject3D = m_model.getChildByName( "Bip01_R_Hand_PIVOT", true );
			if ( null != batItem.model.parent )
			{
				batPivot.removeChild( batItem.model );
			}			
			// hat
			var hatItem:CItem = m_items[ KConsts.CatHat ];
			var hatPivot:DisplayObject3D = m_model.getChildByName( "Bip01_Head_PIVOT", true );
			if ( null != hatItem.model.parent )
			{
				hatPivot.removeChild( hatItem.model );
			}			 
			
			// replace all items for current user items
			for each ( var id:String in KConsts.CategoryList )
			{
				m_items[ id ] = CUser.instance().getItemByCategory( id );
			}
			
			// head
			var face:CMaterial = new CMaterial( "head", new BitmapData(50, 50, true, 0xffff0000 ) );
			face.addBitmap( m_items[ KConsts.CatSkin ].bitmap );		
			face.addBitmap( m_items[ KConsts.CatEyes ].bitmap );		
			face.addBitmap( m_items[ KConsts.CatMouth ].bitmap );		
			m_model.replaceMaterialByName( face.bitmapMaterial,	face.id );
			
			// jacket
			var jacket:CMaterial = new CMaterial( "jacket", new BitmapData(50, 50, true, 0xffff0000 ) );
			jacket.addBitmap( m_items[ KConsts.CatSkin ].bitmap );		
			jacket.addBitmap( m_items[ KConsts.CatShirt ].bitmap );		
			jacket.addBitmap( m_items[ KConsts.CatJacket ].bitmap );		
			m_model.replaceMaterialByName( jacket.bitmapMaterial,	jacket.id );
			
			// pants
			var pants:CMaterial = new CMaterial( "pants", new BitmapData(50, 50, true, 0xffff0000 ) );
			pants.addBitmap( m_items[ KConsts.CatSkin ].bitmap );		
			pants.addBitmap( m_items[ KConsts.CatPants ].bitmap );		
			m_model.replaceMaterialByName( pants.bitmapMaterial,	pants.id );

			// shoes
			var shoes:CMaterial = new CMaterial( "shoes", new BitmapData(50, 50, true, 0xffff0000 ) );
			shoes.addBitmap( m_items[ KConsts.CatSkin ].bitmap );		
			shoes.addBitmap( m_items[ KConsts.CatShoes ].bitmap );		
			m_model.replaceMaterialByName( shoes.bitmapMaterial,	shoes.id );

			// bat
			batItem = m_items[ KConsts.CatBat ];
			batPivot.addChild( batItem.model );

			//	hat
			hatItem = m_items[ KConsts.CatHat ];
			hatPivot.addChild( hatItem.model );			
		}
		
		public function startLoading():void
		{
//			var data:ByteArray = new BodyModelClass();
//			m_model.load( data , m_materialsList );
			m_model.load( "../objects/models/body.dae" , m_materialsList );
		}
		
		protected function onModelLoaded( _event:Event ):void
		{
			build();
			this.dispatchEvent( new Event( Event.COMPLETE ) );
			
			var do3d:DisplayObject3D = m_model.getChildByName( "po", true );
			do3d.addEventListener( InteractiveScene3DEvent.OBJECT_RELEASE, onObject3DMouseUp );
			do3d.addEventListener( InteractiveScene3DEvent.OBJECT_OVER, onObject3DMouseOver );
			do3d.addEventListener( InteractiveScene3DEvent.OBJECT_OUT, onObject3DMouseOut );
		}

		protected function onObject3DMouseUp( _event:InteractiveScene3DEvent ):void
		{
			dispatchEvent( new Event( KConsts.BodyMouseUp ) );			
		}
		
		protected function onObject3DMouseOver( _event:InteractiveScene3DEvent ):void
		{
			dispatchEvent( new Event( KConsts.BodyMouseOver ) );
		}

		protected function onObject3DMouseOut( _event:InteractiveScene3DEvent ):void
		{
			dispatchEvent( new Event( KConsts.BodyMouseOut ) );
		}


	}
}