package {
	import avatar.CBody;
	import avatar.CCategoryManager;
	import avatar.CItem;
	import avatar.CItemsManager;
	import avatar.CUser;
	import avatar.KConsts;
	import avatar.ui.CAvatarConfig;
	import avatar.ui.CAvatarShop;
	
	import flash.display.MovieClip;
	import flash.events.*;
	
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.stats.StatsView;


	[SWF(width="660", height="528", backgroundColor="#FFFFFF", frameRate='30')]
	public class Main extends BasicView
	{
		[Embed(source="./objects/content/AvatarUI.swf", symbol="AvatarUI")]
		protected var AvatarUIClass:Class;

			
		protected var m_body:CBody;
		protected var m_avatarUI:MovieClip;
		protected var m_avatarConfig:CAvatarConfig;
		protected var m_avatarShop:CAvatarShop;
				
		protected var m_isOverBody:Boolean;
		
		public function Main()
		{
			super( width, height, true, true ); 
			
			var categoriesManager:CCategoryManager = new CCategoryManager();
			
			var bmpMgr:CItemsManager = new CItemsManager();			
			CItemsManager.instance().addEventListener( Event.COMPLETE, onItemsLoaded );
//			CItemsManager.instance().startLoading();
			
			var user:CUser = new CUser();		
			
			m_isOverBody = false;		
			
			loadModel();			
		}
		
		protected function onItemComplete( _event:Event ):void
		{
//			m_avatarConfig.populateList();
			m_body.build();
		} 
				
		protected function onItemsLoaded( _event:Event ):void
		{
			m_avatarConfig.populateList();		
			m_avatarShop.populateList();		
		}
		protected function loadModel():void
		{
			trace( "all items loaded" );
			
			m_body = new CBody();
			m_body.addEventListener( Event.COMPLETE, OnBodyLoaded );
			m_body.addEventListener( KConsts.BodyMouseUp, onBodyMouseUp );
			m_body.addEventListener( KConsts.BodyMouseOver, onBodyMouseOver );
			m_body.addEventListener( KConsts.BodyMouseOut, onBodyMouseOut );
			m_body.startLoading();
			
			m_avatarConfig = new CAvatarConfig();
			m_avatarShop = new CAvatarShop();
		}
		
		protected function OnBodyLoaded( _event:Event):void
		{
			var cameraTarget:DisplayObject3D = new DisplayObject3D();
			_camera.target 	= cameraTarget;
			_camera.zoom 	= 1000 / _camera.focus ;			
			addChild( new StatsView( this.renderer ) );
			m_body.model.x = 20;
			m_body.model.z = 1150;
			m_body.model.rotationY = -45;
			
			scene.addChild( m_body.model );
						

			
			this.addChild( m_avatarConfig );
			m_avatarShop.visible = false;
			m_avatarShop.addEventListener( KConsts.BackToConfig, onBackToConfig );
			this.addChild( m_avatarShop );
			m_avatarConfig.addEventListener( KConsts.GoToShop, onGoToShop );
			
			startRendering();			
			this.addEventListener( MouseEvent.MOUSE_UP, onMouseUp );
		
			CItemsManager.instance().addEventListener( KConsts.ItemComplete, onItemComplete );
			CItemsManager.instance().startLoading();
		}
		
		override protected function onRenderTick(event:Event=null):void
		{
//			var rotationY:Number = -(mouseX / stage.stageWidth * 360);
//			var rotationX:Number = -(mouseY / stage.stageHeight * 360);
//			m_obj.rotationY += (rotationY - m_obj.rotationY) / 12;
//			m_obj.rotationX += (rotationX - m_obj.rotationX) / 12;
			super.onRenderTick(event);			
//			m_bodyModel.model.yaw( 4 );			
		}	
		
		protected function resetAvatarConfigItem():void
		{
			m_avatarConfig.mouseIsDown 			= false;
			m_avatarConfig.selectedItemIndex	= -1;
		}
		
		protected function onMouseUp( _event:MouseEvent ):void
		{
//			trace("Global Mouse Up");
			if ( !m_isOverBody )
			{
				resetAvatarConfigItem();
			}
		}
		
		protected function onBodyMouseUp( _event:Event ):void
		{			
//			trace("Body MouseRelease");
			if ( null != m_avatarConfig.selectedItem )
			{
				var item:CItem = m_avatarConfig.selectedItem;
				if ( CUser.instance().canUse( item.id ) )
				{
					wearItem( item );					
				}
				else
				{
					trace( "user cannot wear that item" );
				}
				resetAvatarConfigItem();
			}
		}

		protected function onBodyMouseOver( _event:Event ):void
		{			
			m_isOverBody = true;
		}
		
		protected function onBodyMouseOut( _event:Event ):void
		{			
			m_isOverBody = false
		}
		
		protected function wearItem( _item:CItem ):void
		{
			CUser.instance().setCurrentItem( _item );
			m_body.build();
		}
		
		protected function onGoToShop( _event:Event ):void
		{
			m_avatarShop.visible = true;
		}
		
		protected function onBackToConfig( _event:Event ):void
		{
			m_body.build();
			m_avatarConfig.populateList();
			m_avatarShop.visible = false;
		}
	}
}
