-- Table: test

-- DROP TABLE test;

CREATE TABLE test
(
  test_id bigserial NOT NULL,
  test_com_id integer,
  test_timestamp bigint,
  test_hw_id bigint,
  CONSTRAINT test_pkey PRIMARY KEY (test_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE test
  OWNER TO spartan;

-- Index: test_test_com_id_idx

-- DROP INDEX test_test_com_id_idx;

CREATE INDEX test_test_com_id_idx
  ON test
  USING btree
  (test_com_id);

-- Index: test_test_hw_id_idx

-- DROP INDEX test_test_hw_id_idx;

CREATE INDEX test_test_hw_id_idx
  ON test
  USING btree
  (test_hw_id);

-- Index: test_test_timestamp_idx

-- DROP INDEX test_test_timestamp_idx;

CREATE INDEX test_test_timestamp_idx
  ON test
  USING btree
  (test_timestamp DESC);

 
