-- Table: public.dtrans_frames

-- DROP TABLE public.dtrans_frames;

CREATE TABLE public.dtrans_frames
(
  dt_id bigserial,
  dt_timestamp bigint,
  dt_com_id integer,
  dt_serial bigint,
  dt_frame text,
  CONSTRAINT dtrans_frames_pkey PRIMARY KEY (dt_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE public.dtrans_frames
  OWNER TO postgres;

-- Index: public.dtrans_frames_dt_com_id_dt_serial_dt_timestamp_idx

-- DROP INDEX public.dtrans_frames_dt_com_id_dt_serial_dt_timestamp_idx;

CREATE INDEX dtrans_frames_dt_com_id_dt_serial_dt_timestamp_idx
  ON public.dtrans_frames
  USING btree
  (dt_com_id, dt_serial, dt_timestamp DESC);

-- Index: public.dtrans_frames_dt_com_id_dt_timestamp_idx

-- DROP INDEX public.dtrans_frames_dt_com_id_dt_timestamp_idx;

CREATE INDEX dtrans_frames_dt_com_id_dt_timestamp_idx
  ON public.dtrans_frames
  USING btree
  (dt_com_id, dt_timestamp DESC);

