-- Table: request_tracker

-- DROP TABLE request_tracker;

CREATE TABLE request_tracker
(
  rt_id bigserial NOT NULL,
  rt_type smallint,
  rt_timestamp bigint,
  rt_com_id integer,
  CONSTRAINT request_tracker_pkey PRIMARY KEY (rt_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE request_tracker
  OWNER TO spartan;

-- Index: request_tracker_rt_com_id_rt_timestamp_idx

-- DROP INDEX request_tracker_rt_com_id_rt_timestamp_idx;

CREATE INDEX request_tracker_rt_com_id_rt_timestamp_idx
  ON request_tracker
  USING btree
  (rt_com_id, rt_timestamp);

-- Index: request_tracker_rt_com_id_rt_type_rt_timestamp_idx

-- DROP INDEX request_tracker_rt_com_id_rt_type_rt_timestamp_idx;

CREATE INDEX request_tracker_rt_com_id_rt_type_rt_timestamp_idx
  ON request_tracker
  USING btree
  (rt_com_id, rt_type, rt_timestamp);

-- Index: request_tracker_rt_timestamp_idx

-- DROP INDEX request_tracker_rt_timestamp_idx;

CREATE INDEX request_tracker_rt_timestamp_idx
  ON request_tracker
  USING btree
  (rt_timestamp DESC NULLS LAST);

