
CREATE OR REPLACE FUNCTION get_event_description(
    _hw_id bigint,
    _hw_company bigint,
    _msg_type integer,
    _evt_qualifier integer,
    _evt_code integer,
    _partition integer,
    _zone integer)
  RETURNS text AS
$BODY$
	DECLARE
		ref REFCURSOR;
		res text := '';
		rec RECORD;
	BEGIN
		IF EXISTS( SELECT het_var AS txt, het_emergency AS emergency FROM hardware_events_tpl WHERE het_hw_id = _hw_id
							AND het_type = _msg_type AND het_qualifier = _evt_qualifier
							AND het_code = _evt_code AND het_partition = _partition AND het_zone = _zone LIMIT 1 )
		THEN
			OPEN ref FOR SELECT het_var AS txt, het_emergency AS emergency FROM hardware_events_tpl WHERE het_hw_id = _hw_id
							AND het_type = _msg_type AND het_qualifier = _evt_qualifier
							AND het_code = _evt_code AND het_partition = _partition AND het_zone = _zone LIMIT 1;
		ELSIF EXISTS( SELECT cet_var AS txt, cet_emergency AS emergency FROM company_events_tpl WHERE cet_company_id = _hw_company
					AND cet_type = _msg_type AND cet_qualifier = _evt_qualifier
					AND cet_code = _evt_code AND cet_partition = _partition AND cet_zone = _zone	LIMIT 1 )
		THEN
			OPEN ref FOR SELECT cet_var AS txt, cet_emergency AS emergency FROM company_events_tpl WHERE cet_company_id = _hw_company
					AND cet_type = _msg_type AND cet_qualifier = _evt_qualifier
					AND cet_code = _evt_code AND cet_partition = _partition AND cet_zone = _zone	LIMIT 1;
		ELSIF EXISTS( SELECT et_var AS txt, et_emergency AS emergency FROM events_tpl WHERE
					 et_type = _msg_type AND et_qualifier = _evt_qualifier
					 AND et_code = _evt_code AND et_partition = _partition AND et_zone = _zone LIMIT 1 )
		THEN
			OPEN ref FOR SELECT et_var AS txt, et_emergency AS emergency FROM events_tpl WHERE
					 et_type = _msg_type AND et_qualifier = _evt_qualifier
					 AND et_code = _evt_code AND et_partition = _partition AND et_zone = _zone LIMIT 1;
		ELSE
			OPEN ref FOR SELECT '' AS txt, 0 AS emergency;
		END IF;

		FETCH ref INTO rec;
	
		res := to_json( rec );
		
		CLOSE ref;
		
		return res;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION get_event_description(bigint, bigint, integer, integer, integer, integer, integer)
  OWNER TO spartan;
 
