
CREATE TYPE command_status AS ENUM ('PENDING_SEND', 'WAITING_RESPONSE', 'CANCELLED', 'OK', 'EXECUTED', 'ERROR_TIMEOUT', 'ERROR');

-- Table: kpanel_msg_received

-- DROP TABLE kpanel_msg_received;

CREATE TABLE kpanel_msg_received
(
  kmr_id bigserial NOT NULL,
  kmr_hw_serial bigint,
  kmr_hw_code bigint,
  kmr_secuence integer,
  kmr_age integer,
  kmr_jump integer,
  kmr_prefix integer,
  kmr_flags integer,
  kmr_fixed_flag integer,
  kmr_msg_id integer,
  kmr_partition integer,
  kmr_partition_mask bigint,
  kmr_partition_state integer,
  kmr_led_state bigint,
  kmr_sound_state integer,
  kmr_raw bytea,
  kmr_com_id bigint NOT NULL,
  kmr_timestamp timestamp without time zone NOT NULL DEFAULT now(),
  CONSTRAINT kpanel_msg_received_pkey PRIMARY KEY (kmr_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE kpanel_msg_received
  OWNER TO spartan;

-- Index: kpanel_msg_received_kmr_com_id_kmr_hw_serial_kmr_timestamp_idx

-- DROP INDEX kpanel_msg_received_kmr_com_id_kmr_hw_serial_kmr_timestamp_idx;

CREATE INDEX kpanel_msg_received_kmr_com_id_kmr_hw_serial_kmr_timestamp_idx
  ON kpanel_msg_received
  USING btree
  (kmr_com_id, kmr_hw_serial, kmr_timestamp DESC);

-- Table: kpanel_msg_send

-- DROP TABLE kpanel_msg_send;

CREATE TABLE kpanel_msg_send
(
  kms_id bigserial NOT NULL,
  kms_hw_serial bigint,
  kms_hw_code bigint,
  kms_msg_id integer,
  kms_partition integer,
  kms_reports_num integer,
  kms_msg character varying(32),
  kms_raw bytea,
  kms_state command_status DEFAULT 'PENDING_SEND'::command_status,
  kms_com_id bigint NOT NULL,
  kms_timestamp timestamp without time zone NOT NULL DEFAULT now(),
  CONSTRAINT kpanel_msg_send_pkey PRIMARY KEY (kms_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE kpanel_msg_send
  OWNER TO spartan;

-- Index: kpanel_msg_send_kms_com_id_kms_hw_serial_kms_timestamp_kms_st_i

-- DROP INDEX kpanel_msg_send_kms_com_id_kms_hw_serial_kms_timestamp_kms_st_i;

CREATE INDEX kpanel_msg_send_kms_com_id_kms_hw_serial_kms_timestamp_kms_st_i
  ON kpanel_msg_send
  USING btree
  (kms_com_id, kms_hw_serial, kms_timestamp DESC, kms_state);

