-- Table: receiver_command

-- DROP TABLE receiver_command;

CREATE TABLE receiver_command
(
  rcmd_id bigserial NOT NULL,
  rcmd_cmd text,
  rcmd_parameters text,
  rcmd_status integer NOT NULL DEFAULT 0,
  rcmd_creation_time timestamp without time zone NOT NULL DEFAULT now(),
  rcmd_com_id integer,
  CONSTRAINT receiver_command_pkey PRIMARY KEY (rcmd_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE receiver_command
  OWNER TO spartan;

-- Index: receiver_command_rcmd_com_id_rcmd_status_idx

-- DROP INDEX receiver_command_rcmd_com_id_rcmd_status_idx;

CREATE INDEX receiver_command_rcmd_com_id_rcmd_status_idx
  ON receiver_command
  USING btree
  (rcmd_com_id, rcmd_status);

 
