-- Table: radar_log

-- DROP TABLE radar_log;

CREATE TABLE radar_log
(
  rl_id bigserial NOT NULL,
  rl_com_id integer,
  rl_msg text,
  rl_timestamp timestamp without time zone DEFAULT now(),
  CONSTRAINT radar_log_pkey PRIMARY KEY (rl_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE radar_log
  OWNER TO spartan;

-- Index: radar_log_rl_com_id_rl_timestamp_idx

-- DROP INDEX radar_log_rl_com_id_rl_timestamp_idx;

CREATE INDEX radar_log_rl_com_id_rl_timestamp_idx
  ON radar_log
  USING btree
  (rl_com_id, rl_timestamp DESC);

 
