-- Table: hardware_setup_signal_history

-- DROP TABLE hardware_setup_signal_history;

CREATE TABLE hardware_setup_signal_history
(
  hwsh_id serial NOT NULL,
  hwsh_company_code smallint,
  hwsh_receiver_code smallint,
  hwsh_hw_code integer,
  hwsh_hw_serial bigint,
  hwsh_signal real NOT NULL DEFAULT 0,
  hwsh_signal_filtered real NOT NULL DEFAULT 0,
  hwsh_inst_time timestamp without time zone DEFAULT now(),
  hwsh_first_timestamp bigint,
  hwsh_last_timestamp bigint,
  hwsh_signal_quality real NOT NULL DEFAULT 0,
  CONSTRAINT hardware_setup_signal_history_pkey PRIMARY KEY (hwsh_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE hardware_setup_signal_history
  OWNER TO spartan;

-- Index: hwsh_company_code_index

-- DROP INDEX hwsh_company_code_index;

CREATE INDEX hwsh_company_code_index
  ON hardware_setup_signal_history
  USING btree
  (hwsh_company_code);

-- Index: hwsh_hw_code_index

-- DROP INDEX hwsh_hw_code_index;

CREATE INDEX hwsh_hw_code_index
  ON hardware_setup_signal_history
  USING btree
  (hwsh_hw_code);

-- Index: hwsh_hw_serial_index

-- DROP INDEX hwsh_hw_serial_index;

CREATE INDEX hwsh_hw_serial_index
  ON hardware_setup_signal_history
  USING btree
  (hwsh_hw_serial);

-- Index: hwsh_receiver_code_index

-- DROP INDEX hwsh_receiver_code_index;

CREATE INDEX hwsh_receiver_code_index
  ON hardware_setup_signal_history
  USING btree
  (hwsh_receiver_code);

ALTER TABLE company_airmesh_config ADD cac_force_send integer;
ALTER TABLE company_citymesh_config ADD ccc_force_send integer;

-- Table: hardware_noise_config

-- DROP TABLE hardware_noise_config;

CREATE TABLE hardware_noise_config
(
  hwnc_id serial NOT NULL,
  hwnc_hw_serial bigint,
  hwnc_com_id integer,
  hwnc_retry_count integer NOT NULL DEFAULT 1,
  hwnc_lifetime integer NOT NULL DEFAULT 99000,
  hwnc_period integer,
  hwnc_noise_test_per_channel_count integer,
  hwnc_signal_strength_test_count integer,
  hwnc_channels_to_test character varying(32),
  hwnc_batch_id bigint NOT NULL DEFAULT 1,
  hwnc_state character varying(18),
  hwnc_sent integer NOT NULL DEFAULT 0,
  hwnc_timestamp bigint,
  CONSTRAINT hwnc_id_pkey PRIMARY KEY (hwnc_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE hardware_noise_config
  OWNER TO spartan;

-- Index: hwnc_batch_id_index

-- DROP INDEX hwnc_batch_id_index;

CREATE INDEX hwnc_batch_id_index
  ON hardware_noise_config
  USING btree
  (hwnc_batch_id);

-- Index: hwnc_com_id_index

-- DROP INDEX hwnc_com_id_index;

CREATE INDEX hwnc_com_id_index
  ON hardware_noise_config
  USING btree
  (hwnc_com_id);

-- Index: hwnc_hw_serial_index

-- DROP INDEX hwnc_hw_serial_index;

CREATE INDEX hwnc_hw_serial_index
  ON hardware_noise_config
  USING btree
  (hwnc_hw_serial);

-- Index: hwnc_sent_index

-- DROP INDEX hwnc_sent_index;

CREATE INDEX hwnc_sent_index
  ON hardware_noise_config
  USING btree
  (hwnc_sent);



-- Table: company_noise_config

-- DROP TABLE company_noise_config;

CREATE TABLE company_noise_config
(
  cnc_com_id bigint NOT NULL,
  cnc_send_ok_interval integer,
  cnc_send_err_interval integer,
  cnc_send_max_per_mac integer,
  cnc_max_resp_time_per_mac integer,
  CONSTRAINT company_noise_config_pkey PRIMARY KEY (cnc_com_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE company_noise_config
  OWNER TO spartan;

 
-- Table: hardware_noise_log

-- DROP TABLE hardware_noise_log;

CREATE TABLE hardware_noise_log
(
  hnl_id serial NOT NULL,
  hnl_hw_serial bigint,
  hnl_com_id integer,
  hnl_timestamp bigint,
  hnl_value integer,
  hnl_channel smallint,
  CONSTRAINT hnl_id_pkey PRIMARY KEY (hnl_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE hardware_noise_log
  OWNER TO spartan;

-- Index: hnl_channel_index

-- DROP INDEX hnl_channel_index;

CREATE INDEX hnl_channel_index
  ON hardware_noise_log
  USING btree
  (hnl_channel);

-- Index: hnl_com_id_index

-- DROP INDEX hnl_com_id_index;

CREATE INDEX hnl_com_id_index
  ON hardware_noise_log
  USING btree
  (hnl_com_id);

-- Index: hnl_hw_serial_index

-- DROP INDEX hnl_hw_serial_index;

CREATE INDEX hnl_hw_serial_index
  ON hardware_noise_log
  USING btree
  (hnl_hw_serial);

-- Index: hnl_timestamp_index

-- DROP INDEX hnl_timestamp_index;

CREATE INDEX hnl_timestamp_index
  ON hardware_noise_log
  USING btree
  (hnl_timestamp);

-- Table: hardware_signal_log

-- DROP TABLE hardware_signal_log;

CREATE TABLE hardware_signal_log
(
  hsl_id serial NOT NULL,
  hsl_hw_serial bigint,
  hsl_com_id integer,
  hsl_timestamp bigint,
  hsl_value integer,
  CONSTRAINT hsl_id_pkey PRIMARY KEY (hsl_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE hardware_signal_log
  OWNER TO spartan;

-- Index: hsl_com_id_index

-- DROP INDEX hsl_com_id_index;

CREATE INDEX hsl_com_id_index
  ON hardware_signal_log
  USING btree
  (hsl_com_id);

-- Index: hsl_hw_serial_index

-- DROP INDEX hsl_hw_serial_index;

CREATE INDEX hsl_hw_serial_index
  ON hardware_signal_log
  USING btree
  (hsl_hw_serial);

-- Index: hsl_timestamp_index

-- DROP INDEX hsl_timestamp_index;

CREATE INDEX hsl_timestamp_index
  ON hardware_signal_log
  USING btree
  (hsl_timestamp);





-- Table: data_frames_history

-- DROP TABLE data_frames_history;

CREATE TABLE data_frames_history
(
  df_id integer,
  df_packet_type smallint,
  df_company_code smallint,
  df_receiver_code smallint,
  df_hw_code integer,
  df_msg_type smallint,
  df_frame_data character varying(10),
  df_hw_serial integer,
  df_hw_timestamp bigint,
  df_msg_id integer,
  df_reserved bigint,
  df_checksum_total smallint
)
WITH (
  OIDS=FALSE
);
ALTER TABLE data_frames_history
  OWNER TO spartan;


-- Index: index_dfh_company_code

-- DROP INDEX index_dfh_company_code;

CREATE INDEX index_dfh_company_code
  ON data_frames_history
  USING btree
  (df_company_code);

-- Index: index_dfh_hw_code

-- DROP INDEX index_dfh_hw_code;

CREATE INDEX index_dfh_hw_code
  ON data_frames_history
  USING btree
  (df_hw_code);

-- Index: index_dfh_hw_serial

-- DROP INDEX index_dfh_hw_serial;

CREATE INDEX index_dfh_hw_serial
  ON data_frames_history
  USING btree
  (df_hw_serial);

-- Index: index_dfh_hw_timestamp

-- DROP INDEX index_dfh_hw_timestamp;

CREATE INDEX index_dfh_hw_timestamp
  ON data_frames_history
  USING btree
  (df_hw_timestamp);

-- Index: index_dfh_receiver_code

-- DROP INDEX index_dfh_receiver_code;

CREATE INDEX index_dfh_receiver_code
  ON data_frames_history
  USING btree
  (df_receiver_code);
  
  
  
ALTER TABLE hardware_citymesh_command 
ADD hwcc_priority integer DEFAULT 0 NOT NULL;

ALTER TABLE sms_pending
ADD sms_timestamp timestamp without time zone NOT NULL DEFAULT now();







-- Table: receiver_ticks_period

-- DROP TABLE receiver_ticks_period;

CREATE TABLE receiver_ticks_period
(
  rtp_id serial NOT NULL,
  rtp_com_id integer NOT NULL,
  rtp_ticks_count integer NOT NULL DEFAULT 0,
  rtp_from_time integer NOT NULL,
  CONSTRAINT receiver_ticks_period_rtp_id_pkey PRIMARY KEY (rtp_id),
  CONSTRAINT receiver_ticks_period_rtp_com_id_fkey FOREIGN KEY (rtp_com_id)
      REFERENCES company (com_id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE
)
WITH (
  OIDS=FALSE
);
ALTER TABLE receiver_ticks_period
  OWNER TO postgres;

-- Index: index_rtp_com_id

-- DROP INDEX index_rtp_com_id;

CREATE INDEX index_rtp_com_id
  ON receiver_ticks_period
  USING btree
  (rtp_com_id);

-- Index: index_rtp_from_time

-- DROP INDEX index_rtp_from_time;

CREATE INDEX index_rtp_from_time
  ON receiver_ticks_period
  USING btree
  (rtp_from_time);





ALTER TABLE company_airmesh_config
ADD COLUMN cac_cancel_batch integer DEFAULT 0;

ALTER TABLE company_citymesh_config 
ADD COLUMN ccc_cancel_batch integer DEFAULT 0;

ALTER TABLE company_noise_config
ADD cnc_force_send integer DEFAULT 0;



ALTER TABLE events_tpl 
ADD COLUMN et_emergency INT NOT NULL DEFAULT 0;

ALTER TABLE hardware_events_tpl 
ADD COLUMN het_emergency INT NOT NULL DEFAULT 0;

ALTER TABLE company_events_tpl 
ADD COLUMN cet_emergency INT NOT NULL DEFAULT 0;

ALTER TABLE company_user
ADD COLUMN cu_is_guard INT NOT NULL DEFAULT 0;


-- Table: dshield_event

-- DROP TABLE dshield_event;

CREATE TABLE dshield_event
(
  dse_id serial NOT NULL,
  dse_event_id bigint NOT NULL,
  dse_hw_id bigint,
  dse_uid bigint,
  dse_status integer,
  dse_observations text,
  dse_type integer NOT NULL DEFAULT 0,
  dse_opened timestamp without time zone DEFAULT now(),
  dse_closed timestamp without time zone,
  dse_com_id bigint,
  CONSTRAINT dshield_event_pkey PRIMARY KEY (dse_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE dshield_event
  OWNER TO postgres;

-- Index: dshield_event_dse_com_id_index

-- DROP INDEX dshield_event_dse_com_id_index;

CREATE INDEX dshield_event_dse_com_id_index
  ON dshield_event
  USING btree
  (dse_com_id);

-- Index: dshield_event_dse_event_id_index

-- DROP INDEX dshield_event_dse_event_id_index;

CREATE INDEX dshield_event_dse_event_id_index
  ON dshield_event
  USING btree
  (dse_event_id);

-- Index: dshield_event_dse_hw_id_index

-- DROP INDEX dshield_event_dse_hw_id_index;

CREATE INDEX dshield_event_dse_hw_id_index
  ON dshield_event
  USING btree
  (dse_hw_id);

-- Index: dshield_event_dse_status_index

-- DROP INDEX dshield_event_dse_status_index;

CREATE INDEX dshield_event_dse_status_index
  ON dshield_event
  USING btree
  (dse_status);

-- Index: dshield_event_dse_uid_index

-- DROP INDEX dshield_event_dse_uid_index;

CREATE INDEX dshield_event_dse_uid_index
  ON dshield_event
  USING btree
  (dse_uid);

-- Table: dshield_event_chat

-- DROP TABLE dshield_event_chat;

CREATE TABLE dshield_event_chat
(
  dsec_id serial NOT NULL,
  dsec_dse_id bigint,
  dsec_uid bigint,
  dsec_msg text,
  dsec_timestamp timestamp without time zone,
  CONSTRAINT dshield_event_chat_pkey PRIMARY KEY (dsec_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE dshield_event_chat
  OWNER TO postgres;

-- Index: dshield_event_chat_dsec_dse_id_index

-- DROP INDEX dshield_event_chat_dsec_dse_id_index;

CREATE INDEX dshield_event_chat_dsec_dse_id_index
  ON dshield_event_chat
  USING btree
  (dsec_dse_id);

-- Index: dshield_event_chat_dsec_timetsamp_index

-- DROP INDEX dshield_event_chat_dsec_timetsamp_index;

CREATE INDEX dshield_event_chat_dsec_timetsamp_index
  ON dshield_event_chat
  USING btree
  (dsec_timestamp);

-- Index: dshield_event_chat_dsec_uid_index

-- DROP INDEX dshield_event_chat_dsec_uid_index;

CREATE INDEX dshield_event_chat_dsec_uid_index
  ON dshield_event_chat
  USING btree
  (dsec_uid);

-- Table: dshield_event_states

-- DROP TABLE dshield_event_states;

CREATE TABLE dshield_event_states
(
  des_id serial NOT NULL,
  des_com_id integer,
  des_name character varying(40),
  CONSTRAINT dshield_event_states_pkey PRIMARY KEY (des_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE dshield_event_states
  OWNER TO postgres;

-- Index: dshield_event_states_des_id_index

-- DROP INDEX dshield_event_states_des_id_index;

CREATE INDEX dshield_event_states_des_id_index
  ON dshield_event_states
  USING btree
  (des_com_id);


ALTER TABLE dshield_event_chat
ALTER COLUMN dsec_timestamp timestamp without time zone NOT NULL DEFAULT now();


-- Table: dshield_event_relation

-- DROP TABLE dshield_event_relation;

CREATE TABLE dshield_event_relation
(
  der_id serial NOT NULL,
  der_event_id bigint,
  der_dse_id bigint,
  CONSTRAINT dshield_event_relation_pkey PRIMARY KEY (der_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE dshield_event_relation
  OWNER TO postgres;

-- Index: dshield_event_relation_der_event_id_index

-- DROP INDEX dshield_event_relation_der_event_id_index;

CREATE INDEX dshield_event_relation_der_event_id_index
  ON dshield_event_relation
  USING btree
  (der_event_id DESC);


ALTER TABLE dshield_event
ADD COLUMN dse_closed_uid bigint;

ALTER TABLE company
ADD COLUMN com_address character varying(128) NOT NULL DEFAULT ''::character varying;

ALTER TABLE company
ADD COLUMN com_lat double precision NOT NULL DEFAULT 0;

ALTER TABLE company
ADD COLUMN com_long double precision NOT NULL DEFAULT 0;



-- Table: dshield_event_history

-- DROP TABLE dshield_event_history;

CREATE TABLE dshield_event_history
(
  deh_id serial NOT NULL,
  deh_dse_id bigint,
  deh_status integer,
  deh_observations text,
  deh_timestamp timestamp without time zone NOT NULL DEFAULT now(),
  deh_uid bigint,
  CONSTRAINT dshield_event_history_pkey PRIMARY KEY (deh_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE dshield_event_history
  OWNER TO postgres;

-- Index: dshield_event_history_deh_dse_id_index

-- DROP INDEX dshield_event_history_deh_dse_id_index;

CREATE INDEX dshield_event_history_deh_dse_id_index
  ON dshield_event_history
  USING btree
  (deh_dse_id);

-- Index: dshield_event_history_deh_timestamp_index

-- DROP INDEX dshield_event_history_deh_timestamp_index;

CREATE INDEX dshield_event_history_deh_timestamp_index
  ON dshield_event_history
  USING btree
  (deh_timestamp);
















-- Function: get_event_description(bigint, bigint, integer, integer, integer, integer, integer)

-- DROP FUNCTION get_event_description(bigint, bigint, integer, integer, integer, integer, integer);

CREATE OR REPLACE FUNCTION get_event_description(
    _hw_id bigint,
    _hw_company bigint,
    _msg_type integer,
    _evt_qualifier integer,
    _evt_code integer,
    _partition integer,
    _zone integer)
  RETURNS text AS
$BODY$
	DECLARE
		ref REFCURSOR;
		res text := '';
		rec RECORD;
	BEGIN
		IF EXISTS( SELECT het_var AS txt, het_emergency AS emergency FROM hardware_events_tpl WHERE het_hw_id = _hw_id
							AND het_type = _msg_type AND het_qualifier = _evt_qualifier
							AND het_code = _evt_code AND het_partition = _partition AND het_zone = _zone LIMIT 1 )
		THEN
			OPEN ref FOR SELECT het_var AS txt, het_emergency AS emergency FROM hardware_events_tpl WHERE het_hw_id = _hw_id
							AND het_type = _msg_type AND het_qualifier = _evt_qualifier
							AND het_code = _evt_code AND het_partition = _partition AND het_zone = _zone LIMIT 1;
		ELSIF EXISTS( SELECT het_var AS txt, het_emergency AS emergency FROM hardware_events_tpl WHERE het_hw_id = _hw_id
								AND het_type = _msg_type AND het_qualifier = _evt_qualifier
								AND het_code = _evt_code 
								ORDER BY het_zone ASC, het_partition ASC LIMIT 1 )
		THEN
			OPEN ref FOR SELECT het_var AS txt, het_emergency AS emergency FROM hardware_events_tpl WHERE het_hw_id = _hw_id
								AND het_type = _msg_type AND het_qualifier = _evt_qualifier
								AND het_code = _evt_code 
								ORDER BY het_zone ASC, het_partition ASC LIMIT 1;
		ELSIF EXISTS( SELECT cet_var AS txt, cet_emergency AS emergency FROM company_events_tpl WHERE cet_company_id = _hw_company
					AND cet_type = _msg_type AND cet_qualifier = _evt_qualifier
					AND cet_code = _evt_code AND cet_partition = _partition AND cet_zone = _zone	LIMIT 1 )
		THEN
			OPEN ref FOR SELECT cet_var AS txt, cet_emergency AS emergency FROM company_events_tpl WHERE cet_company_id = _hw_company
					AND cet_type = _msg_type AND cet_qualifier = _evt_qualifier
					AND cet_code = _evt_code AND cet_partition = _partition AND cet_zone = _zone	LIMIT 1;
		ELSIF EXISTS( SELECT cet_var AS txt, cet_emergency AS emergency FROM company_events_tpl WHERE cet_company_id = _hw_company
					AND cet_type = _msg_type AND cet_qualifier = _evt_qualifier AND cet_code = _evt_code
					ORDER BY cet_zone ASC, cet_partition ASC LIMIT 1 )
		THEN
			OPEN ref FOR SELECT cet_var AS txt, cet_emergency AS emergency FROM company_events_tpl WHERE cet_company_id = _hw_company
					AND cet_type = _msg_type AND cet_qualifier = _evt_qualifier AND cet_code = _evt_code
					ORDER BY cet_zone ASC, cet_partition ASC LIMIT 1;
		ELSIF EXISTS( SELECT et_var AS txt, et_emergency AS emergency FROM events_tpl WHERE
					 et_type = _msg_type AND et_qualifier = _evt_qualifier
					 AND et_code = _evt_code AND et_partition = _partition AND et_zone = _zone LIMIT 1 )
		THEN
			OPEN ref FOR SELECT et_var AS txt, et_emergency AS emergency FROM events_tpl WHERE
					 et_type = _msg_type AND et_qualifier = _evt_qualifier
					 AND et_code = _evt_code AND et_partition = _partition AND et_zone = _zone LIMIT 1;
		ELSIF EXISTS( SELECT et_var AS txt, et_emergency AS emergency FROM events_tpl WHERE
					 et_type = _msg_type AND et_qualifier = _evt_qualifier
					 AND et_code = _evt_code
					 ORDER BY et_zone ASC, et_partition ASC LIMIT 1 )
		THEN
			OPEN ref FOR SELECT et_var AS txt, et_emergency AS emergency FROM events_tpl WHERE
					 et_type = _msg_type AND et_qualifier = _evt_qualifier
					 AND et_code = _evt_code
					 ORDER BY et_zone ASC, et_partition ASC LIMIT 1;
		ELSE
			OPEN ref FOR SELECT '' AS txt, 0 AS emergency;
		END IF;

		FETCH ref INTO rec;
	
		res := to_json( rec );
		
		CLOSE ref;
		
		return res;
END;
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 100;
ALTER FUNCTION get_event_description(bigint, bigint, integer, integer, integer, integer, integer)
  OWNER TO spartan;




ALTER TABLE users 
ADD COLUMN upass_recover_token character varying(64);

ALTER TABLE users 
ADD COLUMN upass_recover_expiration timestamp without time zone;
















-- Table: global_event

-- DROP TABLE global_event;

CREATE TABLE global_event
(
  ge_id serial NOT NULL,
  ge_type integer,
  ge_event_id bigint,
  ge_user_id bigint,
  ge_hw_id bigint,
  ge_hw_serial bigint,
  ge_hw_code bigint,
  ge_com_id integer,
  ge_time bigint,
  ge_desc text,
  ge_emergency integer NOT NULL DEFAULT 0,
  CONSTRAINT global_event_pkey_id PRIMARY KEY (ge_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE global_event
  OWNER TO spartan;

-- Index: global_event_index_ge_com_id

-- DROP INDEX global_event_index_ge_com_id;

CREATE INDEX global_event_index_ge_com_id
  ON global_event
  USING btree
  (ge_com_id);

-- Index: global_event_index_ge_event_id

-- DROP INDEX global_event_index_ge_event_id;

CREATE INDEX global_event_index_ge_event_id
  ON global_event
  USING btree
  (ge_event_id DESC NULLS LAST);

-- Index: global_event_index_ge_hw_code

-- DROP INDEX global_event_index_ge_hw_code;

CREATE INDEX global_event_index_ge_hw_code
  ON global_event
  USING btree
  (ge_hw_code);

-- Index: global_event_index_ge_hw_id

-- DROP INDEX global_event_index_ge_hw_id;

CREATE INDEX global_event_index_ge_hw_id
  ON global_event
  USING btree
  (ge_hw_id);

-- Index: global_event_index_ge_hw_serial

-- DROP INDEX global_event_index_ge_hw_serial;

CREATE INDEX global_event_index_ge_hw_serial
  ON global_event
  USING btree
  (ge_hw_serial);

-- Index: global_event_index_ge_time

-- DROP INDEX global_event_index_ge_time;

CREATE INDEX global_event_index_ge_time
  ON global_event
  USING btree
  (ge_time DESC NULLS LAST);

-- Index: global_event_index_ge_type

-- DROP INDEX global_event_index_ge_type;

CREATE INDEX global_event_index_ge_type
  ON global_event
  USING btree
  (ge_type);

-- Index: global_event_index_ge_user_id

-- DROP INDEX global_event_index_ge_user_id;

CREATE INDEX global_event_index_ge_user_id
  ON global_event
  USING btree
  (ge_user_id);












ALTER TABLE hardware 
ADD COLUMN hw_create_time timestamp without time zone;

ALTER TABLE company
ADD COLUMN com_memo text;






ALTER TABLE keychain
ADD COLUMN key_user bigint;

CREATE INDEX keychain_index_kev_id
  ON keychain
  USING btree
  (key_id);

CREATE INDEX keychain_index_kev_company
  ON keychain
  USING btree
  (key_company);

CREATE INDEX keychain_index_kev_user
  ON keychain
  USING btree
  (key_user);

CREATE INDEX keychain_index_kev_group
  ON keychain
  USING btree
  (key_group);








-- Table: radar

-- DROP TABLE radar;

CREATE TABLE radar
(
  rd_id bigserial NOT NULL,
  rd_name character varying(64) NOT NULL DEFAULT ''::character varying,
  rd_lat double precision NOT NULL DEFAULT 0,
  rd_long double precision NOT NULL DEFAULT 0,
  rd_company bigint NOT NULL,
  rd_serial bigint NOT NULL DEFAULT 0,
  rd_trigger_speed integer DEFAULT 100,
  CONSTRAINT radar_rd_id_pkey PRIMARY KEY (rd_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE radar
  OWNER TO postgres;

-- Index: radar_rd_company

-- DROP INDEX radar_rd_company;

CREATE INDEX radar_rd_company
  ON radar
  USING btree
  (rd_company);







-- Table: radar_event

-- DROP TABLE radar_event;

CREATE TABLE radar_event
(
  re_id serial NOT NULL,
  re_rd_serial bigint NOT NULL,
  re_country_id integer,
  re_image character varying(68) NOT NULL DEFAULT ''::character varying,
  re_timestamp bigint NOT NULL,
  re_max_speed integer NOT NULL,
  re_speed integer,
  re_type integer NOT NULL,
  CONSTRAINT radar_event_pkey PRIMARY KEY (re_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE radar_event
  OWNER TO spartan;

-- Index: radar_event_re_rd_serial_index

-- DROP INDEX radar_event_re_rd_serial_index;

CREATE INDEX radar_event_re_rd_serial_index
  ON radar_event
  USING btree
  (re_rd_serial);








-- Table: rfid

-- DROP TABLE rfid;

CREATE TABLE rfid
(
  rfid_serial bigint NOT NULL,
  rfid_user bigint,
  rfid_com_id bigint,
  CONSTRAINT rfid_pkey PRIMARY KEY (rfid_serial)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid
  OWNER TO spartan;

-- Index: rfid_rfid_com_id_idx

-- DROP INDEX rfid_rfid_com_id_idx;

CREATE INDEX rfid_rfid_com_id_idx
  ON rfid
  USING btree
  (rfid_com_id);

-- Index: rfid_rfid_user_idx

-- DROP INDEX rfid_rfid_user_idx;

CREATE INDEX rfid_rfid_user_idx
  ON rfid
  USING btree
  (rfid_user);


-- Table: rfid_event

-- DROP TABLE rfid_event;

CREATE TABLE rfid_event
(
  re_id serial NOT NULL,
  re_serial bigint,
  re_code bigint,
  re_device_type smallint,
  re_event_type smallint,
  re_timestamp bigint,
  re_state character varying(18),
  re_com_id bigint,
  re_user bigint,
  CONSTRAINT rfid_event_pkey PRIMARY KEY (re_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_event
  OWNER TO spartan;

-- Index: rfid_event_re_code_idx

-- DROP INDEX rfid_event_re_code_idx;

CREATE INDEX rfid_event_re_code_idx
  ON rfid_event
  USING btree
  (re_code);

-- Index: rfid_event_re_com_id_idx

-- DROP INDEX rfid_event_re_com_id_idx;

CREATE INDEX rfid_event_re_com_id_idx
  ON rfid_event
  USING btree
  (re_com_id);

-- Index: rfid_event_re_serial_idx

-- DROP INDEX rfid_event_re_serial_idx;

CREATE INDEX rfid_event_re_serial_idx
  ON rfid_event
  USING btree
  (re_serial);

-- Index: rfid_event_re_state_idx

-- DROP INDEX rfid_event_re_state_idx;

CREATE INDEX rfid_event_re_state_idx
  ON rfid_event
  USING btree
  (re_state COLLATE pg_catalog."default");

-- Table: rfid_user

-- DROP TABLE rfid_user;

CREATE TABLE rfid_user
(
  urfid_id serial NOT NULL,
  urfid_name character varying(64) NOT NULL DEFAULT ''::character varying,
  urfid_photo text,
  urfid_status smallint,
  urfid_restricted_access smallint,
  urfid_user_type smallint,
  urfid_user_data json,
  urfid_dni bigint,
  urfid_com_id bigint,
  urfid_plate character varying(64),
  CONSTRAINT user_rfid_pkey PRIMARY KEY (urfid_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_user
  OWNER TO spartan;

-- Index: rfid_user_urfid_com_id_idx

-- DROP INDEX rfid_user_urfid_com_id_idx;

CREATE INDEX rfid_user_urfid_com_id_idx
  ON rfid_user
  USING btree
  (urfid_com_id);

-- Index: user_rfid_rfid_status_index

-- DROP INDEX user_rfid_rfid_status_index;

CREATE INDEX user_rfid_rfid_status_index
  ON rfid_user
  USING btree
  (urfid_status);

-- Index: user_rfid_rfid_user_type_index

-- DROP INDEX user_rfid_rfid_user_type_index;

CREATE INDEX user_rfid_rfid_user_type_index
  ON rfid_user
  USING btree
  (urfid_user_type);

-- Table: rfid_citymesh

-- DROP TABLE rfid_citymesh;

CREATE TABLE rfid_citymesh
(
  rc_id serial NOT NULL,
  rc_code bigint,
  rc_name character varying(64),
  rc_com_id bigint,
  CONSTRAINT rfid_citymesh_pkey PRIMARY KEY (rc_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_citymesh
  OWNER TO spartan;

-- Index: rfid_citymesh_rc_code_idx

-- DROP INDEX rfid_citymesh_rc_code_idx;

CREATE INDEX rfid_citymesh_rc_code_idx
  ON rfid_citymesh
  USING btree
  (rc_code);

-- Index: rfid_citymesh_rc_com_id_idx

-- DROP INDEX rfid_citymesh_rc_com_id_idx;

CREATE INDEX rfid_citymesh_rc_com_id_idx
  ON rfid_citymesh
  USING btree
  (rc_com_id);

-- Table: rfid_user_plot

-- DROP TABLE rfid_user_plot;

CREATE TABLE rfid_user_plot
(
  rup_id serial NOT NULL,
  rup_urfid_id bigint,
  rup_plot integer,
  CONSTRAINT rfid_user_plot_pkey PRIMARY KEY (rup_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_user_plot
  OWNER TO postgres;

-- Index: rfid_user_plot_rup_plot_idx

-- DROP INDEX rfid_user_plot_rup_plot_idx;

CREATE INDEX rfid_user_plot_rup_plot_idx
  ON rfid_user_plot
  USING btree
  (rup_plot);

-- Index: rfid_user_plot_rup_urfid_id_idx

-- DROP INDEX rfid_user_plot_rup_urfid_id_idx;

CREATE INDEX rfid_user_plot_rup_urfid_id_idx
  ON rfid_user_plot
  USING btree
  (rup_urfid_id);

-- Index: hardware_hours_hh_hw_id_idx

-- DROP INDEX hardware_hours_hh_hw_id_idx;

CREATE INDEX hardware_hours_hh_hw_id_idx
  ON hardware_hours
  USING btree
  (hh_hw_id);

-- Table: rfid_user_hours

-- DROP TABLE rfid_user_hours;

CREATE TABLE rfid_user_hours
(
  ruh_id serial NOT NULL,
  ruh_urfid_id bigint NOT NULL,
  ruh_day character varying(3) NOT NULL,
  ruh_init time without time zone NOT NULL,
  ruh_end time without time zone NOT NULL
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_user_hours
  OWNER TO postgres;


-- Index: rfid_user_hours_ruh_urfid_id_idx

-- DROP INDEX rfid_user_hours_ruh_urfid_id_idx;

CREATE INDEX rfid_user_hours_ruh_urfid_id_idx
  ON rfid_user_hours
  USING btree
  (ruh_urfid_id);



-- Table: rfid_gallery

-- DROP TABLE rfid_gallery;

CREATE TABLE rfid_gallery
(
  rg_id serial NOT NULL,
  rg_urfid_id bigint,
  rg_name character varying(64),
  rg_type integer,
  CONSTRAINT rfid_gallery_pkey PRIMARY KEY (rg_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_gallery
  OWNER TO spartan;

-- Index: rfid_gallery_rg_urfid_id_idx

-- DROP INDEX rfid_gallery_rg_urfid_id_idx;

CREATE INDEX rfid_gallery_rg_urfid_id_idx
  ON rfid_gallery
  USING btree
  (rg_urfid_id);

-- Table: rfid_photo

-- DROP TABLE rfid_photo;

CREATE TABLE rfid_photo
(
  rp_id serial NOT NULL,
  rp_path text,
  rp_gallery_id bigint,
  rp_name character varying(64),
  CONSTRAINT rfid_photo_pkey PRIMARY KEY (rp_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_photo
  OWNER TO spartan;

-- Index: rfid_photo_rp_gallery_id_idx

-- DROP INDEX rfid_photo_rp_gallery_id_idx;

CREATE INDEX rfid_photo_rp_gallery_id_idx
  ON rfid_photo
  USING btree
  (rp_gallery_id);


-- Table: rfid_user_citymesh

-- DROP TABLE rfid_user_citymesh;

CREATE TABLE rfid_user_citymesh
(
  ruc_id serial NOT NULL,
  ruc_uid bigint,
  ruc_citymesh_id bigint,
  CONSTRAINT rfid_user_citymesh_pkey PRIMARY KEY (ruc_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_user_citymesh
  OWNER TO spartan;

-- Index: rfid_user_citymesh_ruc_uid_idx

-- DROP INDEX rfid_user_citymesh_ruc_uid_idx;

CREATE INDEX rfid_user_citymesh_ruc_uid_idx
  ON rfid_user_citymesh
  USING btree
  (ruc_uid);



ALTER TABLE rfid_citymesh ADD COLUMN rc_type integer DEFAULT 0;

ALTER TABLE company_user RENAME COLUMN cu_is_guard TO cu_type;

ALTER TABLE rfid_user ADD COLUMN urfid_uid bigint;

ALTER TABLE rfid_user ADD COLUMN urfid_inside integer DEFAULT 0;

ALTER TABLE rfid_event ADD COLUMN re_result integer DEFAULT 0;

ALTER TABLE rfid_event RENAME COLUMN re_device_type TO re_packet_type;

ALTER TABLE rfid_event ADD COLUMN re_device_type integer DEFAULT 1;

ALTER TABLE rfid_user ADD COLUMN urfid_phone character varying(64) NOT NULL DEFAULT ''::character varying;

ALTER TABLE rfid_user ADD COLUMN urfid_observations text NOT NULL DEFAULT ''::text;

ALTER TABLE rfid_user ADD COLUMN urfid_entrance_type integer DEFAULT 1;

ALTER TABLE rfid_user ADD COLUMN urfid_exit_type integer DEFAULT 1;

ALTER TABLE rfid_event ALTER COLUMN re_id SET DATA TYPE bigint;

ALTER TABLE actions_config ADD COLUMN ac_force_send integer DEFAULT 1;

ALTER TABLE actions_log ADD COLUMN al_force_send integer DEFAULT 1;






ALTER TABLE rfid_photo ADD COLUMN rp_state integer DEFAULT 0;

ALTER TABLE users_info ADD COLUMN ui_type integer DEFAULT 0;



-- Table: rfid_visit

-- DROP TABLE rfid_visit;

CREATE TABLE rfid_visit
(
  rv_id bigserial NOT NULL,
  rv_urfid_id bigint,
  rv_time_start bigint,
  rv_time_end bigint,
  rv_rve_id bigint,
  rv_parent_urfid_id bigint,
  CONSTRAINT rfid_visit_pkey PRIMARY KEY (rv_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_visit
  OWNER TO spartan;

-- Index: rfid_visit_rv_parent_urfid_id_idx

-- DROP INDEX rfid_visit_rv_parent_urfid_id_idx;

CREATE INDEX rfid_visit_rv_parent_urfid_id_idx
  ON rfid_visit
  USING btree
  (rv_parent_urfid_id);

-- Index: rfid_visit_rv_rfid_event_idx

-- DROP INDEX rfid_visit_rv_rfid_event_idx;

CREATE INDEX rfid_visit_rv_rfid_event_idx
  ON rfid_visit
  USING btree
  (rv_rve_id);

-- Index: rfid_visit_rv_time_end_idx

-- DROP INDEX rfid_visit_rv_time_end_idx;

CREATE INDEX rfid_visit_rv_time_end_idx
  ON rfid_visit
  USING btree
  (rv_time_end);

-- Index: rfid_visit_rv_time_start_idx

-- DROP INDEX rfid_visit_rv_time_start_idx;

CREATE INDEX rfid_visit_rv_time_start_idx
  ON rfid_visit
  USING btree
  (rv_time_start);

-- Index: rfid_visit_rv_urfid_id_idx

-- DROP INDEX rfid_visit_rv_urfid_id_idx;

CREATE INDEX rfid_visit_rv_urfid_id_idx
  ON rfid_visit
  USING btree
  (rv_urfid_id);


-- Table: rfid_visit_event

-- DROP TABLE rfid_visit_event;

CREATE TABLE rfid_visit_event
(
  rve_id bigserial NOT NULL,
  rve_name text,
  rve_desc text,
  rve_urfid_id bigint,
  rve_time_start bigint,
  rve_time_end bigint,
  CONSTRAINT rfid_visit_event_pkey PRIMARY KEY (rve_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_visit_event
  OWNER TO spartan;

-- Index: rfid_visit_event_rve_time_end_idx

-- DROP INDEX rfid_visit_event_rve_time_end_idx;

CREATE INDEX rfid_visit_event_rve_time_end_idx
  ON rfid_visit_event
  USING btree
  (rve_time_end);

-- Index: rfid_visit_event_rve_time_start_idx

-- DROP INDEX rfid_visit_event_rve_time_start_idx;

CREATE INDEX rfid_visit_event_rve_time_start_idx
  ON rfid_visit_event
  USING btree
  (rve_time_start);

-- Index: rfid_visit_event_rve_urfid_id_idx

-- DROP INDEX rfid_visit_event_rve_urfid_id_idx;

CREATE INDEX rfid_visit_event_rve_urfid_id_idx
  ON rfid_visit_event
  USING btree
  (rve_urfid_id);






-- Table: company_time_frame

-- DROP TABLE company_time_frame;

CREATE TABLE company_time_frame
(
  ctf_id bigserial NOT NULL,
  ctf_com_id bigint,
  ctf_type integer,
  ctf_time_start bigint,
  ctf_time_end bigint,
  CONSTRAINT company_time_frame_pkey PRIMARY KEY (ctf_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE company_time_frame
  OWNER TO spartan;

-- Index: company_time_frame_ctf_com_id_idx

-- DROP INDEX company_time_frame_ctf_com_id_idx;

CREATE INDEX company_time_frame_ctf_com_id_idx
  ON company_time_frame
  USING btree
  (ctf_com_id);

-- Index: company_time_frame_ctf_time_end_idx

-- DROP INDEX company_time_frame_ctf_time_end_idx;

CREATE INDEX company_time_frame_ctf_time_end_idx
  ON company_time_frame
  USING btree
  (ctf_time_end);

-- Index: company_time_frame_ctf_time_start_idx

-- DROP INDEX company_time_frame_ctf_time_start_idx;

CREATE INDEX company_time_frame_ctf_time_start_idx
  ON company_time_frame
  USING btree
  (ctf_time_start);

-- Index: company_time_frame_ctf_type_idx

-- DROP INDEX company_time_frame_ctf_type_idx;

CREATE INDEX company_time_frame_ctf_type_idx
  ON company_time_frame
  USING btree
  (ctf_type);


-- Table: company_time_frame_config

-- DROP TABLE company_time_frame_config;

CREATE TABLE company_time_frame_config
(
  ctfc_com_id bigint NOT NULL,
  ctfc_time_in integer,
  ctfc_time_out integer,
  CONSTRAINT company_time_frame_config_pkey PRIMARY KEY (ctfc_com_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE company_time_frame_config
  OWNER TO spartan;


ALTER TABLE rfid_user ADD COLUMN urfid_expiration bigint;





-- Table: rfid_citymesh_restriction

-- DROP TABLE rfid_citymesh_restriction;

CREATE TABLE rfid_citymesh_restriction
(
  rcr_id bigserial NOT NULL,
  rcr_rc_id bigint,
  rcr_user_type integer,
  rcr_state integer,
  CONSTRAINT rfid_citymesh_restriction_pkey PRIMARY KEY (rcr_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rfid_citymesh_restriction
  OWNER TO spartan;

ALTER TABLE radar ADD COLUMN rd_urbanization_name character varying(64) NOT NULL DEFAULT ''::character varying;

ALTER TABLE radar ADD COLUMN rd_urbanization_address character varying(64) NOT NULL DEFAULT ''::character varying;

ALTER TABLE radar ADD COLUMN rd_urbanization_logo character varying(64) NOT NULL DEFAULT ''::character varying;

ALTER TABLE radar_event ADD COLUMN re_plate character varying(64) NOT NULL DEFAULT ''::character varying;

ALTER TABLE radar_event ADD COLUMN re_valid integer DEFAULT 0;

SET CONSTRAINTS ALL DEFERRED;

ALTER TABLE receiver_ticks DROP CONSTRAINT receiver_ticks_rt_company_id_fkey;

ALTER TABLE receiver_console_log DROP CONSTRAINT receiver_console_log_rcl_company_id_fkey;





-- Table: hardware_generic_message

-- DROP TABLE hardware_generic_message;

CREATE TABLE hardware_generic_message
(
  hgm_id bigserial NOT NULL,
  hgm_com_id bigint,
  hgm_timestamp bigint,
  hgm_serial bigint,
  hgm_msg text,
  hgm_state character varying(18),
  CONSTRAINT hardware_generic_message_pkey PRIMARY KEY (hgm_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE hardware_generic_message
  OWNER TO postgres;

-- Index: hardware_generic_message_hgm_com_id_idx

-- DROP INDEX hardware_generic_message_hgm_com_id_idx;

CREATE INDEX hardware_generic_message_hgm_com_id_idx
  ON hardware_generic_message
  USING btree
  (hgm_com_id);

-- Index: hardware_generic_message_hgm_timestamp_idx

-- DROP INDEX hardware_generic_message_hgm_timestamp_idx;

CREATE INDEX hardware_generic_message_hgm_timestamp_idx
  ON hardware_generic_message
  USING btree
  (hgm_timestamp);



ALTER TABLE hardware_group ADD COLUMN hwg_serial integer DEFAULT 0;







-- Table: receiver_geotrace_log

-- DROP TABLE receiver_geotrace_log;

CREATE TABLE receiver_geotrace_log
(
  rgl_id bigserial NOT NULL,
  rgl_time timestamp without time zone NOT NULL DEFAULT now(),
  rgl_msg text NOT NULL,
  CONSTRAINT receiver_geotrace_log_rgl_id_pkey PRIMARY KEY (rgl_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE receiver_geotrace_log
  OWNER TO postgres;

-- Index: rgl_time

-- DROP INDEX rgl_time;

CREATE INDEX rgl_time
  ON receiver_geotrace_log
  USING btree
  (rgl_time);



ALTER TABLE company_user ADD COLUMN cu_dshield_guard integer DEFAULT 0;
