var page_url				= '';
var site_loaded				= false;
var editing_row				= null;
var editing_sel				= null;
var table_header_set		= null;
var resize_callbacks		= [];
var resize_informer_id		= null;
var user_jobs				= null;
var user_job_locked			= false;
var modal_dialog_keep_open	= false;
var site_version			= 0;
var auto_update_interval	= null;

function site_init( base_url )
{
	page_url		= base_url;
	
	subsystem_but_update();
	
	content_update();
	
	$('.header_icon').each(
		function()
		{
			$(this).on('click', function(e)
			{
				header_icon_click( $( e.currentTarget ), e.which );
			})
		}
	);
	
	$('.subsystem_but').hover(
		function()
		{
			if ( $(this).parent().next().hasClass('vertical_sep') )
			{
				$(this).parent().next().css('opacity', 0);
			}
			
			if ( $(this).parent().prev().hasClass('vertical_sep') )
			{
				$(this).parent().prev().css('opacity', 0);
			}
		},
		function()
		{
			if ( $(this).parent().next().hasClass('vertical_sep') )
			{
				$(this).parent().next().css('opacity', 1);
			}
			
			if ( $(this).parent().prev().hasClass('vertical_sep') )
			{
				$(this).parent().prev().css('opacity', 1);
			}
		}
	);
	
	header_icon_update();
	
	kajax_register_load_callback( 
		function( where, page_url )
		{
			content_manage( where, page_url );
			
			content_update();
		}
	);
	
	alertify.set(
		{
			labels:
			{
				ok: "Aceptar", 
				cancel : "Cancelar"
			}
		}
	);
	
	client_search_button_register( $( "#to_user_profile" ), page_url + 'users/search/?cb=user_profile_jump' );
		
	$(document).mouseup(function (e)
	{
		$(".panel_box").each(
			function()
			{
				var container	= $(this);
				
				if ( !container.hasClass('no_lock') )
				{
					var fchild		= container.find(':first-child');
					
					if (fchild.has(e.target).length > 0)
					{
						panel_lock( container, true );
					}
				}
			}
		);
	});
	
	user_jobs_start();
	
	if ( 'undefined' != typeof on_site_loaded )
	{
		on_site_loaded();
	}
	
	site_loaded = true;
}

function resize_event()
{
	content_update();
	
	table_header_fixed_update();
	
	resize_callbacks_fire();
}

$(window).resize(function()
{
	resize_event();
});

function viewport()
{
	var e = window, a = 'inner';

	if ( !('innerWidth' in window ) )
	{
		a = 'client';
		e = document.documentElement || document.body;
	}

	return { width : e[ a+'Width' ] , height : e[ a+'Height' ] };
}

function user_profile_jump( row_id, ui_id, uid, ui_fullname )
{
	location.href = page_url + 'user/log_as/' + uid;
}

function header_slide_up()
{
	var htop = $('#header_top');
	
	if ( htop.is(":visible") )
	{
		$('#header_top_hide_but').children().attr('class','sprite-img-flechin-down');
		
		htop.slideUp( { 'duration' : 250, 'step' : function() { content_update(); resize_callbacks_fire(); } } );
		
		dshield_update_state();
	}
}

function header_slide_down()
{
	var htop = $('#header_top');
	
	if ( !htop.is(":visible") )
	{
		$('#header_top_hide_but').children().attr('class','sprite-img-flechin-up');
		
		htop.slideDown( { 'duration' : 250, 'step' : function() { content_update(); resize_callbacks_fire(); } } );
		
		dshield_update_state( true );
	}
}

function header_toggle()
{
	var htop = $('#header_top');
	
	if ( htop.is(":visible") )
	{
		header_slide_up();
	}
	else
	{
		header_slide_down();
	}
}

function panel_lock( panel, lock )
{
	var lock_but = panel.find('.panel_lock_but');
	
	if ( lock_but.length > 0 )
	{
		panel.prop('locked', lock );
		
		if ( panel.prop('locked') )
		{
			lock_but.removeClass('sprite-img-candado-unlock');
			lock_but.addClass('sprite-img-candado-lock');
		}
		else
		{
			lock_but.removeClass('sprite-img-candado-lock');
			lock_but.addClass('sprite-img-candado-unlock');
		}
	}
}

function panel_register( panel, kind, locked )
{
	if ( panel.length == 0 )
	{
		return;
	}
	
	var rkind	= typeof kind == 'undefined' ? 'left' : kind;
	var rlocked	= typeof locked == 'undefined' ? false : locked;
	
	panel.prop('kind', rkind);
	panel.prop('locked', rlocked);
	panel.prop('hovering', false);
	
	panel.mouseenter( function( event )
	{
		panel_mouseenter( event );
	});
	
	panel.mouseleave( function( event )
	{
		panel_mouseleave( event );
	});
	
	var lock_but = panel.find('.panel_lock_but');
	
	if ( lock_but.length > 0 )
	{
		lock_but.unbind('click');
		lock_but.bind('click', 
			function()
			{
				panel_lock( panel, !panel.prop('locked') );
			}
		);
	}
	
	if ( !panel.prop('locked') )
	{
		var panel_toggle_to = 'left' == rkind ?
								function() { panel_toggle_left( panel, true ) } :
								function() { panel_toggle_right( panel, true ) }
								
		setTimeout(
			function()
			{
				if ( !panel.prop('locked') && !panel.prop('hovering') )
				{
					panel_toggle_to();
				}
			},
		2000 );
	}
	else
	{
		lock_but.removeClass('sprite-img-candado-unlock');
		lock_but.addClass('sprite-img-candado-lock');
	}
}

function panel_mouseenter( panel )
{
	var par		= $(panel.currentTarget);
	
	par.prop('hovering', true);
	
	if ( par.prop('locked') )
	{
		return;
	}
	
	var box 	= par.find(':first-child');
	var box_pos	= 0;
	var css_obj	= par.prop('kind') == 'left' ? { left: box_pos } : { right: box_pos };
	
	par.stop().animate( css_obj, { duration: 500 } );
}

function panel_mouseleave( panel )
{
	var par		= $(panel.currentTarget);
	
	par.prop('hovering', false);
	
	if ( par.prop('locked') )
	{
		return;
	}
	
	var box 	= par.find(':first-child');
	var box_pos	= par.prop('kind') == 'left' ? -box.innerWidth() + parseInt( box.css('paddingRight') ) : -box.outerWidth();
	var css_obj	= par.prop('kind') == 'left' ? { left: box_pos } : { right: box_pos };
	
	par.stop().animate( css_obj, { duration: 500 } );
}

function panel_toggle_left( clicked, is_parent )
{
	var par 	= 'undefined' == typeof is_parent ? clicked.parent().parent() : clicked;
	var box 	= par.find(':first-child');
	var box_pos	= par.offset().left >= 0 ? -box.innerWidth() + parseInt( box.css('paddingRight') ) : 0;
	var box_cls	= par.offset().left >= 0 ? 'sprite-img-flechin-in' : 'sprite-img-flechin-out';

	par.stop().animate( { left: box_pos }, 500 );
	
	if ( 'undefined' == typeof is_parent )
	{
		clicked.attr( 'class', box_cls );
	}
	else
	{
		clicked.find( '.panel_hide_but' ).attr( 'class', box_cls );
	}
	
	return false;
}

function panel_toggle_right( clicked, is_parent )
{	
	var par 	= 'undefined' == typeof is_parent ? clicked.parent().parent() : clicked;
	var box 	= par.find(':first-child');
	var right	= parseInt( par.css('right') );
	var box_pos	= right < 0 ? 0 : -box.outerWidth();
	var box_cls	= right < 0 ? 'sprite-img-flechin-in' : 'sprite-img-flechin-out';

	par.stop().animate( { right: box_pos }, 500 );
	
	if ( 'undefined' == typeof is_parent )
	{
		clicked.attr( 'class', box_cls );
	}
	else
	{
		clicked.find( '.panel_hide_but' ).attr( 'class', box_cls );
	}
	
	return false;
}

function subsystem_buttons_set_inactive()
{
	$('.subsystem_but').each(
		function()
		{
			$(this).removeClass('subsystem_but_active');
		}
	);
}

function subsystem_but_update()
{
	subsystem_buttons_set_inactive();
	
	$('#vsep_1, #vsep_2').show();

	if ( location.pathname.startsWith( '/geotrace' ) )
	{
		var geotrace = $('#geotrace_but');
		
		geotrace.addClass( 'subsystem_but_active' );
		geotrace.parent().prev().hide();
		geotrace.parent().next().hide();
	}
	else if ( location.pathname.startsWith( '/dshield' ) )
	{
		var dshield = $('#dshield_but');
		
		dshield.addClass( 'subsystem_but_active' );
		dshield.parent().prev().hide();
		
		header_slide_up();
	}
	else
	{
		var airmesh = $('#airmesh_but');
		
		airmesh.addClass( 'subsystem_but_active' );
		airmesh.parent().next().hide();
	}
	
	dshield_update_state();
}

function header_icon_update()
{
	header_icons_set_inactive();
	
	if ( location.pathname.startsWith( '/user/map' ) || 
		 location.pathname.startsWith( '/dshield/map' ) || 
		 '/dshield' == location.pathname
	)
	{
		$('#header_icon_map, #header_icon_map_ds').addClass('header_icon_active');
	}
	else if ( 
		location.pathname.startsWith( '/hw/percents' )	|| 
		location.pathname.startsWith( '/hw/tests' )		|| 
		location.pathname.startsWith( '/hw/stats' ) 
	)
	{
		$('#header_icon_graph').addClass('header_icon_active');
	}
	else if ( location.pathname.startsWith( '/hw/events' ) )
	{
		$('#header_icon_events').addClass('header_icon_active');
	}
	else if ( location.pathname.startsWith( '/receiver' ) )
	{
		$('#header_icon_receiver').addClass('header_icon_active');
	}
	else if ( location.pathname.startsWith( '/dshield/control' ) )
	{
		$('#header_icon_control').addClass('header_icon_active');
	}
	else if ( location.pathname.startsWith( '/dshield/stats' ) )
	{
		$('#header_icon_stats_ds').addClass('header_icon_active');
	}
	else if ( location.pathname == '/user' )
	{
		var init = $('#header_icon_init');
		
		if ( init.length > 0 )
		{
			init.addClass('header_icon_active');
		}
		else
		{
			$('#header_icon_map').addClass('header_icon_active');
		}
	}
}

function content_manage( where, page_url )
{
	if ( 'ajax-paging' != where.attr('id') && !where.hasClass('modal_dialog') && where.parents('.modal_dialog').length == 0 )
	{
		editing_row			= null;
		editing_sel			= null;
		table_header_set	= null;
		
		if ( !modal_dialog_keep_open )
		{
			modal_dialog_close();
		}
	}
	
	subsystem_but_update();
	
	header_icon_update();
}

function content_get_visible_height()
{
	var header = $('#header');
	
	if ( null == header || header.length == 0 )
	{
		content_force_size();
		return;
	}
	
	var footer = $('#footer');
	var win	= $(window);
	var conh = ( win.height() - header.outerHeight() - footer.outerHeight() );
	
	return conh;
}

function header_get_height()
{
	var header = $('#header');
	
	if ( null == header || header.length == 0 )
	{
		return 0;
	}
	
	return header.outerHeight();
}

function content_force_size()
{	// This is for the pdf rendering
	
	if ( 0 == $('.login').length )
	{
		var content = $('#content');
		content.css('width',  "1280px" );
		content.css('height', "768px" );
		content.css('margin-top', "0px" );
	}
}

function boxed_table_update()
{
	var header = $('#header');
	var bottom_panel = $('.panel_dshield_bottom');
	
	if ( header.length > 0 && bottom_panel.length > 0 )
	{
		var win	= $(window);
		var max_height = ( win.height() - header.outerHeight() - bottom_panel.outerHeight() ).toString();
		
		$('.boxed_table').css('max-height', max_height + 'px' );
	}
}

function content_update()
{
	var header = $('#header');
	
	if ( null == header || header.length == 0 )
	{
		content_force_size();
		return;
	}
	
	var content = $('#content');
	var footer = $('#footer');
	var win	= $(window);
	var winw = win.width().toString();
	var conh = ( win.height() - header.outerHeight() - footer.outerHeight() ).toString();
	
	if ( location.pathname.startsWith( '/dshield' ) )
	{
		conh = ( win.height() - header.outerHeight() ).toString();
	}
	
	if ( null == header.outerHeight() )
	{
		return;
	}
	
	var conm = header.outerHeight().toString();
	
	$('.pace-progress').css('top', conm + "px" );
	
	content.css('width',  winw + "px" );
	content.css('height', conh + "px" );
	content.css('margin-top', conm + "px" );
	
	$('.panel_box_left_top').each(
		function()
		{
			$(this).css('top', ( header.outerHeight() + 10 ).toString() + "px" );
		}
	);
	
	$('.panel_box_right_top').each(
		function()
		{
			$(this).css('top', ( header.outerHeight() + 10 ).toString() + "px" );
		}
	);
	
	$('.panel_box_left_bottom').each(
		function()
		{
			$(this).css('top', ( header.outerHeight() + 10 + $('.panel_box_left_top').outerHeight() + 10 ).toString() + "px" );
		}
	);
	
	$('.panel_box_right_bottom').each(
		function()
		{
			$(this).css('top', ( header.outerHeight() + 10 + $('.panel_box_right_top').outerHeight() + 10 ).toString() + "px" );
		}
	);
	
	boxed_table_update();
	modal_dialog_update();
}

function header_icons_set_inactive()
{
	$('.header_icon').each(
		function()
		{
			$(this).removeClass('header_icon_active');
		}
	);
}

function header_icon_click( icon_parent, button_id )
{
	if ( !icon_parent.data( 'href' ) || icon_parent.data( 'href' ) == '#' )
	{
		return;
	}
	
	if ( 2 == button_id )
	{
		window.open( icon_parent.data( 'href' ), '_blank');
	}
	else if ( 1 == button_id )
	{	
		header_icons_set_inactive();
		
		icon_parent.addClass('header_icon_active');
		
		kajax_load_target( icon_parent.data('href') );
	}
}

function svg_save()
{
	//get html text
	var svg = $('svg').clone().wrap('<div>').parent().html();

	//temporary canvas
	var tmpc = document.createElement('canvas');

	//renders the svg
	canvg( tmpc, svg, { ignoreMouse: true, ignoreAnimation: true} ); //render canvas

	var img = tmpc.toDataURL("image/png");

	open(img);
}

function zero_fill( number, width )
{
	if ( typeof width == 'undefined' )
	{
		width = 2;
	}
	
	width -= number.toString().length;

	if ( width > 0 )
	{
		return new Array( width + (/\./.test( number ) ? 2 : 1) ).join( '0' ) + number;
	}

	return number;
}

function get_random_color()
{
	var letters_str = '0123456789ABCDEF';
	var letters = letters_str.split('');
	var color = '#';
	
	for (var i = 0; i < 6; i++ )
	{
		color += letters[Math.floor(Math.random() * letters_str.length)];
	}
	
	return color;
}

function get_random_color_from_string( str )
{
	var d2h = function(d)
	{
		var h = (parseInt(+d)).toString(16);
		return h.length === 1 ? '0' + h : h;
	}
	
	var val = Math.abs( str.hashCode() );

	val = (val+0x7ed55d16) + (val<<12);
	val = (val^0xc761c23c) ^ (val>>19);
	val = (val+0x165667b1) + (val<<5);
	val = (val+0xd3a2646c) ^ (val<<9);
	val = (val+0xfd7046c5) + (val<<3);
	val = (val^0xb55a4f09) ^ (val>>16);

	var r = (val>>0) & 0xFF;
	var g = (val>>8) & 0xFF;
	var b = (val>>16) & 0xFF;

	var max = r>g ? (r>b ? r : b) : (g>b ? g : b);

	var mult = 127;
	var add = 63;
	
	r = (r*mult)/max + add;
	g = (g*mult)/max + add;
	b = (b*mult)/max + add;

	return '#' + d2h(r) + d2h(g) + d2h(b);
}

function datetime_format( datestr )
{
	var fsplit = datestr.split(' ');
	var ssplit = fsplit[0].split('/');
	var msplit = fsplit[1].split(':');
	
	return { year:ssplit[2], month:ssplit[1], day:ssplit[0], hours:msplit[0], minutes:msplit[1], seconds:0, milliseconds:0 }
}

function date_str_beautify( datestr )
{
	var nsplit = datestr.split('.');
	return nsplit[0];
}

function date_from_unix_timestamp( unix_timestamp )
{
	return new Date(parseInt(unix_timestamp) * 1000);
}

function date_pp( unix_timestamp, without_year )
{
	var date = date_from_unix_timestamp( unix_timestamp );
	
	if ( 'undefined' != typeof without_year && true == without_year )
	{
		return	zero_fill(date.getDate()) + '/' + 
				zero_fill(date.getMonth()+1) + ' ' + 
				zero_fill(date.getHours()) + ':' + 
				zero_fill(date.getMinutes()) + ':' + 
				zero_fill(date.getSeconds());
	}
	
	return	date.getFullYear() + '-' + 
			zero_fill(date.getMonth()+1) + '-' + 
			zero_fill(date.getDate()) + ' ' + 
			zero_fill(date.getHours()) + ':' + 
			zero_fill(date.getMinutes()) + ':' + 
			zero_fill(date.getSeconds());
}

function date_from_str(strdate)
{
	var splited		= strdate.split( ' ' );
	var tdate		= splited[0].split( '-' );
	var thour		= splited[1].split( ':' );
	var msecs		= 0;
	var tsecs		= [0];
	
	if ( tdate.length <= 1 )
	{
		tdate = splited[0].split('/');
		
		if ( tdate.length == 3 )
		{
			var year = tdate[2];
			tdate[2] = tdate[0]; // day
			tdate[0] = year;
		}
	}

	if ( thour.length < 3 )
	{
		//
	}
	else if ( thour[2].indexOf( '.' ) != -1 )
	{
		tsecs		= thour[2].split( '.' );
		msecs 		= tsecs[1] / 1000;
	}
	else
	{
		tsecs[0]	= thour[2];
	}
	
	if ( tsecs.length > 0 && 'string' == typeof tsecs[0] )
	{
		if ( tsecs[0].contains('-') )
		{
			tsecs[0] = tsecs[0].split('-')[0];
		}
		else if ( tsecs[0].contains('+') )
		{
			tsecs[0] = tsecs[0].split('+')[0];
		}
	}
	
	return new Date( tdate[0],  tdate[1] - 1, tdate[2], thour[0],  thour[1], tsecs[0], msecs );
}

function date_format_time_entry(strdate)
{
	var date = isNaN(strdate) ? date_from_str(strdate) : date_from_unix_timestamp( strdate );
	var d = zero_fill(date.getDate())+'/'+ zero_fill(date.getMonth()+1);
	var t =	zero_fill(date.getHours()) + ':' + 
			zero_fill(date.getMinutes()) + ':' + 
			zero_fill(date.getSeconds());
	
	return d+' '+t;
}

function date_picker_init( elem, datestr, date_format_prefix )
{
	datetime_picker_init( elem, datestr, date_format_prefix, '' );
}

function datetime_picker_init( elem, datestr, date_format_prefix, time_format )
{
	try
	{
		$.datepicker.setDefaults( $.datepicker.regional['es'] );
		var df = typeof date_format_prefix == 'undefined' ? '' : date_format_prefix;
		var el = $(elem);
		var tf = typeof time_format == 'undefined' ? 'HH:mm' : time_format;
		
		el.datetimepicker(
			{
				dateFormat: df + 'dd/mm/yy',
				altSeparator: ' ',
				timeFormat: tf
			}
		);
		
		var date;
		
		if ( typeof datestr != 'undefined' )
		{
			if ( typeof datestr.getMonth == 'function' )
			{
				date = datestr;
			}
			else
			{
				date = date_from_str( datestr );
			}
		}
		else
		{
			date = new Date();
		}
		
		el.datetimepicker( 'setDate', date );
	}
	catch(err)
	{}
}

function file_upload_init( fu /* file upload DOM element */, url /** request url */, done_cb /** on upload done callback */, progress_el /** progressbar element */ )
{
	if ( 'undefined' == typeof progress_el )
	{
		progress_el = $('#progress');
	}
	
	if ( fu.length > 0 )
	{
		fu.fileupload({
			url: url,
			dataType: 'json',
			start:function(e)
			{
				if ( 'undefined' != typeof progress_el )
				{
					progress_el.show();
					
					var progress_text = progress_el.find('.progress-text');
					
					if ( progress_text.length )
					{
						progress_text.text( '0%' );
					}
				}
			},
			done: function (e, data)
			{
				done_cb( e, data );
			},
			progressall: function (e, data)
			{
				if ( 'undefined' != typeof progress_el )
				{
					var progress = parseInt( data.loaded / data.total * 100, 10 );
					
					progress_el.find('.progress-bar').css( 'width', progress + '%' );
					
					var progress_text = progress_el.find('.progress-text');
					
					if ( progress_text.length )
					{
						progress_text.text( progress + '%' );
					}
					
					if ( data.loaded == data.total )
					{
						progress_el.hide();
					}
					else
					{
						progress_el.show();
					}
				}
			}
		}).prop('disabled', !$.support.fileInput).parent().addClass($.support.fileInput ? undefined : 'disabled');
	}
}

function table_row_selected_register( t )
{
	var focus_f = function()
	{
		var p = t.parent().parent();
		
		if ( p.is('tbody') )
		{
			p = t.parent();
		}
		
		do
		{
			if ( p && p.attr('id') && p.attr('id').startsWith('row') )
			{
				break;
			}
			
			p = p.parent();
		} while( p.length > 0 );
		
		if ( p.length == 0 )
		{
			return;
		}
		
		var row_selected	= p;
		var new_editing_row = row_selected.next();
		
		if ( !row_selected.attr('id').startsWith('row') )
		{
			return;
		}
		
		while ( row_selected.attr('id').startsWith('row_extra') )
		{
			row_selected = row_selected.prev();
		}
		
		while ( new_editing_row.attr('id').startsWith('row_extra') )
		{
			new_editing_row = new_editing_row.next();
		}
		
		var new_editing_row_id = new_editing_row.attr('id');
		
		while ( !new_editing_row.attr('id').startsWith('row_hidden') )
		{
			new_editing_row	= new_editing_row.next();
		}
		
		if ( null != editing_row && editing_row.attr('id') != new_editing_row.attr('id') )
		{
			editing_sel.removeClass('selected');
			editing_row.addClass( 'hidden' );
			
			var row_extra = editing_sel.next();
			
			while ( row_extra.length > 0 && row_extra.attr('id').startsWith('row_extra') )
			{
				row_extra.addClass('hidden');
				row_extra = row_extra.next();
			}
			
			if ( 'undefined' != typeof on_table_row_unselected )
			{
				on_table_row_unselected( editing_sel );
			}
		}
		
		editing_sel = row_selected;
		editing_row = new_editing_row;
		
		editing_sel.addClass('selected');
		editing_row.removeClass('hidden');
		
		var row_next = editing_sel.next();
		
		while ( row_next.attr('id').startsWith('row_extra') )
		{
			row_next.addClass('selected');
			row_next.removeClass('hidden');
			row_next = row_next.next();
		}
		
		if ( 'undefined' != typeof on_table_row_selected )
		{
			on_table_row_selected( row_selected );
		}
	}
	
	if ( t.is(':checkbox') )
	{
		t.change( focus_f );
	}
	else if ( t.is('tr') || t.is('td') )
	{
		t.click(function(el)
		{
			if ( el.target == this )
			{
				var target = $(el.target).parent();
				var id = target.attr('id');
				
				if ( 'undefined' != typeof id && !id.startsWith('row_hidden') )
				{
					focus_f();
				}
			}
		} );
	}
	else
	{
		t.focus( focus_f );
	}
}

function table_row_new_register_from_hidden( row_new_hidden, rows_new, row_hidden_new, div_scroller, form, base_name, table )
{
	if ( $(rows_new).length == 0 )
	{
		var row_new = row_new_hidden.clone();
		
		row_new.find('tr').each(function(index)
		{
			var tr = $(this);
			
			if ( tr.attr('id').startsWith( base_name ) )
			{
				tr.attr('id', tr.attr('id').substr( base_name.length ) );
			}
		});
		
		table.prepend( row_new.children() );
		
		table_row_new_register( $(rows_new), $(row_hidden_new), $(div_scroller), $(form) );
	}
}

function table_row_new_register_from_url( url, el, rows_new, row_hidden_new, div_scroller, form )
{
	if ( rows_new.length == 0 )
	{
		kajax_eval( 
			el.attr('href'), 
			null, 
			function()
			{
				table_row_new_register( rows_new, row_hidden_new, div_scroller, form );
			}
		);
	}
}

function table_row_new_register( rows_new, row_hidden_new, div_scroller, form, avoid_scroll )
{
	var row_new = null;
	var focus_f = function( row_new )
	{
		var nri = row_new.find('input[type=text]');
		
		for ( var i = 0; i < nri.length; i++ )
		{
			var el = $( nri[i] );
			
			if ( !el.prop('disabled') )
			{
				el.focus();
				
				break;
			}
		}
	}
	
	if ( $.isArray( rows_new ) )
	{
		row_new = rows_new[0];
		
		for ( var i = 0; i < rows_new.length; i++ )
		{
			rows_new[i].find('input[type=text], input[type=password], select, textarea, img').each(
				function()
				{
					table_row_selected_register( $(this) );
				}
			);
		}
	}
	else
	{
		row_new = rows_new;
		row_new.find('input[type=text], input[type=password], select, textarea, img').each(
			function()
			{
				table_row_selected_register( $(this) );
			}
		);
	}
	
	var cancel_but = row_hidden_new.find( 'button.cancel_btn' );
	cancel_but.unbind('click');
	cancel_but.bind('click', 
		function()
		{
			if ( $.isArray( rows_new ) )
			{
				for ( var i = 0; i < rows_new.length; i++ )
				{
					rows_new[i].remove();
				}
			}
			else
			{
				rows_new.remove();
			}
			
			row_hidden_new.remove();
			
			editing_row	= null;
			editing_sel	= null;
		}
	);
	
	var save_but = row_hidden_new.find('button.save_btn');
	save_but.unbind('click');
	save_but.bind('click', 
		function()
		{
			table_save_click_register( form, save_but.parent().parent().prev() );
		}
	);
	
	if ( div_scroller.scrollTop() > 0 && !avoid_scroll )
	{
		div_scroller.scrollTo(
			{ top:0, left:0 },
			800,
			{
				onAfter: function()
				{
					focus_f( row_new );
				}
			}
		);
	}
	else
	{
		focus_f( row_new );
	}
}

function table_cancel_click_register( t )
{
	var row = t.parent().parent().prev();
	
	while ( row.attr('id').startsWith('row_extra') )
	{
		row.removeClass('selected');
		row.addClass('hidden');
		row = row.prev();
	}
	
	row.removeClass('selected');
	t.parent().parent().addClass('hidden');

	var row_extra = row.next();
	
	while ( row_extra.attr('id').startsWith('row_extra') )
	{
		row_extra.addClass('hidden');
		row_extra = row_extra.next();
	}

	if ( 'undefined' != typeof on_table_row_unselected )
	{
		on_table_row_unselected( row );
	}
}

function table_row_new_convert_to_id( id, id_field_name, url, val )
{
	var row_new		= $('#row_new');
	var row			= ( row_new.length > 0 ) ? row_new : $('#row_'+id);
	var row_hidden	= row.next();

	while ( !row_hidden.attr('id').startsWith('row_hidden') )
	{
		row_hidden	= row_hidden.next();
	}

	row.find('input[name="' + id_field_name + '"]').val(id);
	
	var cancel_but = row_hidden.find( 'button.cancel_btn' );
	cancel_but.unbind('click');
	cancel_but.bind('click', function() { table_cancel_click_register( cancel_but ); } );
	
	if ( 'undefined' != typeof url && '' != url )
	{
		row_hidden.find('td').prepend( '<button data-href="' + url + '" class="submit_btn_table delete_btn" data-text="' + val + '"><span>Eliminar</span></button>' );
		
		var delete_but = row_hidden.find('button.delete_btn');
		delete_but.unbind('click');
		delete_but.bind('click', 
			function()
			{
				kajax_fancy_confirm( delete_but.data('text'), function() { kajax_eval_click( delete_but ); } );
			}
		);
	}
	
	if ( 'undefined' != typeof table_row_new_fix_current )
	{
		table_row_new_fix_current( id );
	}
}

function table_save_click_register( form, row_clone )
{
	while ( row_clone.attr('id').startsWith('row_extra') )
	{
		row_clone = row_clone.prev();
	}
	
	var row			= [ row_clone ];
	var row_extra	= row_clone.next();
	
	while ( row_extra.attr('id').startsWith('row_extra') )
	{
		row.push( row_extra );
		
		row_extra	= row_extra.next();
	}
	
	kajax_table_row_form_submit( form, row );
}

function table_delete_click_register( btn )
{
	btn.unbind('click');
	btn.bind('click', 
		function()
		{
			kajax_fancy_confirm( btn.data('text'), function() { kajax_eval_click( btn ); } );
		}
	);
}

function table_register( form_table, focus_td_click )
{
	$('table tr td input[type=text], table tr td input[type=password], table tr td select, table tr td textarea, table tr td img, table tr td input[type=checkbox]').each(
		function()
		{
			table_row_selected_register( $(this) );
		}
	);
	
	if ( focus_td_click == true )
	{
		$('table tr td').each(
			function()
			{
				table_row_selected_register( $(this) );
			}
		);
	}
	
	$('table tr td button.cancel_btn').each(
		function()
		{
			var t = $(this);
			
			t.unbind('click');
			t.bind('click', 
				function()
				{
					table_cancel_click_register( t );
				}
			);
		}
	);
	
	$('table tr td button.save_btn').each(
		function()
		{
			var f = form_table;
			var t = $(this);
			
			t.unbind('click');
			t.bind('click', 
				function()
				{
					table_save_click_register( f, t.parent().parent().prev() );
				}
			);
		}
	);
	
	$('table tr td button.view_btn').each(
		function()
		{
			var t = $(this);
			
			t.unbind('click');
			t.bind('click',
				function()
				{
					kajax_load_target( t.data('href') );
				}
			);
		}
	);
	
	$('table tr td button.modal_ajax_btn').each(
		function()
		{
			var t = $(this);
			
			t.unbind('click');
			t.bind('click',
				function()
				{
					modal_dialog_ajax_get( t.data('href'), null, t.data('options') );
				}
			);
		}
	);
	
	$('table tr td button.delete_btn, table tr td button.suspend_btn').each(
		function()
		{
			table_delete_click_register( $(this) );
		}
	);
}

function autocomplete_register( el, url, what, callback )
{
	el.autocomplete(
	{
		source: function( request, response )
		{
			$.ajax(
			{
				url: url,
				type: 'GET',
				data: { search: request.term, what:what },
				success: function( data )
				{
					var d = $.parseJSON( data );
					
					response( $.map(d, function(item)
					{
						return {
							value: item.name,
							id: item.id
						};
					}));
				}
			});
		},
		minLength: 1,
		select: function( event, ui )
		{
			if ( ui.item )
			{
				callback(ui);
			}
		}
	});
}

function client_search_button_register( el, url, callback )
{
	el.unbind('click');
	el.bind('click', 
		function()
		{
			var load_url	= url;
			
			$(this).focus();
			
			modal_dialog_ajax_get( load_url, null, {
					width: '95%', 
					extraClass: 'users_dialog',
					onComplete: function()
					{
						kajax_on_loaded_event( $('#ajax-paging'), load_url );
					}
				}
			);
			
		}
	);
}

function edit_show()
{
	$('.edit_box, .edit_box input, .edit_box select, #name_input').each(
		function()
		{
			$(this).addClass('editable');
			$(this).prop('disabled',false);
		}
	);
	
	$('.cancel_btn, .save_btn').show();
}

function edit_hide()
{
	$('.edit_box, .edit_box input, .edit_box select, #name_input').each(
		function()
		{
			$(this).removeClass('editable');
			$(this).prop('disabled',true);
		}
	);
	
	$('.cancel_btn, .save_btn').hide();
}

function edit_switch()
{
	if ( $('.edit_box').hasClass('editable') )
	{
		edit_hide();
	}
	else
	{
		edit_show();
	}
	
	content_update();
	
	return false;
}

function elem_sum( elname, quant )
{
	var el	= $(elname);
	var sum	= 1;
	
	if ( typeof quant != 'undefined' )
	{
		sum = quant;
	}
	
	if ( el.length )
	{
		var num	= parseInt( el.text() );
		
		num += sum;
		
		el.text( num.toString() );
	}
}

function dropdown_filter_register( filter_name, accept_cb, cancel_cb )
{
	filter_name = 'undefined' == typeof filter_name ? '.filter_tab' : filter_name;
	
	$(filter_name).each(function()
	{
		var filter_tab		= $(this);
		var filter_title	= filter_tab.find('.filter_title').html();
		var open 			= filter_tab.find('.open-form');
		var close			= filter_tab.find('.close-form');
		var accept			= filter_tab.find('.accept');
		var cancel			= filter_tab.find('.cancel');
		var hidden_filter	= filter_tab.find('.hidden-filters');
		var info_container	= filter_tab.find('.info_container');
		
		if ( info_container.length > 0 )
		{
			info_container.mCustomScrollbar({
				setWidth: "100%"
			});
		}
		
		var accept_func		= function()
		{
			check_title_func();
			
			open.show();
			hidden_filter.stop().slideUp(100);
			
			if ( 'function' == typeof accept_cb )
			{
				var checked_map = $filter_tab.find('input:checkbox:checked').map(function() { return this.value; }).get();
				
				accept_cb( filter_tab, checked_map );
			}
		};
		
		var cancel_func		= function()
		{
			filter_tab.find('input[type=checkbox]').prop('checked', false);
			filter_tab.find('.filter_title').html( filter_title );
			
			open.show();
			hidden_filter.stop().slideUp(100);
			
			if ( 'function' == typeof cancel_cb )
			{
				cancel_cb( filter_tab, [] );
			}
		};
		
		var check_title_func= function()
		{
			var ftitle = filter_tab.find('.filter_title');
			var checked = filter_tab.find('input[type=checkbox]:checked');
			
			if ( ftitle.hasClass('filter_clean') )
			{
				return;
			}
			
			if ( checked.length > 0 )
			{
				if ( checked.length == 1 )
				{
					ftitle.html( checked.next().html() );
				}
				else
				{
					ftitle.html('Varios grupos seleccionados');
				}
			}
			else
			{
				ftitle.html( filter_title );
			}
		};
		
		check_title_func();
		
		open.unbind('click').bind('click',function()
		{
			$(this).hide(100);
			
			hidden_filter.stop().slideDown(100);
			hidden_filter.focus();
		});
		
		accept.unbind('click').bind('click', accept_func );
		
		cancel.unbind('click').bind('click', cancel_func );
		
		close.unbind('click').bind('click', accept_func );
	});
}

function table_header_fixed_update()
{
	if ( null == table_header_set )
	{
		return;
	}

	setTimeout(function()
	{
		var table_header_fixed	= $(".table_header_fixed");
		var header_tr			= table_header_fixed.find('thead tr');
		
		if ( null == table_header_set )
		{
			return;
		}
		
		var table_tr			= table_header_set.find("thead tr");
		
		table_tr.children().each(
			function(i, e)
			{
				var w = $(e).width();
				var c = $(header_tr.children()[i]);
				
				c.width( w );
			}
		);
	}, 100);
}

function table_header_fixed_register( table, top_elem_height )
{
	jQuery(document).ready(function()
	{
		setTimeout(function()
		{
			if ( 'undefined' == typeof table )
			{
				table				= $('.default_table');
			}
			
			if ( table.length == 0 )
			{
				return;
			}
			
			table_header_set		= table;
			var table_offset		= table_header_set.offset().top;
			var table_header		= table_header_set.find(" > thead").clone();
			var table_header_fixed	= $(".table_header_fixed");
			
			table_header_fixed.empty();
			
			var header_fixed		= table_header_fixed.append(table_header);
			var header_tr			= table_header.find('tr');
			var table_tr			= table_header_set.find("thead tr");
			var header_height		= parseInt( table_header_set.css("paddingTop").replace('px', '') );
			
			var prev_header			= table.parent().prev();
			
			while ( prev_header.length > 0 )
			{
				var pos_type = prev_header.css('position');
				
				if ( prev_header.is(':visible') && pos_type != 'absolute' && pos_type != 'fixed' )
				{
					header_height += prev_header.outerHeight();
				}
				
				prev_header = prev_header.prev();
			}
			
			table_tr.children().each(
				function(i, e)
				{
					var w = $(e).width();
					var c = $(header_tr.children()[i]);
					
					c.width( w );
				}
			);
			
			kajax_init( table_header_fixed );
			
			table_header.removeAttr('style');
			
			$('#content').bind("scroll", function()
			{
				var offset = $(this).scrollTop();
				
				if (offset >= header_height)
				{
					header_fixed.css('top', header_get_height() + 'px' );
					header_fixed.fadeIn(100);
				}
				else if (offset < table_offset)
				{
					header_fixed.fadeOut(100);
				}
			});
			
			var content_el = $('.resize_informer');
			
			if ( content_el.length > 0 )
			{
				var content_prev_height = content_el.height();
				
				resize_informer_id = setInterval(function()
				{
					var content_cur_height = content_el.height();
					
					if (content_prev_height !== content_cur_height)
					{
						resize_event();
						
						content_prev_height = content_cur_height;
					}
				}, 250 );
				
				kajax_register_unload_callback(function()
				{
					table_header_fixed_unregister();
					return true;
				});
			}
		}, 0 );
	});
}

function table_header_fixed_unregister()
{
	if ( null != resize_informer_id )
	{
		clearInterval( resize_informer_id );
		resize_informer_id = null;
	}
}

function mail_modal_dialog( load_url )
{
	modal_dialog_ajax_get( load_url, null, { width: 600, onComplete:function()
	{
		kajax_on_loaded_event( $('.mail_popup_div'), load_url );
	}} );
}

function mail_support()
{
	mail_modal_dialog( page_url + 'company/techsupport' );
}

function mail_buy()
{
	mail_modal_dialog( page_url + 'company/hwbuy' );
}

function mail_user_support()
{
	mail_modal_dialog( page_url + 'user/techsupport' );
}

function mail_user_adm_support()
{
	mail_modal_dialog( page_url + 'user/admsupport' );
}

function resize_callback_register( cb )
{
	return resize_callbacks.push( cb ) - 1;
}

function resize_callback_unregister( id )
{
	kajax_obj_remove_item( resize_callbacks, id );
}

function receiver( _receiver_div, _freq, _state_change_cb, _url, _new_tick_cb, _send_but, _auto_pause )
{
	this.max_id = null;
	this.last_tick_id = 0;
	this.interval_id = null;
	this.freq = _freq;
	this.receiver_div = _receiver_div;
	this.state_change_cb = typeof _state_change_cb == 'function' ? _state_change_cb : null;
	this.url = ( typeof _url != 'undefined' && null != _url ) ? _url : page_url + '/receiver/get_messages';
	this.new_tick_cb = typeof _new_tick_cb == 'function' ? _new_tick_cb : null;
	this.send_but = typeof _send_but != 'undefined' ? _send_but : null;
	this.auto_pause = typeof _auto_pause != 'undefined' ? _auto_pause : true;
	
	var my = this;
	
	if ( this.auto_pause )
	{
		this.receiver_div.scroll(function()
		{
			var sh = parseInt( my.receiver_div.prop("scrollHeight") - my.receiver_div.height() );
			var st = parseInt( my.receiver_div.scrollTop() );
			
			if ( sh != st )
			{
				my.unregister();
			}
			else
			{
				my.register();
			}
		});
	}
	
	this.register();
};

receiver.prototype.build_console_entry = function( data )
{
	var log_entry_base = $('#log_entry_base').clone();
	var cls = 'log_entry_color_normal';

	time = date_format_time_entry( data['time'] );
	msg = data['msg'];

	var lower = msg.toLowerCase();

	if( lower.indexOf("error") != -1 || lower.indexOf("excepcion") != -1)
	{
		cls = 'log_entry_color_error';
	}
	else if( msg.indexOf("Heart Beat") == 0 )
	{
		cls = 'log_entry_color_heartbeat';
	}
	else if( msg.indexOf("Domo") != -1 )
	{
		cls = 'log_entry_color_domo';
	}
	else if ( msg.indexOf("Modem") != -1 )
	{
		cls = 'log_entry_color_modem';
		
		if ( msg.startsWith("TX") )
		{
			cls = 'log_entry_color_modem_sent';
		}
	}
	else if ( msg.startsWith("Queued Command") )
	{
		cls = 'log_entry_color_queued';
	}
	else if ( msg.startsWith("Sending Command") )
	{
		cls = 'log_entry_color_sending';
	}
	else if ( msg.startsWith("Received Command") )
	{
		msgp = msg.split(' ');
		
		// this is a citymesh response
		if ( msgp.length > 13 )
		{
			var force_state = parseInt( msgp[10] );
			
			switch ( force_state )
			{
				case 0x00/*EXECUTED*/:
				{
					cls = 'log_entry_color_executed';
					break;
				}
				case 0x01/*ERROR*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( unknown error )";
					break;
				}
				case 0x02/*ERROR_INVALID_CMD*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( invalid command )";
					break;
				}
				case 0x03/*ERROR_INVALID_VAL*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( invalid value )";
					break;
				}
				case 0x04/*ERROR_TIMEOUT*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( timeout )";
					break;
				}
			}
		}
		// this is an airmesh response
		else if ( msgp.length >= 6 )
		{
			var state_type = parseInt( msgp[4] );
			
			switch ( state_type )
			{
				case 0x00/*EXECUTED*/:
				{
					cls = 'log_entry_color_executed';
					break;
				}
				case 0x01/*ERROR*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( unknown error )";
					break;
				}
				case 0x02/*ERROR_INVALID_CMD*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( invalid command )";
					break;
				}
				case 0x03/*ERROR_INVALID_VAL*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( invalid value )";
					break;
				}
				case 0x04/*ERROR_TIMEOUT*/:
				{
					cls = 'log_entry_color_error';
					msg += " ( timeout )";
					break;
				}
			}
		}
	}
	else if ( msg.startsWith("Created Commands Batch") )
	{
		cls = 'log_entry_color_started';
	}
	else if ( msg.contains('success') )
	{
		cls = 'log_entry_color_executed';
	}
	else if ( msg.contains('error') || msg.contains('Cancelled') )
	{
		cls = 'log_entry_color_error';
	}
	
	log_entry_base.find('.log_entry_time').html( time );
	log_entry_base.find('.log_entry_msg').addClass( cls );
	
	if ( data['serial'] && data['serial'].length > 0 )
	{
		var entry_msg = log_entry_base.find('.log_entry_msg');
		entry_msg.html( '<span>' + dec2hex( data['serial'] ) + ': </span>' + msg );
		entry_msg.find('span').css('color', get_random_color_from_string( data['serial'] ) );
	}
	else
	{
		log_entry_base.find('.log_entry_msg').html( msg );
	}
	
	log_entry_base.attr('id', 'log_entry_' + data['id'] );
	
	return log_entry_base;
}

receiver.prototype.register = function()
{
	var my = this;
	
	if ( this.is_active() )
	{
		return;
	}
	
	this.interval_id = setInterval(function()
	{
		var data_str = ''
		
		if( my.max_id != null )
		{
			data_str = 'last_id=' + my.max_id;
		}

		$.ajax({
			url: my.url,
			type:'POST',
			data: data_str,
			success: function(res)
			{
				if ( '{}' == res )
				{
					return;
				}
				
				resp = jQuery.parseJSON(res);
				tick = resp['tick'];
				
				if( null != tick && parseInt( tick['last_tick_id'] ) > my.last_tick_id )
				{
					my.last_tick_id = parseInt( tick['last_tick_id'] );
					
					if ( null != my.new_tick_cb )
					{
						my.new_tick_cb( tick );
					}
				}

				if( resp['ok'] )
				{
					 $("#console_error").hide();
					 
					 if(resp['data'])
					 {
						var c = resp['data'].length;
						
						for( i in resp['data'] )
						{
							var d = resp['data'][c-i-1];
							var new_id = parseInt( d['id'] );
							
							if( my.max_id == null || new_id > my.max_id )
							{
								my.max_id = new_id;
							}

							var insert_e = my.build_console_entry( d );
							
							my.receiver_div.append( insert_e );
							
							$( '.log_entry_time', insert_e ).css('color','#a5ff00').animate( { color: '#808080' }, 5000, 'easeInExpo' );
						}
					 }
				}
				else
				{
					 var msg = "ERROR: "+resp['msg'];
					 
					 if($("#console_error").html() != null)
					 {
						 $("#console_error").html( msg );
						 $("#console_error").hide().fadeIn();
					 }
					 else
					 {
					 	var insert_e = $("<div class='console_error'>"+msg+"</div>" );
						
					 	my.receiver_div.append( insert_e );
					 }
				}
				
				my.receiver_div.scrollTop( my.receiver_div.prop("scrollHeight") );
				
				if ( my.state_change_cb != null )
				{
					my.state_change_cb();
				}
				
				if ( null != resp['is_running'] )
				{
					if ( !resp['is_running'] )
					{
						if ( null != my.send_but )
						{
							my.send_but.removeClass('red_but');
						}
					}
				}
			}
		});
	}, this.freq );
}

receiver.prototype.unregister = function()
{
	if ( this.is_active() )
	{
		clearInterval( this.interval_id );
		this.interval_id = null;
		
		if ( this.state_change_cb != null )
		{
			this.state_change_cb();
		}
	}
}

receiver.prototype.is_active = function()
{
	return this.interval_id != null;
}

receiver.prototype.switch_state = function()
{
	if ( this.is_active() )
	{
		this.unregister();
	}
	else
	{
		this.register();
	}
}

function resize_callbacks_fire()
{
	for ( var i = 0; i < resize_callbacks.length; i++ )
	{
		resize_callbacks[i]();
	}
	
	if ( 'function' == typeof map_resize_callback )
	{
		map_resize_callback();
	}
}

function user_jobs_start()
{
	var uj = $('#user_jobs');
	
	var user_job_func = function()
	{
		if ( user_job_locked )
			return;
		
		user_job_locked = true;
		
		$.get( page_url + 'user/jobs', null,
			function(res)
			{
				var json = $.parseJSON( res );
				
				if ( json )
				{
					var show = false;
					
					if ( json.airmesh )
					{
						var airmesh_send_but = $('#airmesh_send_but');
						
						if ( json.airmesh.is_running )
						{
							show = true;
							
							var state = json.airmesh.state;
							
							uj.find('.airmesh .ok_state div').html( state.ok );
							uj.find('.airmesh .error_state div').html( state.errors );
							uj.find('.airmesh .noresp_state div').html( state.noresp );
							uj.find('.airmesh .total_state div').html( state.total );
							uj.find('.airmesh .pending_send div').html( state.pending_send );
							uj.find('.airmesh .sent div').html( state.sent );
							uj.find('.airmesh .received div').html( state.received );
							
							if ( !airmesh_send_but.hasClass('red_but') )
							{
								airmesh_send_but.addClass('red_but')
							}
						}
						else
						{
							airmesh_send_but.removeClass('red_but');
						}
					}
					
					if ( json.citymesh )
					{
						var city_send_but = $('#citymesh_send_but');
						
						if ( json.citymesh.is_running )
						{
							show = true;
							
							var state = json.citymesh.state;
							
							uj.find('.citymesh .ok_state div').html( state.ok );
							uj.find('.citymesh .error_state div').html( state.errors );
							uj.find('.citymesh .noresp_state div').html( state.noresp );
							uj.find('.citymesh .total_state div').html( state.total );
							uj.find('.citymesh .pending_send div').html( state.pending_send );
							uj.find('.citymesh .sent div').html( state.sent );
							uj.find('.citymesh .received div').html( state.received );
							
							if ( !city_send_but.hasClass('red_but') )
							{
								city_send_but.addClass('red_but')
							}
						}
						else
						{
							city_send_but.removeClass('red_but');
						}
					}
					
					if ( show )
					{
						uj.fadeIn();
					}
					else
					{
						uj.fadeOut();
					}
				}
			}
		).always(function()
		{
			user_job_locked = false;
		});
	}
	
	user_job_func();
	
	user_jobs = setInterval( user_job_func, 5000 );
}

function user_jobs_slide_up()
{
	var htop = $('#user_jobs');
	
	if ( 0 != parseInt( htop.css('bottom') ) )
	{
		$('#user_jobs div.contractor').children().attr('class','sprite-img-flechin-down');
		
		htop.stop().animate( { bottom: 0 }, 500 );
	}
}

function user_jobs_slide_down()
{
	var htop = $('#user_jobs');
	
	if ( 0 == parseInt( htop.css('bottom') ) )
	{
		$('#user_jobs div.contractor').children().attr('class','sprite-img-flechin-up');
		
		var cont = htop.find('div.contractor');
		
		htop.stop().animate( { bottom: -htop.outerHeight(true) + cont.outerHeight(true) + cont.position().top }, 500 );
	}
}

function user_jobs_toggle()
{
	var htop = $('#user_jobs');
	
	if ( 0 == parseInt( htop.css('bottom') ) )
	{
		user_jobs_slide_down();
	}
	else
	{
		user_jobs_slide_up();
	}
}

function modal_dialog_from_url( url, reload_target )
{
	modal_dialog_ajax_get( url, {},
	{ 
		extraClass: 'modal_dialog_fancy', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
		},
		onClosed: function( _modal_manual_close )
		{
			if ( _modal_manual_close && 'undefined' != typeof reload_target && true == reload_target )
			{
				kajax_reload_target();
			}
		}
	});
}

function modal_dialog_from_data_href( me, reload_target )
{
	var url = $(me).attr('data-href') || $(me).attr('href');
	modal_dialog_from_url( url, reload_target );
}

if ( 'function' !== typeof Array.prototype.reduce )
{
	Array.prototype.reduce = function( callback /*, initialValue*/ )
	{
		'use strict';
		if ( null === this || 'undefined' === typeof this )
		{
			throw new TypeError( 'Array.prototype.reduce called on null or undefined' );
		}
		
		if ( 'function' !== typeof callback )
		{
			throw new TypeError( callback + ' is not a function' );
		}
		
		var t = Object( this ), len = t.length >>> 0, k = 0, value;
		
		if ( arguments.length >= 2 )
		{
			value = arguments[1];
		}
		else
		{
			while ( k < len && ! k in t ) k++;
			if ( k >= len )
				throw new TypeError('Reduce of empty array with no initial value');
			
			value = t[ k++ ];
		}
		
		for ( ; k < len ; k++ )
		{
			if ( k in t )
			{
				value = callback( value, t[k], k, t );
			}
		}
		
		return value;
	};
}

if ( !String.prototype.hashCode )
{
	String.prototype.hashCode = function()
	{
		return this.split("").reduce(
			function( a, b )
			{
				a = ( ( a << 5 ) - a ) + b.charCodeAt(0);
				return a & a;
			}, 0
		);
	};
}

function obj_serialize(obj)
{
	var str = [];
	
	for(var p in obj)
	{
		if (obj.hasOwnProperty(p))
		{
			str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
		}
	}
	
	return str.join("&");
}

function post_request( path, parameters )
{
	var form = $('<form></form>');

	form.attr("method", "post");
	form.attr("action", path);

	$.each(parameters, function(key, value)
	{
		if ( typeof value == 'object' || typeof value == 'array' )
		{
			$.each(value, function(subkey, subvalue)
			{
				var field = $('<input />');
				field.attr("type", "hidden");
				field.attr("name", key+'[]');
				field.attr("value", subvalue);
				form.append(field);
			});
		}
		else
		{
			var field = $('<input />');
			field.attr("type", "hidden");
			field.attr("name", key);
			field.attr("value", value);
			form.append(field);
		}
	});
	
	$(document.body).append(form);
	
	form.submit();
}

function domotic_action( hw_id, switch_num, state )
{
	this.hw_id				= hw_id;
	this.switch_num			= switch_num;
	this.state				= state;
	this.action_id			= 0;
	this.request_interval	= 2000; //intervalo de actualizacion de acciones en ms
	this.interval_id		= 0;
	this.switch_state		= this.action_switch_state;
	this.state_check		= this.action_state_check;
	var my					= this;
}

function domotic_action_new( hw_id, switch_num, state )
{
	var action = new domotic_action( hw_id, switch_num, state );
	
	action.switch_state( hw_id, switch_num, state );
}

function actions_state_check()
{
	var actions = $('.action_row');
	
	if ( actions.length > 0 )
	{
		for ( var i = 0; i < actions.length; i++ )
		{
			var act = $(actions.get(i));
			
			var action = new domotic_action( act.data("hw_id"), act.data("switch_num"), "" != act.data("enabled") );
			
			action.state_check( act.data("hw_id"), act.data("switch_num"), "" != act.data("enabled"), act.data("action_id"), true );
		}
	}
}

domotic_action.prototype.action_state_check = function( hw_id, switch_num, state, action_id, cancel_on_ended_response )
{
	var my = this;
	
	if ( undefined == typeof action_id || "" == action_id || !action_id )
		return;
	
	$.ajax({
		url: page_url + '/receiver/get_action_state',
		data: {
			'action_id':action_id
		},
		type: 'GET',
		success: function(res)
		{
			resp = jQuery.parseJSON(res);

			if(resp.ok)
			{
				if ( typeof cancel_on_ended_response != undefined && cancel_on_ended_response )
				{
					if ( 'EXECUTED' == resp.state || 'FAILED' == resp.state )
					{
						clearInterval( my.interval_id );
						
						return;
					}
				}
				
				my.action_state_show( hw_id, switch_num, state, resp.state );
			}
			else
			{
				clearInterval( my.interval_id );
			}
		}
	});
}

domotic_action.prototype.action_state_show = function( hw_id, switch_num, state, resp_state )
{
	var my = this;
	var action = $('#action_' + hw_id + '_' + switch_num );
	
	if( resp_state == 'EXECUTED' )
	{
		my.action_switch_end();
		
		my.action_switch_state_box( hw_id, switch_num, state );
		
		action.find('.state_pending').text('Procesando');
		
		action.find('.state_box').show();
		action.find('.state_pending').hide();
	}
	else if( resp_state == 'FAILED' )
	{
		my.action_state_show_pending( hw_id, switch_num );
		
		action.find('.state_pending').text('Sin respuesta');
		
		my.action_switch_end();
	}
	else if ( resp_state == 'WAITING_RESPONSE' || resp_state == 'SEND_PENDING' )
	{
		my.action_state_show_pending( hw_id, switch_num );
		
		action.find('.state_pending').text('Esperando respuesta');
	}
}

domotic_action.prototype.action_switch_state_box = function( hw_id, switch_num, state )
{
	var my = this;
	var action = $('#action_' + hw_id + '_' + switch_num );
	var action_state_box = action.find('.state_box');
	var action_click = function() { my.action_switch_state( hw_id, switch_num, ( state ? 0 : 1 ) ) };
	
	action_state_box.show();
	action.find('.state_pending').hide();
	
	action_state_box.find('a').unbind('click');
	
	var on = action_state_box.find('.on');
	var off = action_state_box.find('.off');
	
	if ( state )
	{
		if ( !on.hasClass('on_active') )
		{
			on.addClass('on_active')
		}
		
		off.removeClass('off_active');
		
		off.bind('click', action_click );
	}
	else
	{
		if ( !off.hasClass('off_active') )
		{
			off.addClass('off_active')
		}
		
		on.removeClass('on_active');
		
		on.bind('click', action_click );
	}
}

domotic_action.prototype.action_switch_end = function()
{
	var my = this;
	
	clearInterval( my.interval_id );
	my.interval_id = 0;
}

domotic_action.prototype.action_state_show_pending = function( hw_id, switch_num )
{
	var action = $('#action_' + hw_id + '_' + switch_num );
	action.find('.state_box').hide();
	action.find('.state_pending').show();
}

domotic_action.prototype.action_switch_state = function( hw_id, switch_num, state )
{
	var my = this;
	
	if( 0 != my.interval_id )
	{
		alertify.error("Accionamiento en progreso.");
		return;
	}
	
	var action = $('#action_' + hw_id + '_' + switch_num );
	
	my.action_switch_state_box( hw_id, switch_num, state );
	
	my.action_state_show_pending( hw_id, switch_num );
	
	$.ajax({
		url: page_url + '/receiver/send_hw_action',
		data: {
		  'hw_id': hw_id,
		  'index': switch_num,
		  'state': state
		},
		type: 'GET',
		success: function(res)
		{
			if ( res )
			{
				resp = jQuery.parseJSON(res);
				
				if( resp.ok )
				{
					my.action_id = resp.action_id;
					
					my.interval_id = setInterval( function(action_id)
					{
						my.action_state_check( hw_id, switch_num, state, my.action_id );
					}, my.request_interval );
				}
				else
				{
					my.action_switch_end();
					
					my.action_switch_state_box( hw_id, switch_num, state ? 0 : 1 );
					
					alertify.error( resp.msg );
				}
			}
		}
	});
}

function site_auto_update()
{
	if ( null != auto_update_interval )
	{
		return;
	}
	
	var auto_update_func = function()
	{
		$.get( page_url + 'main/version', null,
			function(res)
			{
				var json = $.parseJSON( res );
				
				if ( json )
				{
					if ( json.version != site_version )
					{
						if ( site_version != 0 )
						{
							location.reload(true);
						}
						else
						{
							site_version = json.version;
						}
					}
				}
			}
		);
	}
	
	auto_update_func();
	
	auto_update_interval = setInterval( auto_update_func, 60000 );
}

function dec2hex(str)
{
	var dec = str.toString().split(''), sum = [], hex = [], i, s
	
	while(dec.length)
	{
		s = 1 * dec.shift()
		
		for(i = 0; s || i < sum.length; i++)
		{
			s += (sum[i] || 0) * 10
			sum[i] = s % 16
			s = (s - sum[i]) / 16
		}
	}
	
	while(sum.length)
	{
		hex.push(sum.pop().toString(16))
	}
	
	return hex.join('')
}

function line_chart( context, graph_data, type )
{
	this.ctx = 'string' == typeof canvas ? $(context) : context;
	this.graph_data = graph_data;
	this.resize_cb_id = null;
	this.chart = null;
	this.select_all = this.graph_select_all;
	this.unselect_all = this.graph_unselect_all;
	this.invert_all = this.graph_invert_all;
	this.type = type || 'time';
	this.data = {};
	var my = this;

	Chart.plugins.register({
		beforeDraw: function(chartInstance) {
			var ctx = chartInstance.chart.ctx;
			ctx.fillStyle = "white";
			ctx.fillRect(0, 0, chartInstance.chart.width, chartInstance.chart.height);
		}
	});
	
	my.chart_create();
}

line_chart.prototype.graph_select_all = function()
{
	var my = this;
	
	for ( var i = 0; i < my.chart.data.datasets.length; i++ )
	{
		a = my.chart.getDatasetMeta(i);
		
		a.hidden = null;
	}
	
	my.chart.update();
}

line_chart.prototype.graph_unselect_all = function()
{
	var my = this;
	
	for ( var i = 0; i < my.chart.data.datasets.length; i++ )
	{
		a = my.chart.getDatasetMeta(i);
		
		a.hidden = !my.chart.data.datasets[i].hidden;
	}
	
	my.chart.update();
}

line_chart.prototype.graph_invert_all = function()
{
	var my = this;
	
	for ( var i = 0; i < my.chart.data.datasets.length; i++ )
	{
		a = my.chart.getDatasetMeta(i);
		
		a.hidden = a.hidden = null === a.hidden ? !my.chart.data.datasets[i].hidden : null;
	}
	
	my.chart.update();
}

line_chart.prototype.chart_create_data = function()
{
	var my			= this;
	var data		= {};
	var dataset 	= [];
	var datamap 	= {};
	var labels		=  [];
	var last_time	= null;
	
	if ( null == my.graph_data )
		return data;
	
	if ( my.type == 'time' )
	{
		for ( var i = 0; i < my.graph_data.length; i++ )
		{
			var packet	= my.graph_data[i];
			
			if ( last_time != packet.time )
			{
				last_time	= packet.time;
				
				var date	= new Date( 1000 * packet.time );
				
				labels.push( date );
			}
						
			if ( !( packet.type in datamap ) )
			{
				datamap[ packet.type ] = [];
				my.data[ packet.type ] = [];
			}
			
			datamap[ packet.type ].push( packet.total );
			my.data[ packet.type ].push( packet );
		}
	}
	
	for ( var key in datamap )
	{
		var color = get_random_color_from_string( key );
		
		dataset.push( {
			label: key,
			fill: false,
			lineTension: 0,
			data: datamap[key],
			backgroundColor: color,
			fillColor: color, 
			borderColor: color,
			strokeColor: color, 
			highlightFill: color,
			highlightStroke: color
		} );
	}
	
	return {
		labels: labels,
		datasets: dataset
	};
}

line_chart.prototype.resize_cb = function( _my )
{
	var my = _my || this;
	var canvas = my.ctx;
	var height = content_get_visible_height() - 32;
	
	canvas.css('height', height + 'px' );
	
	if ( null != my.chart )
	{
		my.chart.resize();
	}
};

line_chart.prototype.chart_create = function()
{
	var my = this;
	
	my.resize_cb_id = resize_callback_register(function()
	{
		my.resize_cb( my );
	});
	
	Chart.defaults.global.legend.position = 'bottom';
	
	if ( null != my.chart )
	{
		my.chart.destroy();
	}
	
	if ( my.graph_data && my.graph_data.length > 0 ) 
	{
		chart_data = my.chart_create_data();
		
		my.chart = new Chart(my.ctx, {
			type: 'line',
			data: chart_data,
			options: {
				maintainAspectRatio: false,
				responsive: true,
				scales: {
					xAxes: [{
						type: 'time',
						time: {
							displayFormats: {
								second: 'HH:mm',
								minute: 'HH:mm',
								hour: 'HH:mm'
							}
						}
					}],
					yAxes: [{
						ticks: {
							beginAtZero:true
						}
					}]
				},
				tooltips: {
					callbacks: {
						label: function(tooltipItem, data) {
							var obj = my.data[ data.datasets[tooltipItem.datasetIndex].label ][ tooltipItem.index ];
							
							if ( obj.total_count )
							{
								return obj.type + ': ' +  obj.total + '/' + obj.total_count;
							}
							
							return obj.type + ': ' +  obj.total;
						}
					}
				}
			}
		});
	}
	
	my.resize_cb();
	
	kajax_register_unload_callback(function()
	{
		my.destroy( my );
	});
}

line_chart.prototype.destroy = function( _my )
{
	var my = _my || this;
	
	resize_callback_unregister( my.resize_cb_id );
	
	if ( null != my.chart )
	{
		my.chart.destroy();
	}
	
	my.chart = null;
	
	return true;
}

function query_param_get( key )
{
    key = key.replace(/[*+?^$.\[\]{}()|\\\/]/g, "\\$&"); // escape RegEx meta chars
    var match = location.search.match(new RegExp("[?&]"+key+"=([^&]+)(&|$)"));
    return match && decodeURIComponent(match[1].replace(/\+/g, " "));
}