//creates the map
var map							= null;
var map_drawing_manager			= null;
var map_drawing_listener		= null;
var map_lat_lng_bounds			= null;
var map_point_count				= 0;
var map_point_total				= 0;
var map_markers					= new Array();
var map_markers_fake			= new Array();
var map_markers_point			= new Array();
var map_markers_geotrace		= new Array();
var map_info_window				= null;
var map_default_marker			= null;
var map_disable_ui				= false;
var map_polyline				= null;
var map_data_raw				= null;
var map_data_points				= null;
var map_update_interval_id		= null;
var map_default_update_interval	= 30000;
var map_citymesh_data			= null;
var map_geotrace_data			= null;
var map_canvas_name				= '';
var map_marker_click_cb			= null;

function map_options_get()
{
	if ( 'undefined' != typeof google )
	{
		var map_options = {
			mapTypeId: google.maps.MapTypeId.ROADMAP,
			zoom:4,
			center: new google.maps.LatLng(-39.876019,-65.500488)
		};
		
		if ( map_disable_ui )
		{
			map_options['disableDefaultUI'] = true;
		}
	}
	
	return map_options;
}

function map_info_window_get()
{
	if ( 'undefined' != typeof google && null == map_info_window )
	{
		map_info_window = new google.maps.InfoWindow( { content: "holding...", maxWidth: 1024 } );
	}
	
	return map_info_window;
}

function map_reset()
{
	map_markers_delete();
	
	geotrace_map_auto_update_stop();
	
	delete map;
	map							= null;
	map_lat_lng_bounds			= null;
	map_info_window				= null;
	map_info_window				= map_info_window_get();
	map_disable_ui				= false;
	map_polyline				= null;
	map_data_raw				= null;
	map_data_points				= null;
	map_update_interval_id		= null;
	map_marker_click_cb			= null;
	map_default_update_interval	= 30000;
}

function map_resize_callback()
{
	if ( null != map )
	{
		google.maps.event.trigger(map, 'resize');
		map.setZoom( map.getZoom() );
	}
}

function map_dechex (number)
{
	if (number < 0)
	{
		number = 0xFFFFFFFF + number + 1;
	}

	return parseInt(number, 10).toString(16);
}

function map_marker_click_default_cb( marker )
{
	map_marker_reload_icon( map_default_marker );
	map_default_marker = marker;
	map_info_window_get();
	map_info_window.setContent( marker.html );
	map_info_window.open( map, marker );
	
	kajax_init( $('.maps_globe') );
	
	if ( null != map_marker_click_cb )
	{
		map_marker_click_cb( marker );
	}
}

function map_add_point(id, real_id, point, tests_state, info, icon, network, color, name, hw_type)
{
	var marker	= null;
	var is_fake	= id.startsWith('hwf_');
	
	if ( 'undefined' == typeof network )
	{
		network = '';
	}
	
	if ( 'undefined' == typeof hw_type )
	{
		hw_type = '';
	}
	
	if ( null == tests_state )
	{
		tests_state = new Array();
		tests_state['state'] = icon.toLowerCase();
	}
	
	map_point_count++;

	var icon_url = '/api/icon?icon=' + icon + '&state=' + tests_state['state'] + '&color=' + color;

	if( point )
	{
		//adds the new marker
		marker = new google.maps.Marker({
			id: id,
			real_id: real_id,
			position: point,
			map: map,
			icon: icon_url,
			icon_name: icon,
			color: color,
			state: tests_state['state'],
			icon_url: icon_url,
			network: network,
			hw_type: hw_type,
			name: name
		});
		
		if ( tests_state.hasOwnProperty('fake') )
		{
			marker.setVisible( false );
			map_markers_fake.push( marker );
		}
		
		marker.html = info;

		google.maps.event.addListener(marker, 'click', function()
		{
			map_marker_click_default_cb( this );
		});
		
		map_markers.push( marker );
		
		if ( null == map_default_marker )
		{
			map_default_marker = marker;
		}
		
		if ( !is_fake )
		{
			map_lat_lng_bounds.extend( point );
		}
	}

	if( !is_fake && map_point_count >= map_point_total )
	{
		map.fitBounds(map_lat_lng_bounds);

		map.initialZoom = true;
	}
	
	return marker;
}

function map_markers_fake_set_visible( visible, type )
{
	for (var i = 0; i < map_markers_fake.length; i++)
	{
		if ( 1 == type )
		{
			if ( map_markers_fake[i]['state'] == 'fucsia' )
			{
				map_markers_fake[i].setVisible( visible );
			}
		}
		else if ( 0 == type )
		{
			if ( map_markers_fake[i]['state'] == 'blue' )
			{
				map_markers_fake[i].setVisible( visible );
			}
		}
	}
}

function map_date_fix( date )
{
	if ( null != date )
	{
		var s = date.split( '.' );
		return s[0];
	}
	
	return '';
}

function map_make( canvas_name, data, data_fake, data_receiver, data_radars, marker_color_default )
{
	if ( 'undefined' == typeof google )
	{
		return;
	}
	
	map_canvas_name = canvas_name;
	
	google.maps.visualRefresh = true;

 	var canvas = document.getElementsByClassName(canvas_name);
 	map = new google.maps.Map( canvas[0], map_options_get());
	map_lat_lng_bounds = new google.maps.LatLngBounds( );
	
	map_citymesh_data	= data;
	map_default_marker	= null;
	map_point_count		= 0;
	map_point_total		= 0;
	
	if ( null != data )
	{
		map_point_total		= data.length;
		map_info_window_get();
		
		google.maps.event.addListener(map_info_window,'closeclick',function()
		{
			map_marker_reload_icon( map_default_marker );
			map_default_marker = null;
		});
		
		if ( 'undefined' == typeof marker_color_default )
		{
			marker_color_default = '';
		}
		
		for ( var i = 0; i < data.length; i++ )
		{
			var d		= data[i];
			var name	= '<a class="ajax-link" href="' + page_url + map_append_opt_dshield_path() + 'hw/view/' + d['hw_id'] + '">' + d['hw_name'] + '</a>';
			var code	= '<span>Nº de Abonado: <b>' + map_dechex( d['hw_code'] ) + '</b></span>';
			var serial	= '<span>MAC: <b>' + map_dechex( 0xFFFFFFFF & d['hw_serial'] ) + '</b></span>';
			var tuh		= '<span>Tests Última Hora: <b>' + d['tests_state']['count'] + '</b></span>';
			var hw_type = 'XBee';
			
			if ( map_dechex( d['hw_serial'] ).startsWith( '5' ) )
			{
				hw_type = 'D-Trans';
			}
			
			var ue		= '<span>Último Encendido ' + hw_type + ': <b>' + map_date_fix( d['hw_inst_time'] ) + '</b></span>';
			
			if ( d['hw_inst_time_3g'] )
				ue += '<span>Último Encendido 3G: <b>' + map_date_fix( d['hw_inst_time_3g'] ) + '</b></span>';
			
			var signal_filtered	= '-';
			
			if( d['hw_setup_signal_filtered'] != null )
			{
				var sn				= Math.round( 100 * d['hw_setup_signal_filtered'] / parseFloat( d['hw_setup_signal_total_xbee'] ) );
				signal_filtered		= Math.min( sn, 100 ) + '%';
			}
			
			d['signal_filtered'] = signal_filtered;
			
			var inst	= '';
			
			if ( d['hw_inst_time'] != null )
			{
				inst += '<span>% Señal de Instalación ' + hw_type + ': <b>' + d['signal_filtered'] + '</b></span>';
			}
			
			if ( d['hw_inst_time_3g'] != null )
			{
				var sn				= Math.round( 100 * d['hw_setup_signal_3g'] / parseFloat( d['hw_setup_signal_total_3g'] ) );
				signal_filtered		= Math.min( sn, 100 ) + '%';
				
				inst	+= '<span>% Señal de Instalación 3G: <b>' + signal_filtered + '</b></span>';
			}
			
			var groups	= '';
			
			if ( d['hw_groups'] )
			{
				groups	= '<span>Grupos:<br/>';
			
				var group	= d['hw_groups'].split( '~' );
				
				if ( group.length > 0 )
				{
					for ( var z = 0; z < group.length; z++ )
					{
						groups += '<b>' + group[z] + '</b><br/>';
					}
				}
				
				groups += '</span>';
			}
			
			var info	= '<div class="maps_globe">' + name + code + serial + tuh + ue + inst + groups + '</div>';
			var network	= d['hw_imei'] != null ? 'GPRS' : 'AIRMESH';
			
			if ( d['hw_inst_time_3g'] != null )
			{
				if ( map_dechex( d['hw_serial'] ).startsWith( '40' ) || map_dechex( d['hw_serial'] ).startsWith( '41' ) )
				{
					d['hw_icon'] = 'INST_TYPE_1';
				}
				else if ( map_dechex( d['hw_serial'] ).startsWith( '43' ) )
				{
					d['hw_icon'] = 'INST_TYPE_2';
					hw_type = '3G';
				}
			}
			
			if ( 1 == d['hw_core'] )
			{
				d['hw_icon'] = 'NUCLEATOR';
			}
			
			map_add_point( 'hw_' + d['hw_id'], d['hw_id'], new google.maps.LatLng(d['hw_lat'], d['hw_long']), d['tests_state'], info, d['hw_icon'], network, marker_color_default, d['hw_name'], hw_type ); //already have latlong
		}
	}
	
	if ( null != data_fake )
	{
		for (var i = 0; i < data_fake.length; i++)
		{
			var d = data_fake[i];
			
			d['tests_state'] = new Array();
			
			d['tests_state']['fake'] = 1;
			
			if ( parseInt( d['hwf_type'] ) == 1 )
			{
				d['tests_state']['state'] = 'fucsia';
			}
			else
			{
				d['tests_state']['state'] = 'blue';
			}
			
			var u_id_txt = ( d['hwf_code'] );
			
			var preinfo = "<strong>" + d['hwf_name'] + '<br/>' + d['hwf_address'] + "</strong><br/>";
			
			var info = preinfo + "<strong>Número de Abonado: </strong>" + map_dechex( u_id_txt ) + "<br/>";
			var network	= d['hw_imei'] != null ? 'GPRS' : 'AIRMESH';

			map_add_point( 'hwf_' + d['hwf_id'], d['hwf_id'], new google.maps.LatLng( d['hwf_lat'], d['hwf_long'] ), d['tests_state'], info, d['hwf_icon'], network, marker_color_default, d['hwf_name'] );
		}
	}
	
	if ( null != data_receiver )
	{
		for (var i = 0; i < data_receiver.length; i++)
		{
			var d = data_receiver[i];
			
			var info = "<strong>" + d['com_name'] + '<br/>' + d['com_address'] + "</strong><br/>";
			
			info += "<strong>Calidad de conexión: " + d['tests_state']['count'] + "%</strong>";
			
			map_add_point( 'rec_' + d['com_id'], d['com_id'], new google.maps.LatLng( d['com_lat'], d['com_long'] ), d['tests_state'], info, 'MONITORING_CENTRAL', 'RECEIVER', marker_color_default, d['com_name'] );
		}
	}
	
	if ( 'undefined' != typeof data_radars && null != data_radars )
	{
		for (var i = 0; i < data_radars.length; i++)
		{
			var d = data_radars[i];
			
			var info = "<b>" + d['rd_name'] + '</b> ( ' + parseInt( d['rd_serial'] ).toString(16) + " )<br/>";
			
			var state = null;
			
			if ( 'undefined' != typeof d['tests_state'] )
			{
				state = d['tests_state'];
				
				info += "Tests Última Hora: <b>" + d['tests_state']['count'] + "</b>";
			}
			
			map_add_point( 'rd_' + d['rd_id'], d['rd_serial'], new google.maps.LatLng( d['rd_lat'], d['rd_long'] ), state, info, 'RADAR', 'RADAR', marker_color_default, d['rd_name'] );
		}
	}
	
	change_bounds_listener = google.maps.event.addListener(map, 'bounds_changed', function(event)
	{
		if (this.getZoom() > 16 && this.initialZoom == true)
		{
			this.setZoom(16);
			this.initialZoom = false;
		}
		
		google.maps.event.removeListener(change_bounds_listener);
	});
	
	$('#show_hide_inst_blue').click(function()
	{
		map_markers_fake_set_visible( $('#show_hide_inst_blue').is(':checked'), 0 );
	});
	
	$('#show_hide_inst_fucsia').click(function()
	{
		map_markers_fake_set_visible( $('#show_hide_inst_fucsia').is(':checked'), 1 );
	});

	$('#show_hide_gprs').click(function()
	{
		city_markers_set_visible( $('#show_hide_gprs').is(':checked'), 'GPRS' );
	});

	$('#show_hide_airmesh').click(function()
	{
		city_markers_set_visible( $('#show_hide_airmesh').is(':checked'), 'AIRMESH' );
	});
	
	$('#show_hide_hardware').click(function()
	{
		city_markers_set_visible( $('#show_hide_hardware').is(':checked'), 'AIRMESH' );
		city_markers_set_visible( $('#show_hide_hardware').is(':checked'), 'GPRS' );
		map_markers_fake_set_visible( $('#show_hide_inst_blue').is(':checked'), 0 );
		map_markers_fake_set_visible( $('#show_hide_inst_fucsia').is(':checked'), 1 );
	});
	
	$('#show_hide_xbee').click(function()
	{
		hw_type_markers_set_visible( $('#show_hide_xbee').is(':checked'), 'XBee' );
	});
	
	$('#show_hide_dtrans').click(function()
	{
		hw_type_markers_set_visible( $('#show_hide_dtrans').is(':checked'), 'D-Trans' );
	});
	
	$('#show_hide_3g').click(function()
	{
		hw_type_markers_set_visible( $('#show_hide_3g').is(':checked'), '3G' );
	});
	
	/*
	if ( query_param_get( 'gtodate' ) )
	{
		var xbee_visible = query_param_get( 'xbee_visible' ) ? true : false;
		hw_type_markers_set_visible( xbee_visible, 'XBee' );
		$('#show_hide_xbee').prop( 'checked', xbee_visible );
		
		var dtrans_visible = query_param_get( 'dtrans_visible' ) ? true : false;
		hw_type_markers_set_visible( dtrans_visible, 'D-Trans' );
		$('#show_hide_dtrans').prop( 'checked', dtrans_visible );
		
		var tg_visible = query_param_get( '3g_visible' ) ? true : false;
		hw_type_markers_set_visible( tg_visible, '3G' );
		$('#show_hide_3g').prop( 'checked', tg_visible );
	}
	*/
	
	if ( 'function' == typeof map_on_load )
	{
		map_on_load();
	}
}

function map_drawable_tools_init()
{
	map_drawing_manager = new google.maps.drawing.DrawingManager(
	{
		drawingMode: google.maps.drawing.OverlayType.POLYGON,
		drawingControl: true,
		drawingControlOptions:
		{
			position: google.maps.ControlPosition.TOP_CENTER,
			drawingModes: [
				google.maps.drawing.OverlayType.POLYGON
			]
		}
	});
}

var map_drawable_tools_escape = function(e)
{
	if ( e.keyCode == 27 )
	{
		setTimeout(function()
		{
			map_drawable_tools_hide();
		}, 0 );
	}
};

function map_drawable_tools_show( on_poly_complete )
{
	if ( null == map_drawing_manager )
	{
		map_drawable_tools_init();
	}
	
	if ( null != map_drawing_listener )
	{
		google.maps.event.removeListener( map_drawing_listener );
	}
	
	if ( 'undefined' != typeof on_poly_complete )
	{
		map_drawing_listener = google.maps.event.addListener( map_drawing_manager, 'polygoncomplete', on_poly_complete );
	}
	
	map_drawing_manager.setMap( map );
	
	$(document).keyup( map_drawable_tools_escape );
}

function map_drawable_tools_hide()
{
	if ( null != map_drawing_manager )
	{
		$(document).unbind( "keyup", map_drawable_tools_escape );
		map_drawing_manager.setMap( null );
		map_drawing_manager = null;
	}
}

function map_drawable_tools_show_export()
{
	map_drawable_tools_show(function(polygon)
	{
		alertify.confirm( "¿Desea exportar los abonados dentro del polígono?", function(e)
		{
			if ( e )
			{
				var markers_inside_polygon = map_markers_get_inside_polygon( polygon );
				
				if ( markers_inside_polygon.length > 0 )
				{
					var ids = '';
					
					for ( var i = 0; i < markers_inside_polygon.length; i++ )
					{
						ids += markers_inside_polygon[i].real_id + ',';
					}
					
					ids = ids.substr( 0, ids.length - 1 );
					
					post_request( page_url + 'hw/export/csv/1', { 'ids': ids } );
				}
				else
				{
					alertify.error("No se encontraron abonados dentro del polígono.");
				}
			}
			
			polygon.setMap( null );
			
			map_drawable_tools_hide();
		});
	});
}

function map_find_marker( id )
{
	if ( map_markers.length > 0 )
	{
		for ( var i = 0; i < map_markers.length; i++ )
		{
			var marker = map_markers[i];
			
			if ( id == marker.id )
			{
				return marker;
			}
		}
	}
	
	return null;
}

function map_marker_reload_icon( marker )
{
	if ( null != marker )
	{
		var icon_url = page_url + '/api/icon?icon=' + marker.icon_name + '&state=' + marker.state + '&color=' + marker.color;
		marker.setIcon( icon_url );
	}
}

function map_show_marker_info_from_id( id, _center, _color )
{
	var marker = map_find_marker( id );
	
	if ( null != marker )
	{
		map_show_marker_info( marker, _center, _color );
	}
	
	return marker;
}

function map_show_marker_info( _marker, _center, _color )
{
	var marker = typeof _marker == 'undefined' ? map_default_marker : _marker;
	
	if ( null != marker )
	{
		map_marker_reload_icon( map_default_marker );
		
		if ( 'undefined' != typeof _center && true == _center )
		{
			map.setCenter( marker.getPosition() );
			
			if ( 'undefined' != typeof _color )
			{
				var icon_url = page_url + '/api/icon?icon=' + marker.icon_name + '&state=' + marker.state + '&color=' + _color;
				
				marker.setIcon( icon_url );
				marker.icon_url = icon_url;
			}
		}
		
		map_default_marker = marker;
		map_info_window_get();
		map_info_window.setContent(marker.html);
		map_info_window.open(map, marker);
	}
}

function map_markers_get_inside_polygon( polygon )
{
	var markers = [];
	
	for ( var i = 0; i < map_markers.length; i++ )
	{
		var marker = map_markers[i];
		
		if ( null != marker.getMap() && marker.id.startsWith('hw_') /* only export real hardware */ && google.maps.geometry.poly.containsLocation( marker.getPosition(), polygon ) )
		{
			markers.push( marker );
		}
	}
	
	return markers;
}

function geotrace_map_add_point(id, real_id, point, state, info, icon, color, fit_bounds, heading, name, not_set_marker)
{
	var marker = null;
	
	map_point_count++;

	var icon_url = page_url + '/api/icon?icon=' + icon + '&state=' + state + '&color=' + color;

	if( point )
	{
		//adds the new marker
		marker = new google.maps.Marker({
			id: id,
			real_id: real_id,
			position: point,
			map: map,
			icon: icon_url,
			icon_name: icon,
			color: color,
			icon_url: icon_url,
			state: state,
			name: name
		});
		
		marker.html = info;

		google.maps.event.addListener(marker, 'click', function()
		{
			map_marker_reload_icon( map_default_marker );
			map_default_marker = this;
			map_info_window_get();
			map_info_window.setContent(this.html);
			map_info_window.open(map, this);
			
			kajax_init( $('.maps_globe') );
			
			if ( null != map_marker_click_cb )
			{
				map_marker_click_cb( this );
			}
		});
		
		if ( null == map_default_marker && !( true == not_set_marker ) )
		{
			map_default_marker = marker;
		}
		
		map_lat_lng_bounds.extend( point );
		
		map_markers.push( marker );
		
		map_markers_geotrace.push( marker );
		
		if ( 'POINT' == icon )
		{
			map_markers_point.push( marker );
		}
	}

	if( fit_bounds && map_point_count >= map_point_total )
	{
		map.fitBounds(map_lat_lng_bounds);

		map.initialZoom = true;
	}
	
	return marker;
}

function map_markers_set_all( _map )
{
	if ( 'undefined' != typeof map_markers && map_markers && map_markers.length > 0 )
	{
		for ( var i = 0; i < map_markers.length; i++ )
		{
			map_markers[i].setMap( _map );
		}
	}
}

function map_markers_clear()
{
	map_markers_set_all( null );
}

function map_markers_show()
{
	map_markers_set_all( map );
}

function map_markers_delete()
{
	map_markers_clear();
	map_markers					= new Array();
	map_markers_fake			= new Array();
	map_markers_point			= new Array();
	map_default_marker			= null;
	map_point_count				= 0;
	map_point_total				= 0;
}

function map_markers_show_hide( id_str, visible )
{
	for (var i = 0; i < map_markers.length; i++)
	{
		var marker = map_markers[i];
		
		if ( marker.id.startsWith( id_str ) )
		{
			marker.setVisible( visible );
		}
	}
}

function map_markers_show_hide_checkbox( el_id, id_str )
{
	var el = $(el_id);
	
	el.click(function()
	{
		map_markers_show_hide( id_str, el.is(':checked') );
	});
}

function city_markers_set_visible( visible, network )
{
	for (var i = 0; i < map_markers.length; i++)
	{
		if ( network == map_markers[i]['network'] )
		{
			map_markers[i].setVisible( visible );
		}
	}
}

function hw_type_markers_set_visible( visible, hw_type )
{
	for (var i = 0; i < map_markers.length; i++)
	{
		if ( hw_type == map_markers[i]['hw_type'] )
		{
			map_markers[i].setVisible( visible );
		}
	}
	
	map_update_graph();
}

function geotrace_markers_set_visible( visible, state )
{
	for (var i = 0; i < map_markers.length; i++)
	{
		if ( state == map_markers[i]['state'] )
		{
			map_markers[i].setVisible( visible );
		}
	}
}

function geotrace_gen_info( d, show_as_last_report )
{
	var name	= '<a class="ajax-link" href="' + page_url + map_append_opt_dshield_path() + 'geotrace/view/' + d['ahw_imei'] + '">' + d['ahw_name'] + '</a>';
	var code	= '<span>IMEI: <b>' + d['ahw_imei'] + '</b></span>';
	var speed	= '<span>Velocidad: <b>' + d['ae_speed'] + '</b></span>';
	var ur		= '<span>Hora de Reporte: <b>' + date_pp( d['ae_timestamp'] ) + '</b></span>';
	
	if ( 'undefined' != typeof show_as_last_report )
	{
		ur		= '<span>Último Reporte: <b>' + date_pp( d['ae_timestamp'] ) + '</b></span>';
	}
	
	var info	= '<div class="maps_globe">' + name + code + speed + ur;
	
	if ( 'undefined' != typeof map_debug && true == map_debug )
	{
		info	+= '<span>Event Code: <b>' + d['ae_code'] + '</b></span>';
		info	+= '<span>GPS Status: <b>' + d['ae_gpsstatus'] + '</b></span>';
		info	+= '<span>GPS Satellite Number: <b>' + d['ae_gpssatnum'] + '</b></span>';
		info	+= '<span>GSM Signal: <b>' + d['ae_gsmsignal'] + '</b></span>';
		info	+= '<span>Heading: <b>' + d['ae_heading'] + '</b></span>';
		info	+= '<span>HDOP: <b>' + d['ae_hdop'] + '</b></span>';
		info	+= '<span>Altitude: <b>' + d['ae_altitude'] + '</b></span>';
	}
	
	info		+= '</div>';
	
	return info;
}

function geotrace_get_event_color( evcode, gpsstatus )
{
	if ( gpsstatus == 'V' )
	{
		return 'FFF300';
	}
	
	switch( parseInt( evcode ) )
	{
		case 19:	return 'FF8C00';
		case 22:	return '00C800';
		case 23:	return 'C80000';
		case 31:	return '00C8BE';
		case 32:	return 'FF5ABE';
		case 33:	return '7F1E57';
		case 35:	return 'E1E100';
		case 142:	return '0000AA';
		case 143:	return '8B6914';
		case 145:	return '000000';
	}
	
	return '';
}

function map_marker_remove( markers_array, marker )
{
	if ( markers_array.length )
	{
		for ( var i = 0; i < markers_array.length; i++ )
		{
			if ( markers_array[i].id == marker.id )
			{
				markers_array.splice(i,1);
				
				return;
			}
		}
	}
}

function geotrace_markers_remove()
{
	for ( var i = 0; i < map_markers_geotrace.length; i++ )
	{
		map_marker_remove( map_markers, map_markers_geotrace[i] );
		
		map_markers_geotrace[i].setMap(null);
		
		map_point_count--;
	}
	
	map_markers_geotrace = Array();
}

function geotrace_map_update( data, data_points, fit_bounds, keep_markers, marker_color_default, not_set_marker )
{
	if ( 'undefined' == typeof google )
	{
		return;
	}
	
	var map_fit_bounds			= 'undefined' != fit_bounds ? fit_bounds : true;
	map_data_raw				= data;
	map_data_points				= data_points;
	map_point_count				= 0;
	
	if ( 'undefined' == typeof keep_markers && true != keep_markers )
	{
		map_markers_delete();
	}
	else
	{
		geotrace_markers_remove();
	}
	
	if( !map_data_raw || map_data_raw.length == 0 )
	{
		return;
	}
	
	map_point_total				= map_data_raw.length;
	
	if ( 'undefined' == typeof marker_color_default )
	{
		marker_color_default = '';
	}
	
	for ( var i = 0; i < map_data_raw.length; i++ )
	{
		var d			= map_data_raw[i];
		geotrace_map_add_point( 'ahw_' + d['ahw_imei'], d['ahw_imei'], new google.maps.LatLng(d['ae_lat'],d['ae_long']), d['state'], geotrace_gen_info( d, true ), d['ahw_icon'], marker_color_default, map_fit_bounds, d['ae_heading'], d['ahw_name'], not_set_marker );
	}
	
	if ( 'undefined' == typeof not_set_marker || false == not_set_marker )
	{
		map_default_marker = map_markers[ map_markers.length - 1 ];
	}
	
	if ( map_data_points && map_data_points.length > 0 )
	{
		var points		= new Array();
		
		for ( var i = 0; i < map_data_points.length; i++ )
		{
			var dp		= map_data_points[i];
			var point	= new google.maps.LatLng( dp['ae_lat'], dp['ae_long'] );
			var pstate	= dp['ae_speed'] != 0 ? 'MOVING' : ( dp['ae_gpsstatus'] == 'V' ? 'NOGPS' : 'STOPPED' );
			var color	= geotrace_get_event_color( dp['ae_code'], dp['ae_gpsstatus'] );
			
			points.push( point );
			map_lat_lng_bounds.extend( point );
			
			geotrace_map_add_point( 'ae_' + dp['ae_id'], d['ahw_imei'], point, pstate, geotrace_gen_info( dp ), 'POINT', color, null );
		}
		
		if ( null != map_polyline )
		{
			map_polyline.setMap(null);
			map_polyline = null;
		}

		map_polyline	= new google.maps.Polyline({
			path: points,
			strokeColor:'#33cec4',
			strokeOpacity:2,
			strokeWeight:4
		});

		map_polyline.setMap( map );

		if ( map_fit_bounds )
		{
			map.fitBounds( map_lat_lng_bounds );
			map.initialZoom = true;
		}
	}
	
	if ( map_fit_bounds )
	{
		geotrace_change_bounds_listener = google.maps.event.addListener(map, 'bounds_changed', function(event)
		{
			if (this.getZoom() > 16 && this.initialZoom == true)
			{
				this.setZoom(16);
				this.initialZoom = false;
			}
			
			google.maps.event.removeListener(geotrace_change_bounds_listener);
		});
	}
}

function geotrace_map_make( canvas_name, data, data_points )
{
	if ( 'undefined' == typeof google )
	{
		return;
	}
	
	google.maps.visualRefresh	= true;
 	var canvas					= document.getElementsByClassName(canvas_name);
 	map							= new google.maps.Map( canvas[0], map_options_get() );
	map_lat_lng_bounds			= new google.maps.LatLngBounds();
	map_geotrace_data			= data;
	
	geotrace_map_update( data, data_points, true );
	
	$('#show_hide_moving').click(function()
	{
		geotrace_markers_set_visible( $('#show_hide_moving').is(':checked'), 'MOVING' );
	});
	
	$('#show_hide_stopped').click(function()
	{
		geotrace_markers_set_visible( $('#show_hide_stopped').is(':checked'), 'STOPPED' );
	});
	
	$('#show_hide_noreport').click(function()
	{
		geotrace_markers_set_visible( $('#show_hide_noreport').is(':checked'), 'NOREPORT' );
	});

	if ( 'function' == typeof map_on_load )
	{
		map_on_load();
	}
}

function geotrace_map_auto_update( interval, update_url, data, cb )
{
	geotrace_map_auto_update_stop();
	
	map_update_interval_id = setInterval(function()
	{
		$.get( update_url, data, function(res)
		{
			var data = $.parseJSON( res );
			
			if ( null != data )
			{
				var tmp_vehicles	= 'undefined' != typeof data['vehicles'] ? data['vehicles'] : null;
				var tmp_points		= 'undefined' != typeof data['points'] ? data['points'] : null;
				
				geotrace_map_update( tmp_vehicles, tmp_points, false );
				
				if ( null != map_default_marker )
				{
					map_show_marker_info_from_id( map_default_marker.id );
				}
				
				if ( 'function' == typeof cb )
				{
					cb( tmp_vehicles, tmp_points );
				}
			}
		});
	}, interval );
}

function geotrace_map_auto_update_stop()
{
	if ( null != map_update_interval_id )
	{
		clearInterval( map_update_interval_id );
		map_update_interval_id = null;
	}
}

function map_is_in_dshield()
{
	return location.pathname.startsWith( '/dshield' );
}

function map_append_opt_dshield_path()
{
	return map_is_in_dshield() ? 'dshield/' : '';
}

var map_xbee_visible = true;
var map_dtrans_visible = true;
var map_3g_visible = true;

function map_cache_hw_type_state()
{
	map_xbee_visible = $('#show_hide_xbee').is(':checked');
	map_dtrans_visible = $('#show_hide_dtrans').is(':checked');
	map_3g_visible = $('#show_hide_3g').is(':checked');
}

function map_is_hw_type_active( hw_type )
{
	if ( map_xbee_visible && hw_type == 'XBee' ) return true;
	if ( map_dtrans_visible && hw_type == 'D-Trans' ) return true;
	if ( map_3g_visible && hw_type == '3G' ) return true;
	return false;
}

function map_bar_reset( signal, eq, percent )
{
	count = ( 0 == percent ) ? -1 : Math.ceil( percent / 25 );
	
	signals = [ signal.prev().prev().prev().prev(), 
				signal.prev().prev().prev(), 
				signal.prev().prev(), 
				signal.prev()
	];
	
	for ( var i = 0; i < signals.length; i++ )
	{
		signals[i][0].className = '';
		signals[i].addClass('signal_box');
		signals[i].addClass( "sprite-img-equalizador-" + ( ( i <= count ) ? eq :'none' ) );
	}
}

function map_update_graph()
{
	map_cache_hw_type_state();
	
	dead = 0;
	low = 0;
	good = 0;
	excellent = 0;
	
	for (var i = 0; i < map_markers.length; i++)
	{
		if ( map_is_hw_type_active( map_markers[i]['hw_type'] ) )
		{
			if ( 'dead' == map_markers[i].state )
			{
				dead++;
			}
			else if ( 'low' == map_markers[i].state )
			{
				low++;
			}
			else if ( 'good' == map_markers[i].state )
			{
				good++;
			}
			else if ( 'excellent' == map_markers[i].state )
			{
				excellent++;
			}
		}
	}
	
	total = parseFloat( dead + low + good + excellent );
	
	$('.signal_hw_green').text( excellent );
	$('.signal_hw_yellow').text( good );
	$('.signal_hw_orange').text( low );
	$('.signal_hw_red').text( dead );
	
	map_bar_reset( $('.signal_hw_red'), 'nula', dead / total * 100 );
	map_bar_reset( $('.signal_hw_orange'), 'baja', low / total * 100 );
	map_bar_reset( $('.signal_hw_yellow'), 'buena', good / total * 100 );
	map_bar_reset( $('.signal_hw_green'), 'optima', excellent / total * 100 );
	
	$('.panel_hw_count').text( total );
}
