var HW_CFG_IN_PROGRESS	= false;
var HW_CFG_REQ_INTERVAL	= 2000; //intervalo de actualizacion de acciones en ms
var HW_CFG_INTERVAL_ID	= 0;

function is_valid_edit_key(keyCode)
{
	// Allow: backspace, delete, tab, escape, and enter
	return ( keyCode == 46 || keyCode == 8 || keyCode == 9 || keyCode == 27 || keyCode == 13 ||
			// Allow: Ctrl+A
			(keyCode == 65 && event.ctrlKey === true) ||
			// Allow: home, end, left, right
			(keyCode >= 35 && keyCode <= 39));

}

function is_valid_hex_key(keyCode)
{
	return 	(keyCode >= 48 && keyCode <= 57 ) || // 0..9
			(keyCode >= 65 &&  keyCode <= 70) || // A..F
			(keyCode >= 96 &&  keyCode <= 105);// 0..9 NUMPAD
}

function hw_config_init()
{
	$(".validate_hex_2").keydown(function(event)
	{
		if(is_valid_hex_key(event.keyCode))
		{
			if($(this).val().length >= 2)
			{
				event.preventDefault();
			}
		}
		else if(!is_valid_edit_key(event.keyCode))
		{
			event.preventDefault();
		}
	});

	$(".validate_hex_4").keydown(function(event) {
		if(is_valid_hex_key(event.keyCode))
		{
			if($(this).val().length >= 4)
			{
				event.preventDefault();
			}
		}
		else if(!is_valid_edit_key(event.keyCode))
		{
			event.preventDefault();
		}
	});

	$("#config_a_evt_code").change(function ()
	{
		$("#config_a_value").val("");

		var sel = $("#config_a_evt_code option:selected");

		$('#help_msg').hide();
		$('#help_msg').text(sel.attr('title'));

		if($.trim($('#help_msg').text()) != '')
		{
			$('#help_msg').fadeIn();
		}

		if( sel.hasClass("opt_val_none") )
		{
			$('#values_div').hide();
		}
		else
		{
			$('#values_div').show();
		}

		if( sel.hasClass("opt_val_hex") )
		{
			$("#config_a_value_div").show();
		}
		else
		{
			$("#config_a_value_div").hide();
		}

		if( sel.hasClass("opt_zero") )
		{
			$("#config_a_value").val("00");
		}

		if( sel.hasClass("opt_sensor_sirena") )
		{
			$("#sensor_sirena_div").show();
		}
		else
		{
			$("#sensor_sirena_value").val("");
			$("#sensor_sirena_div").hide();
		}

		if( sel.hasClass("opt_toggle") )
		{
			$("#toggle_value_div").show();
		}
		else
		{
			$("#toggle_value").val("");
			$("#toggle_value_div").hide();
		}

		if( sel.hasClass("opt_toggle_reversed") )
		{
			$("#toggle_reversed_value_div").show();
		}
		else
		{
			$("#toggle_reversed_value").val("");
			$("#toggle_reversed_value_div").hide();
		}
	});

	$("#sensor_sirena_value").change(function()
	{
		$("#config_a_value").val( $(this).val() );
	});

	$("#toggle_value").change(function()
	{
		$("#config_a_value").val( $(this).val() );
	});

	$("#toggle_reversed_value").change(function()
	{
		$("#config_a_value").val( $(this).val() );
	});

	$("#config_a_evt_code").change();
}

function action_config_state_show(state, response)
{
	var resp = parseInt( response );
	
	if( state == 'EXECUTED' )
	{
		clearInterval(HW_CFG_INTERVAL_ID);
		
		var sel = $("#config_a_evt_code option:selected");
		var help_msg = $('#help_msg');
		
		if( sel.hasClass("opt_val_none") )
		{
			help_msg.html('<span class="server_ok">La Acción se ha ejecutado correctamente</span>').fadeIn()
		}
		else if( sel.hasClass("opt_sensor_sirena") )
		{
			var status = 'Código de respuesta no reconocido';
			
			if ( resp == 0 )
			{
				status = 'Inactivo';
			}
			else if ( resp == 0x10 )
			{
				status = "Activo - Nivel digital Alto";
			}
			else if ( resp == 0x40 )
			{
				status = "Activo - Nivel digital Bajo";
			}
			
			status += ' ( 0x' + zero_fill( resp.toString(16).toUpperCase() ) + ' )';
			
			help_msg.html( '<span class="server_ok">Estado de sensor de sirena: </span>' + status );
		}
		else if( sel.hasClass("opt_toggle") )
		{
			var status = resp != 0 ? 'Activo' : 'Inactivo';
			
			status += ' ( 0x' + zero_fill( resp.toString(16).toUpperCase() ) + ' )'; 
			
			help_msg.html( '<span class="server_ok">La Acción se ha ejecutado correctamente, estado: </span>' + status );
		}
		else if( sel.hasClass("opt_toggle_reversed") )
		{
			var status = resp == 0 ? 'Activo' : 'Inactivo';
			
			status += ' ( 0x' + zero_fill( resp.toString(16).toUpperCase() ) + ' )'; 
			
			help_msg.html( '<span class="server_ok">La Acción se ha ejecutado correctamente, estado: </span>' + status );
		}
		else
		{
			help_msg.html('<span class="server_ok">La Acción se ha ejecutado correctamente: </span>0x' + zero_fill( parseInt( response ).toString(16).toUpperCase() ) + ' ( ' + response + ' )' ).fadeIn()
		}
	}
	else if( state == 'FAILED' )
	{
		clearInterval(HW_CFG_INTERVAL_ID);
		
		$('#help_msg').html('<span class="server_error">ERROR: No se ha recibido respuesta de la receptora.</span>').fadeIn()
	}
	else if (state == 'WAITING_RESPONSE' || state == 'SEND_PENDING')
	{
	}
}

function action_config_check_state(cfg_action_id)
{
	$.ajax({
		url: page_url + '/receiver/get_config_state',
		data: {
			'cfg_action_id':cfg_action_id
		},
		type: 'GET',
		success: function(res){
			resp = jQuery.parseJSON(res);

			if(resp.ok)
			{
				action_config_state_show(resp.state.ac_state, resp.state.ac_response);
			}
			else
			{
				clearInterval(HW_CFG_INTERVAL_ID);
				HW_CFG_IN_PROGRESS = false;
			}
		}
	});
}

function action_config_send( action )
{
	action_config_state_show('SEND_PENDING');

	$.ajax({
		url: page_url + '/receiver/send_hw_config',
		data: 'action='+action+'&'+$("#receptora_config_basico_form").serialize(),
		type: 'POST',
		success: function(res)
		{
			resp = jQuery.parseJSON(res);
			
			if( null != resp && resp.ok )
			{
				$('#help_msg').html('Enviado, esperando respuesta...').fadeIn();
				HW_CFG_INTERVAL_ID = setInterval('action_config_check_state('+resp.cfg_action_id+')', HW_CFG_REQ_INTERVAL );
			}
			else
			{
				clearInterval( HW_CFG_INTERVAL_ID );
				$('#help_msg').html('<span class="server_error">'+resp.msg+'</span>').fadeIn();
			}
		}
	});
}

function KPanel( hw_id )
{
	this.hw_id = hw_id;
	this.kms_id = null;
	this.starttime = null;
	this.clientstarttime = 0;
	this.failurecount = 0;
	this.active = true;
	this.timeouttime = 300;
	this.first_message = true;
	this.pressedkeys = "";
	this.messagehexa = "";
	this.prev_sound_state = 0;
	
	this.reset_timeout();
}

KPanel.prototype.reset_timeout = function()
{
	this.clientstarttime = Math.floor(Date.now() / 1000);
}

KPanel.prototype.set_active = function( active )
{
	this.active = active;
}

KPanel.prototype._goto_fail = function()
{
	var my = this;
	
	my.failurecount++;

	if ( my.failurecount >= 5 )
	{
		$('.kpanel_container > div').hide();
		$('.kpanel_container .communication_error').show();
	}
}

KPanel.prototype.wait_for_messages = function()
{
	var my = this;
	
	$.ajax({
		url: page_url + '/kpanel/get_new_messages_from/' + my.hw_id,
		data: 'timestamp=' + my.starttime,
		type: 'GET',
		success: function(resp)
		{
			if( null != resp )
			{
				my.starttime = resp.timestamp;
				
				if ( resp.last_message > resp.timestamp )
				{
					$('.kpanel_container > div').hide();
					$('.kpanel_container .sending_initialization').show();
					
					my.send_initialization();
				}
				else if ( Math.floor(Date.now() / 1000) - my.clientstarttime > my.timeouttime )
				{
					$('.kpanel_container > div').hide();
					$('.kpanel_container .no_messages').show();
				}
				else if ( my.active )
				{
					setTimeout(function(){ my.wait_for_messages(); }, 2000 );
				}
			}
			else if ( my.active )
			{
				setTimeout(function(){ my.wait_for_messages(); }, 2000 );
			}
		}
	}).fail(function()
	{
		my._goto_fail();
	});
}

KPanel.prototype.send_initialization = function()
{
	var my = this;
	
	$.ajax({
		url: page_url + '/kpanel/send_initialization/' + my.hw_id,
		type: 'GET',
		success: function(resp)
		{
			if ( null != resp && resp.message )
			{
				my.kms_id = resp.message.kms_id;
				
				my.wait_for_response();
			}
			else
			{
				my._goto_fail();
			}
		}
	}).fail(function()
	{
		my._goto_fail();
	});
}

KPanel.prototype.update_on_next_message = function()
{
	var my = this;
	
	$.ajax({
		url: page_url + '/kpanel/get_new_messages_from/' + my.hw_id,
		data: 'timestamp=' + my.starttime,
		type: 'GET',
		success: function(resp)
		{
			if( null != resp )
			{
				if ( resp.count > 0 )
				{
					my.starttime = resp.messages[ resp.count - 1 ].timestamp;
					
					my.update( resp.messages[ resp.count - 1 ] );
				}
				
				if ( my.active )
				{
					setTimeout(function(){ my.update_on_next_message(); }, 2000 );
				}
			}
			else if ( my.active )
			{
				setTimeout(function(){ my.update_on_next_message(); }, 2000 );
			}
		}
	}).fail(function()
	{
		my._goto_fail();
	});
}

KPanel.prototype.wait_for_response = function()
{
	var my = this;
	
	$.ajax({
		url: page_url + '/kpanel/get_message_sent/' + my.kms_id,
		type: 'GET',
		success: function(resp)
		{
			if ( null != resp && resp.message )
			{
				if ( resp.message.kms_state == 'EXECUTED' )
				{
					my.reset_timeout();
					
					if ( my.first_message )
					{
						my.first_message = false;
						
						kpanel.update_timeout();
					}
					else
					{
						alertify.alert("Mensaje ejecutado con éxito.");
					}
					
					if ( resp.received )
					{
						my.reset_message();
						my.update( resp.received );
						
						$('img[usemap]').rwdImageMaps();
						
						my.starttime = resp.timestamp;
						my.update_on_next_message();
					}
					
					$('.kpanel_container > div').hide();
					$('.kpanel_container .panel_view').css('display', 'table');
				}
				else if ( my.active )
				{
					setTimeout(function(){ my.wait_for_response(); }, 2000 );
				}
			}
			else
			{
				my._goto_fail();
			}
		}
	}).fail(function()
	{
		my._goto_fail();
	});
}

KPanel.prototype.send_message = function( partition, message )
{
	var my = this;
	
	$.ajax({
		url: page_url + '/kpanel/send_message/' + my.hw_id,
		type: 'POST',
		data: 'partition=' + partition + "&msg=" + message,
		success: function(resp)
		{
			if ( resp.error )
			{
				if ( resp.error == 'invalid_partition' )
				{
					alertify.alert( "Partición seleccionada inválida." );
				}
				else if ( resp.error == 'message_not_valid' )
				{
					alertify.alert( "Mensaje inválido." );
				}
			}
			else if ( resp.message )
			{
				$('.kpanel_container .panel_view').css('display','none');
				$('.kpanel_container .sending_message').show();
				
				my.kms_id = resp.message.kms_id;
				
				my.wait_for_response();
			}
			else
			{
				my._goto_fail();
			}
		}
	}).fail(function()
	{
		my._goto_fail();
	});
}

KPanel.prototype.update = function( message )
{
	var my = this;
	var leds	= message.kmr_led_state;
	var masks	= message.kmr_partition_mask;
	var reset_pm = ( message.kmr_partition_state & ( 1 << 13 ) ) && ( message.kmr_partition_state & ( 1 << 14 ) ) && ( message.kmr_partition_state & ( 1 << 15 ) );
	
	if ( reset_pm )
	{
		masks = 0x000000FF;
	}
	
	for ( var i = 0; i <= 13; i++ )
	{
		var kpanel_img = $('.keymap_led_zone_' + (i+1) );
		
		if ( kpanel_img.length > 0 )
		{
			var led = ( parseInt( leds ) & ( 1 << i ) );
			var mask = ( parseInt( masks ) & ( 1 << i ) );
			var state = led & mask;
			
			if ( state )
			{
				kpanel_img.show();
			}
			else
			{
				kpanel_img.hide();
			}
		}
	}
	
	var kpanel_img = $('.keymap_led_ready' );
	
	if ( kpanel_img.length > 0 )
	{
		var state = message.kmr_partition_state & ( 1 << 0 );
		
		if ( state )
		{
			kpanel_img.show();
		}
		else
		{
			kpanel_img.hide();
		}
	}
	
	kpanel_img = $('.keymap_led_armed' );
	
	if ( kpanel_img.length > 0 )
	{
		var state = message.kmr_partition_state & ( 1 << 1 );
		
		if ( state )
		{
			kpanel_img.show();
		}
		else
		{
			kpanel_img.hide();
		}
	}
	
	kpanel_img = $('.keymap_led_system' );
	
	if ( kpanel_img.length > 0 )
	{
		var state = message.kmr_partition_state & ( 1 << 4 );
		
		if ( state )
		{
			kpanel_img.show();
		}
		else
		{
			kpanel_img.hide();
		}
		
		blink_state = ( message.kmr_partition_state & ( 1 << 13 ) ) && ( message.kmr_partition_state & ( 1 << 15 ) );
		
		if ( blink_state )
		{
			kpanel_img.addClass('blink');
			kpanel_img.show();
		}
		else
		{
			kpanel_img.removeClass('blink');
		}
	}
	
	if ( message.kmr_sound_state != my.prev_sound_state )
	{
		my.prev_sound_state = message.kmr_sound_state;
		
		switch ( parseInt( message.kmr_sound_state ) )
		{
			case 0x10:
			{
				$('#kpanel_audio_4').get(0).play(); // 4 beeps
				break;
			}
			case 0x20:
			{
				$('#kpanel_audio_2').get(0).play(); // 2 beeps
				break;
			}
			case 0x30:
			{
				$('#kpanel_audio_5').get(0).play(); // 5 beeps
				break;
			}
			case 0x60:
			{
				$('#kpanel_audio_3').get(0).play(); // 3 beeps
				break;
			}
			case 0x80:
			{
				$('#kpanel_audio_long').get(0).play(); // large beep
				break;
			}
		}
	}
}

KPanel.prototype.update_timeout = function()
{
	var my = this;
	
	setTimeout(function()
	{
		var secs = 300 - ( Math.floor(Date.now() / 1000) - my.clientstarttime );
		var mins = Math.floor( secs / 60 );
		
		if ( secs >= 0 )
		{
			secs = secs - mins * 60;
			
			$('.panel_view .panel_top .panel_timer').text( zero_fill( mins ) + ':' + zero_fill( secs ) );
			
			if ( my.active )
			{
				my.update_timeout();
			}
		}
		else
		{
			$('.kpanel_container > div').hide();
			$('.kpanel_container .communication_timeout').show();
		}
	}, 1000);
}

KPanel.prototype.reset_message = function()
{
	var my = this;
	var msglog = $('.panel_view .panel_top .pressed_keys');
	my.pressedkeys = "";
	my.messagehexa = "";
	msglog.html("&nbsp;");
}

KPanel.prototype.send_message_safe = function()
{
	var my = this;
	var partition_select = $('#partition_select');
	
	if ( partition_select.val() == null || partition_select.val().length == 0 )
	{
		alertify.alert("Debes seleccionar una partición antes de enviar el mensaje.");
		return;
	}
	
	if ( my.messagehexa.length == 0 )
	{
		alertify.alert( "El mensaje no puede estar vacío." );
		return;
	}
	
	my.send_message( partition_select.val(), my.messagehexa );
}

KPanel.prototype.push_button = function(el)
{
	var my = this;
	var name = el.data('code');
	var val = el.data('val');
	var msglog = $('.panel_view .panel_top .pressed_keys');
	
	if ( my.pressedkeys.length < 16 )
	{
		my.pressedkeys += name;
		my.messagehexa += val;
		
		msglog.text( my.pressedkeys );
	}
}