var dshield_control_jobs_id			= null;
var dshield_control_jobs_interval	= 10000;
var dshield_control_update_url		= '';
var dshield_event_get_url			= '';
var dshield_chat_send_url			= '';
var dshield_first_event_id			= 0;
var dshield_last_event_id			= 0;
var dshield_events_data				= [];
var dshield_event_hw_id				= null;
var dshield_event_last_chat_id		= 0;
var dshield_events_div				= null;
var dshield_event_id				= 0;
var dshield_event_box_bottom_init	= 0;
var dshield_rfid_job_update_locked	= false;
var dshield_rfid_event_status_job_locked = false;
var DSHIELD_TAB_ALL					= 0;
var DSHIELD_TAB_EMERGENCY			= 1;
var dshield_tab_selected_index		= DSHIELD_TAB_ALL;
var dshield_citymesh_using			= null;
var dshield_citymesh_selected		= null;

var DSHIELD_PERSON_TYPE = {
 	OWNER				: 1,
	NEIGHBOR			: 2,
	VISITOR				: 3,
	NEIGHBOR_EMPLOYEE	: 4,
	SERVICE				: 5,
	PROFESSIONAL		: 6,
	WORKER				: 7,
	GUARD				: 8,
	GUEST				: 9,
	PROVIDER			: 10
}

var DSHIELD_GALLERY_TYPE = {
	GENERAL				: 0,
	TOOLS				: 1,
	INSURANCE			: 2
}

function dshield_control_init( update_url, event_get_url, chat_send_url, last_event_id )
{
	dshield_events_div			= dshield_control_get_events_div();
	dshield_control_update_url	= update_url;
	dshield_event_get_url		= event_get_url;
	dshield_chat_send_url		= chat_send_url;
	dshield_first_event_id		= last_event_id;
	dshield_last_event_id		= last_event_id;
	
	dshield_event_box_bottom_init	= parseInt( $('#dshield_event_box').css('bottom') );
	
	dshield_control_events_bind();
	dshield_control_jobs_start();
}

function dshield_control_get_events_div()
{
	var dshield_events_div = $('.dshield_events');
	
	if ( dshield_events_div.find('.mCustomScrollBox .mCSB_container').length > 0 )
	{
		dshield_events_div = dshield_events_div.find('.mCustomScrollBox .mCSB_container');
	}
	
	return dshield_events_div;
}

function dshield_chat_message_send()
{
	var event_content = $('.event_content');
	var message = event_content.find('.send_box input[name="msg"]').val();
	
	if ( message.length > 0 )
	{
		event_content.find('.send_box input[name="msg"]').val('');
		
		$.post( dshield_chat_send_url,
		{
			event_hw_id: dshield_event_id,
			msg: message
		},
		function()
		{
			dshield_control_update();
		});
	}
}

function dshield_event_fill_data( event_data )
{
	var event_content = $('.event_content');
	dshield_event_id = event_data.dse_id;
	
	$('#event_id_hinput').val( dshield_event_id );
	
	event_content.find('.hw_code').removeClass('hidden');
	event_content.find('.hw_serial').removeClass('hidden');
	event_content.find('.key_owner_phone').removeClass('hidden');
	event_content.find('.key_owner_cellphone').removeClass('hidden');
	
	if ( event_data.key_id != null )
	{
		event_content.find('.hw_name').html( event_data.key_owner_lastname + " " + event_data.key_owner_name );
		
		event_content.find('.hw_code').addClass('hidden');
		event_content.find('.hw_serial').addClass('hidden');
		
		if ( event_data.key_owner_phone != null && event_data.key_owner_phone.length > 0 )
		{
			event_content.find('.key_owner_phone').removeClass('hidden');
			event_content.find('.key_owner_phone span').html( event_data.key_owner_phone );
		}
		
		if ( event_data.key_owner_cellphone != null && event_data.key_owner_cellphone.length > 0 )
		{
			event_content.find('.key_owner_cellphone').removeClass('hidden');
			event_content.find('.key_owner_cellphone span').html( event_data.key_owner_cellphone );
		}
	}
	else
	{
		event_content.find('.key_owner_phone').addClass('hidden');
		event_content.find('.key_owner_cellphone').addClass('hidden');
		
		event_content.find('.hw_name').html( event_data.hw_name );
		
		var hw_code = event_content.find('.hw_code span a');
		hw_code.html( parseInt( event_data.hw_code ).toString(16) );
		hw_code.attr('href', page_url + 'hw/view/' + event_data.hw_id );
		
		var hw_serial = event_content.find('.hw_serial span a');
		hw_serial.html( parseInt( event_data.hw_serial ).toString(16) );
		hw_serial.attr('href', page_url + 'hw/view/' + event_data.hw_id );
	}
	
	event_content.find('.state_box textarea').val( event_data.dse_observations );
	event_content.find('.send_box input[name="msg"]').val('');
	event_content.find('.send_box input[name="send"]').unbind('click').bind('click', function()
	{
		dshield_chat_message_send();
	});
	
	var history_but = event_content.find('#event_history').unbind('click').bind('click', function()
	{
		modal_dialog_ajax_get( page_url + 'dshield/event_history/' + dshield_event_id, null, {
			extraClass: 'modal_dialog_fancy',
			width: '800px'
		});
	});
	
	event_content.find('.send_box input[name="msg"]').keyup(function (e)
	{
		if (e.which == 13)
		{
			dshield_chat_message_send();
			return false;
		}
	});
	
	if ( '' != event_data.dse_status )
	{
		event_content.find('.state_box .state option[value="' + event_data.dse_status + '"]').prop('selected', true).change();
	}
}

function dshield_timestamp_get_hour( timestamp )
{
	var time = timestamp.split(' ');
	var time_hs = time[1].split('.');
	
	return time_hs[0];
}

function dshield_event_chat_box_reset()
{
	var msg_box = $('.chat_box .msgs_box');
	var msg_base = msg_box.find('.msg_base').clone();
	
	msg_box.empty();
	msg_box.append( msg_base );
}

function dshield_event_chat_messages_push( event_msgs, scroll_down )
{
	var msg_box = $('.chat_box .msgs_box');
	var msg_base = msg_box.find('.msg_base');
	var sh = parseInt( msg_box.prop("scrollHeight") - msg_box.height() );
	var st = parseInt( msg_box.scrollTop() );
	var force_scroll = scroll_down || ( sh == st );
	
	for ( var i = 0; i < event_msgs.length; i++ )
	{
		var msg = event_msgs[i];
		var msg_div = msg_base.clone();
		
		msg_div.removeClass('msg_base');
		msg_div.attr('id', 'msg_id_' + msg.dsec_id );
		msg_div.find('.time').html( dshield_timestamp_get_hour( msg.dsec_timestamp ) );
		msg_div.find('.author').html( msg.author );
		msg_div.find('.message').text( msg.dsec_msg );
		
		msg_box.append( msg_div );
	}
	
	dshield_event_last_chat_id = event_msgs[ event_msgs.length - 1 ].dsec_id;
	
	if ( force_scroll )
	{
		msg_box.scrollTop( msg_box.prop("scrollHeight") );
	}
}

function dshield_event_events_push( events )
{
	var events_list = $('.events_box .events_list');
	var event_base = events_list.find('.hwevent_base');
	
	events_list.empty();
	events_list.append( event_base );
	
	for ( var i = events.length - 1; i >= 0; i-- )
	{
		var event = events[i];
		var event_div = event_base.clone();
		
		event_div.removeClass('hwevent_base');
		event_div.attr('id', 'hwevent_id_' + event.id);
		event_div.attr('data-hwid', event.hw_id );
		event_div.find('.time div').html( event.time );
		event_div.find('.desc div').html( event.desc );
		
		if ( event_div.emergency && !event.done )
		{
			event_div.addClass('emergency');
		}
		else if ( event.done )
		{
			event_div.addClass('done');
		}
		
		events_list.append( event_div );
	}
}

function dshield_control_event_show( id, event_id )
{
	var event_box = $('#dshield_event_box');
	var event_content = event_box.find('.event_content');
	var loader_div = event_box.find('.loading-spinner');
	
	event_box.show();
	
	dshield_event_hw_id = parseInt( id );
	dshield_event_last_chat_id = 0;
	
	dshield_event_slide_up();
	
	event_content.hide();
	loader_div.show();
	
	dshield_event_slide_up();
	
	$.post( dshield_event_get_url,
	{
		event_hw_id: dshield_event_hw_id,
		event_selected_id: event_id,
		event_last_chat_id: dshield_event_last_chat_id
	},
	function(res)
	{
		var data = $.parseJSON( res );
		
		if ( null != data.event_data )
		{
			dshield_event_update_status( data.event_data );
			dshield_event_fill_data( data.event_data );
			
			map_show_marker_info_from_id( 'hw_' + dshield_event_hw_id, true, 'ff0000' );
			
			if ( null != data.events && data.events.length > 0 )
			{
				dshield_event_events_push( data.events );
			}
			
			dshield_event_chat_box_reset();
			
			loader_div.hide();
			event_content.show();
			
			if ( null != data.event_msgs && data.event_msgs.length > 0 )
			{
				dshield_event_chat_messages_push( data.event_msgs, true );
			}
		}
	});
}

function dshield_control_event_bind_click( me )
{
	me.unbind('click').bind('click', function()
	{
		dshield_control_event_show( me.data('hwid'), me.attr('id').substr( 'event_id_'.length ) ); 
	});
}

function dshield_control_events_bind()
{
	dshield_events_div.find('.event.emergency, .event.done').each(function()
	{
		dshield_control_event_bind_click( $(this) );
	});
}

function dshield_event_search( event )
{
	if ( null != dshield_events_data && 0 != dshield_events_data.length )
	{
		for ( var i = 0; i < dshield_events_data.length; i++ )
		{
			if ( dshield_events_data[i].dse_id == event.dse_id )
			{
				return dshield_events_data[i];
			}
		}
	}
		
	return null;
}

function dshield_event_update_status( event )
{
	var event_div = $('#event_id_' + event.dse_event_id);
	
	if ( event_div.length == 0 )
	{
		return;
	}
	
	if ( event.dse_status != '' )
	{
		event_div.removeClass('emergency');
		event_div.addClass('done');
				
		$('.state_box .state option[value="' + event.dse_status + '"]').prop('selected', true).change();
	}
	else
	{		
		$('.state_box .state option:first-child').prop('selected', true).change();
	}
}

function dshield_events_compare( event_new )
{
	var event_old = dshield_event_search( event_new );
	
	if ( null != event_old )
	{
		if ( event_old.dse_status == '' && event_old.dse_status != event_new.dse_status )
		{
			dshield_event_update_status( event_new );
			
			if ( event_new.relations )
			{
				event_new.relations = $.parseJSON( event_new.relations );
				
				if ( event_new.relations )
				{
					for ( var i = 0; i < event_new.relations.length; i++ )
					{
						var event_copy = event_new;
						
						event_copy.dse_event_id = event_new.relations[i].der_event_id;
						
						dshield_event_update_status( event_copy );
					}
				}
			}
		}
	}
}

function dshield_control_update()
{
	$.post( dshield_control_update_url, 
	{
		first_event_id: dshield_first_event_id,
		last_event_id: dshield_last_event_id,
		event_hw_id: dshield_event_hw_id,
		event_id: dshield_event_id,
		event_last_chat_id: dshield_event_last_chat_id
	}, 
	function(res)
	{
		var data = $.parseJSON( res );
		
		if ( null != data.events && data.events.length > 0 )
		{
			var alarm = false;
			
			for ( var i = data.events.length - 1; i >= 0; i-- )
			{
				var event		= data.events[i];
				var event_div	= $('.event_base').clone();
				
				event_div.removeClass('event_base');
				event_div.attr('id', 'event_id_' + event.id);
				event_div.attr('data-hwid', event.hw_id );
				
				if ( event.emergency )
				{
					if ( !event.done )
					{
						event_div.addClass('emergency');
						event_div.addClass('shake');
					
						alarm = true;
					}
					else
					{
						event_div.addClass('done');
					}
					
					dshield_control_event_bind_click( event_div );
				}
				else if ( event.done )
				{
					event_div.addClass('done');
				}
				else
				{
					event_div.addClass('normal');
				}
				
				event_div.find('.time').html( event.time );
				var desc = event_div.find('.desc');
				
				desc.html( event.desc + ' en ' + event.target );
				
				if ( event.type == '2'/** DKEEP */ && event.reported_by )
				{
					desc.html( desc.html() + '. Reportado por abonado: ' + event.reported_by + '.' );
				}
				
				dshield_events_div.prepend( event_div );
			}
			
			if ( alarm )
			{
				dshield_audio_alarm();
			}
			
			dshield_last_event_id = data.events[0].id;
			
			$('.dshield_button_emergency span').html( $('.dshield_events .event.emergency, .dshield_events .event.done').length );
			
			$('.dshield_events').mCustomScrollbar('update');
			
			dshield_tab_refresh();
		}
		
		if ( null != data.events_data && data.events_data.length > 0 )
		{
			for ( var i = 0; i < data.events_data.length; i++ )
			{
				dshield_events_compare( data.events_data[i] );
			}
			
			dshield_events_data = data.events_data;
		}
		
		if ( null != data.event_msgs && data.event_msgs.length > 0 )
		{
			dshield_event_chat_messages_push( data.event_msgs );
		}
	});
}

function dshield_control_jobs_start()
{
	dshield_control_job_id = setInterval(function()
	{
		dshield_control_update();
	}, dshield_control_jobs_interval );
}

function dshield_control_jobs_stop()
{
	if ( null != dshield_control_job_id )
	{
		clearInterval( dshield_control_job_id );
	}
}

function dshield_map_make( canvas_name, citymesh_data, geotrace_data, receivers_data, radars_data )
{
	map_make( canvas_name, citymesh_data, null, receivers_data, radars_data, 'ffffff' );
	geotrace_map_update( geotrace_data, null, true, true, 'ffffff' );
	map_default_marker = null;
}

function dshield_map_auto_update( interval, update_url, data )
{
	map_update_interval_id = setInterval(function()
	{
		$.get( update_url, data, function(res)
		{
			var data = $.parseJSON( res );
			
			if ( null != data )
			{
				var tmp_vehicles	= 'undefined' != typeof data['vehicles'] ? data['vehicles'] : null;
				
				geotrace_map_update( tmp_vehicles, null, false, true, 'ffffff', true );
				
				if ( null != map_default_marker )
				{
					map_show_marker_info_from_id( map_default_marker.id );
				}
			}
		});
	}, interval );
}

function dshield_map_auto_update_stop()
{
	geotrace_map_auto_update_stop();
}

function dshield_audio_alarm()
{
	var audio = $('#audio_alarm').get(0);
	
	if ( audio.paused )
	{
		audio.play();
	}
}

function dshield_event_slide_up()
{
	var htop = $('#dshield_event_box');
	var bottom = parseInt( htop.css('bottom') );
	
	if ( 0 != bottom && dshield_footer_height() != bottom )
	{
		$('#dshield_event_box div.contractor').children().first().attr('class','sprite-img-flechin-down');
		
		htop.stop().animate( { bottom: dshield_footer_height() }, 500 );
	}
}

function dshield_event_slide_down()
{
	var htop = $('#dshield_event_box');
	var bottom = parseInt( htop.css('bottom') );
	
	if ( 0 == bottom || dshield_footer_height() == bottom )
	{
		$('#dshield_event_box div.contractor').children().first().attr('class','sprite-img-flechin-up');
		
		var cont = htop.find('div.contractor');
		
		htop.stop().animate( { bottom: dshield_event_box_bottom_init }, 500 );
	}
}

function dshield_event_toggle()
{
	var htop = $('#dshield_event_box');
	var bottom = parseInt( htop.css('bottom') );
	
	if ( 0 == bottom || dshield_footer_height() == bottom )
	{
		dshield_event_slide_down();
	}
	else
	{
		dshield_event_slide_up();
	}
}

function dshield_footer_height()
{
	var footer = $('#footer');
	
	if ( !footer.hasClass('footer_dshield') )
	{
		var h = parseInt( footer.outerHeight() );
		
		return h;
	}
	
	return 0;
}

function dshield_event_close()
{
	var htop = $('#dshield_event_box');
	
	htop.css('bottom', dshield_event_box_bottom_init );
	
	htop.hide();
	
	event_id = 0;
	event_hw_id = 0;
	event_last_chat_id = 0;
}

function dshield_update_state( _going_down )
{
	$('#header_bottom').removeClass('dshield');
	$('#header_bottom_cont').show();
	$('#header_dshield_cont').hide();
	$('.footer_complete').show();
	$('#footer').removeClass('footer_dshield');
	$('#footer').removeClass('ignore');
	
	if ( location.pathname.startsWith( '/dshield' ) && !_going_down )
	{
		$('#header_bottom').addClass('dshield');
		$('#header_bottom_cont').hide();
		$('#header_dshield_cont').show();
		$('.footer_complete').hide();
		$('#footer').addClass('footer_dshield');
		$('#footer').addClass('ignore');
	}
	
	var htop = $('#dshield_event_box');
	var bottom = parseInt( htop.css('bottom') );
	
	if ( htop.is(':visible') )
	{
		if ( dshield_event_box_bottom_init != bottom )
		{
			htop.css( 'bottom', dshield_footer_height() );
		}
	}
}

function dshield_tab_refresh()
{
	switch ( dshield_tab_selected_index )
	{
		case DSHIELD_TAB_ALL:
		{
			$('.dshield_button').removeClass('active');
			$('.dshield_button_all').addClass('active');
			$('.dshield_events .event.normal').css('display', 'block');
			break;
		}
		case DSHIELD_TAB_EMERGENCY:
		{
			$('.dshield_button').removeClass('active');
			$('.dshield_button_emergency').addClass('active');
			$('.dshield_events .event.normal').css('display', 'none');
			break;
		}
	}
}

function dshield_tab_set( index )
{
	dshield_tab_selected_index = index;
	
	dshield_tab_refresh();
}

function dshield_person_photo_change( urfid_id )
{
	modal_dialog_ajax_get( page_url + 'person/edit_photo/' + urfid_id, {}, { 
		width: '656px',
		extraClass: 'modal_dialog_fancy', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
			dshield_photo_set_person( urfid_id );
		} 
	});
}

var dshield_person_user_professional = false;

function dshield_person_add( me, reload_target, user_is_professional )
{
	dshield_person_user_professional = typeof user_is_professional != 'undefined' ? user_is_professional : false;
	
	var type = local_storage_form_get_item( 'person_insert_form', 'type' );
	
	if ( null != type )
	{
		var $me = $(me);
		
		$me.data('href', $me.data('href') + '/' + type );
	}
	
	modal_dialog_from_data_href( me, reload_target );
}

function dshield_person_add_check_previous()
{
	var type = local_storage_form_get_item( 'person_insert_form', 'type' );
	
	if ( null != type )
	{
		modal_dialog_from_url( page_url + '/dshield/person/add/' + type );
	}
}

function dshield_person_edit( urfid_id )
{
	modal_dialog_ajax_get( page_url + 'person/edit/' + urfid_id, {}, { 
		extraClass: 'modal_dialog_fancy', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
		}
	});
}

function dshield_person_entrance( urfid_id )
{
	modal_dialog_ajax_get( page_url + 'person/edit_entrance/' + urfid_id, {}, { 
		extraClass: 'modal_dialog_fancy', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
		} 
	});
}

function dshield_person_edit_hours( urfid_id, data )
{
	modal_dialog_keep_open = true;
	
	if ( 'undefined' == typeof data )
	{
		data = {};
	}
	
	modal_dialog_ajax_get( page_url + 'person/edit_hours/' + urfid_id, data, { 
		extraClass: 'modal_dialog_fancy', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
			
			modal_dialog_keep_open = false;
		} 
	});
}

function dshield_person_edit_gallery_load( path, data )
{
	if ( 'undefined' == typeof data )
	{
		data = {};
	}
	
	modal_dialog_ajax_get( path, data, { 
		extraClass: 'modal_dialog_fancy', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
			
			md.imagesLoaded(function()
			{
				modal_dialog_update();
			});
		}
	});
}

function dshield_person_edit_tools( urfid_id, data )
{
	dshield_person_edit_gallery_load( page_url + 'person/edit_tools/' + urfid_id, data );
}

function dshield_person_edit_gallery( urfid_id, data )
{
	dshield_person_edit_gallery_load( page_url + 'person/edit_gallery/' + urfid_id, data );
}

function dshield_person_edit_insurance( urfid_id, data )
{
	dshield_person_edit_gallery_load( page_url + 'person/edit_insurance/' + urfid_id, data );
}

var dshield_photo_temp_image_data = null;
var dshield_photo_current_urfid = null;

function dshield_photo_delete( rp_id, gallery_type )
{
	var msg = '"¿Seguro que desea eliminar esta imagen?"';
	
	switch ( gallery_type )
	{
		case DSHIELD_GALLERY_TYPE.TOOLS:
		{
			msg = "¿Seguro que deseas remover esta herramienta?";
			break;
		}
		case DSHIELD_GALLERY_TYPE.INSURANCE:
		{
			msg = "¿Seguro que deseas remover el seguro de trabajo?";
			break;
		}
	}
	
	alertify.confirm( msg, function (e)
	{
		if (e)
		{
			kajax_eval( page_url + 'person/delete_photo/' + rp_id + '/' + gallery_type );
		}
	});
}

function dshield_photo_upload_snapshot()
{
	if ( null != dshield_photo_temp_image_data )
	{
		var base_url = $('#photo_upload_form').attr('action');
		
		var query_sep = base_url.indexOf( '?' ) == -1 ? '?' : '&';
		
		Webcam.upload( dshield_photo_temp_image_data, base_url + query_sep + 'webcam=true&urfid_id=' + dshield_photo_current_urfid, function(code, text)
		{
			var data = jQuery.parseJSON( text );
			
			if ( data )
			{
				dshield_photo_file_uploaded( null, data );
			}
			else
			{
				alertity.error("Error desconocido al subir imagen");
			}
		});
	}
}

function dshield_photo_take_snapshot()
{
	if ( $('#my_camera').is(':visible') )
	{
		$('#photo_taken_confirm').show();
		
		Webcam.snap(function(data_uri)
		{
			dshield_photo_temp_image_data = data_uri;
			
			$('#photo_take_button input').val( 'Tomar otra' );
			
			$('#my_camera').hide();
			
			$('#my_result').show();
			
			$('#my_result').html( '<img src="'+data_uri+'"/>' );
		});
	}
	else
	{
		$('#photo_take_button input').val( 'Tomar Fotografía' );
		
		$('#my_camera').show();
		
		$('#my_result').hide();
		
		$('#photo_taken_confirm').hide();
	}
}

function dshield_photo_select_click( el )
{
	$('#photo_file_upload_input').click();
}

function dshield_photo_file_uploaded_result( data )
{
	var files = 'undefined' != typeof data.result ? data.result.files : data.files;
	
	$.each(files, function (index, file)
	{
		if ( 'error' in file )
		{
			$('#progress').addClass( 'incomplete' );
			
			alertify.error( file['error'] );
		}
		else
		{
			if ( 'undefined' != typeof file['result'] )
			{
				alertify.success( file['result'] );
			}
			else
			{
				alertify.success( "Foto subida con éxito" );
			}
		}
	});
}

function dshield_photo_file_uploaded( e, data )
{
	var result = 'undefined' != typeof data.result ? data.result : data;
	
	dshield_photo_file_uploaded_result( result );
	
	if ( result.upload_type == 'profile_photo' )
	{
		if ( 'undefined' == typeof result.was_editing || !result.was_editing )
		{
			dshield_person_set_type_data();
		}
		else
		{
			kajax_load_target( window.location.href );
			modal_dialog_close();
		}
	}
	else
	{
		modal_dialog_ajax_get( result.href, result,
		{ 
			extraClass: 'modal_dialog_fancy', 
			onComplete: function(md)
			{
				kajax_on_loaded_event( md );
			} 
		});
	}
}

function dshield_photo_take_init()
{
	kajax_bind_click( $('#photo_choose_button'), dshield_photo_select_click );
	
	$('#photo_file_upload_input').change(function()
	{
		$('#photo_file_form_selected').text( $('#photo_file_upload_input').val().replace(/^.*(\\|\/|\:)/, '') );
	});
	
	file_upload_init( $('#photo_file_upload_input'), $('#photo_upload_form').attr('action'), dshield_photo_file_uploaded );
	
	Webcam.on( 'error', function()
	{
		$('#my_camera').hide();
		
		$('#photo_take_button').hide();
		
		modal_dialog_update();
	} );
	
	Webcam.set({
		width: 400,
		height: 300,
		dest_width: 400,
		dest_height: 300,
		image_format: 'jpeg',
		jpeg_quality: 90,
		force_flash: false
	});
	
	Webcam.attach( '#my_camera' );
}

function dshield_photo_set_person( urfid_id )
{
	dshield_photo_current_urfid = urfid_id;
	
	$('.person_add_step_1').hide();
	$('.person_add_step_2').show();
	$('#photo_urfid_id').val( urfid_id );
	$('#step_hours_urfid_id').val( urfid_id );
	
	dshield_photo_take_init();
	
	modal_dialog_update();
}

function dshield_person_set_type_data()
{
	$('.person_add_step_2').hide();
	
	switch ( dshield_current_editing_type )
	{
		case DSHIELD_PERSON_TYPE.SERVICE:
		case DSHIELD_PERSON_TYPE.PROFESSIONAL:
		case DSHIELD_PERSON_TYPE.NEIGHBOR_EMPLOYEE:
		case DSHIELD_PERSON_TYPE.WORKER:
		{
			dshield_person_edit_hours( dshield_photo_current_urfid, { adding_person: true } );
			
			break;
		}
		case DSHIELD_PERSON_TYPE.GUEST:
		{
			dshield_rfid_event_create_id( dshield_photo_current_urfid, 0 );
			break;
		}
		case DSHIELD_PERSON_TYPE.PROVIDER:
		{
			dshield_person_edit_tools( dshield_photo_current_urfid, { adding_person: true } );
			
			break;
		}
		default:
		{
			dshield_person_set_type_data_2();
		}
	}
}

function dshield_person_set_type_data_2()
{
	switch ( dshield_current_editing_type )
	{
		case DSHIELD_PERSON_TYPE.SERVICE:
		case DSHIELD_PERSON_TYPE.PROFESSIONAL:
		{
			dshield_person_edit_tools( dshield_photo_current_urfid, { adding_person: true } );
			
			break;
		}
		case DSHIELD_PERSON_TYPE.WORKER:
		{
			dshield_person_edit_insurance( dshield_photo_current_urfid, { adding_person: true } );
			
			break;
		}
		default:
		{
			dshield_person_rfid_set( dshield_photo_current_urfid, { adding_person: true } );
		}
	}
}

function dshield_person_set_type_data_3()
{
	switch ( dshield_current_editing_type )
	{
		case DSHIELD_PERSON_TYPE.WORKER:
		{
			dshield_person_edit_tools( dshield_photo_current_urfid, { adding_person: true, next_step: 'dshield_person_set_type_data_4' } );
			
			break;
		}
		default:
		{
			dshield_person_rfid_set( dshield_photo_current_urfid, { adding_person: true } );
		}
	}
}

function dshield_person_set_type_data_4()
{
	if ( !dshield_person_user_professional )
	{
		dshield_person_rfid_set( dshield_photo_current_urfid, { adding_person: true } );
	}
	else
	{
		kajax_reload_target();
		modal_dialog_close();
	}
}

function dshield_person_new_access( rc_type )
{
	alertify.prompt( "Ingrese el DNI de la persona", function (ok, str)
	{
		if ( ok && '' != str )
		{
			dshield_rfid_event_create( str, rc_type );
		}
	}, "" );
	
	$('#alertify-text').attr('type','number');
}

var dshield_rfid_worker = null;
var dshield_rfid_job_id = null;
var dshield_rfid_update_url = '';
var dshield_rfid_pairing = null;
var dshield_rfid_unpairing = false;
var dshield_rfid_pairing_inteval_id = null;
var dshield_rfid_locked = false;
var dshield_rfid_events = null;
var dshield_rfid_event_current = null;
var dshield_rfid_event_set_executing = false;
var dshield_rfid_event_status_job_id = null;
var dshield_is_guard = false;

function dshield_rfid_citymesh_set()
{
	dshield_is_guard = true;
	
	modal_dialog_ajax_get( page_url + 'rfid/citymesh_show', {}, { 
		width: '656px',
		extraClass: 'modal_dialog_fancy', 
		lockClose: true,
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
		},
		onClosed: function()
		{
			dshield_rfid_job_restart();
		}
	});
}

function dshield_rfid_event_dialog_close()
{
	dshield_rfid_locked = false;
	dshield_rfid_event_current = null;
	dshield_rfid_event_set_executing = false;
	dshield_rfid_event_status_job_stop();
	dshield_person_add_check_previous();
}

function dshield_rfid_event_create( dni, rc_type )
{
	dshield_rfid_locked = true;
	dshield_rfid_event_current = null;
	
	modal_dialog_ajax_get( page_url + 'rfid/event_show_dni/' + dni + '/' + rc_type, {}, {
		width: '100%',
		height: '100%',
		extraClass: 'modal_dialog_fancy dshield_modal_dialog', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
			
			md.imagesLoaded(function()
			{
				modal_dialog_update();
			});
			
			var server_time = $('#event_server_time').val();
			
			dshield_rfid_event_status_job_start( page_url + 'rfid/event_is_created/' + dni + '/' + rc_type + '/' + server_time );
			
		},
		onClosed: function()
		{
			dshield_rfid_event_dialog_close();
		},
		lockClose: true
	});
}

function dshield_rfid_event_create_id( urfid_id, rc_type )
{
	dshield_rfid_locked = true;
	dshield_rfid_event_current = null;
	
	modal_dialog_ajax_get( page_url + 'rfid/event_show_id/' + urfid_id + '/' + rc_type, {}, {
		width: '100%',
		height: '100%',
		extraClass: 'modal_dialog_fancy dshield_modal_dialog', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
			
			md.imagesLoaded(function()
			{
				modal_dialog_update();
			});
			
			var server_time = $('#event_server_time').val();
			
			dshield_rfid_event_status_job_start( page_url + 'rfid/event_is_created_id/' + urfid_id + '/' + rc_type + '/' + server_time );
		},
		onClosed: function()
		{
			dshield_rfid_event_dialog_close();
		},
		lockClose: true
	});
}

function dshield_rfid_event_open( event )
{
	if ( dshield_rfid_locked )
		return;
	
	dshield_rfid_locked = true;
	dshield_rfid_event_current = event;
	
	modal_dialog_ajax_get( page_url + 'rfid/event_show/' + event.re_id + '/' + event.re_serial, {}, {
		width: '100%',
		height: '100%',
		extraClass: 'modal_dialog_fancy dshield_modal_dialog', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
			
			md.imagesLoaded(function()
			{
				modal_dialog_update();
			});
			
			dshield_rfid_event_status_job_start( page_url + 'rfid/event_is_set/' + event.re_id + '/' + event.re_serial );
		},
		onClosed: function()
		{
			dshield_rfid_event_dialog_close();
		},
		lockClose: true
	});
}

function dshield_rfid_event_validate( event, accepted, data, callback )
{
	if ( dshield_rfid_event_set_executing == true )
		return;
	
	dshield_rfid_event_set_executing = true;
	
	var _data = { validated: accepted };
	
	if ( 'object' == typeof data )
	{
		$.extend( _data, data );
	}
	
	dshield_rfid_locked = true;
	
	$.get( page_url + 'rfid/event_set/' + event.re_id + '/' + event.re_serial, _data, function()
	{
		delete dshield_rfid_events[ event.re_serial ];
		
		dshield_rfid_locked = false;
		
		if ( 'function' == typeof callback )
		{
			callback( event );
		}
	});
}

function dshield_rfid_citymesh_get_using( rc_type )
{
	var ret = [];
	
	if ( dshield_citymesh_using && dshield_citymesh_using.length > 0 )
	{
		for ( var i = 0; i < dshield_citymesh_using.length; i++ )
		{
			if ( dshield_citymesh_using[i].type == rc_type ) {
				ret.push( dshield_citymesh_using[i] );
			}
		}
	}
	
	return ret;
}

function dshield_rfid_check_citymesh_available( rc_type, fbcb )
{
	var possible_citymesh = dshield_rfid_citymesh_get_using( rc_type );
	
	if ( possible_citymesh.length == 0 )
	{
		alertify.alert( "No estás trabajando con ningún puesto de " + ( 0 == rc_type ? 'ingreso' : 'egreso' ) + "." );
		modal_dialog_close();
		return true;
	}
	else if ( possible_citymesh.length > 1 )
	{
		var cs = $('.citymesh_select_modal');
		var csi = cs.find('.citymesh_select_table');
		
		for ( var i = 0; i < possible_citymesh.length; i++ )
		{
			csi.append( '<div data-id="' + possible_citymesh[i].id + '" id="citymesh_open_' + possible_citymesh[i].id + '">' + possible_citymesh[i].name + '</div>' );
			
			$('#citymesh_open_' + possible_citymesh[i].id).click(function()
			{
				dshield_citymesh_selected = parseInt( $(this).data('id') );
				
				fbcb();
				
				cs.hide();
			});
		}
		
		cs.show();
		
		return true;
	}
	
	return false;
}

function dshield_rfid_event_validate_new( dni, data, rc_type, callback )
{
	if ( dshield_rfid_event_set_executing == true )
		return;
		
	if ( data.validated == 1 && !data.walking && ( !dshield_citymesh_selected || 0 == dshield_citymesh_selected ) && 
			dshield_rfid_check_citymesh_available( rc_type, function(){ dshield_rfid_event_validate_new( dni, data, rc_type, callback ); } ) )
		return;

	dshield_rfid_event_set_executing = true;
	
	dshield_rfid_locked = true;
	
	$.get( page_url + 'rfid/event_create/' + dni + '/' + rc_type + ( dshield_citymesh_selected ? '/' + dshield_citymesh_selected : '' ), data, function(res)
	{
		dshield_citymesh_selected = null;
		dshield_rfid_locked = false;
		
		if ( 'function' == typeof callback )
		{
			callback(res);
		}
	});
}

function dshield_rfid_event_validate_new_id( urfid_id, data, rc_type, callback )
{
	if ( dshield_rfid_event_set_executing == true )
		return;
	
	if ( ( !dshield_citymesh_selected || 0 == dshield_citymesh_selected ) && 
			dshield_rfid_check_citymesh_available( rc_type, function(){ dshield_rfid_event_validate_new_id( urfid_id, data, rc_type, callback ); } ) )
		return;
	
	dshield_rfid_event_set_executing = true;
	
	dshield_rfid_locked = true;
	
	$.get( page_url + 'rfid/event_create_id/' + urfid_id + '/' + rc_type + ( dshield_citymesh_selected ? '/' + dshield_citymesh_selected : '' ), data, function(res)
	{
		dshield_citymesh_selected = null;
		dshield_rfid_locked = false;
		
		if ( 'function' == typeof callback )
		{
			callback(res);
		}
	});
}

function dshield_rfid_event_set_validation_parse_response( res, rc_type )
{
	modal_dialog_close();
	
	var data = $.parseJSON( res );
	
	if ( null != data.result && data.result == 'error' && null != data.type )
	{
		var rc_type_str = rc_type == 0 ? 'un ingreso' : 'una salida';
		
		if ( data.type == 'city_not_found' )
		{
			alertify.error( "No se puede registrar " + rc_type_str + " porque no se ha seleccionado un puesto para trabajar que sea " + rc_type_str );
		}
		else if ( data.type == 'permissions' )
		{
			alertify.error( "No posee permisos para validar " + rc_type_str + " de esta persona" );
		}
	}
	else
	{
		if ( 'undefined' != typeof data.new_url )
		{
			var link = $(data.new_id).find('a');
			
			if ( link.length > 0 )
			{
				link.attr('data-href', data.new_url );
				link.find('p').text( data.new_state );
			}
		}
	}
	
	dshield_rfid_event_dialog_close();
}

function dshield_rfid_event_set_validation( validated, rc_type, walking, note )
{
	var data = { validated: validated, members: dshield_family_member_select_get() };
	
	if ( 'undefined' != typeof walking && walking == 1 )
	{
		data.walking = 1;
	}
	
	if ( 'undefined' != typeof note && note.length > 0 )
	{
		data.note = note;
	}
	
	if ( null != dshield_rfid_event_current )
	{
		dshield_rfid_event_validate( dshield_rfid_event_current, validated, data, function( event )
		{
			modal_dialog_close();
		});
	}
	else
	{
		var rfid_alert_dni = $('.rfid_alert .dni').val();
		
		if ( rfid_alert_dni.length > 0 && parseInt( rfid_alert_dni ) != 0 )
		{
			dshield_rfid_event_validate_new( rfid_alert_dni, data, rc_type, function(res)
			{
				dshield_rfid_event_set_validation_parse_response( res, rc_type );
			});
		}
		else
		{
			dshield_rfid_event_validate_new_id( $('.rfid_alert .urfid_id').val(), data, rc_type, function(res)
			{
				dshield_rfid_event_set_validation_parse_response( res, rc_type );
			});
		}
	}
}

function dshield_rfid_accept( rc_type, walking, note )
{
	dshield_rfid_event_set_validation( 1, rc_type, walking, note );
}

function dshield_rfid_reject( rc_type, note )
{
	dshield_rfid_event_set_validation( 0, rc_type, 0, note );
}

function dshield_family_member_select_get()
{
	var dsel = $('.profile_photos_family div.selected');
	var sel = '';
	
	for ( var i = 0; i < dsel.length; i++ )
	{
		sel += $( dsel.get(i) ).data('id') + ',';
	}
	
	if ( sel.length > 0 )
	{
		sel = sel.substr( 0, sel.length - 1 );
	}
	
	return sel;
}

function dshield_rfid_event_alertify( event )
{
	if ( 0 == $('.alertify-logs .log_id_' + event.re_serial ).length )
	{
		var ret = alertify.log( 'Intento de ingreso con tarjeta no registrada.<br/><a href="#" onclick="modal_dialog_from_data_href(this)" data-href="' + ( page_url + 'dshield/person/add' ) + '">Registrar Persona</a>', "error", 0 );
		
		$('.alertify-logs article:last-child').addClass( 'log_id_' + event.re_serial );
		
		dshield_rfid_event_validate( event, 0 );
	}
}

function dshield_rfid_update_control( data )
{
	if ( null != dshield_rfid_event_current || dshield_rfid_locked )
	{
		return;
	}
	
	if ( 'undefined' != typeof data )
	{
		var events = {};
		
		if ( null != data.events && data.events.length > 0 )
		{
			for ( var i = 0; i < data.events.length; i++ )
			{
				var event = data.events[i];
				
				if ( !( event.re_serial in events ) )
				{
					events[ event.re_serial ] = event;
				}
			}
			
			dshield_rfid_events = events;
		}
		else
		{
			dshield_rfid_events = null;
		}
	}
	
	if ( null != dshield_rfid_events )
	{
		$.each( dshield_rfid_events, function( serial, event )
		{
			if ( null != dshield_rfid_event_current )
			{
				return false;
			}
			
			if ( null != event.urfid_id )
			{
				dshield_rfid_event_open( event );
				
				return false;
			}
			else
			{
				dshield_rfid_event_alertify( event );
			}
			
			return true;
		});
	}
}

function dshield_rfid_job_update()
{
	if ( dshield_rfid_pairing || dshield_rfid_locked || dshield_rfid_job_update_locked )
	{
		return;
	}
	
	dshield_rfid_job_update_locked = true;
	
	$.post( dshield_rfid_update_url, {},
	function(res)
	{
		if ( !dshield_rfid_pairing || !dshield_rfid_locked )
		{
			var data = $.parseJSON( res );
			
			if ( null != data.events && data.events.length > 0 )
			{
				dshield_rfid_update_control( data );
			}
		}
	}).always(function()
	{
		dshield_rfid_job_update_locked = false;
	});
}

function dshield_rfid_job_restart()
{
	dshield_rfid_job_stop();
	dshield_rfid_job_start();
}

function dshield_rfid_job_start()
{
	dshield_rfid_update_url = page_url + 'rfid/jobs';
	
	dshield_rfid_job_id = setInterval(function()
	{
		dshield_rfid_job_update();
	}, 1000 );
}

function dshield_rfid_job_stop()
{
	if ( null != dshield_rfid_job_id )
	{
		clearInterval( dshield_rfid_job_id );
	}
}

function dshield_rfid_event_status_job_update( update_url )
{
	if ( dshield_rfid_event_status_job_locked )
		return;
	
	dshield_rfid_event_status_job_locked = true;
	
	$.post( update_url, {},
	function(res)
	{
		var data = $.parseJSON( res );
		
		if ( null != data.result && data.result == 'true' )
		{
			modal_dialog_close();
		}
	}).always(function()
	{
		dshield_rfid_event_status_job_locked = false;
	});
}

function dshield_rfid_event_status_job_start( update_url )
{	
	dshield_rfid_event_status_job_id = setInterval(function()
	{
		dshield_rfid_event_status_job_update( update_url );
	}, 1000 );
}

function dshield_rfid_event_status_job_stop()
{
	if ( null != dshield_rfid_event_status_job_id )
	{
		clearInterval( dshield_rfid_event_status_job_id );
	}
}

function dshield_person_rfid_set( urfid_id, data )
{
	dshield_rfid_pairing = true;
	
	if ( 'undefined' == typeof data )
	{
		data = {};
	}
	
	dshield_rfid_job_stop();
	
	modal_dialog_ajax_get( page_url + 'rfid/pair/' + urfid_id, data, { 
		extraClass: 'modal_dialog_fancy', 
		onComplete: function(md)
		{
			kajax_on_loaded_event( md );
		},
		onClosed: function()
		{
			if ( null != dshield_rfid_pairing_inteval_id )
			{
				clearInterval( dshield_rfid_pairing_inteval_id );
			}
			
			dshield_rfid_pairing = false;
			dshield_rfid_pairing_inteval_id = null;
			
			if ( dshield_is_guard )
			{
				dshield_rfid_job_restart();
			}
			
			if ( 'undefined' != typeof dshield_current_editing_type )
			{
				if (
						dshield_current_editing_type == DSHIELD_PERSON_TYPE.PROVIDER || 
						dshield_current_editing_type == DSHIELD_PERSON_TYPE.WORKER
				)
				{
					dshield_rfid_event_create_id( dshield_photo_current_urfid, 0 );
				}
			}
		}
	});
}

function dshield_person_rfid_unset( urfid_id )
{
	alertify.confirm( "¿Seguro que desea desasignar la tarjeta RFID?", function (e)
	{
		if (e)
		{
			$.post( page_url + 'rfid/unpair/' + urfid_id, 
				{},
				function(res)
				{
					var data = $.parseJSON( res );
					
					if ( null != data.result )
					{
						if ( 'ok' == data.result )
						{
							kajax_reload_target();
							
							alertify.success( "Tarjeta RFID desasignada." );
							
							return;
						}
					}
					
					alertify.error( "Error al suspender tarjeta RFID." );
				}
			);
		}
	});
}

function dshield_person_suspend( urfid_id )
{
	alertify.confirm( "¿Seguro que desea suspender la tarjeta RFID?", function (e)
	{
		if (e)
		{
			$.post( page_url + 'person/suspend/' + urfid_id, 
				{},
				function(res)
				{
					var data = $.parseJSON( res );
					
					if ( null != data.result )
					{
						if ( 'ok' == data.result )
						{
							kajax_reload_target();
							
							alertify.success( "Tarjeta RFID suspendida." );
							
							return;
						}
					}
					
					alertify.error( "Error al suspender tarjeta RFID." );
				}
			);
		}
	});
}

function dshield_person_allow( urfid_id )
{
	alertify.confirm( "¿Seguro que desea habilitar la tarjeta RFID?", function (e)
	{
		if (e)
		{
			$.post( page_url + 'person/allow/' + urfid_id, 
				{},
				function(res)
				{
					var data = $.parseJSON( res );
					
					if ( null != data.result )
					{
						if ( 'ok' == data.result )
						{
							var status = $('#event_status');
							
							if ( status.length == 0 )
							{
								kajax_reload_target();
							}
							else
							{
								var stat = status.find('.status');
								
								if ( stat.length )
								{
									stat.removeClass('status_warning');
									stat.removeClass('status_error');
									
									stat.html('SIN IRREGULARIDADES EN EL SISTEMA');
								}
							}
							
							alertify.success( "Tarjeta RFID habilitada." );
							
							return;
						}
					}
					
					alertify.error( "Error al habilitadar tarjeta RFID." );
				}
			);
		}
	});
}

function dshield_person_rfid_pairing_start( urfid_id, re_id )
{
	dshield_rfid_pairing_inteval_id = setInterval(function()
	{
		$.post( page_url + 'rfid/pairing', 
		{
			urfid_id: urfid_id,
			re_id: re_id
		},
		function(res)
		{
			if ( dshield_rfid_pairing && !dshield_rfid_unpairing )
			{
				var data = $.parseJSON( res );
				
				if ( null != data.result )
				{
					if ( 'ok' == data.result )
					{
						clearInterval( dshield_rfid_pairing_inteval_id );
						dshield_rfid_pairing_inteval_id = null;
						
						var p = $('.rfid_sync p.data');
						p.text( "Tarjeta de RFID asignada con éxito" );
						p.removeClass('error');
						
						$('.rfid_sync .loading').hide();
						
						setTimeout(function()
						{
							if ( dshield_rfid_pairing )
							{
								kajax_reload_target();
								
								modal_dialog_close();
							}
						}, 5000 );
					}
					else if ( 'assigned' == data.result )
					{
						clearInterval( dshield_rfid_pairing_inteval_id );
						dshield_rfid_pairing_inteval_id = null;
						
						kajax_reload_target();
						
						modal_dialog_close();
					}
					else if ( 'exists' == data.result )
					{
						var p = $('.rfid_sync p.data');
						
						p.text( "La tarjeta de RFID se encuentra asignada a: " + data.person.urfid_name + " ( DNI " + data.person.urfid_dni + " )" );
						
						if ( !p.hasClass('error') )
						{
							p.addClass('error');
						}
						
						$('.rfid_sync .unassign').removeClass('hidden');
						
						$('.rfid_sync .unassign input').unbind('click').bind('click', function()
						{
							dshield_person_rfid_unassign( data.person.urfid_id );
						});
					}
				}
			}
			else if ( null != dshield_rfid_pairing_inteval_id )
			{
				clearInterval( dshield_rfid_pairing_inteval_id );
				dshield_rfid_pairing_inteval_id = null;
			}
		});
	}, 2000 );
}

function dshield_person_rfid_unassign( urfid_id )
{
	if ( 'undefined' == typeof urfid_id )
	{
		return;
	}
	
	dshield_rfid_unpairing = true;
	
	var p = $('.rfid_sync p.data');
	p.text( "Desasignando RFID de persona." );
	
	$.post( page_url + 'rfid/unpair/' + urfid_id, 
		{},
		function(res)
		{
			var data = $.parseJSON( res );
			
			if ( null != data.result )
			{
				var p = $('.rfid_sync p.data');
				
				if ( 'ok' == data.result )
				{
					p.text( "Vuelva a pasar la tarjeta por el lector." );
					p.removeClass('error');
					
					$('.rfid_sync .unassign').addClass('hidden');
				}
				else
				{
					p.text( "Error al desasignar tarjeta." );
				}
			}
			
			dshield_rfid_unpairing = false;
		}
	);
}

function dshield_person_set_insurance_expiration( urfid_id )
{
	$.post( page_url + '/person/insurance_set', { urfid_id: urfid_id, expiration: $('#enddate').val() },
		function(res)
		{
			var data = $.parseJSON( res );
			
			if ( null != data.result && 'ok' == data.result )
			{
				alertify.success("Vencimiento de Seguro de Trabajo actualizado");
			}
			else
			{
				alertify.error("Error al asignar vencimiento de seguro de trabajo");
			}
		}
	);
}
