<? if ( 0 == $com_id ) { ?>
	<h2>Debes estar logueado como empresa para poder ver el reporte de una receptora.</h2>
<? } ?>

<?
function format_log($log)
{
	$real_log = base64_decode($log,TRUE);
	
	if ( FALSE != $real_log )
	{
		$log = $real_log;
	}
	
	$arr = explode("\n", $log);
	$new_log = "";
	foreach($arr as $line)
	{
		$class="";

		if( strpos($line,' | INFO | ')  )
		{
			$class="log_entry_info";
		}else if( strpos($line,' | ERROR | ')  )
		{
			$class="log_entry_error";
		}else if( strpos($line,' | CRITICAL | ')  )
		{
			$class="log_entry_critical";

		}else if( strpos($line,' | ACTION | ')  )
		{
			$class="log_entry_action";

		}

		$line = '<div class="'.$class.'">'.$line.'</div>' . "\n";
		$new_log=$new_log.$line;
	}
	return $new_log;

}
?>

<div class="report_cont">

<div class="report_div">
	<h2>Reporte</h2>
	<p>
		<em>Fecha de reporte:</em> <?=report_prop( $r, 'ReportTime' )?><br/>
	</p>

	<h2>Red</h2>
	<p>
		<em>IP WAN:</em> <?=$com['com_ip']?><br/>
		<em>IP Local:</em> <?=report_prop( $r, 'Network', 'LocalIP' )?>
	</p>

	<h2>Receptora</h2>
	<p>
		<em>Versión:</em> <?=report_prop( $r, 'SoftVersion' )?><br/>
		<em>MAC del Modem: </em> <?=report_prop( $r, 'modemMAC' )?><br/>
		<em>Version Instalada:</em> <?=report_prop( $r, 'Settings', 'soft_version', 'currentversion' )?><br/>
		<em>Carpeta de instalación:</em> <?=report_prop( $r, 'Paths', 'InstallPath' )?><br/>
		<em>Fecha de Actualización:</em> <?=report_prop( $r, 'Settings', 'soft_version', 'lastupdate' )?><br/>
		<em>API Key:</em> <?=report_prop( $r, 'Settings', 'soft_domo_config', 'api_key' )?><br/>
		<em>Config.ini ultima instalacion web:</em> <?=report_prop( $r, 'Settings', 'config_ini_version', 'lastupdate' )?><br/>
	</p>

	<h2>Sistema Operativo</h2>
	<p>
	<em>Tipo:</em> <?=report_prop( $r, 'OS', 'Type' )?><br/>
	<em>Version:</em> <?=report_prop( $r, 'OS', 'Version' )?><br/>
	<em>Arquitectura:</em> <?=report_prop( $r, 'OS', 'Architecture' )?><br/>
	<em>Nº de Procesadores:</em> <?=report_prop( $r, 'OS', 'ProcessorCount' )?><br/>
	<em>.NET Runtime:</em> <?=report_prop( $r, 'OS', 'DotNetRuntime' )?><br/>
	<em>RAM Total:</em> <?=report_prop( $r, 'OS', 'TotalRam' )?><br/>
	<em>RAM Libre:</em> <?=report_prop( $r, 'OS', 'FreeRam' )?><br/>
	<?if(isset($r->OS->Type) && $r->OS->Type == 'Linux'){?>
		<em>Version de Mono:</em> <?=report_prop( $r, 'OS', 'MonoVersion' )?><br/>
	<?}?>
	</p>

	<h2>Disco</h2>
	<p>
	<em>Espacio Libre:</em> <?=isset( $r->Disk->AvailableFreeSpace ) ? round($r->Disk->AvailableFreeSpace / (1024  *1024),2) . 'MB' : 'Sin datos'?><br/>
	<em>Espacio Total:</em> <?=isset( $r->Disk->TotalSize ) ? round( $r->Disk->TotalSize / (1024  *1024),2) . 'MB' : 'Sin datos'?><br/>
	<em>Directorio Raiz:</em> <?=report_prop( $r, 'Disk', 'RootDirectory' )?><br/>
	<em>Formato:</em> <?=report_prop( $r, 'Disk', 'DriveFormat' )?><br/>
	<em>Tipo:</em> <?=report_prop( $r, 'Disk', 'DriveType' )?><br/>
	</p>
	
	<h2>Configuraciones</h2>
	<ul>
		<li>
				<a onclick="show_modal_log('.domo_config')" href="#">domo_config.json</a>
				
				<div class="hidden">
					<div class="domo_config logbody">
						<?=json_enc( report_prop( $r, 'Settings' ), TRUE )?>
					</div>
				</div>
		</li>
	</ul>

	<h2>Logs</h2>
	
	<ul class="loglinks">
		<? if ( isset( $r->Logs ) ) { foreach($r->Logs as $name=>$txt) { if( $txt != null) {
			$cname = str_replace( '.', '_', $name );
		?>
			<li>
				<a onclick="show_modal_log('.<?=$cname?>')" href="#"><?=$name?></a>
				
				<div class="hidden">
					<div class="<?=$cname?> logbody">
						<?=format_log( $txt )?>
					</div>
				</div>
			</li>
		<?	} } } else { ?>
			<b>No hay logs disponibles</b>
		<? } ?>
	</ul>
</div>

</div>

<script>
function show_modal_log( el )
{
	el = $(el);
	
	modal_dialog_inline( el, {
		'onUpdate': function()
		{
			el.css( 'height', parseInt( modal_dialog_get().height() * 0.8 ) + 'px' );
		}
	});
}
</script>