<?php
$sel = 'selected="selected"';
function radar_build_link( $order_by )
{
	return base_url( '/radars/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="resize_informer">
	<form enctype="multipart/form-data" id="table-form" action="<?=base_url('/radars/update')?>" method="post" style="display: none;"></form>

	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>

	<table id="radars_list_table" class="default_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="ajax-el-link" data-href="<?=radar_build_link( 'rd_serial' )?>">MAC</th>
				<th class="ajax-el-link" data-href="<?=radar_build_link( 'rd_name' )?>">Nombre</th>
				<th>Empresa</th>
				<th>Latitud</th>
				<th>Longitud</th>
				<th>Velocidad Máxima</th>
			</tr>
		</thead>
		<tbody>
			<? if ( isset( $radars ) ) { foreach ( $radars as $radar ) { ?>
			<tr id="row_<?=$radar['rd_id']?>">
				<td class="greener">
					<input type="hidden" name="id" value="<?=$radar['rd_id']?>" />
					<input type="text" name="serial" value="<?=dechex_bigint( $radar['rd_serial'] )?>" />
				</td>
				<td class="greener">
					<input type="text" name="name" value="<?=$radar['rd_name']?>" />
				</td>
				<td class="greener">
					<select name="company">
						<option value="">Asignar Empresa</option>
					<?	if ( isset( $companies ) ) { foreach( $companies as $com ) { ?>
						<option value="<?=$com->com_id?>" <?=isset($radar['rd_company'])&&$radar['rd_company']==$com->com_id?$sel:''?>><?=$com->com_name?></option>
					<?	} } ?>
					</select>
				</td>
				<td class="greener">
					<input type="text" name="lat" value="<?=$radar['rd_lat']?>" />
				</td>
				<td class="greener">
					<input type="text" name="long" value="<?=$radar['rd_long']?>" />
				</td>
				<td class="greener">
					<input type="text" name="trigger_speed" value="<?=$radar['rd_trigger_speed']?>" />
				</td>
			</tr>
			<tr class="hidden" id="row_extra_<?=$radar['rd_id']?>">
				<td class="greener">
					<span class="box">Nombre de Urbanización</span>
					<input type="text" name="urbanization_name" value="<?=$radar['rd_urbanization_name']?>" />
				</td>
				<td class="greener">
					<span class="box">Domicilio de Urbanización</span>
					<input type="text" name="urbanization_address" value="<?=$radar['rd_urbanization_address']?>" />
				</td>
				<td class="greener">
					<span class="box">Logo de Urbanización</span>
					<input type="file" name="urbanization_logo" value="" />
				</td>
				<td>
					<span class="box">Logo Actual</span>
					<? $logo_url = !empty($radar['rd_urbanization_logo']) ? base_url('assets/radars_logos/'.$radar['rd_urbanization_logo'].'.jpg') : ""; ?>
					<a class="logo_link" target="_blank" href="<?=$logo_url?>">
						<img class="logo_img" src="<?=$logo_url?>" />
					</a>
				</td>
				<? if ( User()->is_logged_as_god() ) { ?>
				<td class="greener">
					<span class="box">Código de País</span>
					<input type="text" name="country_id" value="<?=$radar['rd_country_id']?>" />
				</td>
				<td class="greener">
					<span class="box">Velocidad de Error</span>
					<input type="text" name="speed_ignore" value="<?=$radar['rd_speed_ignore']?>" />
				</td>
				<? } else { ?>
					<td colspan="2"></td>
				<? } ?>
			</tr>
			<? if ( User()->is_logged_as_god() ) { ?>
			<tr class="hidden" id="row_extra_2_<?=$radar['rd_id']?>">
				<td class="greener">
					<span class="box">Intevalo de Captura ( ms )</span>
					<input type="text" name="photo_timeout_ms" value="<?=$radar['rd_photo_timeout_ms']?>" />
				</td>
				<td class="greener">
					<span class="box">Cantidad de Imágenes</span>
					<input type="text" name="photo_count" value="<?=$radar['rd_photo_count']?>" />
				</td>
				<td class="greener">
					<span class="box">Índice de Foto</span>
					<input type="text" name="photo_index" value="<?=$radar['rd_photo_index']?>" />
				</td>
				<td class="greener">
					<span class="box">Índice de Foto</span>
					<input type="text" name="photo_index" value="<?=$radar['rd_photo_index']?>" />
				</td>
				<td class="greener">
					<span class="box">Dirección de host ( con http/s )</span>
					<input type="text" name="host_address" value="<?=isset($radar['rd_host_addr'])?$radar['rd_host_addr']:'https://reddomo.com.ar'?>" />
				</td>
				<td class="greener">
					<span class="box">API Key</span>
					<input type="text" name="api_key" value="<?=isset($radar['rd_api_key'])&&!empty($radar['rd_api_key'])?$radar['rd_api_key']:$radar['com_apikey']?>" />
				</td>
				<td colspan="1"></td>
			</td>
			<? } ?>
			<tr class="form_buttons hidden" id="row_hidden_<?=$radar['rd_id']?>">
				<td colspan="6" align="center">
					<? if ( User()->is_logged_as_god() ) { ?>
					<button data-href="<?=base_url('/radars/delete/'.$radar['rd_id'])?>" class="submit_btn_table delete_btn" data-text="¿Seguro que quiere eliminar el radar <?=dechex( $radar['rd_name'] )?>?"><span>Eliminar</span></button>
					<? } ?>
					
					<button class="submit_btn_table cancel_btn" value="cancel"><span>Cancelar</span></button>
					
					<button class="submit_btn_table save_btn" value="submit"><span>Guardar</span></button>
				</td>
			</tr>
			<? }} ?>
		</tbody>
	</table>
</div>

<script type="text/javascript">
	var form_table	= null;

	function row_new_add_click( el )
	{
		if ( $('#row_new').length == 0 )
		{
			kajax_eval( 
				el.attr('href'), 
				null, 
				function()
				{
					table_row_new_register( [ $('#row_new'), $('#row_extra_new'), $('#row_extra_2_new') ], $('#row_hidden_new'), $('#content'), $('#table-form') );
				}
			);
		}
	}
	
	$(function()
	{
		form_table	= $('#table-form');
		
		table_register( form_table );
		
		table_header_fixed_register();
		
		kajax_bind_click( $('#add_new_but'), row_new_add_click );
	})
</script>

<a id="add_new_but" href="<?=base_url('/radars/get_new_row')?>"><div class="table_after_right_button">Nuevo Radar</div></a>
