
<div class="panel_box panel_box_left_top" id="panel_radar_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				<input class="fecha" name="from" id="from" type="text" value="" readonly style="cursor:pointer" />
				
				<input class="fecha" name="to" id="to" type="text" value="" readonly style="cursor:pointer" />
				
				<input id="rd_serial_search" class="panel_text_input panel_search_hw_input" type="text" name="hw_serial" placeholder="Filtrar por MAC de Radar" value="<?=$rd_serial?>" />
				
				<div class="search_box">
					<p>Filtrar por Velocidad:</p>
				
					<input class="panel_half_input" type="text" name="min_speed" placeholder="Desde Km/h..." value="<?=$min_speed?>" />
				
					<input class="panel_half_input" type="text" name="max_speed" placeholder="Hasta Km/h..." value="<?=$max_speed?>" />
				</div>
				
				<input type="hidden" id="rd_id" name="rd_id" value="<?=$rd_id?>" />
				
				<div class="left clear">
					<button class="left submit_btn" type="submit" value="submit"><span>Consultar</span></button>
				</div>
			</form>
		 </div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<? if ( isset( $events ) && !empty( $events ) ) { ?>
	<table id="events_list_table" class="default_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th>MAC Radar</th>
				<th>Nombre Radar</th>
				<th>Dominio</th>
				<th>Fecha y Hora</th>
				<th>Velocidad</th>
				<th>Max. Vel.</th>
				<th>Foto</th>
				<? if ( $management ) { ?>
				<th>Infracción</th>
				<? if ( User()->is_logged_as_god() ) { ?>
				<th>Validación</th>
				<? } ?>
				<? } ?>
			</tr>
		</thead>
		<tbody>
		<? foreach ( $events as $e ) { 
			$alert = '';
			 if ( ( User()->is_logged_as_god() || User()->is_radar_validator() ) && $e['re_valid'] == RadarEventStatus::NOT_VALIDATED ) {
				$alert = 'alert';
			} ?>
			<tr class="<?=$alert?>" id="re_id_<?=$e['re_id']?>" data-id="<?=$e['re_id']?>">
				<td><?=dechex( $e['re_rd_serial'] )?></td>
				<td><?=$e['rd_name']?></td>
				<td id="re_id_<?=$e['re_id']?>_plate" onclick="radar_change_plate( <?=$e['re_id']?>, '<?=$e['re_plate']?>' )" style="cursor:pointer;"><?=$e['re_plate']?></td>
				<td><?=strftime( '%d/%m/%Y %H:%M:%S', $e['re_timestamp'] )?></td>
				<td><?=$e['re_speed']?></td>
				<td><?=$e['re_max_speed']?></td>
				<td>
					<a href="<?=base_url('/assets/tickets/' . $e['re_image'] )?>" target="_blank">
						<img src="<?=base_url('/assets/tickets/medium/' . $e['re_image'] )?>" />
					</a>
				</td>
				<? if ( $management ) { ?>
				<td>
					<a target="_blank" href="<?=base_url('radars/ticket/'.$e['re_id'])?>">
						<div class="light_green_but">Descargar</div>
					</a>
					
					<br/><br/>
					
					<a target="_blank" href="<?=base_url('radars/export/'.$e['re_id'])?>">
						<div class="light_green_but">Exportar Imagen</div>
					</a>
				</td>
				<? if ( User()->is_logged_as_god() || User()->is_radar_validator() ) { ?>
				<td>
					<? if ( $e['re_valid'] == RadarEventStatus::NOT_VALIDATED ) { ?>
					<a class="validate" onclick="radar_validate_prompt(<?=$e['re_id']?>)">
						<div class="light_green_but">Validar</div>
					</a>
					
					<br/><br/>
					
					<a class="invalidate ajax-eval-link" href="<?=base_url('radars/invalidate/'.$e['re_id'])?>">
						<div class="light_green_but red_but">Inválido</div>
					</a>
					
					<a class="revalidate hidden" onclick="radar_validate_prompt(<?=$e['re_id']?>)">
						<div class="light_green_but">Re-Validar</div>
					</a>
					<? } else { ?>
					<a class="revalidate" onclick="radar_validate_prompt(<?=$e['re_id']?>)">
						<div class="light_green_but">Re-Validar</div>
					</a>
					<? } ?>
				</td>
				<? } ?>
				<? } ?>
			</tr>
		<? } ?>
		</tbody>
	</table>
<? } else if ( $was_filtering ) { ?>
	<script>
		$(function()
		{
			alertify.alert("No se han encontrado eventos.");
		})
	</script>
<? } ?>

<script type="text/javascript">
	function radar_change_plate( id, plate )
	{
		alertify.prompt( "¿Desea modificar el dominio?",function(ok, str)
		{
			if ( ok )
			{
				kajax_eval( '<?=base_url('/radars/update_plate')?>', { "re_id": id, "plate": str } );
			} 
		});
		
		$('.alertify-text').val( plate );
	}
	
	$(function()
	{
		panel_register( $('#panel_radar_filters'), 'left', <?=( isset( $events ) && !empty( $events ) ) ? 'false' : 'true'?> );

		datetime_picker_init( '#from', "<?=$from?>", "'Desde el '" );
		datetime_picker_init( '#to', "<?=$to?>", "'Hasta el '" );
		
		autocomplete_register( $( "#rd_serial_search" ), "<?=base_url('/radars/autocomplete/serial')?>", '', function(ui)
		{
			$('#rd_id').val( ui.item.id );
		});
	});
	
	<? if ( User()->is_logged_as_god() || User()->is_radar_validator() ) { ?>
	
	function radar_validate_prompt( re_id )
	{
		var url = '<?=base_url('radars/validate')?>';
		
		alertify.prompt( "Ingrese la patente del vehículo", function (ok, str)
		{
			if ( ok && '' != str )
			{
				data = {
					re_id: re_id,
					plate: str
				}
				
				kajax_eval( url, data );
			}
		}, "" );
	}
	
	<? } ?>
</script>