<?php
$sel = 'selected="selected"';
function macsicons_build_link( $order_by )
{
	return base_url( '/macs/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>
<div class="resize_informer">

<form id="table-form" action="<?=base_url('/macs/update')?>" method="POST" style="display: none;"></form>

<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>

<table id="macsicons_list_table" class="default_table" align="center" cellpadding="0" cellspacing="0">
	<thead>
		<tr>
			<th class="ajax-el-link" data-href="<?=macsicons_build_link( 'mac_serial' )?>">MAC</th>
			<th class="ajax-el-link" data-href="<?=macsicons_build_link( 'mac_icon' )?>">Ícono</th>
		</tr>
	</thead>
	<tbody>
<? if ( isset( $hws ) ) { ?>
	<? foreach ( $hws as $hw ) { ?>
		<tr id="row_<?=$hw['mac_serial']?>">
			<td class="greener">
				<input type="text" name="serial" value="<?=dechex( $hw['mac_serial'] )?>" readonly />
			</td>
			<td class="icons greener" align="center">
				<div style="display:none">
					<div class="mac_pin_select" id="mac_pin_select_<?=$hw['mac_serial']?>">
						<select class="icons" id="mac_icon_<?=$hw['mac_serial']?>" name="icon">
							<? $icons = get_icons_array(); foreach ( $icons as $name=>$key ) { ?>
							
							<option value="<?=$key?>" <?=$key==$hw['mac_icon']?$sel:''?>><?=$name?></option>
							<?	} ?>
						</select>
						
						<div class="submit_btn pin_select" onclick="return pin_select_for( '<?=$hw['mac_serial']?>' )">Seleccionar</div>
					</div>
				</div>
				<img id="mac_icon_img_<?=$hw['mac_serial']?>" class="hw_icon_img" src="<?=base_url('/assets/pin/'.$hw['mac_icon'])?>.png" onclick="return pin_open_select( '<?=$hw['mac_serial']?>', { onClosed: function() { pin_select_close(); } } )" />
			</td>
		</tr>
		<tr class="form_buttons hidden" id="row_hidden_<?=$hw['mac_serial']?>">
			<td colspan="2" align="center">
				<button data-href="<?=base_url('/macs/delete/'.$hw['mac_serial'])?>" class="submit_btn_table delete_btn" data-text="¿Seguro que quiere eliminar este ícono para esta MAC?"><span>Eliminar</span></button>
				<button class="submit_btn_table cancel_btn" value="cancel"><span>Cancelar</span></button>
				<button class="submit_btn_table save_btn" value="submit"><span>Guardar</span></button>
			</td>
		</tr>
	<? } ?>
<? } ?>
	</tbody>
</table>

<div class="panel_box panel_box_left_top no_lock" id="panel_macs_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<a id="add_new_but" href="<?=base_url('/macs/get_new_row')?>"><div class="panel_left_but">Nuevo Ícono de MAC</div></a>
			<a id="macs_import_show" href="<?=base_url('/macs/import')?>"><div class="panel_left_but" style="margin-bottom: 12px">Importar íconos de MACs</div></a>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<div class="hidden">
	<div id="macs_import_box">
		<h4>Elegir Archivo CSV</h4>
		
		<p>* El csv requiere tener los datos con el formato adecuado. <br/>
			Consiste en dos columnas: n&uacute;mero de mac en hexa y nombre de &iacute;cono.<br/><br/>
			<b>Explicaci&oacute;n de nombre de &iacute;conos:</b><br/>
			<span class="hw_fake_list_span">INTERIOR</span>: Interior de vivienda. <img src="<?=base_url('/api/icon?state=fake&icon=INTERIOR')?>" /><br/>
			<span class="hw_fake_list_span">EXTERIOR_HIGH_FILTERED</span>: Exterior con filtro a m&aacute;s de 10 metros de altura. <img src="<?=base_url('/api/icon?state=fake&icon=EXTERIOR_HIGH_FILTERED')?>" /><br/>
			<span class="hw_fake_list_span">EXTERIOR_HIGH</span>: Exterior sin filtro a m&aacute;s de 10 metros de altura. <img src="<?=base_url('/api/icon?state=fake&icon=EXTERIOR_HIGH')?>" /><br/>
			<span class="hw_fake_list_span">EXTERIOR_GROUND</span>: Exterior a menos de 10 metros de altura. <img src="<?=base_url('/api/icon?state=fake&icon=EXTERIOR_GROUND')?>" /><br/>
			<span class="hw_fake_list_span">INST_TYPE_1</span>: Potencial Instalaci&oacute;n Tipo 1. <img src="<?=base_url('/api/icon?state=fake&icon=INST_TYPE_1')?>" /><br/>
			<span class="hw_fake_list_span">INST_TYPE_2</span>: Potencial Instalaci&oacute;n Tipo 2. <img src="<?=base_url('/api/icon?state=fake&icon=INST_TYPE_2')?>" /><br/>
			<span class="hw_fake_list_span">MONITORING_CENTRAL</span>: Central de Monitoreo. <img src="<?=base_url('/api/icon?state=fake&icon=MONITORING_CENTRAL')?>" /><br/><br/>
		</p>
		
		<div id="macs_import_result_box"></div>
		<form class="ajax-form" id="hwfake_import_form" action="<?=base_url('/macs/upload')?>" method="post" enctype="multipart/form-data">
			<input id="fileupload" class="hidden" type="file" name="files[]" value="" />
			
			<button id="file_select" class="submit_btn" value="submit"><span>Elegir Archivo</span></button>
			
			<span id="form_file_selected">Selecciona un archivo</span>
			
			<div id="progress" class="progress" onclick="$('#fileupload').click()">
				<div class="progress-bar progress-bar-success"></div>
			</div>
		</form>
	</div>
</div>

<? if ( !isset( $hws ) ) { ?>
	<span id="macs_not_found">No se han encontrado íconos de MACs</span>
<? } ?>

<a id="add_new_but_bottom" href="<?=base_url('/macs/get_new_row')?>"><div class="table_after_right_clear_button">Nuevo Ícono de MAC</div></a>

</div>

<script type="text/javascript">
	var mac_icon_sel= null;
	var mac_icon_id	= null;
	
	function pin_select_close()
	{
		if ( null != mac_icon_id && null != mac_icon_sel )
		{
			$('#mac_icon_'+mac_icon_id).val( mac_icon_sel );
			
			mac_icon_id		= null;
			mac_icon_sel	= null;
		}
	}
	
	function pin_open_select( id, opts )
	{
		var settings = { width: 250, extraClass: 'pin_select_dialog' };
		
		mac_icon		= $('#mac_icon_'+id);
		mac_icon_id		= id;
		mac_icon_sel	= mac_icon.val();
		
		if ( typeof opts != 'undefined' )
		{
			jQuery.extend( settings, opts );
		}
		
		modal_dialog_inline( '#mac_pin_select_' + id, settings );
		
		return false;
	}
	
	function pin_select_for( id )
	{
		var sel = $( '#mac_icon_img_' + id );
		var val = $( '#mac_icon_' + id ).val();
		
		sel.attr('src', page_url + 'assets/pin/' + val + '.png' );
		
		mac_icon_id		= null;
		mac_icon_sel	= null;
		
		modal_dialog_close();
		
		return false;
	}
	
	function file_select_click( el )
	{
		var fu = $('#fileupload');
		
		fu.click();
	}
	
	function show_macs_import_click( el )
	{
		modal_dialog_inline( $('#macs_import_box'), { width: '800px', extraClass: 'upload_modal' } );
	}
	
	function row_new_add_click( el )
	{
		$('#macs_not_found').hide();
		
		if ( $('#row_new').length == 0 )
		{
			kajax_eval( 
				el.attr('href'), 
				null, 
				function()
				{
					table_row_new_register( $('#row_new'), $('#row_hidden_new'), $('#content'), $('#table-form') );
				}
			);
		}
	}
	
	function file_uploaded( e, data )
	{
		$.each(data.result.files, function (index, file)
		{
			if ( 'error' in file )
			{
				$('#progress').addClass( 'incomplete' );
				$('#macs_import_result_box').html( file['error'] );
			}
			else
			{
				$('#macs_import_result_box').html( file['result'] );
			}
		});
	}
	
	$(function()
	{
		panel_register( $('#panel_macs_filters') );
		
		table_register( $('#table-form') );
		
		table_header_fixed_register();
		
		kajax_bind_click( $('#add_new_but'), row_new_add_click );
		kajax_bind_click( $('#add_new_but_bottom'), row_new_add_click );
		kajax_bind_click( $('#macs_import_show'), show_macs_import_click );
		kajax_bind_click( $('#file_select'), file_select_click );
		
		$("#fileupload").change(function()
		{
			$('#form_file_selected').text( $("#fileupload").val().replace(/^.*(\\|\/|\:)/, '') );
		});
		
		file_upload_init( $('#fileupload'), $('#hwfake_import_form').attr('action'), file_uploaded );
	})
</script>
