<?php
$sel = 'selected="selected"';
$list_coms = ( User()->is_logged_as_god() && isset( $all_com ) && !empty( $all_com ) );

function key_build_link( $order_by )
{
	return base_url( '/keychain/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="panel_box panel_box_left_top" id="panel_keychain_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				<input class="panel_text_input panel_search_hw_input" type="text" name="key_id" placeholder="Filtrar por ID de Llavero" value="<?=$key_id?>">
				<input class="panel_text_input panel_search_hw_input" type="text" name="key_owner_lastname" placeholder="Filtrar por Apellido de Abonado"  value="<?=$key_owner_lastname?>">
				<input class="panel_text_input panel_search_hw_input" type="text" name="key_group" placeholder="Filtrar por Grupo" value="<?=$key_group?>">
				
				<button id="" class="submit_btn" value="submit"><span>Filtrar</span></button>
			</form>

			<div class="panel_hw_hsep"></div>
			
			<div class="left" id="hw_list_count_total"><b><?=$total_hw?></b> LLaveros</div>
			
			<div id="hw_count_and_exports">
				<a target="_blank" class="left" href="<?=base_url('/keychain/export/csv/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_xls_button">XLS</div></a>
			</div>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

	<div class="resize_informer">
	
	<form id="table-form" action="<?=base_url('/keychain/update')?>" method="POST" style="display: none;"></form>
	
	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>
	
	<table id="keychain_list_table" class="default_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_id' )?>">ID</th>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_owner_lastname' )?>">Apellido</th>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_owner_name' )?>">Nombre</th>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_owner_dni' )?>">DNI</th>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_owner_phone' )?>">Teléfono</th>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_owner_cellphone' )?>">Celular</th>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_owner_mail' )?>">Mail</th>
				<th class="ajax-el-link" data-href="<?=key_build_link( 'key_group' )?>">Grupo</th>
			</tr>
		</thead>
		<tbody>

<? if ( isset( $keys ) ) { ?>
	<? foreach ( $keys as $key ) { ?>
			<tr id="row_<?=$key['key_uid']?>">
				<td class="greener">
					<input type="hidden" name="uid" value="<?=$key['key_uid']?>" />
					<input type="hidden" name="key_id" value="<?=$key['key_id']?>" />
					<input type="text" name="id" value="<?=dechex( $key['key_id'] )?>" disabled />
				</td>
				<td class="greener">
					<input type="text" name="owner_lastname" value="<?=$key['key_owner_lastname']?>" />
				</td>
				<td class="greener">
					<input type="text" name="owner_name" value="<?=$key['key_owner_name']?>" />
				</td>
				<td class="greener">
					<input type="text" name="owner_dni" value="<?=$key['key_owner_dni']?>" />
				</td>
				<td class="greener">
					<input type="text" name="owner_phone" value="<?=$key['key_owner_phone']?>" />
				</td>
				<td class="greener">
					<input type="text" name="owner_cellphone" value="<?=$key['key_owner_cellphone']?>" />
				</td>
				<td class="greener">
					<input type="text" name="owner_mail" value="<?=$key['key_owner_mail']?>" />
				</td>
				<td class="greener">
					<input type="text" name="group" value="<?=$key['key_group']?>" />
				</td>
			</tr>
			<tr class="hidden" id="row_extra_<?=$key['key_uid']?>">
				<? if ( $list_coms ) { ?>
				<td colspan="3">
				</td>
				<td class="<?=$list_coms?'greener':''?>">
					<? if ( User()->is_logged_as_god() && isset( $all_com ) && !empty( $all_com ) ) { ?>
						<span class="box">Empresa</span>
						<select name="com_id">
							<? foreach ( $all_com as $com ) { ?>
							<option value="<?=$com->com_id?>" <?=$com->com_id==$key['key_company']?$sel:''?>><?=$com->com_name?></option>
							<? } ?>
						</select>
					<? } ?>
				</td>
				<? } else { ?>
				<td colspan="4">
				</td>
				<? } ?>
				<td class="greener">
					<span class="box">Teléfono Alt.</span>
					<input type="text" name="owner_phone_alt" value="<?=$key['key_owner_phone_alt']?>" />
				</td>
				<td colspan="3" class="greener">
					<span class="box">Observaciones</span>
					<input type="text" name="observations" value="<?=$key['key_observations']?>" />
				</td>
			</tr>
			<tr class="form_buttons hidden" id="row_hidden_<?=$key['key_uid']?>">
				<td colspan="8" align="center">
					<? if ( User()->is_logged_as_god_or_company() ) { ?>
					<button data-href="<?=base_url('/keychain/delete/'.$key['key_uid'])?>" class="submit_btn_table delete_btn" data-text="¿Seguro que quiere eliminar el llavero <?=dechex( $key['key_id'] )?>?"><span>Eliminar</span></button>
					<? } ?>
					<button onclick="keychain_template_modal_dialog(<?=$key['key_uid']?>)" class="submit_btn_table template_btn"><span>Plantilla</span></button>
					
					<button class="submit_btn_table cancel_btn" value="cancel"><span>Cancelar</span></button>
					
					<button class="submit_btn_table save_btn" value="submit"><span>Guardar</span></button>
				</td>
			</tr>
	<? } ?>
<? } ?>
		</tbody>
	</table>
	
	<?=$pagination?>
	
	</div>

<script type="text/javascript">
	var form_table	= null;
	var keychain_select_interval = null;
	var keychain_select_get_table = function()
	{
		$.ajax({
			url: '<?=base_url('/keychain/get_active_not_registered_table')?>',
			type: 'GET',
			success: function( resp )
			{
				var ksl = $('.keychain_select_list');
				
				if ( ksl.length > 0 )
				{
					ksl.html( resp );
					
					modal_dialog_update();
				}
				else
				{
					keychain_select_interval_close();
				}
			}
		});
	};
	
	function row_new_add_click( el )
	{
		if ( $('#row_new').length == 0 )
		{
			var url = el.attr('href') ? el.attr('href') : el.data('href');
			
			kajax_eval( 
				url, 
				null, 
				function()
				{
					table_row_new_register( [ $('#row_new'), $('#row_extra_new') ], $('#row_hidden_new'), $('#content'), $('#table-form') );
				}
			);
			
			keychain_select_interval_close();
			
			modal_dialog_close();
		}
	}
	
	function keychain_select_interval_close()
	{
		if ( null != keychain_select_interval )
		{
			clearInterval( keychain_select_interval );
			
			keychain_select_interval = null;
		}
	}
	
	function keychain_template_modal_dialog( uid )
	{
		var load_url = page_url + 'keychain/template/' + uid;
		
		modal_dialog_ajax_get( load_url, null, {
			width: '80%',
			extraClass: 'keychain_template_dialog', 
			onComplete:function()
			{
				kajax_on_loaded_event( $('.keychain_template_dialog'), load_url );
			}
		});
	}
	
	function keychain_select_dialog()
	{
		modal_dialog_ajax_get( page_url + 'keychain/select',null, {
			width: '80%',
			extraClass: 'keychain_dialog',
			onComplete: function()
			{
				keychain_select_interval_close();
				
				keychain_select_get_table();
				
				keychain_select_interval = setInterval( keychain_select_get_table, 5000 );
			},
			onClosed: function()
			{
				keychain_select_interval_close();
			}
		});
	}
	
	$(function()
	{
		panel_register( $('#panel_keychain_filters') );
		
		form_table	= $('#table-form');
		
		table_register( form_table );
		
		table_header_fixed_register();
		
		<? if ( isset( $focus ) ) { ?>
		$("#row_<?=$focus?> input[name='owner_lastname']").focus();
		<? } ?>
	})
</script>

<? if ( User()->is_logged_as_god_or_company() ) { ?>
<a id="add_new_but" href="#" onclick="keychain_select_dialog()"><div class="table_after_right_clear_button">Agregar Nuevo Llavero</div></a>
<? } ?>
