<?php
$sel = 'selected="selected"';
function hwf_build_link( $order_by )
{
	return base_url( '/hwfake/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<script type="text/javascript">
	function file_select_click( el )
	{
		$('#fileupload').click();
	}
	
	function show_hw_fake_import_click( el )
	{
		modal_dialog_inline( $('#hwfake_import_box'), { width: '800px', height: '510px', extraClass:'upload_modal' } );
	}
	
	function row_new_add_click( el )
	{
		$('#hw_not_found').hide();
		
		if ( $('#row_new').length == 0 )
		{
			kajax_eval( 
				el.attr('href'), 
				null, 
				function()
				{
					table_row_new_register( $('#row_new'), $('#row_hidden_new'), $('#content'), $('#table-form') );
				}
			);
		}
	}
	
	function file_uploaded( e, data )
	{
		$('#hwfake_import_box > img').hide();
		$('#hwfake_import_form').hide();
		$('#hwfake_import_result_box').show();
		
		$.each(data.result.files, function (index, file)
		{
			if ( 'error' in file )
			{
				$('#progress').addClass( 'incomplete' );
				$('#hwfake_import_result_box').html( file['error'] );
			}
			else
			{
				$('#hwfake_import_result_box').html( file['result'] );
			}
		});
	}
	
	$(function()
	{
		panel_register( $('#panel_hwf_filters') );
		
		kajax_bind_click( $('#add_new_but'), row_new_add_click );
		kajax_bind_click( $('#add_new_but_bottom'), row_new_add_click );
		kajax_bind_click( $('#hw_fake_import_show'), show_hw_fake_import_click );
		kajax_bind_click( $('#file_select'), file_select_click );
		
		$("#fileupload").change(function()
		{
			$('#form_file_selected').text( $("#fileupload").val().replace(/^.*(\\|\/|\:)/, '') );
		});
		
		file_upload_init( $('#fileupload'), $('#hwfake_import_form').attr('action'), file_uploaded );
	})
</script>

<div class="hidden">
	<div id="hwfake_import_box">
		<h4>Elegir Archivo CSV</h4>
		
		<img src="<?=base_url('/assets/images/csv_import_tuto.png')?>" />
		
		<div id="hwfake_import_result_box"></div>
		<form class="ajax-form" id="hwfake_import_form" action="<?=base_url('/hwfake/upload')?>" method="post" enctype="multipart/form-data">
			<input id="fileupload" class="hidden" type="file" name="files[]" value="" />
			
			<button id="file_select" class="submit_btn" value="submit"><span>Elegir Archivo</span></button>
			
			<span id="form_file_selected">Selecciona un archivo</span>
			
			<div id="progress" class="progress" onclick="$('#fileupload').click()">
				<div class="progress-bar progress-bar-success"></div>
			</div>
		</form>
	</div>
</div>

<div class="panel_box panel_box_left_top no_lock" id="panel_hwf_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				<? if ( !User()->is_logged_as_god_or_meta_company() ) { ?>
				<a id="add_new_but" href="<?=base_url('/hwfake/get_new_row')?>"><div class="panel_left_but">Nueva Instalación Potencial</div></a>
				<a id="hw_fake_import_show" href="<?=base_url('/hwfake/import')?>"><div class="panel_left_but" style="margin-bottom: 12px">Importar Nuevas Instalaciones</div></a>
				<? } ?>
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="hwf_code" placeholder="Filtrar por Nº de Abonado" value="<?=$hwf_code?>">
				<input class="panel_text_input panel_search_hw_input" type="text" name="hwf_name" placeholder="Filtrar por Nombre de Abonado"  value="<?=$hwf_name?>">
				<input class="panel_text_input panel_search_hw_input" type="text" name="hwf_address" placeholder="Filtrar por Dirección de Abonado"  value="<?=$hwf_address?>">
				
				<button id="" class="submit_btn" value="submit"><span>Filtrar</span></button>
				
				<div class="panel_hw_hsep"></div>
				
				<div class="left" id="hw_list_count_total"><b><?=$total_hw?></b> Abonados Potenciales</div>
			</form>	
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

	<div class="resize_informer">
	
	<form id="table-form" action="<?=base_url('/hwfake/update')?>" method="POST" style="display: none;"></form>
	
	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>
	
	<table id="hwf_list_table" class="default_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="ajax-el-link" data-href="<?=hwf_build_link( 'hwf_code' )?>">Número</th>
				<th class="ajax-el-link" data-href="<?=hwf_build_link( 'hwf_name' )?>">Nombre</th>
				<th>Latitud</th>
				<th>Longitud</th>
				<th>Dirección</th>
				<th class="icon_th">TI</th>
				<th class="icon_color">Color</th>
			</tr>
		</thead>
		<tbody>
<? if ( isset( $hws ) ) { ?>
	<? foreach ( $hws as $hw ) { ?>
			<tr id="row_<?=$hw['hwf_id']?>">
				<td class="greener">
					<input type="hidden" name="hwf_id" value="<?=$hw['hwf_id']?>" />
					<input type="text" name="code" value="<?=dechex( $hw['hwf_code'] )?>" />
				</td>
				<td class="greener">
					<input type="text" name="name" value="<?=$hw['hwf_name']?>" />
				</td>
				<td class="greener">
					<input type="text" name="lat" value="<?=$hw['hwf_lat']?>" />
				</td>
				<td class="greener">
					<input type="text" name="long" value="<?=$hw['hwf_long']?>" />
				</td>
				<td class="greener">
					<input type="text" name="address" value="<?=$hw['hwf_address']?>" />
				</td>
				<td class="icons greener" align="center">
					<div style="display:none">
						<div class="hwf_pin_select" id="hwf_pin_select_<?=$hw['hwf_id']?>">
							<select class="icons" id="hwf_icon_<?=$hw['hwf_id']?>" name="icon">
								<? $icons = get_icons_array(); foreach ( $icons as $name=>$key ) { ?>
								
								<option value="<?=$key?>" <?=$key==$hw['hwf_icon']?$sel:''?>><?=$name?></option>
								<?	} ?>
							</select>
							
							<div class="submit_btn pin_select" onclick="return pin_select_for( '<?=$hw['hwf_id']?>' )">Seleccionar</div>
						</div>
					</div>
					<img id="hwf_icon_img_<?=$hw['hwf_id']?>" class="hw_icon_img" src="<?=base_url('/assets/pin/'.$hw['hwf_icon'])?>.png" onclick="return pin_open_select( '<?=$hw['hwf_id']?>', { onClosed: function() { pin_select_close(); } } )" />
				</td>
				<td class="greener">
					<input type="hidden" value="<?=$hw['hwf_type']?>" id="row_color_type_<?=$hw['hwf_id']?>" name="type" />
					<? $col = ( 0 == $hw['hwf_type'] ) ? 'blue' : 'purple'; ?>
					<div id="fake_hw_color_selector_<?=$hw['hwf_id']?>" class="center fake_hw_<?=$col?>_box" onclick="return fake_hw_toggle_box(<?=$hw['hwf_id']?>);"></div>
				</td>
			</tr>
			<tr class="form_buttons hidden" id="row_hidden_<?=$hw['hwf_id']?>">
				<td colspan="7" align="center">
					<button data-href="<?=base_url('/hwfake/delete/'.$hw['hwf_id'].'/'.dechex( $hw['hwf_code'] ))?>" class="submit_btn_table delete_btn" data-text="¿Seguro que quiere eliminar esta instalación potencial?"><span>Eliminar</span></button>
					<button class="submit_btn_table cancel_btn" value="cancel"><span>Cancelar</span></button>
					<button class="submit_btn_table save_btn" value="submit"><span>Guardar</span></button>
				</td>
			</tr>
	<? } ?>
<? } ?>
		</tbody>
	</table>
	
	<?=$pagination?>
	
	</div>
	
	<script type="text/javascript">
		var form_table	= null;
		var hwf_icon_sel= null;
		var hwf_icon_id	= null;
		
		function fake_hw_toggle_box( row_id )
		{
			var box = $('#fake_hw_color_selector_'+row_id);
			
			if ( box.hasClass( 'fake_hw_blue_box' ) )
			{
				box.removeClass('fake_hw_blue_box');
				box.addClass('fake_hw_purple_box');
				$('#row_color_type_'+row_id).val( '1' );
			}
			else
			{
				box.removeClass('fake_hw_purple_box');
				box.addClass('fake_hw_blue_box');
				$('#row_color_type_'+row_id).val( '0' );
			}
		}
		
		function pin_select_close()
		{
			if ( null != hwf_icon_id && null != hwf_icon_sel )
			{
				$('#hwf_icon_'+hwf_icon_id).val( hwf_icon_sel );
				
				hwf_icon_id		= null;
				hwf_icon_sel	= null;
			}
		}
		
		function pin_open_select( id, opts )
		{
			var settings = { width: 250, extraClass: 'pin_select_dialog' };
			
			hwf_icon		= $('#hwf_icon_'+id);
			hwf_icon_id		= id;
			hwf_icon_sel	= hwf_icon.val();
			
			if ( typeof opts != 'undefined' )
			{
				jQuery.extend( settings, opts );
			}
			
			modal_dialog_inline( $('#hwf_pin_select_' + id), settings );
			
			return false;
		}
		
		function pin_select_for( id )
		{
			var sel = $( '#hwf_icon_img_' + id );
			var val = $( '#hwf_icon_' + id ).val();
			
			sel.attr('src', page_url + 'assets/pin/' + val + '.png' );
			
			hwf_icon_id		= null;
			hwf_icon_sel	= null;
			
			modal_dialog_close();
			
			return false;
		}
		
		function table_row_new_fix_current( id )
		{
			var row_new		= $('#row_new');
			var row			= ( row_new.length > 0 ) ? row_new : $('#row_'+id);
			
			var t = $('#hwf_icon_img_'+id, row);
			t.attr('onclick','');
			t.unbind('click');
			t.bind('click', 
				function()
				{
					return pin_open_select( id, { onClosed: function() { pin_select_close(); } } );
				}
			);
			
			t = $('#fake_hw_color_selector_' + id, row );
			t.attr('onclick','');
			t.unbind('click');
			t.bind('click', 
				function()
				{
					return fake_hw_toggle_box( id );
				}
			);
			
			t = $('.pin_select', row);
			t.attr('onclick','');
			t.unbind('click');
			t.bind('click',
				function()
				{
					return pin_select_for( id );
				}
			)
		}

		$(function()
		{
			table_register( $('#table-form') );
			
			table_header_fixed_register();
		})
	</script>

<? if ( !isset( $hws ) ) { ?>
	<span id="hw_not_found">No se han encontrado abonados</span>
<? } ?>

<? if ( !User()->is_logged_as_god_or_meta_company() ) { ?>
<a id="add_new_but_bottom" href="<?=base_url('/hwfake/get_new_row')?>"><div class="table_after_right_clear_button">Nueva Instalación Potencial</div></a>
<? } ?>