<?php
$sel = 'selected="selected"';
function hw_build_link( $order_by )
{
	return base_url( '/hw/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="panel_box panel_box_left_top" id="panel_hw_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				<div class="panel_hw_black_box">
					<span class="custom-checkbox ckx-right"><input type="checkbox" id="hw_active" name="hw_active" <?=$hw_active!=NULL?'checked':''?>><label for="hw_active">Abonados Activos</label></span>
					<div style="clear:both"></div>
					<span class="custom-checkbox ckx-right"><input type="checkbox" id="hw_inactive" name="hw_inactive" <?=$hw_inactive!=NULL?'checked':''?>><label for="hw_inactive">Abonados Inactivos</label></span>
				</div>

				<input class="panel_text_input panel_search_hw_input" type="text" name="hw_code" placeholder="Filtrar por Nº de Abonado" value="<?=$hw_code?>">
				<input class="panel_text_input panel_search_hw_input" type="text" name="hw_serial" placeholder="Filtrar por Nº de MAC" value="<?=$hw_serial?>">
				<input class="panel_text_input panel_search_hw_input" type="text" name="hw_name" placeholder="Filtrar por Nombre de Abonado"  value="<?=$hw_name?>">
				
				<? include('group_filter.php') ?>

				<button id="" class="submit_btn" value="submit"><span>Filtrar</span></button>

				<div class="panel_hw_hsep"></div>
				
				<div class="left" id="hw_list_count_total"><b><?=$total_hw?></b> Abonados</div>
				
				<div id="hw_count_and_exports">
					<a target="_blank" class="left" href="<?=base_url('/hw/export/csv/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_xls_button">XLS</div></a>
					<a target="_blank" class="left" href="<?=base_url('/hw/export/pdf/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_pdf_button">PDF</div></a>
				</div>
				
				<div class="panel_hw_hsep"></div>
				
				<? if ( User()->is_logged_as_company() ) { ?>
				
				<div id="hw_list_helpers" class="left clear">
					<a href="<?=base_url('/hw/groups')?>" class="ajax-link"><div id="hw_groups_icon">Grupo de Abonados</div></a>
				</div>
				
				<? } ?>
				
				<div id="hw_list_helpers" class="left clear">
					<a href="<?=base_url('/hw/inst_history')?>" class="ajax-link"><div id="hw_inst_history_icon">Historial de Instalaciones</div></a>
				</div>
				
				<div id="hw_list_helpers" class="left clear">
					<a href="<?=base_url('/hw/tmp_hw')?>" class="ajax-link"><div id="hw_inst_history_icon">Equipos en Proceso de Instalación</div></a>
				</div>
			</form>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<? if ( isset( $hws ) ) { ?>
	<div class="resize_informer">
	
	<form id="table-form" action="<?=base_url('/hw/update')?>" method="POST" style="display: none;"></form>
	
	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>
	
	<table id="hw_list_table" class="default_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="ajax-el-link" data-href="<?=hw_build_link( 'hw_code' )?>">Número</th>
				<th class="ajax-el-link" data-href="<?=hw_build_link( 'hw_serial' )?>">MAC</th>
				<th class="ajax-el-link" data-href="<?=hw_build_link( 'hw_name' )?>">Nombre</th>
				<th title="Tests en la Última Hora">TUH</th>
				<th class="ajax-el-link" data-href="<?=hw_build_link( 'hw_inst_time' )?>" title="Último Encendido">UE</th>
				<th>Latitud</th>
				<th>Longitud</th>
				<th>Dirección</th>
				<th class="ajax-el-link" data-href="<?=hw_build_link( 'hw_state' )?>">Estado</th>
				<th class="icon_th" title="Tipo de Ícono">TI</th>
				<th class="icon_user"><div class="sprite-img-icon-usuario"></div></th>
			</tr>
		</thead>
		<tbody>
	<? foreach ( $hws as $hw ) {
			$signal_filtered	= '-';
			
			if( $hw['hw_setup_signal_filtered'] != NULL )
			{
				$sn					= 0 != intval( $hw['hw_setup_signal_total_xbee'] ) ? round( 100 * $hw['hw_setup_signal_filtered'] / $hw['hw_setup_signal_total_xbee'] ) : 0;
				$signal_filtered	= min($sn,100).'%';
			}
?>
			<tr id="row_<?=$hw['hw_id']?>">
				<td>
					<input type="hidden" name="hw_id" value="<?=$hw['hw_id']?>" /><?=dechex( $hw['hw_code'] )?>
				</td>
				<td>
					<?=dechex( $hw['hw_serial'] )?>
				</td>
				<td class="greener">
					<input type="text" name="name" value="<?=$hw['hw_name']?>" />
				</td>
				<td>
					<?=isset( $hw['tl_tests_count'] ) ? $hw['tl_tests_count'] : '-'?>
				</td>
				<td style="cursor:pointer;" onclick="setup_signal_history_modal(<?=$hw['hw_id']?>)">
					<?=isset( $hw['hw_inst_time'] ) ? datetime_noms( $hw['hw_inst_time'] ) : '-'?>
				</td>
				<td class="greener">
					<input type="text" name="lat" value="<?=$hw['hw_lat']?>" />
				</td>
				<td class="greener">
					<input type="text" name="long" value="<?=$hw['hw_long']?>" />
				</td>
				<td class="greener">
					<input type="text" name="address" value="<?=$hw['hw_address']?>" />
				</td>
				<td class="greener">
					<select name="state">
						<option value="ACTIVE" <?=$hw['hw_state']=='ACTIVE'?$sel:''?>>Activo</option>
						<option value="INACTIVE" <?=$hw['hw_state']=='INACTIVE'?$sel:''?>>Inactivo</option>
					</select>
				</td>
				<td class="greener icons" align="center">
					<div style="display:none">
						<div class="hw_pin_select" id="hw_pin_select_<?=$hw['hw_id']?>">
							<select class="icons" id="hw_icon_<?=$hw['hw_id']?>" name="icon">
								<? $icons = get_icons_array(); foreach ( $icons as $name=>$key ) { ?>
								
								<option value="<?=$key?>" <?=$key==$hw['hw_icon']?$sel:''?>><?=$name?></option>
								<?	} ?>
							</select>
							
							<div class="submit_btn" onclick="return pin_select_for( '<?=$hw['hw_id']?>' )">Seleccionar</div>
						</div>
					</div>
					<img id="hw_icon_img_<?=$hw['hw_id']?>" src="<?=base_url('/assets/pin/'.$hw['hw_icon'])?>.png" class="hw_icon_img" title="<?=get_icon_name($hw['hw_icon'])?>" onclick="return pin_open_select( '<?=$hw['hw_id']?>', { onClosed: function() { pin_select_close(); } } )" />
				</td>
				<td class="greener">
					<input type="text" readonly class="user_info_name" id="ui_lastname_<?=$hw['hw_id']?>" name="ui_lastname" value="<?=isset( $hw['ui_lastname'] ) ? ( $hw['ui_lastname'] . ' ' . $hw['ui_name'] ) : ''?>" />
					<input type="hidden" name="code" value="<?=dechex( $hw['hw_code'] )?>" />
					<input type="hidden" id="user_id_<?=$hw['hw_id']?>" name="user_id" value="<?=isset( $hw['uid'] ) ? $hw['uid'] : ''?>" />
					<input type="hidden" id="user_info_id_<?=$hw['hw_id']?>" name="user_info_id" value="<?=isset( $hw['ui_id'] ) ? $hw['ui_id'] : ''?>" />
					<input type="hidden" id="old_user_info_id_<?=$hw['hw_id']?>" name="old_user_info_id" value="<?=isset( $hw['ui_id'] ) ? $hw['ui_id'] : ''?>" />
				</td>
			</tr>
			<tr class="form_buttons hidden" id="row_hidden_<?=$hw['hw_id']?>">
				<td colspan="13" align="center">
					<? if ( 'INACTIVE' == $hw['hw_state'] ) { ?>
					<button data-href="<?=base_url( '/hw/delete/' . $hw['hw_id'] )?>" data-text="¿Está seguro que desea eliminar el abonado <?=dechex( $hw['hw_code'] )?>?" class="submit_btn_table delete_btn" value="delete"><span>Eliminar</span></button>
					<? } ?>
					<button class="submit_btn_table cancel_btn" value="cancel"><span>Cancelar</span></button>
					<button class="submit_btn_table save_btn" value="submit"><span>Guardar</span></button>
					<button class="submit_btn_table view_btn" value="view" data-href="<?=base_url( '/hw/view/' . $hw['hw_id'] )?>"><span>Ver</span></button>
					<button class="submit_btn_table modal_ajax_btn" value="groups" data-href="<?=base_url( '/hw/groups_show/' . $hw['hw_id'] )?>" data-options='{"extraClass":"modal_dialog_fancy", "width":"60%"}'><span>Grupos</span></button>
				</td>
			</tr>
	<? } ?>
		
		</tbody>
	</table>
	
	<?=$pagination?>
	
	</div>
	
	<script type="text/javascript">
		var form_table	= null;
		var hw_icon_sel	= null;
		var hw_icon_id	= null;
		
		function setup_signal_history_modal( hw_id )
		{
			modal_dialog_ajax_get( '<?=base_url('/hw/setup_signal_history').'/'?>' + hw_id, null, {
				extraClass: 'modal_dialog_fancy signal_history_modal',
				width: '80%',
				height: '60%'
			});
		}
		
		function pin_select_close()
		{
			if ( null != hw_icon_id && null != hw_icon_sel )
			{
				$('#hw_icon_'+hw_icon_id).val( hw_icon_sel );
				
				hw_icon_id	= null;
				hw_icon_sel	= null;
			}
		}
		
		function pin_open_select( id, opts )
		{
			var settings = { width: 250, extraClass: 'pin_select_dialog' };
			
			hw_icon		= $('#hw_icon_'+id);
			hw_icon_id	= id;
			hw_icon_sel = hw_icon.val();
			
			if ( typeof opts != 'undefined' )
			{
				jQuery.extend( settings, opts );
			}
			
			modal_dialog_inline( $('#hw_pin_select_' + id), settings );
			
			return false;
		}
		
		function pin_select_for( id )
		{
			var sel = $( '#hw_icon_img_' + id );
			var val = $( '#hw_icon_' + id ).val();
			
			sel.attr('src', page_url + 'assets/pin/' + val + '.png' );
			
			modal_dialog_close();
			
			hw_icon_id	= null;
			hw_icon_sel	= null;
			
			return false;
		}
		
		function user_search_select( row_id, ui_id, uid, ui_fullname )
		{
			$('#user_info_id_'+row_id).val( ui_id );
			$('#user_id_'+row_id).val( uid );
			$('#ui_lastname_'+row_id).val( ui_fullname );
			
			modal_dialog_close();
		}
		
		$(function()
		{
			panel_register( $('#panel_hw_filters') );
			
			form_table	= $('#table-form');
			
			table_register( form_table );
			
			$('.user_info_name').each(
				function()
				{
					var t			= $(this);
					var row_id		= t.parent().parent().attr('id').substr(4);
					var load_url	= "<?=base_url('/users/search/?unselect_but=1&cb=user_search_select&row_id=')?>" + row_id;
					client_search_button_register( t, load_url );
				}
			);
			
			dropdown_filter_register();
			
			table_header_fixed_register();
		})
	</script>
<? } else { ?>
	<span>No se han encontrado abonados</span>
<? } ?>
