<?php
function inst_build_link( $order_by )
{
	return base_url( '/hw/inst_history/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}

if ( isset($setups) ) { ?>

<div class="resize_informer">

<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>

<table class="default_table">
	<thead>
		<tr>
			<th class="ajax-el-link" data-href="<?=inst_build_link( 'hwsh_hw_code' )?>">Número</th>
			<th class="ajax-el-link" data-href="<?=inst_build_link( 'hwsh_hw_serial' )?>">MAC</th>
			<th class="ajax-el-link" data-href="<?=inst_build_link( 'hwsh_inst_time' )?>">Fecha de Instalación</th>
			<th>Paquetes Recibidos</th>
			<th>Paquetes Recibidos (sin repetir)</th>
			<th>Calidad de Señal</th>
		</tr>
	</thead>
	<tbody>

	<? foreach( $setups as $setup ) { ?>
		<tr>
			<? if ( isset( $setup['hw_id'] ) ) { ?>
			<td class="ajax-el-link" data-href="<?=base_url('/hw/view/'.$setup['hw_id'])?>"><?=dechex( $setup['hwsh_hw_code'] )?></td>
			<? } else { ?>
			<td><?=dechex( $setup['hwsh_hw_code'] )?></td>	
			<? } ?>
			<td><?=dechex( $setup['hwsh_hw_serial'] )?></td>
			<td><?=datetime_noms( $setup['hwsh_inst_time'] )?></td>
			<td><?=$setup['hwsh_signal']?></td>
			<td><?=$setup['hwsh_signal_filtered']?></td>
			<td><?=$setup['hwsh_signal_quality']?>%</td>
		</tr>
	<? } ?>
	</tbody>
</table>

<?=$pagination?>

<a class="ajax-link" href="<?=base_url('/hw/all')?>"><div class="table_after_right_button clear_right">Tabla de Abonados</div></a>

</div>

<script type="text/javascript">
	var _inst_history_interval = null;
	var _last_inst_id = null;
	
	$(function()
	{
		table_header_fixed_register();
		
		_inst_history_interval = setInterval(function()
		{
			$.get( page_url + 'hw/get_last_instalation_id', null, function(res)
			{
				if ( _last_inst_id == null || parseInt( _last_inst_id ) == 0 )
				{
					_last_inst_id = parseInt( res );
				}
				else
				{
					var _new_last_id = parseInt( res );
					
					if ( _last_inst_id != _new_last_id )
					{
						_last_inst_id = _new_last_id;
						
						kajax_reload_target();
					}
				}
			});
		}, 5000 );
		
		kajax_register_unload_callback(function()
		{
			if ( _inst_history_interval != null )
			{
				clearInterval( _inst_history_interval );
			}
			
			_inst_history_interval = null
			
			return true;
		});
	})
</script>

<? } else { ?>

<span>No se han encontrado instalaciones</span>

<? } ?>
