<?php
$sel = 'selected="selected"';
?>
<script type="text/javascript">	
	var vis_data	= null;
	var graph_data	= <?=json_encode($data)?>;
	var time_count	= 0;
	var ccol		= [];
	var chart		= null;
	
	function get_draw_opts()
	{
		var w = $(window).width()-100;
		var m_charArea = { left:100, top:10, width:w, height:content_get_visible_height() - 110 };
		var m_hAxis = { slantedText:true, maxAlternation:1 };
		var m_vAxis = { viewWindowMode: 'explicit' };
		return {
			width:w, height: content_get_visible_height() - 20,
			chartArea: m_charArea, hAxis: m_hAxis, vAxis: m_vAxis,
			fontSize: 12, legend:{position:'bottom',textStyle:{fontSize:11}},
			bar: { groupWidth: '75%' },
			colors: ['#DC3912','#FF9900','#FFAA00','#FFBB00','#FFCC00','#FFDD00','#FFEE00','#FFEA00','#FFFB00','#FFFC00','#FFFD00','#109618'],
	        isStacked: true
		};
	}
	
	function draw_data()
	{
		var view = new google.visualization.DataView(vis_data);
		chart.draw( view, get_draw_opts() );
	}
	
	function add_graph_data()
	{
		var last_id 	= null;
		var last_time	= null;
		var chart		= null;
		
		if ( null == graph_data )
			return;
		
		for ( var i = 0; i < graph_data.length; i++ )
		{
			var packet	= graph_data[i];
			
			last_time	= packet.tl_from_time;
			
			var date	= new Date( 1000 * packet.tl_from_time );
			var datestr	= zero_fill( date.getDate(), 2 ) + "/" + zero_fill( date.getMonth() + 1, 2 ) + " - " + zero_fill( date.getHours(), 2 ) + "hs";
			
			packet.dead_count = packet.total_count - packet.low_1_count - packet.low_2_count - packet.low_3_count - packet.low_4_count - packet.low_5_count - packet.low_6_count - packet.good_7_count - packet.good_8_count - packet.good_9_count - packet.good_10_count - packet.excellent_count;
			
			vis_data.setValue( i, 0, datestr );
			vis_data.setValue( i, 1, packet.dead_count );
			vis_data.setValue( i, 2, packet.low_1_count );
			vis_data.setValue( i, 3, packet.low_2_count );
			vis_data.setValue( i, 4, packet.low_3_count );
			vis_data.setValue( i, 5, packet.low_4_count );
			vis_data.setValue( i, 6, packet.low_5_count );
			vis_data.setValue( i, 7, packet.low_6_count );
			vis_data.setValue( i, 8, packet.good_7_count );
			vis_data.setValue( i, 9, packet.good_8_count );
			vis_data.setValue( i, 10, packet.good_9_count );
			vis_data.setValue( i, 11, packet.good_10_count );
			vis_data.setValue( i, 12, packet.excellent_count );
		}
	}
	
	function draw_chart()
	{
		chart			= new google.visualization.ColumnChart( document.getElementById('chart_div') );
		vis_data		= new google.visualization.DataTable();
		
		vis_data.addRows( null != graph_data ? graph_data.length : 0 );
		vis_data.addColumn( 'string', 'Fecha' );
		vis_data.addColumn( 'number', 'Nula' );
		vis_data.addColumn( 'number', 'Baja 1 Test' );
		vis_data.addColumn( 'number', 'Baja 2 Tests' );
		vis_data.addColumn( 'number', 'Baja 3 Tests' );
		vis_data.addColumn( 'number', 'Baja 4 Tests' );
		vis_data.addColumn( 'number', 'Baja 5 Tests' );
		vis_data.addColumn( 'number', 'Baja 6 Tests' );
		vis_data.addColumn( 'number', 'Buena 7 Tests' );
		vis_data.addColumn( 'number', 'Buena 8 Tests' );
		vis_data.addColumn( 'number', 'Buena 9 Tests' );
		vis_data.addColumn( 'number', 'Buena 10 Tests' );
		vis_data.addColumn( 'number', 'Óptima' );
		
		add_graph_data();
		
		draw_data();
	}

	$(function()
	{
		if ( 'undefined' == typeof google ) return;
		
		google.load("visualization", "1", {
			packages: ["corechart"],
			callback: draw_chart
		});
		
		var resize_cb_id = resize_callback_register(function()
		{
			draw_data();
		});
		
		datetime_picker_init( '#hasta', "<?=$date_str?>" );
		
		panel_register( $('#panel_graph_filters'), 'right' );
		
		dropdown_filter_register();
		
		kajax_register_unload_callback(function()
		{
			resize_callback_unregister( resize_cb_id );
			delete vis_data;
			delete graph_data;
			time_count	= 0;
			ccol		= [];
			delete chart;
			vis_data = graph_data = chart = null;
			return true;
		});
		
		panel_register( $('#panel_airmesh') );
		panel_register( $('#panel_gprs') );
	});
</script>

<div style="" id="chart_div"></div>

<?
include('panel_airmesh.php');
?>
<div class="panel_box panel_box_right_top" id="panel_graph_filters">
	<div class="panel_data_box_right">
    	<div class="panel_data_box_margined_right">
			<div id="filters_default">
				<form class="ajax-get-form" id="graph_filters">
					
					<? if ( User()->is_logged_as_god() ) { ?>
						<div class="custom-select">
							<select id="company" class="campos_graph" name="company">
								<option value="">Filtrar por Empresa</option>
							<?	if ( isset( $companies ) ) { foreach( $companies as $com ) { ?>
								<option value="<?=$com->com_id?>" <?=isset($company)&&$company==$com->com_id?$sel:''?>><?=$com->com_name?></option>
							<?	} } ?>
							</select>
						</div>
						
						<span class="seleccion">
							Seleccionar:
							<a href="#" onclick="graph_select_all()">todo</a> |
							<a href="#" onclick="graph_unselect_all()">nada</a> |
							<a href="#" onclick="graph_invert_all()">invertir</a>
						</span>
					<? } ?>
					
					<? include('group_filter.php') ?>
					 
					<input class="campos_graph fecha" name="gtodate" id="hasta" type="text" value="<?=$date_str?>" readonly style="cursor:pointer" />
					<div class="custom-select">
						<select class="campos_graph" name = "ghours">
							<option value="1" <?=(1==$hours)?$sel:''?>>1hs</option>
							<option value="2" <?=(2==$hours)?$sel:''?>>2hs</option>
							<option value="3" <?=(3==$hours)?$sel:''?>>3hs</option>
							<option value="6" <?=(6==$hours)?$sel:''?>>6hs</option>
							<option value="12" <?=(12==$hours)?$sel:''?>>12hs</option>
							<option value="24" <?=(24==$hours)?$sel:''?>>24hs</option>
							<option value="48" <?=(48==$hours)?$sel:''?>>48hs</option>
							<option value="72" <?=(72==$hours)?$sel:''?>>72hs</option>
						</select>
					</div>
					<input type="hidden" name="map_ignore_hours" value="1" />
					
					<button id="filterButton" class="submit_btn" type="submit" value="submit"><span>Filtrar</span></button>
					
					<button id="export_form" class="submit_btn" type="button" value="submit"><span>Exportar</span></button>
				</form>
			</div>
		</div>
	</div>
	
	<div class="panel_hide_box_right">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>
