<?php
$sel = 'selected="selected"';
?>
<script type="text/javascript">
	var vis_data		= null;
	var graph_data		= <?=json_encode($data)?>;
	var hours_to_show	= <?=$hours?>*12;
	var chart			= null;
	var time_count		= 0;
	var ccol			= [];
	var tcol			= [];

	function get_day( day_num )
	{
		switch ( day_num )
		{
			case 0: return 'Domingo';
			case 1: return 'Lunes';
			case 2: return 'Martes';
			case 3: return 'Miércoles';
			case 4: return 'Jueves';
			case 5: return 'Viernes';
			case 6: return 'Sábado';
		}
	}
	
	function get_draw_opts()
	{
		var w = $(window).width()-100;
		var m_charArea = { left:100, top:10, width:w, height:content_get_visible_height() - 110 };
		var m_hAxis = { slantedText:true, maxAlternation:1 };
		var m_vAxis = { viewWindowMode: 'explicit' };
		return {
			width:w, height: content_get_visible_height() - 20, title: 'Período: ' + <?=$hours?> + ' horas',
			chartArea: m_charArea, 
			hAxis: m_hAxis, 
			vAxis: m_vAxis,
			fontSize: 12,
			legend:
			{
				position:'bottom',
				textStyle:
				{
					fontSize:11
				}
			},
			tooltip: { 
				isHtml: true 
			}
		};
	}
	
	function draw_data()
	{
		var view = new google.visualization.DataView(vis_data);
		chart.draw( view, get_draw_opts() );
	}
	
	function add_rows()
	{
		if ( null == graph_data )
		{
			return;
		}
		
		for ( var i = 0; i < graph_data.length; i++ )
		{
			var key = graph_data[i].serial;
			
			if ( 'undefined' == typeof ccol[ key ] )
			{
				var index = vis_data.addColumn('number', key );
				
				ccol[ key ]			= index;
				
				var index_tooltip	= vis_data.addColumn({type: 'string', role: 'tooltip', p: {html:true}});
				var key_tooltip		= ( graph_data[i].serial + '_tooltip' ).hashCode();
				tcol[ index ]		= index_tooltip;
			}
		}
	}
	
	function get_count_time()
	{
		var last_time	= null;
		var chart		= null;
		var count		= 0;
		
		if ( null == graph_data )
			return 0;
		
		for ( var i = 0; i < graph_data.length; i++ )
		{
			var packet	= graph_data[i];
			
			if ( last_time != packet.timestamp )
			{
				last_time	= packet.timestamp;
				count++;
			}
		}
		
		return count;
	}
	
	function add_graph_data()
	{
		var last_id 	= null;
		var last_time	= null;
		var chart		= null;
		
		if ( null == graph_data )
			return;
		
		for ( var i = 0; i < graph_data.length; i++ )
		{
			var packet	= graph_data[i];
			var date	= new Date( 1000 * packet.timestamp );
			var datestr	= zero_fill( date.getHours(), 2 ) + ":" + zero_fill( date.getMinutes(), 2 ) + "hs";
			
			if ( last_time != packet.timestamp )
			{
				last_time	= packet.timestamp;
				
				vis_data.setValue( time_count, 0, datestr );
				
				time_count++;
			}
			
			var key = packet.serial;
			var pos	= ccol[ key ];
			
			if ( 'undefined' != typeof pos )
			{
				vis_data.setValue( time_count - 1, pos, packet.repeated );
				
				var tooltip	= '<div style="padding: 8px">';
				tooltip		+= '<b>' + zero_fill( date.getHours(), 2 ) + ":" + zero_fill( date.getMinutes(), 2 ) + "hs" + '</b><br/>';
				tooltip		+= get_day( date.getDay() ) + " - " + date.getFullYear() + "-" + zero_fill( date.getMonth() + 1, 2 ) + "-" + zero_fill( date.getDate(), 2 );
				tooltip		+= '<br/>';
				tooltip		+= packet.serial.toString(16) + ': <b>' + packet.repeated + '</b>';
				tooltip		+= '</div>';
				
				vis_data.setValue( time_count - 1, tcol[ pos ], tooltip );
			}
		}
	}
	
	function draw_chart()
	{
		chart			= new google.visualization.LineChart( document.getElementById('chart_div') );
		vis_data		= new google.visualization.DataTable();
		
		vis_data.addRows( get_count_time() );
		vis_data.addColumn( 'string', 'Rango Horario' );
		
		add_rows();
		
		add_graph_data();
		
		draw_data();
	}
	
	$(function()
	{
		if ( 'undefined' == typeof google ) return;
		
		google.load("visualization", "1", {
			packages: ["corechart"],
			callback: draw_chart
		});
		
		var resize_cb_id = resize_callback_register(function()
		{
			draw_data();
		});
		
		datetime_picker_init( '#hasta', "<?=$date_str?>" );
		
		panel_register( $('#panel_graph_filters'), 'right' );
		
		dropdown_filter_register();
		
		kajax_register_unload_callback(function()
		{
			resize_callback_unregister( resize_cb_id );
			delete vis_data;
			delete graph_data;
			hours_to_show	= null;
			final_datetime	= null;
			delete chart;
			vis_data = graph_data = chart = null;
			time_count	= 0;
			ccol =	tcol	= []
			return true;
		});
		
		panel_register( $('#panel_airmesh') );
		panel_register( $('#panel_gprs') );
		
		$('#export_form').unbind('click').bind('click', function()
		{
			var url = kajax_get_form_url($('#graph_filters'), '<?=base_url('/hw/repeated_export')?>' );
			
			window.open( url );
		});
	});
</script>

<div id="chart_div"></div>

<?
include('panel_airmesh.php');
?>

<div class="panel_box panel_box_right_top" id="panel_graph_filters">
	<div class="panel_data_box_right">
		<div class="panel_data_box_margined_right">
			<? include('hw_icon_panel.php' ) ?>
			
			<div id="filters_default">
				<form class="ajax-get-form" id="graph_filters">
					
					<? if ( User()->is_logged_as_god() ) { ?>
						<div class="custom-select">
						<select id="company" class="campos_graph" name="company">
							<option value="">Filtrar por Empresa</option>
						<?	if ( isset( $companies ) ) { foreach( $companies as $com ) { ?>
							<option value="<?=$com->com_id?>" <?=isset($company)&&$company==$com->com_id?$sel:''?>><?=$com->com_name?></option>
						<?	} } ?>
						</select>
						</div>
						<span class="seleccion">
							Seleccionar:
							<a href="#" onclick="graph_select_all()">todo</a> |
							<a href="#" onclick="graph_unselect_all()">nada</a> |
							<a href="#" onclick="graph_invert_all()">invertir</a>
						</span>
					<? } ?>
					
					<? include('group_filter.php') ?>
					
					<input class="campos_graph fecha" name="gtodate" id="hasta" type="text" value="<?=$date_str?>" readonly style="cursor:pointer" />
					<div class="custom-select">
						<select class="campos_graph" name = "ghours">
							<option value="1" <?=(1==$hours)?$sel:''?>>1hs</option>
							<option value="2" <?=(2==$hours)?$sel:''?>>2hs</option>
							<option value="3" <?=(3==$hours)?$sel:''?>>3hs</option>
							<option value="6" <?=(6==$hours)?$sel:''?>>6hs</option>
							<option value="12" <?=(12==$hours)?$sel:''?>>12hs</option>
							<option value="24" <?=(24==$hours)?$sel:''?>>24hs</option>
							<option value="48" <?=(48==$hours)?$sel:''?>>48hs</option>
							<option value="72" <?=(72==$hours)?$sel:''?>>72hs</option>
						</select>
					</div>
					<input type="hidden" name="map_ignore_hours" value="1" />
					
					<button id="filterButton" class="submit_btn" type="submit" value="submit"><span>Filtrar</span></button>
					
					<button id="export_form" class="submit_btn" type="button" value="submit"><span>Exportar</span></button>
				</form>
			</div>
		</div>
	</div>
	
	<div class="panel_hide_box_right">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>
