<?php
$sel = 'selected="selected"';
?>
<script type="text/javascript">
	var vis_data	= null;
	var graph_data	= <?=json_encode($data)?>;
	var rows		= <?=json_encode($rows_filtered)?>;
	var time_count	= 0;
	var ccol		= [];
	var tcol		= [];
	var chart		= null;
	var columns		= [];
	var series		= {};
	var chart_mod	= false;
	
	function add_rows()
	{
		rows.push({ 
			com_id: '0',
			com_name: 'Total'
		});
		
		for ( var i = 0; i < rows.length; i++ )
		{
			var index = vis_data.addColumn('number', rows[i].com_name );
			
			var key = rows[i].com_name.hashCode();
			
			ccol[ key ] = index;
			
			var index_tooltip	= vis_data.addColumn({type: 'string', role: 'tooltip', p: {html:true}});
			var key_tooltip		= ( rows[i].com_name + '_tooltip' ).hashCode();
			tcol[ index ]		= index_tooltip;
		}
	}
	
	function get_month( month )
	{
		switch ( month )
		{
			case 0: return 'Enero';
			case 1: return 'Febrero';
			case 2: return 'Marzo';
			case 3: return 'Abril';
			case 4: return 'Mayo';
			case 5: return 'Junio';
			case 6: return 'Julio';
			case 7: return 'Agosto';
			case 8: return 'Septiembre';
			case 9: return 'Octubre';
			case 10: return 'Noviembre';
			case 11: return 'Diciembre';
		}
	}
	
	function add_graph_columns()
	{
		var last_id 	= null;
		var last_time	= null;
		var chart		= null;
		
		if ( null == graph_data )
			return;
		
		for ( var i = 0; i < graph_data.length; i++ )
		{
			var packet	= graph_data[i];
			var date	= new Date( 1000 * packet.tlc_from_time );
			var datestr	= zero_fill( date.getMonth() + 1, 2 ) + "/" + date.getFullYear();
			
			if ( last_time != packet.tlc_from_time )
			{
				last_time	= packet.tlc_from_time;
				
				vis_data.setValue( time_count, 0, datestr );
				
				time_count++;
			}
			
			var key = packet.com_name.hashCode();
			var pos	= ccol[ key ];
			
			if ( 'undefined' != typeof pos )
			{
				vis_data.setValue( time_count - 1, pos, packet.tlc_tests_count );
				
				var tooltip	= '<div style="padding: 8px">';
				tooltip		+= '<b>' + get_month( date.getMonth() ) + " " + date.getFullYear() + '</b><br/>';
				tooltip		+= '<br/>';
				tooltip		+= packet.com_name + ': <b>' + packet.tlc_tests_count + '</b>';
				tooltip		+= '</div>';
				
				vis_data.setValue( time_count - 1, tcol[ pos ], tooltip );
			}
		}
	}
	
	function get_draw_opts()
	{
		var max_hval = <?=$max_hval?>;
		var w = $(window).width()-100;
		var m_charArea = { left:100, top:10, width:w, height:content_get_visible_height() - 110 };
		var m_hAxis = { slantedText:true, maxAlternation:1 };
		var m_vAxis = { viewWindowMode: 'explicit', minValue: 0, maxValue:max_hval };
		
		if ( chart_mod )
		{
			m_vAxis = { viewWindowMode: 'explicit', minValue: 0 };
		}
		
		return {
			width:w, 
			height: content_get_visible_height() - 20, 
			title: 'Período: ' + <?=$months?> + ' meses',
			chartArea: m_charArea, 
			hAxis: m_hAxis, 
			vAxis: m_vAxis,
			fontSize: 12, 
			legend: { 
				position:'bottom', 
				textStyle: { fontSize:11 } 
			},
			tooltip: { 
				isHtml: true 
			}
		};
	}
	
	function redraw_chart()
	{
		var view = new google.visualization.DataView(vis_data);
		view.setColumns(columns);
		chart.draw( view, get_draw_opts() );
	}
	
	function sel_column( col )
	{
		// show the data series
		columns[col]			= col;
		series[col - 1].color	= null;
	}
	
	function unsel_column( col )
	{
		// hide the data series
		columns[col] = {
			label: vis_data.getColumnLabel(col),
			type: vis_data.getColumnType(col),
			calc: function ()
			{
				return null;
			}
		};
		
		// grey out the legend entry
		series[col - 1].color	= '#CCCCCC';
	}
	
	function switch_column( col )
	{
		if (columns[col] == col)
		{
			unsel_column( col );
		}
		else
		{
			sel_column( col );
		}
	}
	
	function hide_group_columns()
	{
		if ( columns.length >= 2 )
		{
			for ( var i = 3; i < columns.length; i+=2 )
			{
				unsel_column(i);
			}
		}
	}
	
	function init_columns()
	{
		for (var i = 0; i < vis_data.getNumberOfColumns(); i++)
		{
			columns.push(i);
			
			if (i > 0)
			{
				series[i - 1] = {};
			}
		}
	}
	
	function draw_chart()
	{
		chart			= new google.visualization.LineChart( document.getElementById('chart_div') );
		vis_data		= new google.visualization.DataTable();

		google.visualization.events.addOneTimeListener(chart, 'ready', function ()
		{
			var container = document.querySelector('#chart_div > div:last-child');
			
			function setPosition(e)
			{
				if (e && e.target)
				{
					var tooltip = $(e.target);
					
					setTimeout(function ()
					{
						var left = parseFloat(tooltip.css('left')) - 120;
						tooltip.css('left', left + 'px');
						$(".google-visualization-tooltip").show();
					}, 1);
				}
				else
				{
					var tooltip = container.querySelector('.google-visualization-tooltip');
					var left = parseFloat(tooltip.style.left) + 120;
					tooltip.style.left = left + 'px';
					$(".google-visualization-tooltip").show();
				}
			}
			
			if (document.addEventListener)
			{
				container.addEventListener('DOMNodeInserted', setPosition);
			}
			else
			{
				container.attachEvent('onDOMNodeInserted', setPosition);
			}
		});
		
		vis_data.addRows( <?=$total_rows?> );
		vis_data.addColumn( 'string', 'Fecha' );
		
		add_rows();
		
		add_graph_columns();
		
		init_columns();
		
		redraw_chart();
		
		google.visualization.events.addListener(chart, 'select', function ()
		{
			chart_mod = true;
			
			var sel = chart.getSelection();
			
			// if selection length is 0, we deselected an element
			if (sel.length > 0)
			{
				// if row is undefined, we clicked on the legend
				if (sel[0].row === null)
				{
					var col = sel[0].column;
					
					switch_column( col );
					
					redraw_chart();
				}
			}
		});
	}
	
	function graph_select_all()
	{
		for ( var i = 1; i < columns.length; i++ )
		{
			sel_column(i);
		}
		
		redraw_chart();
	}
	
	function graph_unselect_all()
	{
		for ( var i = 1; i < columns.length; i++ )
		{
			unsel_column(i);
		}
		
		redraw_chart();
	}
	
	function graph_invert_all()
	{
		for ( var i = 1; i < columns.length; i++ )
		{
			switch_column(i);
		}
		
		redraw_chart();
	}
	
	$(function()
	{
		if ( 'undefined' == typeof google ) return;
		
		google.load("visualization", "1", {
			packages: ["corechart"],
			callback: draw_chart
		});
		
		var resize_cb_id = resize_callback_register(function()
		{
			redraw_chart();
		});
		
		panel_register( $('#panel_graph_filters'), 'right' );
		
		kajax_register_unload_callback(function()
		{
			resize_callback_unregister( resize_cb_id );
			delete vis_data;
			delete graph_data;
			delete rows;;
			time_count	= 0;
			ccol		= [];
			tcol		= [];
			delete chart;
			columns		= [];
			series		= {};
			chart_mod	= false;
			vis_data = graph_data = rows = chart = null;
			return true;
		});
		
		panel_register( $('#panel_airmesh') );
		panel_register( $('#panel_gprs') );
	});
</script>

<div style="" id="chart_div"></div>

<?
include('panel_airmesh.php');
?>

<div class="panel_box panel_box_right_top" id="panel_graph_filters">
	<div class="panel_data_box_right">
		<div class="panel_data_box_margined_right">
			<div id="filters_default">
				<form class="ajax-get-form" id="graph_filters">
					<? if ( User()->is_logged_as_god() ) { ?>
						<div class="custom-select">
							<select id="company" class="campos_graph" name="company">
								<option value="">Filtrar por Empresa</option>
							<?	if ( isset( $companies ) ) { foreach( $companies as $com ) { ?>
								<option value="<?=$com->com_id?>" <?=isset($company)&&$company==$com->com_id?$sel:''?>><?=$com->com_name?></option>
							<?	} } ?>
							</select>
						</div>
					<? } ?>
					
					<div class="custom-select">
						<select class="campos_graph" name="months">
							<option value="3" <?=(3==$months)?$sel:''?>>3 Meses</option>
							<option value="6" <?=(6==$months)?$sel:''?>>6 Meses</option>
							<option value="12" <?=(12==$months)?$sel:''?>>12 Meses</option>
							<option value="24" <?=(24==$months)?$sel:''?>>24 Meses</option>
							<option value="48" <?=(48==$months)?$sel:''?>>48 Meses</option>
						</select>
					</div>
					<input type="hidden" name="map_ignore_hours" value="1" />
					
					<button id="filterButton" class="submit_btn" type="submit" value="submit"><span>Filtrar</span></button>
				</form>
			</div>
		</div>
	</div>
	
	<div class="panel_hide_box_right">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>
