<?php
$sel = 'selected="selected"';
?>
<script type="text/javascript">
	var vis_data		= null;
	var graph_data		= <?=json_encode($data)?>;
	var hours_to_show	= <?=$hours?>;
	var final_datetime	= <?=$final_datetime?>;
	var chart			= null;

	function get_draw_opts()
	{
		var w = $(window).width()-100;
		var m_charArea = { left:100, top:10, width:w, height:content_get_visible_height() - 110 };
		var m_hAxis = { slantedText:true, maxAlternation:1 };
		var m_vAxis = { viewWindowMode: 'explicit' };
		return {
			width:w, height: content_get_visible_height() - 20, title: 'Período: ' + <?=$hours?> + ' horas',
			chartArea: m_charArea, hAxis: m_hAxis, vAxis: m_vAxis,
			fontSize: 12, legend:{position:'bottom',textStyle:{fontSize:11}}
		};
	}
	
	function draw_data()
	{
		var view = new google.visualization.DataView(vis_data);
		chart.draw( view, get_draw_opts() );
	}
	
	function add_graph_data()
	{
		if ( null == graph_data )
		{
			return;
		}
	
		for ( var hw in graph_data )
		{
			vis_data.addColumn( 'number', hw );
		}
			
		for ( var i = hours_to_show; i > 0; i-- )
		{
			var test_time	= final_datetime - ( i - 1 ) * 3600;
			var date		= new Date( 1000 * test_time );
			
			var time_str	= zero_fill( date.getDate(), 2 ) + "/" + zero_fill( date.getMonth() + 1, 2 ) + " " + date.getHours() + "hs";
			
			vis_data.setValue( hours_to_show - i, 0, time_str );
			
			var j = 1;
			
			for ( var hw in graph_data )
			{
				var obj		= graph_data[ hw ];
				var tests	= obj[ i - 1 ];
				
				vis_data.setValue( i - 1, j, tests );
				
				j++;
			}
		}
	}
	
	function draw_chart()
	{
		chart			= new google.visualization.LineChart( document.getElementById('chart_div') );
		vis_data		= new google.visualization.DataTable();
		
		vis_data.addRows( hours_to_show );
		vis_data.addColumn( 'string', 'Rango Horario' );
		
		add_graph_data();
		
		draw_data();
	}
	
	$(function()
	{
		if ( 'undefined' == typeof google ) return;
		
		autocomplete_register( $( "#hw_code_search" ), "<?=base_url('/hw/autocomplete')?>", '', function(ui){});
		
		autocomplete_register( $( "#hw_code_search_serial" ), "<?=base_url('/hw/autocomplete/serial')?>", '', function(ui){});
		
		if ( null != graph_data )
		{
			google.load("visualization", "1", {
				packages: ["corechart"],
				callback: draw_chart
			});
			
			var resize_cb_id = resize_callback_register(function()
			{
				draw_data();
			});
		}

		datetime_picker_init( '#hasta', "<?=$date_str?>" );
		
		panel_register( $('#panel_graph_filters'), 'right' );
		
		dropdown_filter_register();
		
		kajax_register_unload_callback(function()
		{
			resize_callback_unregister( resize_cb_id );
			delete vis_data;
			delete graph_data;
			hours_to_show	= null;
			final_datetime	= null;
			delete chart;
			vis_data = graph_data = chart = null;
			return true;
		});
		
		panel_register( $('#panel_airmesh') );
		panel_register( $('#panel_gprs') );
		
		$('#export_form').unbind('click').bind('click', function()
		{
			var url = kajax_get_form_url($('#graph_filters'), '<?=base_url('/hw/stats_export')?>' );
			
			window.open( url );
		});
	});
</script>

<div id="chart_div"></div>

<?
include('panel_airmesh.php');
?>

<div class="panel_box panel_box_right_top" id="panel_graph_filters">
	<div class="panel_data_box_right">
		<div class="panel_data_box_margined_right">
			<? include('hw_icon_panel.php' ) ?>
			
			<div id="filters_default">
				<form class="ajax-get-form" id="graph_filters">
					
					<? if ( User()->is_logged_as_god() ) { ?>
						<div class="custom-select">
						<select id="company" class="campos_graph" name="company">
							<option value="">Filtrar por Empresa</option>
						<?	if ( isset( $companies ) ) { foreach( $companies as $com ) { ?>
							<option value="<?=$com->com_id?>" <?=isset($company)&&$company==$com->com_id?$sel:''?>><?=$com->com_name?></option>
						<?	} } ?>
						</select>
						</div>
					<? } ?>
					
					<div class="custom-select">
						<select class="campos_graph" name="gfilter">
							<option value="">Filtrar por Señal</option>
							<option value="BAD" <?=print_var_sel('gfilter','BAD')?>>Ver equipos con fallas</option>
							<option value="GOOD" <?=print_var_sel('gfilter','GOOD')?>>Ver equipos sin fallas</option>
						</select>
					</div>
					
					<input id="hw_code_search" class="panel_text_input panel_search_hw_input" type="text" name="gf_hw_code" placeholder="Filtrar por Número de Abonado" value="<?=get_var('gf_hw_code')?>">
					
					<input id="hw_code_search_serial" class="panel_text_input panel_search_hw_input" type="text" name="gf_hw_serial" placeholder="Filtrar por Número de MAC" value="<?=get_var('gf_hw_serial')?get_var('gf_hw_serial'):(isset($hw)?dechex($hw['hw_serial']):'')?>">
					
					<? include('group_filter.php') ?>
					
					<input class="campos_graph fecha" name="gtodate" id="hasta" type="text" value="<?=$date_str?>" readonly style="cursor:pointer" />
					<div class="custom-select">
						<select class="campos_graph" name = "ghours">
							<option value="1" <?=(1==$hours)?$sel:''?>>1hs</option>
							<option value="2" <?=(2==$hours)?$sel:''?>>2hs</option>
							<option value="3" <?=(3==$hours)?$sel:''?>>3hs</option>
							<option value="6" <?=(6==$hours)?$sel:''?>>6hs</option>
							<option value="12" <?=(12==$hours)?$sel:''?>>12hs</option>
							<option value="24" <?=(24==$hours)?$sel:''?>>24hs</option>
							<option value="48" <?=(48==$hours)?$sel:''?>>48hs</option>
							<option value="72" <?=(72==$hours)?$sel:''?>>72hs</option>
						</select>
					</div>
					<input type="hidden" name="map_ignore_hours" value="1" />
					
					<button id="filterButton" class="submit_btn" type="submit" value="submit"><span>Filtrar</span></button>
					
					<button id="export_form" class="submit_btn" type="button" value="submit"><span>Exportar</span></button>
				</form>
			</div>
		</div>
	</div>
	
	<div class="panel_hide_box_right">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>
