 
<?php
$sel = 'selected="selected"';
function users_build_link( $order_by )
{
	return base_url( '/geotrace/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="panel_box panel_box_left_top" id="panel_ahw_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				
				<input id="hw_imei_search" class="panel_text_input panel_search_hw_input" name="ahw_imei" type="text" value="<?=$ahw_imei?>" placeholder="Filtrar por IMEI" />
				<input id="ui_name_search" class="panel_text_input panel_search_hw_input" type="text" name="ui_fullname" value="<?=$ui_fullname?>" style="cursor:pointer" placeholder="Filtrar por Usuario Cliente" readonly="readonly" />
				<input id="ui_uid_search" type="hidden" name="ahw_uid" value="<?=$ahw_uid?>" />
				<input id="hw_name_search" class="panel_text_input panel_search_hw_input" name="ahw_name" type="text" value="<?=$ahw_name?>" placeholder="Filtrar por Nombre de Móvil" />
				
				<button class="submit_btn" value="submit"><span>Filtrar</span></button>
			</form>

			<div class="panel_hw_hsep"></div>
			
			<div id="hw_list_count_total"><b><?=$total_vehicles?></b> Móviles</div>
			
			<div id="hw_count_and_exports" class="left">
				<a class="left" target="_blank" href="<?=base_url('/geotrace/export/csv/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_xls_button">XLS</div></a>
				<a class="left" target="_blank" href="<?=base_url('/geotrace/export/pdf/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_pdf_button">PDF</div></a>
			</div>
			
			<div class="panel_hw_hsep"></div>
			
			<a class="left clear ajax-link" target="_blank" href="<?=base_url('/geotrace/fleets')?>"><div id="fleets_icon">Flotas</div></a>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<div id="vehicles-list">
<? if ( isset( $vehicles ) ) { ?>
	<div class="resize_informer">
	
	<form id="table-form" action="<?=base_url('/geotrace/update')?>" method="POST" style="display: none;"></form>
	
	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>
	
	<table class="default_table" id="users_list_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th><a class="ajax-link" href="<?=users_build_link( 'ahw_imei' )?>">IMEI</a></th>
				<th><a class="ajax-link" href="<?=users_build_link( 'ahw_name' )?>">Nombre</a></th>
				<th><a class="ajax-link" href="<?=users_build_link( 'ahw_licenseplate' )?>">Licencia</a></th>
				<th><a class="ajax-link" href="<?=users_build_link( 'ahw_model' )?>">Vehículo</a></th>
				<th>Tipo</th>
				<th>Estado</th>
				<th><?=User()->is_logged_as_user()?'Flota':(User()->is_logged_as_company()?'Usuario':'Empresa')?></th>
			</tr>
		</thead>
		<tbody>
		<? foreach ( $vehicles as $v ) { ?>
			<tr id="row_<?=$v['ahw_imei']?>">
				<td><?=$v['ahw_imei']?><input type="hidden" name="imei" value="<?=$v['ahw_imei']?>" /></td>
				<td><input type="text" name="name" value="<?=$v['ahw_name']?>" /></td>
				<td><input type="text" name="licenseplate" value="<?=$v['ahw_licenseplate']?>" /></td>
				<td><input type="text" name="model" value="<?=$v['ahw_model']?>" /></td>
				<td>
					<select class="icons" name="icon">
						<? $icons = get_vehicles_array(); foreach ( $icons as $name=>$key ) { ?>
						
						<option value="<?=$key?>" <?=$key==$v['ahw_icon']?$sel:''?>><?=$name?></option>
						<?	} ?>
					</select>
				</td>
				<td>
					<select name="state">
						<option value="ACTIVE" <?=$v['ahw_state']=='ACTIVE'?$sel:''?>>Activo</option>
						<option value="INACTIVE" <?=$v['ahw_state']=='INACTIVE'?$sel:''?>>Inactivo</option>
					</select>
				</td>
				<td>
					<? if ( User()->is_logged_as_user() ) { ?>
						
					<select name="fleet">
						<option value="">Asignar</option>
						
					<?	if ( !empty($fleets) ) { foreach ($fleets as $fleet ) { ?>
						<option value="<?=$fleet['af_id']?>" <?=$fleet['af_id']==$v['ahw_fleet']?$sel:''?>><?=$fleet['af_name']?></option>
					<?	} } ?>
					</select>
						
					<? } else if ( User()->is_logged_as_company() ) { ?>
					
					<input type="hidden" name="imei" value="<?=$v['ahw_imei']?>" />
					<input type="text" readonly class="user_info_name" id="ui_lastname_<?=$v['ahw_imei']?>" name="ui_lastname" value="<?=isset( $v['ui_lastname'] ) ? ( $v['ui_lastname'] . ' ' . $v['ui_name'] ) : ''?>" />
					<input type="hidden" id="user_id_<?=$v['ahw_imei']?>" name="user_id" value="<?=isset( $v['uid'] ) ? $v['uid'] : ''?>" />
					<input type="hidden" id="user_info_id_<?=$v['ahw_imei']?>" name="user_info_id" value="<?=isset( $v['ui_id'] ) ? $v['ui_id'] : ''?>" />
					<input type="hidden" id="old_user_info_id_<?=$v['ahw_imei']?>" name="old_user_info_id" value="<?=isset( $v['ui_id'] ) ? $v['ui_id'] : ''?>" />
					
					<? } else { ?>
						
						<select name="company">
							<option value="">Asignar Empresa</option>
						<?	if ( isset( $companies ) ) { foreach( $companies as $com ) { ?>
							<option value="<?=$com->com_id?>" <?=isset($v['ahw_company'])&&$v['ahw_company']==$com->com_id?$sel:''?>><?=$com->com_name?></option>
						<?	} } ?>
						</select>
					
					<? } ?>
				</td>
			</tr>
			<tr class="form_buttons hidden" id="row_hidden_<?=$v['ahw_imei']?>">
				<td colspan="7" align="center">
					<button class="submit_btn_table cancel_btn" value="cancel"><span>Cancelar</span></button>
					
					<button class="submit_btn_table save_btn" value="submit"><span>Guardar</span></button>
				</td>
			</tr>
		<? } ?>
		</tbody>
	</table>
	
	<?=$pagination?>
	
	</div>
	
	<script type="text/javascript">
		var form_table	= null;
		
		function user_search_select( row_id, ui_id, uid, ui_fullname )
		{
			$('#ui_uid_search').val( uid );
			$('#ui_name_search').val( ui_fullname );
			
			modal_dialog_close();
		}
		
		function geotrace_user_search_select( row_id, ui_id, uid, ui_fullname )
		{
			$('#user_info_id_'+row_id).val( ui_id );
			$('#user_id_'+row_id).val( uid );
			$('#ui_lastname_'+row_id).val( ui_fullname );
			
			modal_dialog_close();
		}
		
		$(function()
		{
			form_table	= $('#table-form');
			
			table_register( form_table );
			
			panel_register( $('#panel_ahw_filters'), 'left' );
			
			$('.user_info_name').each(
				function()
				{
					var t			= $(this);
					var row_id		= t.parent().parent().attr('id').substr(4);
					var load_url	= "<?=base_url('/users/search/?unselect_but=1&cb=geotrace_user_search_select&row_id=')?>" + row_id;
					client_search_button_register( t, load_url );
				}
			);
			
			client_search_button_register( $( "#ui_name_search" ), "<?=base_url('/users/search/?unselect_but=1&cb=user_search_select')?>" );
				
			autocomplete_register( $( "#hw_imei_search" ), "<?=base_url('/geotrace/autocomplete')?>", 'hw_imei', function(ui)
			{
				$('#hw_imei_search').val( ui.item.id );
			});
			
			autocomplete_register( $( "#hw_name_search" ), "<?=base_url('/geotrace/autocomplete')?>", 'hw_name', function(ui)
			{
				$('#hw_name_search').val( ui.item.id );
			});
			
			autocomplete_register( $( "#ui_name_search" ), "<?=base_url('/geotrace/autocomplete')?>", 'ui_name', function(ui)
			{
				$('#ui_name_search').val( ui.item.name );
				$('#ui_uid_search').val( ui.item.id );
			});
			
			table_header_fixed_register();
		})
	</script>
<? } else { ?>
	<span>No se han encontrado móviles</span>
<? } ?>

</div>
