<?php
$sel = 'selected="selected"';
?>
<div class="panel_box panel_box_left_top" id="panel_hw_edit">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-form" action="<?=base_url('/geotrace/update');?>" method="post">
			
			<div class="sprite-img-icon-editar edit_hw_but edit_ahw_but" onclick="return edit_switch()"></div>
			
			<div class="hw_edit_box ahw_edit_box">
				<h3><input id="name_input" type="text" name="name" class="name" value="<?=$hw['ahw_name']?>" disabled /></h3>
				<span>IMEI: <b><?=$hw['ahw_imei']?></b></span>
				<span>Conductor: <b><?=NULL!=$hw['ui_lastname'] ? ( $hw['ui_name'] . ' ' . $hw['ui_lastname'] ) : 'No Asignado'?></b></span>
				<span>Latitud: <b><?=$hw['ae_lat']?></b></span>
				<span>Longitud: <b><?=$hw['ae_long']?></b></span>
				<span>Último Reporte: <b><?=timestamp_to_str( $hw['ae_timestamp'], '-' )?></b></span>
				<span class="<?=intval($hw['ae_speed'])>0?'turquoise':''?>">Velocidad: <b><?=$hw['ae_speed']?> Km/h</b></span>
			</div>
			
			<div class="panel_hsep"></div>
			
			<div class="edit_box">
				<input type="hidden" name="imei" value="<?=$hw['ahw_imei']?>" />
				
				<? if ( !User()->is_logged_as_user() ) { ?>
					<span>Usuario:</span>
					<div class="left">
						<input type="text" readonly class="user_info_name" id="ui_lastname" name="ui_lastname" value="<?=( isset( $hw['ui_lastname'] ) || isset( $hw['ui_name'] ) ) ? ( $hw['ui_lastname'] . ' ' . $hw['ui_name'] ) : ''?>" style="cursor:pointer;" />
						<input type="hidden" id="user_id" name="user_id" value="<?=isset( $hw['ahw_uid'] ) ? $hw['ahw_uid'] : ''?>" />
						<input type="hidden" id="user_info_id" name="user_info_id" value="<?=isset( $hw['ui_id'] ) ? $hw['ui_id'] : ''?>" />
						<input type="hidden" id="old_user_info_id" name="old_user_info_id" value="<?=isset( $hw['ui_id'] ) ? $hw['ui_id'] : ''?>" />
					</div>
				<? } ?>
				
				<span>Vehículo:</span><div class="left"><input type="text" name="model" value="<?=$hw['ahw_model']?>" /></div>
				
				<span>Licencia:</span><div class="left"><input type="text" name="licenseplate" value="<?=$hw['ahw_licenseplate']?>" /></div>
				
				<span>Estado:</span>
				<div class="custom-select">
					<select name="state">
						<option value="ACTIVE" <?=$hw['ahw_state']=='ACTIVE'?$sel:''?>>Activo</option>
						<option value="INACTIVE" <?=$hw['ahw_state']=='INACTIVE'?$sel:''?>>Inactivo</option>
					</select>
				</div>
				
				<span>Tipo:</span>
				<div class="custom-select">
					<select class="icons" name="icon">
						<? $icons = get_vehicles_array(); foreach ( $icons as $name=>$key ) { ?>
						
						<option value="<?=$key?>" <?=$key==$hw['ahw_icon']?$sel:''?>><?=$name?></option>
						<?	} ?>
					</select>
				</div>
				
				<span>Flota:</span>
				<div class="custom-select">
					<select name="fleet">
						<option value="">Sin Asignar</option>
						
						<? if ( isset( $fleets ) ) { foreach ( $fleets as $fleet ) { ?>
						
						<option value="<?=$fleet['af_id']?>" <?=$fleet['af_id']==$hw['ahw_fleet']?$sel:''?>><?=$fleet['af_name']?></option>
						<?	}} ?>
					</select>
				</div>
				
				<div class="edit_buttons">
					<button class="submit_btn_panel cancel_btn" type="button" value="cancel"><span>Cancelar</span></button>
					<button class="submit_btn_panel save_btn" type="submit" value="submit"><span>Guardar</span></button>
				</div>
			</div>
			
			</form>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<? if ( !User()->is_logged_as_user() ) { ?>

<div class="panel_box panel_box_right_bottom" id="panel_ahw_config">
	<div class="panel_data_box_right">
		<div class="panel_data_box_margined_right_only_left">
			<h3>Configuración de Equipo Móvil</h3>
			
			<div class="config_form_cont">
				<form class="ajax-form" action="<?=base_url('/geotrace/save_config/' . $hw['ahw_imei'] )?>">
					<div class="config_cont">
						<div class="block">
							<div class="block_text_white">Intervalo máximo de reporte</div>
							<div class="block_data">
								<div class="block_input"><input type="text" name="time_alr" value="<?=$hw['config']['time_alr']?>" /> Segs.</div>
							</div>
						</div>
						
						<div class="block">
							<div class="block_text_white">Distancia entre reporte</div>
							<div class="block_data">
								<div class="block_input"><input type="text" name="dist_alr" value="<?=$hw['config']['dist_alr']?>" /> Metros</div>
							</div>
						</div>
						
						<div class="block">
							<div class="block_text_white">Disparador de Velocidad</div>
							<div class="block_data">
								<div class="block_input"><input type="text" name="speed_alr" value="<?=$hw['config']['speed_alr']?>" /> Km/h</div>
							</div>
						</div>
						
						<div class="block">
							<div class="block_text_white">Ángulo de Giro para reporte</div>
							<div class="block_data">
								<div class="block_input"><input type="text" name="head_alr" value="<?=$hw['config']['head_alr']?>" /> Grados</div>
							</div>
						</div>
						
						<div class="block">
							<div class="block_text_white">Intervalo de Heartbeat</div>
							<div class="block_data">
								<div class="block_input"><input type="text" name="heart_alr" value="<?=$hw['config']['heart_alr']?>" /> Segs.</div>
							</div>
						</div>

						<div class="block">
							<div class="block_text_white">Intervalo de Heartbeat (domo)</div>
							<div class="block_data">
								<div class="block_input"><input type="text" name="domo_alr" value="<?=$hw['config']['domo_alr']?>" /> Segs.</div>
							</div>
						</div>

						<div class="block">
							<div class="block_text_white">Modo Ahorro de Energía</div>
							<div class="block_data">
								<div class="block_input"><input type="checkbox" name="sleep_lvl" value="1" <?=$hw['config']['sleep_lvl']?'checked':''?> /> ¿Activo?</div>
							</div>
						</div>
						
						<div class="block">
							<div class="block_text_white">Intervalo en Estacionamiento</div>
							<div class="block_data">
								<div class="block_input"><input type="text" name="park_alr" value="<?=$hw['config']['park_alr']?>" /> Segs.</div>
							</div>
						</div>

						<div class="block_free">
							<div class="block_text_white_free">Entrada 1</div>
							<div class="block_data_free">
								<div class="block_input_free"><input type="text" name="in1" value="<?=$hw['config']['in1']?>" /></div>
							</div>
						</div>

						<div class="block_free">
							<div class="block_text_white_free">Entrada 2</div>
							<div class="block_data_free">
								<div class="block_input_free"><input type="text" name="in2" value="<?=$hw['config']['in2']?>" /></div>
							</div>
						</div>

						<div class="block">
							<div class="block_text_white">Salida 1</div>
							<div class="block_data">
								<div class="block_input"><input type="checkbox" name="out1" value="1" <?=$hw['config']['out1']?'checked':''?> /> ¿Activa?</div>
							</div>
						</div>

						<div class="block">
							<div class="block_text_white">Salida 2</div>
							<div class="block_data">
								<div class="block_input"><input type="checkbox" name="out2" value="1" <?=$hw['config']['out2']?'checked':''?> /> ¿Activa?</div>
							</div>
						</div>

						<div class="block">
							<div class="block_text_white">Salida 3</div>
							<div class="block_data">
								<div class="block_input"><input type="checkbox" name="out3" value="1" <?=$hw['config']['out3']?'checked':''?> /> ¿Activa?</div>
							</div>
						</div>

						<div class="block">
							<div class="block_text_white">Salida 4</div>
							<div class="block_data">
								<div class="block_input"><input type="checkbox" name="out4" value="1" <?=$hw['config']['out4']?'checked':''?> /> ¿Activa?</div>
							</div>
						</div>
						
						<div class="block_free">
							<div class="block_text_white_free">Host primario</div>
							<div class="block_data_free">
								<div class="block_input_free"><input type="text" name="gsm" value="<?=$hw['config']['gsm']?>" /></div>
							</div>
						</div>
						
						<div class="block_free">
							<div class="block_text_white_free">DNS</div>
							<div class="block_data_free">
								<div class="block_input_free"><input type="text" name="dns" value="<?=$hw['config']['dns']?>" /></div>
							</div>
						</div>
						
						<div class="block_free">
							<div class="block_text_white_free">Host secundario</div>
							<div class="block_data_free">
								<div class="block_input_free"><input type="text" name="sec_gsm" value="<?=$hw['config']['sec_gsm']?>" /></div>
							</div>
						</div>

						<div class="block_free">
							<div class="block_text_white_free">Cantidad de sims</div>
							<div class="block_data_free">
								<div class="block_input_free"><?=$hw['config']['sims']?></div>
							</div>
						</div>

						<div class="block_free">
							<div class="block_text_white_free">Versión en ejecución</div>
							<div class="block_data_free">
								<div class="block_input_free"><?=$hw['config']['firm_ver']?></div>
							</div>
						</div>
					
						<div class="block_free">
							<div class="block_text_white_free">Versión en actualización</div>
							<div class="block_data_free">
								<div class="block_input_free"><input type="text" name="upgr_ver" value="<?=$hw['config']['upgr_ver']?>" /></div>
							</div>
						</div>
					
					</div>
					
					<button class="submit_btn_panel" type="submit" ><span>Guardar</span></button>
				</form>
			</div>
			
			<div class="config_over_box">
				<p>Domo está esperando una respuesta pendiente del equipo.</p>
				
				<div class="loading-spinner"><div class="loading-spinner-image"></div></div>
			</div>
		
		</div>
		
	</div>
	
	<div class="panel_hide_box_right">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<? } ?>

<div class="panel_box panel_tour_filter panel_box_right_top" id="panel_ahw_filter">
	<div class="panel_data_box_right">
		<div class="panel_data_box_margined_right">
			<form id="date_filter_form" class="ajax-get-form" data-cbstart="on_geotrace_time_filter_start">
				<? include( 'event_filter.php' ) ?>
				
				<input class="fecha" name="from" id="from" type="text" value="" readonly style="cursor:pointer" />
				
				<input class="fecha" name="to" id="to" type="text" value="" readonly style="cursor:pointer" />

				<button class="left clear submit_btn" type="submit" value="submit">
					<span>Ver Recorrido</span>
				</button>
				
				<div class="export_hw_box">
					<a target="_blank" class="left" href="<?=base_url('/geotrace/view/' . $hw['ahw_imei'] . '/export/csv/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_xls_button">XLS</div></a>
					<a target="_blank" class="left" href="<?=base_url('/geotrace/view/' . $hw['ahw_imei'] . '/export/pdf/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_pdf_button">PDF</div></a>
				</div>
			</form>
		</div>
	</div>
	
	<div class="panel_hide_box_right">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<div class="panel_graph_bottom_panel">
	<div id="chart_div">
		<canvas height="120"></canvas>
	</div>
</div>

<script type="text/javascript">
	var _map_data			= <?=$map_data?>;
	var _map_data_points	= <?=$map_data_points?>;
	var _is_search			= <?=$is_search?'true':'false'?>;
	var map_debug			= <?=User()->is_god()?'true':'false'?>;
	var hw					= <?=json_encode($hw)?>;
	var config_old			= null;
	var state_int			= null;
	var chart = null;
	var chart_labels = [];
	var chart_data = [];
	
	function chart_create()
	{
		var chart_panel = $(".panel_graph_bottom_panel");
		var ctx = $("#chart_div canvas");
		
		if ( null != chart )
		{
			chart.destroy();
		}
		
		if ( _map_data_points && _map_data_points.length > 0 ) 
		{
			var max_speed = <?=$hw['config']['speed_alr']?> + 30;
			
			chart_labels = [];
			chart_data = [];
			
			for ( var i = 0; i < _map_data_points.length; i++ )
			{
				var p = _map_data_points[i];
				
				chart_labels.push( new Date( p.ae_timestamp * 1000 ) );
				chart_data.push( p.ae_speed ); 
			}
			
			Chart.defaults.global.legend.display = false;
			
			chart = new Chart(ctx, {
				type: 'line',
				data: {
					labels: chart_labels,
					datasets: [
						{
							label: "Velocidad",
							fill: false,
							lineTension: 0.1,
							backgroundColor: "rgba(150,50,0,0.4)",
							borderColor: "rgba(75,192,192,1)",
							borderCapStyle: 'butt',
							borderDash: [],
							borderDashOffset: 0.0,
							borderJoinStyle: 'miter',
							pointBorderColor: "rgba(150,50,0,1)",
							pointBackgroundColor: "#fff",
							pointBorderWidth: 3,
							pointHoverRadius: 5,
							pointHoverBackgroundColor: "rgba(150,50,0,1)",
							pointHoverBorderColor: "rgba(150,50,0,1)",
							pointHoverBorderWidth: 2,
							pointRadius: 3,
							pointHitRadius: 10,
							data: chart_data,
							spanGaps: false,
						}
					]
				},
				options: {
					maintainAspectRatio: false,
					responsive: true,
					scales: {
						xAxes: [{
							type: 'time',
							time: {
								displayFormats: {
									second: 'HH:mm:ss',
									minute: 'HH:mm:ss'
								}
							}
						}],
						yAxes: [{
							ticks: {
								beginAtZero:true,
								max: max_speed
							}
						}]
					}
				}
			});
			
			ctx.on('click', function (e)
			{
				var bars = chart.getElementAtEvent(e);
				
				if (bars.length == 0) return;
				
				var element = bars[0];
				
				if (element === null) return;
				
				geotrace_map_point_click( element._index );
			});
		}
		else
		{
			chart_panel.hide();
		}
	}
	
	function geotrace_map_point_click( index )
	{
		var p = _map_data_points[ index ];
		
		if ( !_is_search )
		{
			if ( index != _map_data_points.length - 1 )
			{ 
				geotrace_map_auto_update_stop();
			}
			else
			{
				geotrace_map_auto_update( map_default_update_interval, "<?=$update_url?>", null, geotrace_map_update_cb );
			}
		}
		
		geotrace_map_update( [ p ], _map_data_points, false );
		
		map_show_marker_info_from_id( "ae_" + p.ae_id );
	}
	
	function geotrace_map_update_cb( _vehicles, _points )
	{
		if ( !_is_search )
		{
			datetime_picker_init( '#from', new Date( (new Date)*1 - 1000*3600 ), "'Desde el '" );
			datetime_picker_init( '#to', new Date(), "'Hasta el '" );
		}
		
		_map_data = _vehicles;
		_map_data_points = _points;
		
		chart_create();
	}
	
	function user_search_select( row_id, ui_id, uid, ui_fullname )
	{
		$('#user_id').val( uid );
		$('#user_info_id').val( ui_id );
		$('#ui_lastname').val( ui_fullname );
		
		modal_dialog_close();
	}
	
	function map_on_load()
	{
		map_show_marker_info();
	}
	
	function load_map()
	{
		geotrace_map_make( 'map_canvas', _map_data, _map_data_points );
		
		if ( !_is_search )
		{
			geotrace_map_auto_update( map_default_update_interval, "<?=$update_url?>", null, geotrace_map_update_cb );
		}
		else if ( _map_data_points && _map_data_points.length > 0 )
		{
			geotrace_map_point_click( _map_data_points.length - 1 );
		}
		
		chart_create();
	}
	
	function on_site_loaded()
	{
		load_map();
	}
	
	function on_geotrace_time_filter_start()
	{
		geotrace_map_auto_update_stop();
	}
	
	function state_polling_stop()
	{
		if ( null != state_int )
		{
			clearInterval( state_int );
			
			state_int = null;
									
			$('.config_over_box').hide();
		}
	}
	
	function state_polling_start()
	{
		state_polling_stop();
		
		$('.config_over_box').show();
		
		state_int = setInterval(function()
		{
			$.get( page_url + 'geotrace/get_json/' + hw.ahw_imei, null, function(res)
			{
				var json = $.parseJSON(res);
				
				if ( json )
				{
					hw = json;
					
					if ( hw.ahw_cmd_state != 'WAITING_RESPONSE' )
					{
						state_polling_stop();
						
						if ( hw.ahw_cmd_state == 'COMPLETED' )
						{
							alertify.success( 'Configuración del equipo guardada con éxito.' );
							
							config_old = $.parseJSON( hw.ahw_config );
						}
						else if ( hw.ahw_cmd_state == 'TIMEOUT' )
						{
							alertify.error( 'El equipo no ha respondido, no se ha podido guardar la configuración.' );
							
							state_recover();
						}
						else
						{
							alertify.error( 'Ha habido un error al guardar la configuración.' );
							
							state_recover();
						}
					}
				}
			});
		}, 2500);
	}
	
	function state_recover()
	{
		if ( config_old )
		{
			var cont = $('.config_cont');
			
			Object.keys(config_old).forEach(function (key)
			{
				var input = cont.find('input[name="' + key + '"]');

				input.val( config_old[key] );

				if ( input.is(':checkbox') )
				{
					input.prop('checked', config_old[key] == 1);
				}
			});
			
			var serialized = obj_serialize( config_old );
			
			$.post( page_url + 'geotrace/recover_config/' + hw.ahw_imei, serialized, function(res)
			{
			})
		}
	}
	
	$(function()
	{
		edit_hide();
		
		map_reset();
		
		if ( site_loaded )
		{
			load_map();
		}
		
		panel_register( $('#panel_hw_edit'), 'left', true );
		
		panel_register( $('#panel_ahw_config'), 'right' );
		
		panel_register( $('#panel_ahw_filter'), 'right', true );
		
		datetime_picker_init( '#from', "<?=$from?>", "'Desde el '" );
		datetime_picker_init( '#to', "<?=$to?>", "'Hasta el '" );
		
		var cancel_btn = $('.cancel_btn');
		cancel_btn.unbind('click');
		cancel_btn.bind( 'click', function()
		{
			edit_hide();
		});
		
		client_search_button_register( $( "#ui_lastname" ), "<?=base_url('/users/search/?unselect_but=1&cb=user_search_select')?>" );
		
		dropdown_filter_register();
		
		$('.config_cont').mCustomScrollbar({
			scrollbarPosition: 'outside',
			setWidth: "100%"
		});
		
		$('.config_over_box').css('height', $('#panel_ahw_config .config_form_cont').innerHeight() );
		
		config_old = $.parseJSON( hw.ahw_config );
		
		if ( hw.ahw_cmd_state == 'WAITING_RESPONSE' )
		{
			state_polling_start();
		}
		
		kajax_register_unload_callback(function()
		{
			state_polling_stop();
			
			geotrace_map_auto_update_stop();
			
			return true;
		});
	});
</script>

<div id="map_container">
	<div class='map_canvas'></div>
</div>
