<?
$sel = 'selected="selected"';
$hours = isset( $hours ) ? $hours : 1;

function print_signal_boxes( $percent, $eq )
{
	$count = 0 == $percent ? -1 : ceil( $percent / 25 );
	
	for ( $i = 0; $i < 4; $i++ ) { ?>
					<div class="signal_box sprite-img-equalizador-<?=($i <= $count)?$eq:'none'?>"></div>
<?	}
}
?>

<div class="panel_box panel_box_left_top" id="panel_airmesh">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<div class="panel_title_box">GeoTrace</div>
			
			<div class="panel_equalizer tooltip">
				<div class="panel_equalizer_box">
					<? print_signal_boxes( $geotrace_moving_percent, 'movimiento' ); ?>
					<div class="signal_hw_count signal_hw_turquoise"><?=$geotrace_moving_count?></div>
				
				</div>
				
				<div class="panel_equalizer_box">
					<? print_signal_boxes( $geotrace_stopped_percent, 'detenido' ); ?>
					<div class="signal_hw_count signal_hw_pink"><?=$geotrace_stopped_count?></div>
				</div>
				
				<div class="panel_equalizer_box">
					<? print_signal_boxes( $geotrace_noreport_percent, 'nula' ); ?>
					<div class="signal_hw_count signal_hw_red"><?=$geotrace_noreport_count?></div>
				</div>
				
				<span class="panel_signal_explanation geotrace_panel_signal_explanation">
					<span>Turquesa: Móviles en Movimiento</span>
					<span>Rosa: Móviles Detenidos</span>
					<span>Rojo: Sin reporte en las últimas 24 hs</span>
				</span>
			</div>
			
			<div class="panel_hsep"></div>
			
			<div class="panel_hw_text clear"><span class="panel_hw_count"><?=$geotrace_hw_count?></span> <?=$geotrace_hw_count==1?'Móvil':'Móviles'?></div>
			
			<div class="panel_hw_text clear"><span class="panel_hw_count"><?=$fleets?></span> <?=$fleets==1?'Flota':'Flotas'?></div>
	
			<div class="geotrace_panel_map_filters">
				<span class="custom-checkbox ckx-left turquoise">
					<input type="checkbox" name="chbox" id="show_hide_moving" checked="checked">
					<label for="show_hide_moving">Móviles en movimiento</label>
				</span>
				
				<span class="custom-checkbox ckx-left pink">
					<input type="checkbox" name="chbox" id="show_hide_stopped" checked="checked">
					<label for="show_hide_stopped">Móviles detenidos</label>
				</span>
				
				<span class="custom-checkbox ckx-left red">
					<input type="checkbox" name="chbox" id="show_hide_noreport" checked="checked">
					<label for="show_hide_noreport">Móviles sin reporte</label>
				</span>
			</div>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div onclick="return panel_toggle_left( $(this) )" class="panel_hide_but sprite-img-flechin-out"></div>
	</div>
</div>

<div class="panel_box panel_box_right_top" id="panel_geotrace_hw">
	<div class="panel_data_box_right">
		<div class="panel_data_box_margined_right">
			<? if ( !User()->is_logged_as_user() ) { ?>
			<input id="ui_name_search" class="panel_text_input panel_search_hw_input" type="text" placeholder="Filtrar por Usuario Cliente" style="cursor:pointer;">
			<? } ?>
			<input id="hw_name_search" class="panel_text_input panel_search_hw_input" type="text" placeholder="Filtrar por Nombre de Móvil">
			<a href="<?=base_url('/geotrace/all')?>" class="ajax-link"><div class="panel_right_but">Todos los Móviles</div></a>
			
			<? if ( User()->is_logged_as_god() ) { ?>
				<a href="<?=base_url('/geotrace/log')?>" class="ajax-link"><div class="panel_right_but">Log de Comunicación</div></a>
			<? } ?>
			
			<? if ( isset( $vehicles ) && !empty( $vehicles ) ) { ?>
			<div class="panel_right_hsep"></div>
			
			<div id="fleet_scroll_area" class="clear left">
				<div class="fleet_cont">
					<?	$fname	= -1;
						$ff		= TRUE;
						
						foreach ( $vehicles as $hw )
						{
							if ( $fname != $hw['af_name'] )
							{
								$fname = $hw['af_name'];
								
								if ( !$ff ) { ?>
								<div class="panel_fleet_right_hsep"></div>
								<? } else { $ff = FALSE; } ?>
								<h3><?=$fname?></h3>
						<?	}
						
							$clscolor = 'NOREPORT' == $hw['state'] ? 'red_back' : ( 'STOPPED' == $hw['state'] ? 'pink_back' : 'turquoise_back' ); ?>
							
							<a class="ajax-link" href="<?=base_url('/geotrace/view/'.$hw['ahw_imei'])?>">
								<div class="fleet_box <?=$clscolor?>">
									<?=$hw['ahw_name']?>
								</div>
							</a>
					<?	} ?>
				</div>
			</div>
			<? } ?>
		</div>
	</div>
	
	<div class="panel_hide_box_right">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<script type="text/javascript">
	var _map_data		= <?=$map_data?>;
	var map_debug		= <?=User()->is_god()?'true':'false'?>;
	
	function geotrace_user_search_select( row_id, ui_id, uid, ui_fullname )
	{
		kajax_load_target( page_url + 'geotrace/map/' + uid );
		
		modal_dialog_close();
	}
	
	function load_map()
	{
		geotrace_map_make( 'map_canvas', _map_data );
		
		geotrace_map_auto_update( map_default_update_interval, "<?=$update_url?>" );
	}
	
	function on_site_loaded()
	{
		load_map();
	}
	
	function on_geotrace_time_filter_start()
	{
		geotrace_map_auto_update_stop();
	}
	
	$(function()
	{
		map_reset();
		
		if ( site_loaded )
		{
			load_map();
		}
		
		panel_register( $('#panel_geotrace_hw'), 'right' );
		
		autocomplete_register( $( "#hw_name_search" ), "<?=base_url('/geotrace/autocomplete')?>", 'hw_name', function(ui)
		{
			kajax_load_target( page_url + 'geotrace/view/' + ui.item.id );
		});
		
		client_search_button_register( $( "#ui_name_search" ), "<?=base_url('/users/search/?cb=geotrace_user_search_select')?>" );
		
		$('.fleet_cont').mCustomScrollbar({
			scrollbarPosition: 'outside',
			setWidth: '100%'
		});
		
		kajax_register_unload_callback(function()
		{
			geotrace_map_auto_update_stop();
			delete _map_data; _map_data = null;
			return true;
		});
	});
</script>

<div id="map_container">
	
	<div class='map_canvas'></div>

</div>
