<?php
function event_build_link( $order_by )
{
	return base_url( '/dshield/rfid/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="panel_box panel_box_left_top" id="panel_person_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				<input class="fecha" name="from" id="from" type="text" value="" readonly style="cursor:pointer" />
				
				<input class="fecha" name="to" id="to" type="text" value="" readonly style="cursor:pointer" />
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_name" placeholder="Filtrar por Nombre" value="<?=$urfid_name?>">
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_dni" placeholder="Filtrar por DNI"  value="<?=$urfid_dni?>">
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_plate" placeholder="Filtrar por Patente"  value="<?=$urfid_plate?>">
				
				<? if ( !User()->is_dshield_user() ) { ?>
				<input class="panel_text_input panel_search_hw_input" type="text" name="re_user_plot" placeholder="Filtrar por Lote"  value="<?=$re_user_plot?>">
				<? } ?>
				
				<? include( 'person_type_filter.php' ); ?>
				
				<button class="submit_btn" value="submit"><span>Filtrar</span></button>
			</form>
			
			<div class="panel_hw_hsep"></div>
				
			<div class="left" id="hw_list_count_total"><b><?=$total_events?></b> Eventos</div>
			
			<div id="hw_count_and_exports">
				<a target="_blank" class="left" href="<?=base_url('/rfid/export/csv/?').$_SERVER['QUERY_STRING']?>"><div id="hw_export_xls_button">XLS</div></a>
			</div>
			
			<div class="panel_hw_hsep"></div>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<div class="resize_informer">
	<form id="table-form" action="<?=base_url('/cities/update')?>" method="post" style="display: none;"></form>

	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>

	<table class="default_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="ajax-el-link" data-href="<?=event_build_link( 're_timestamp' )?>">Fecha</th>
				<th class="ajax-el-link" data-href="<?=event_build_link( 're_user_name' )?>">Nombre</th>
				<th class="ajax-el-link" data-href="<?=event_build_link( 're_user_dni' )?>">DNI</th>
				<th class="ajax-el-link" data-href="<?=event_build_link( 're_user_plate' )?>">Patente</th>
				<th class="ajax-el-link" data-href="<?=event_build_link( 're_user_plot' )?>">Lote</th>
				<th class="ajax-el-link" data-href="<?=event_build_link( 're_user_type' )?>">Tipo de Usuario</th>
				<th>Descripción</th>
				<th>Nota</th>
			</tr>
		</thead>
		<tbody>
			<? if ( isset( $events ) ) { foreach ( $events as $person ) { ?>
			<tr id="row_<?=$person['re_id']?>">
				<td><?=strftime('%a %d/%b/%y - %H:%M:%S', $person['re_timestamp'] )?></td>
				<td><?=$person['re_user_name']?></td>
				<td><?=$person['re_user_dni']?></td>
				<td><?=$person['re_user_plate']?></td>
				<td><?=isset($person['re_user_plot'])?SQL::arr_to_str( $person['re_user_plot'] ):''?></td>
				<td><?=RfIdUserType::to_string($person['re_user_type'])?></td>
				<td><?=$this->RfidEvent_model->get_event_desc_full( $person['re_event_type'], $person['re_serial'], $person['re_code'], $person['re_timestamp'], $person['re_packet_type'], $person['re_state'], $person['re_result'], $person['re_validator'] )?></td>
				<td><?=$person['re_note']?></td>
			</tr>
			<? }} ?>
		</tbody>
	</table>
	
	<?=$pagination?>
</div>

<br/><br/><br/><br/><br/><br/>

<script type="text/javascript">
	var form_table	= null;
	
	function company_user_search_select( urfid_id, uid, uname )
	{
		kajax_eval( '<?=base_url('/person/pair')?>',  { urfid_id: urfid_id, uid: uid } );
		
		modal_dialog_close();
	}
	
	$(function()
	{
		panel_register( $('#panel_person_filters') );
		
		form_table	= $('#table-form');
		
		table_register( form_table );
		
		table_header_fixed_register( $('.persons_list_table') );
		
		dropdown_filter_register();
		
		datetime_picker_init( '#from', "<?=$from?>", "'Desde el '" );
		datetime_picker_init( '#to', "<?=$to?>", "'Hasta el '" );
	})
</script>
