<?php
$GLOBALS['is_offside'] = isset( $is_offside );
function person_build_link( $order_by )
{
	if ( $GLOBALS['is_offside'] )
	{
		return base_url( '/dshield/person/offside/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
	}
	
	return base_url( '/dshield/person/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="panel_box panel_box_left_top" id="panel_person_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_name" placeholder="Filtrar por Nombre" value="<?=$urfid_name?>">
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_dni" placeholder="Filtrar por DNI"  value="<?=$urfid_dni?>">
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_plate" placeholder="Filtrar por Patente"  value="<?=$urfid_plate?>">
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_plot" placeholder="Filtrar por Lote"  value="<?=$urfid_plot?>">
				
				<input class="panel_text_input panel_search_hw_input" type="hidden" name="urfid_inside" value="<?=$urfid_inside?>">
				
				<? include( 'person_type_filter.php' ); ?>
				
				<button class="submit_btn" value="submit"><span>Filtrar</span></button>
				
				<br/>
				
				<? if ( !isset( $hide_new_person ) ) { ?>
				<button class="submit_btn" type="button" data-href="<?=base_url('/dshield/person/add')?>" onclick="dshield_person_add(this,true,<?=User()->is_professional()?'true':'false'?>)"><span><?=$new_person?></span></button>
				<? } ?>
			</form>
			
			<div class="panel_hw_hsep"></div>
				
			<div class="left" id="hw_list_count_total"><b><?=$total_persons?></b> Personas</div>
			
			<div class="panel_hw_hsep"></div>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<div class="resize_informer">
	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>

	<table class="default_table persons_list_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="profile_photo">Foto Perfil</th>
				<th class="ajax-el-link" data-href="<?=person_build_link( 'urfid_name' )?>">Nombre</th>
				<th class="ajax-el-link" data-href="<?=person_build_link( 'urfid_user_type' )?>">Tipo de Usuario</th>
				<? if ( !$is_guard && !User()->is_professional() ) { ?>
				<th>RFID</th>
				<? } ?>
				<th>Editar</th>
			</tr>
		</thead>
		<tbody>
			<? if ( isset( $persons ) ) { foreach ( $persons as $person ) { ?>
			<tr id="row_<?=$person['urfid_id']?>" <?=$person['urfid_status'] == RfidUserStatus::SUSPENDED?'class="suspended"':''?>>
				<td class="photo" onclick="dshield_person_photo_change(<?=$person['urfid_id']?>)">
					<? if ( isset( $person['urfid_photo'] ) && !empty( $person['urfid_photo'] ) ) { ?>
						<img src="<?=base_url('/assets/photos/thumbnail/'.$person['urfid_photo'].'.jpg')?>" />
					<? } else { ?>
						<img src="<?=base_url('/assets/images/default_user_image.png')?>" />
					<? } ?>
				</td>
				<td class="name" onclick="dshield_person_edit(<?=$person['urfid_id']?>)">
					<p><?=$person['urfid_name']?></p>
					<span>DNI: <?=$person['urfid_dni']?></span><br/>
					<span>Patente: <?=$person['urfid_plate']?></span><br/>
					<span>Lote: <?=$person['urfid_plot']?></span><br/>
					<span>Teléfono: <?=$person['urfid_phone']?></span>
					<? if ( $person['urfid_company_name'] != '' ) { ?>
					<br/><span>Empresa: <?=$person['urfid_company_name']?></span>
					<? } ?>
				</td>
				<td><?=RfIdUserType::to_string($person['urfid_user_type'])?></td>
				<? if ( !$is_guard && !User()->is_professional() ) { ?>
				<td>
					<? if ( isset( $person['rfid_user'] ) ) {  ?>
					
					<? if ( $person['urfid_status'] == RfidUserStatus::ALLOWED ) { ?>
						<a href="#" onclick="dshield_person_suspend(<?=$person['urfid_id']?>)"><p>Suspender RFID</p></a>
					<? } else { ?>
						<a href="#" onclick="dshield_person_allow(<?=$person['urfid_id']?>)"><p>Habilitar RFID</p></a>
					<? } ?>
					
					<a href="#" onclick="dshield_person_rfid_unset(<?=$person['urfid_id']?>)"><p>Desasignar RFID</p></a>
					<? } else { ?>
					<a href="#" onclick="dshield_person_rfid_set(<?=$person['urfid_id']?>)"><p>Asignar RFID</p></a>
					<? } ?>
				</td>
				<? } ?>
				<td>
					<a href="#" onclick="dshield_person_edit_gallery(<?=$person['urfid_id']?>)"><p>Vehículos y Mascotas</p></a>
					
					<? if ( $person['urfid_user_type'] == RfIdUserType::NEIGHBOR_EMPLOYEE || 
							$person['urfid_user_type'] == RfIdUserType::SERVICE || 
							$person['urfid_user_type'] == RfIdUserType::PROFESSIONAL ||
							$person['urfid_user_type'] == RfIdUserType::WORKER
					) { ?>
						<? if ( !User()->is_professional() ) { ?>
							<a href="#" onclick="dshield_person_edit_hours(<?=$person['urfid_id']?>)"><p>Franja Horaria</p></a>
						<? } ?>
					<? } ?>
					
					
					<? if ( $person['urfid_user_type'] == RfIdUserType::SERVICE || 
							$person['urfid_user_type'] == RfIdUserType::PROFESSIONAL || 
							$person['urfid_user_type'] == RfIdUserType::WORKER || 
							$person['urfid_user_type'] == RfIdUserType::PROVIDER
					) { ?>
						<a href="#" onclick="dshield_person_edit_tools(<?=$person['urfid_id']?>)"><p>Herramientas</p></a>
					<? } ?>
					
					<? if ( $person['urfid_user_type'] == RfIdUserType::WORKER ) { ?>
						<a href="#" onclick="dshield_person_edit_insurance(<?=$person['urfid_id']?>)"><p>Seguro de Trabajo</p></a>
					<? } ?>
					
					<? if ( $person['urfid_user_type'] == RfIdUserType::PROFESSIONAL || $person['urfid_user_type'] == RfIdUserType::GUARD ) { ?>
						<? if ( $person['urfid_uid'] == null ) { ?>
							<a class="assign_user" data-id="<?=$person['urfid_id']?>" data-type="<?=$person['urfid_user_type'] == RfIdUserType::PROFESSIONAL ? 2 : 1?>" href="#"><p>Asignar Usuario</p></a>
						<? } else { ?>
							<a class="assign_user ajax-eval-fancy-confirm-link" data-text="¿Seguro desea desasignar el usuario?" href="<?=base_url('/person/unpair/'.$person['urfid_id'])?>"><p>Desasignar Usuario</p></a>
						<? } ?>
					<? } else if ( $person['urfid_user_type'] == RfIdUserType::OWNER && User()->is_normal_dshield_admin() ) { ?>
						<? if ( $person['urfid_uid'] == null ) { ?>
							<a class="assign_user" data-id="<?=$person['urfid_id']?>" data-type="user" href="#"><p>Asignar Usuario</p></a>
						<? } else { ?>
							<a class="assign_user ajax-eval-fancy-confirm-link" data-text="¿Seguro desea desasignar el usuario?" href="<?=base_url('/person/unpair/'.$person['urfid_id'])?>"><p>Desasignar Usuario</p></a>
						<? } ?>
					<? } ?>
					
					<? if ( User()->is_logged_as_god_or_company() && !User()->is_guard() && !User()->is_professional() ) { ?>
						<a href="#" onclick="dshield_person_entrance(<?=$person['urfid_id']?>)"><p>Tipo de Entrada y Salida</p></a>
					<? } ?>
				</td>
			</tr>
			<? }} ?>
		</tbody>
	</table>
	
	<?=$pagination?>
	
	<? if ( !isset( $hide_new_person ) ) { ?>
	<a id="person_add" data-href="<?=base_url('/dshield/person/add')?>" onclick="dshield_person_add(this,true,<?=User()->is_professional()?'true':'false'?>)"><div class="table_after_right_button"><?=$new_person?></div></a>
	<? } ?>
</div>

<br/><br/><br/><br/><br/><br/>

<? if ( User()->is_professional() ) { ?>
<input type="hidden" name="event_server_time" id="event_server_time" value="<?=time()?>" />
<? } ?>

<script type="text/javascript">
	var form_table	= null;
	
	function user_search_select( urfid_id, uid, uname )
	{
		kajax_eval( '<?=base_url('/person/pair')?>',  { urfid_id: urfid_id, uid: uid } );
		
		modal_dialog_close();
	}
	
	$(function()
	{
		panel_register( $('#panel_person_filters') );
		
		form_table	= $('#table-form');
		
		table_register( form_table );
		
		dropdown_filter_register();
		
		table_header_fixed_register( $('.persons_list_table') );
		
		$('.assign_user').each(
			function()
			{
				var t			= $(this);
				var row_id		= t.data('id');
				var type		= t.data('type');
				var load_url	= '';
				
				if ( 'user' == type )
				{
					load_url	= "<?=base_url('/users/search/')?>" + '/?cb=user_search_select&uid=1&row_id=' + row_id;
				}
				else
				{
					load_url	= "<?=base_url('/companies/search/')?>" + '/?type=' + t.data('type') + '&cb=user_search_select&row_id=' + row_id;
				}
				
				client_search_button_register( t, load_url );
			}
		);
	})
</script>

<? if ( isset( $script ) ) { echo $script; }; ?> 
