<?php

function event_build_link( $order_by )
{
	$base_url = base_url( '/dshield/?' );
	return $base_url . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="person_owner_profile">

<div class="person_profile">
	<div>
		<div class="photo">
			<? if ( isset( $user['urfid_photo'] ) && !empty( $user['urfid_photo'] ) ) { ?>
			<img src="<?=base_url( '/assets/photos/thumbnail/' . $user['urfid_photo'] . '.jpg' )?>" />
			<? } else { ?>
			<img src="<?=base_url('/assets/images/default_user_image.png')?>" />
			<? } ?>
		</div>
		
		<div class="info">
			<h3><?=$user['urfid_name']?></h3>
			
			<p>DNI: <?=$user['urfid_dni']?></p>
			
			<p>Patente: <?=$user['urfid_plate']?></p>
			
			<p>Teléfono: <?=$user['urfid_phone']?></p>
		</div>
		
		<div class="observations">
			<h3>Observaciones: </h3>
			<span><?=$user['urfid_observations']?></span>
		</div>
	</div>
</div>

<? if ( ( isset( $general_photos ) && !empty( $general_photos ) ) || isset( $family ) || isset( $workers ) ) { ?>
<div class="profile_expander">
	<div onclick="profile_toggle()")>
		<div class="sprite-img-flechin-down"></div>
	</div>
</div>
<? } ?>

<?
function create_person_tooltip( $m )
{
?>
					<span class="person_tooltip">
						<p>DNI: <?=$m['urfid_dni']?></p>
						
						<? if ( !empty( $m['urfid_phone'] ) ) { ?>
						<p>Teléfono: <?=$m['urfid_phone']?></p>
						<? } ?>
						
						<? if ( !empty( $m['urfid_plate'] ) ) { ?>
						<p>Patente: <?=$m['urfid_plate']?></p>
						<? } ?>
					</span>
<? 
}
?>

<div class="person_profile_extra">

	<? if ( isset( $family ) ) { ?>
	<div class="boxed_table">
		<div class="owner_title"><div>Grupo Familiar</div></div>
	</div>

	<div class="person_profile">
		<div>
			<? foreach ( $family as $m ) { ?>
				<div class="family_photo">
					<div class="photo">
						<? if ( isset( $m['urfid_photo'] ) && !empty( $m['urfid_photo'] ) ) { ?>
						<img src="<?=base_url( '/assets/photos/thumbnail/' . $m['urfid_photo'] . '.jpg' )?>" />
						<? } else { ?>
						<img src="<?=base_url('/assets/images/default_user_image.png')?>" />
						<? } ?>
					</div>
					<p><?=$m['urfid_name']?></p>
					
					<? create_person_tooltip( $m ) ?>
				</div>
				
			<? } ?>
		</div>
	</div>
	<? } ?>

	<? if ( isset( $workers ) ) { ?>
	<div class="boxed_table">
		<div class="owner_title"><div>Profesionales y Empleados de Obra</div></div>
	</div>

	<div class="person_profile">
		<div>
			<? foreach ( $workers as $m ) { ?>
				<div class="family_photo">
					<div class="photo">
						<? if ( isset( $m['urfid_photo'] ) && !empty( $m['urfid_photo'] ) ) { ?>
						<img src="<?=base_url( '/assets/photos/thumbnail/' . $m['urfid_photo'] . '.jpg' )?>" />
						<? } else { ?>
						<img src="<?=base_url('/assets/images/default_user_image.png')?>" />
						<? } ?>
					</div>
					<p><?=$m['urfid_name']?></p>
					
					<? create_person_tooltip( $m ) ?>
				</div>
				
			<? } ?>
		</div>
	</div>
	<? } ?>
	
	<? if ( isset( $general_photos ) && !empty( $general_photos ) ) { ?>
	<div class="boxed_table">
		<div class="owner_title"><div>Vehículos y Mascotas</div></div>
	</div>

	<div class="person_profile">
		<div>
			<div class="family_photo">
				<? foreach ( $general_photos as $photo ) { ?>
					<div class="photo">
						<? $url = base_url('/assets/photos/' . $photo['rp_path'] . '.jpg' ); ?>
						<a href="<?=$url?>" target="_blank">
							<img src="<?=base_url( '/assets/photos/thumbnail/' . $photo['rp_path'] . '.jpg' )?>" />
						</a>
					</div>
				<? } ?>
			</div>
		</div>
	</div>
	<? } ?>
</div>

<div class="boxed_table">
	<div class="owner_title"><div>Eventos</div></div>

	<div class="utils_box">
		<div>
			<div class="utils_right">
				<button class="submit_btn" type="button" data-href="<?=base_url('/guest/add')?>" onclick="modal_dialog_from_data_href(this)"><span>Nueva Visita</span></button>
				
				<button class="submit_btn" type="button" data-href="<?=base_url('/guest/event_add')?>" onclick="modal_dialog_from_data_href(this)"><span>Nuevo Evento</span></button>
			</div>
		</div>
	</div>
	
	<table class="owner_table guests_table default_table" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="ajax-el-link" data-href="<?=event_build_link( 'name' )?>">Nombre / Evento</th>
				<th class="ajax-el-link" data-href="<?=event_build_link( 'time_start' )?>">Comienza</th>
				<th class="ajax-el-link" data-href="<?=event_build_link( 'time_end' )?>">Finaliza</th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			<? if ( isset( $events ) ) { foreach ( $events as $person ) { ?>
			
			<? $href = ( $person['rve_id'] == 0 ) ? base_url('/guest/edit/'.$person['id']) : base_url('/guest/event_edit/'.$person['id']); ?>
			
			<tr id="row<?=$person['rve_id'] != 0?'e':''?>_<?=$person['id']?>">
				<td data-href="<?=$href?>" onclick="modal_dialog_from_data_href(this)"><?=$person['name']?></td>
				<td data-href="<?=$href?>" onclick="modal_dialog_from_data_href(this)"><?=strftime('%a %d/%b/%y - %H:%M:%S', $person['time_start'] )?></td>
				<td <?=( $person['rve_id'] == 0 )?'colspan="2"':''?> data-href="<?=$href?>" onclick="modal_dialog_from_data_href(this)"><?=strftime('%a %d/%b/%y - %H:%M:%S', $person['time_end'] )?></td>
				<? if ( $person['rve_id'] != 0 ) { ?>
				<td>

					<? if ( $person['rve_id'] != 0 ) { ?>
						<a href="#" data-href="<?=base_url('/dshield/guest/event_visits/'.$person['id'])?>" onclick="modal_dialog_from_data_href(this)">
							<p>Administrar Visitas</p>
						</a>
					<? } ?>
				</td>
				<? } ?>
			</tr>
			<? }} ?>
		</tbody>
	</table>
	
	<?=$pagination?>
</div>

<div class="boxed_table">
	<div class="owner_title"><div>Accesos</div></div>
	<div class="utils_box">
		<div>
			<div class="utils_right">
				<button class="submit_btn ajax-el-link" type="button" data-href="<?=base_url('/dshield/rfid/all')?>"><span>Historial de Accesos</span></button>
			</div>
		</div>
	</div>
</div>

<script type="text/javascript">
	var form_table	= null;
	
	function profile_slide_up()
	{
		var htop = $('.person_profile_extra');
		
		if ( htop.is(":visible") )
		{
			$('.profile_expander > div').children().attr('class','sprite-img-flechin-down');
			
			htop.slideUp( { 'duration' : 250, 'step' : function() { content_update(); resize_callbacks_fire(); } } );
		}
	}

	function profile_slide_down()
	{
		var htop = $('.person_profile_extra');
		
		if ( !htop.is(":visible") )
		{
			$('.profile_expander > div').children().attr('class','sprite-img-flechin-up');
			
			htop.slideDown( { 'duration' : 250, 'step' : function() { content_update(); resize_callbacks_fire(); } } );
		}
	}

	function profile_toggle()
	{
		var htop = $('.person_profile_extra');
		
		if ( htop.is(":visible") )
		{
			profile_slide_up();
		}
		else
		{
			profile_slide_down();
		}
	}

	
	$(function()
	{
		form_table	= $('#table-form');
		
		table_register( form_table );
	})
</script>

</div>
