<?php
function insurance_build_link( $order_by )
{
	return base_url( '/dshield/insurance/all/?' ) . http_build_query_merge_auto( array( 'order_by' => $order_by ) );
}
?>

<div class="panel_box panel_box_left_top" id="panel_person_filters">
	<div class="panel_data_box">
		<div class="panel_data_box_margined">
			<form class="ajax-get-form">
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_name" placeholder="Filtrar por Nombre" value="<?=$urfid_name?>">
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_dni" placeholder="Filtrar por DNI"  value="<?=$urfid_dni?>">
				
				<input class="panel_text_input panel_search_hw_input" type="text" name="urfid_plot" placeholder="Filtrar por Lote"  value="<?=$urfid_plot?>">
				
				<? include( 'person_type_filter.php' ); ?>
				
				<button class="submit_btn" value="submit"><span>Filtrar</span></button>
			</form>
			
			<div class="panel_hw_hsep"></div>
				
			<div class="left" id="hw_list_count_total"><b><?=$total_insurances?></b> seguros sin validar</div>
			
			<div class="panel_hw_hsep"></div>
		</div>
	</div>
	
	<div class="panel_hide_box">
		<div class="panel_lock_but sprite-img-candado-unlock"></div>
	</div>
</div>

<div class="resize_informer">
	<table class="table_header_fixed" align="center" cellpadding="0" cellspacing="0"></table>

	<table class="default_table insurances_list_table<?=empty($pagination)?' insurances_list_table_pager':''?>" align="center" cellpadding="0" cellspacing="0">
		<thead>
			<tr>
				<th class="ajax-el-link" data-href="<?=insurance_build_link( 'urfid_name' )?>">Nombre</th>
				<th class="ajax-el-link" data-href="<?=insurance_build_link( 'urfid_dni' )?>">DNI</th>
				<th class="ajax-el-link" data-href="<?=insurance_build_link( 'urfid_plot' )?>">Lote</th>
				<th class="ajax-el-link" data-href="<?=insurance_build_link( 'urfid_user_type' )?>">Tipo de Usuario</th>
				<th class="ajax-el-link" data-href="<?=insurance_build_link( 'urfid_professional_name' )?>">Profesional a Cargo de Obra</th>
				<th>Seguro</th>
				<th>Vencimiento</th>
				<th>Editar</th>
			</tr>
		</thead>
		<tbody>
			<? if ( isset( $insurances ) ) { foreach ( $insurances as $insu ) { ?>
			<tr id="row_<?=$insu['rp_id']?>">
				<td class="name"><?=$insu['urfid_name']?></td>
				<td><?=$insu['urfid_dni']?></td>
				<td><?=$insu['urfid_plot']?></td>
				<td><?=RfIdUserType::to_string($insu['urfid_user_type'])?></td>
				<td class="multiline"><?=str_replace(',', "\n<br/>", $insu['urfid_professional_name'])?></td>
				<td class="photo">
					<? if ( isset( $insu['rp_path'] ) && !empty( $insu['rp_path'] ) ) { ?>
						<? if ( str_ends_with( $insu['rp_path'], '.pdf' ) ) { ?>
							<a href="<?=base_url('/assets/photos/'.$insu['rp_path'])?>" target="_blank">
								<img width="128px" height="128px" src="<?=base_url('/assets/images/application-pdf.png')?>" />
							</a>
						<? } else { ?>
							<a href="<?=base_url('/assets/photos/'.$insu['rp_path'].'.jpg')?>" target="_blank">
								<img src="<?=base_url('/assets/photos/thumbnail/'.$insu['rp_path'].'.jpg')?>" />
							</a>
						<? } ?>
					<? } ?>
				</td>
				<td>
					<?
						$user_data = json_decode( $insu['urfid_user_data'], TRUE );
						
						if ( isset( $user_data['insurance_expiration'] ) )
						{
							echo timestamp_to_date_str( $user_data['insurance_expiration'] );
						}
					?>
				</td>
				<td>
					<p><a class="assign_user ajax-eval-fancy-confirm-link" data-text="¿Seguro desea validar el seguro de trabajo de <?=$insu['urfid_name']?>?" href="<?=base_url('/insurance/validate/'.$insu['rp_id'])?>">Validar Seguro</a></p>
				</td>
			</tr>
			<? }} ?>
		</tbody>
	</table>
	
	<?=$pagination?>
</div>

<script type="text/javascript">
	var form_table	= null;

	$(function()
	{
		panel_register( $('#panel_person_filters') );
		
		dropdown_filter_register();
		
		table_header_fixed_register();
	})
</script>
