<?php
class User_model extends CI_Model
{
	public function get( $uid, $output = OBJECT )
	{
		return $this->db->get_row( 'SELECT * FROM users WHERE uid = ? LIMIT 1', $output, array( intval( $uid ) ) );
	}
	
	public function get_full( $uid, $output = OBJECT )
	{
		return $this->db->get_row( 'SELECT * FROM users LEFT JOIN users_info ON uid = ui_uid WHERE uid = ? LIMIT 1', $output, array( intval( $uid ) ) );
	}
	
	public function get_info( $uid )
	{
		return $this->db->get_row( 'SELECT * FROM users_info INNER JOIN company ON ui_company = com_id WHERE ui_uid = ? LIMIT 1', OBJECT, array( $uid ) );
	}
	
	public function get_info_from_id( $user_id )
	{
		return $this->db->get_row( 'SELECT * FROM users_info INNER JOIN company ON ui_company = com_id WHERE ui_id = ? LIMIT 1', OBJECT, array( $user_id ) );
	}
	
	public function get_with_password( $name, $pass )
	{
		return $this->db->get_row( 'SELECT * FROM users WHERE uname = ? AND upass = ? LIMIT 1', OBJECT, array( strtolower( $name ), get_password_hash( $pass ) ) );
	}
	
	public function get_mail( $uid )
	{
		$user = $this->get( $uid );
		
		if ( null != $user && isset( $user->umail ) )
		{
			return $user->umail;
		}
		
		return '';
	}
	
	public function from_mail( $email )
	{
		return $this->db->get_row( 'SELECT * FROM users WHERE umail = ? LIMIT 1', ARRAY_A, array( $email ) );
	}
	
	public function from_user_and_token( $uname, $token )
	{
		return $this->db->get_row( 'SELECT * FROM users WHERE uname = ? AND upass_recover_token = ? LIMIT 1', ARRAY_A, array( $uname, $token ) );
	}
	
	public function owns_hw( $ui_id, $hw_id )
	{
		return $this->db->get_var( 'SELECT 1 FROM hardware WHERE hw_user = ? AND hw_id = ?', array( $ui_id, intval( $hw_id ) ) );
	}
	
	public function owns_mac( $ui_id, $hw_serial )
	{
		return $this->db->get_var( 'SELECT 1 FROM hardware WHERE hw_user = ? AND hw_serial = ?', array( $ui_id, intval( $hw_serial ) ) );
	}
	
	public function owns_imei( $uid, $imei )
	{
		return $this->db->get_var( 'SELECT 1 FROM avl_hardware WHERE ahw_uid = ? AND ahw_imei = ?', array( $uid, $imei ) );
	}
	
	public function get_type( $uid )
	{
		return $this->db->get_var( 'SELECT utype FROM users WHERE uid = ?', array( $uid ) );
	}
	
	public function get_company( $uid )
	{
		return $this->db->get_var( 'SELECT ui_company FROM users_info WHERE ui_uid = ?', array( $uid ) );
	}
	
	public function get_users_with_payments_service()
	{
		return $this->db->get_results( 'SELECT * FROM users_info INNER JOIN users ON uid = ui_uid WHERE ui_paystart IS NOT NULL' );
	}
	
	public function suspend( $uid, $suspend )
	{
		$susp = $suspend ? 'SUSPENDED' : 'ACTIVE';
		
		$this->db->set_qd( array( $susp, $uid ) );
		
		return $this->db->query( SQL::make_update_pdo( 'users', array( 'ustate', 'uid' ), 'uid' ) );
	}
	
	public function get_god_global_info()
	{
		$sql = 'SELECT 
					( SELECT COUNT(*) FROM users_info ) AS users_count,
					( SELECT COUNT( sl_uid ) FROM site_log WHERE sl_time > ' . SQL::get_31_days_back() . ') AS logins_count,
					( SELECT COUNT( al_hw_id ) FROM actions_log WHERE al_time > ' . SQL::get_31_days_back() . ' ) AS actions_count';
		
		return $this->db->get_row( $sql );
	}
	
	public function get_hw_count( $ui_id )
	{
		return $this->db->get_var( 'SELECT COUNT(*) as hw_count FROM hardware WHERE hw_user = ?', array( $ui_id ) );
	}

	public static function get_company_filter( $filter_company = NULL, $field_name = 'ui_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}

	public function count( $filter_company, $com_df_code, $filter = '' )
	{
		return $this->get_all( $filter_company, $com_df_code, $filter, NULL, 1, 'COUNT(*)' );
	}
	
	public function get_all( $filter_company, $com_df_code, $filter = NULL, $per_page = NULL, $page_num = 1, $fields_get = 'users_info.*, users.*, company.com_id, company.com_name' )
	{
		$where			= self::get_company_filter( $filter_company );
		$df_filter		= '';
		$hw_inner		= '';
		$is_count		= -1 != str_starts_with( 'COUNT', $fields_get );

		if ( strpos( $filter['filter'], 'hw_code' ) )
		{
			$hw_inner = ' INNER JOIN hardware ON hw_company = ' . intval( $filter_company ) . ' ';
		}
		
		if ( NULL != $com_df_code )
		{
			$df_filter = ' AND ( com_df_id = ' . intval( $com_df_code ) . ' ) ';
		}
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql = 'SELECT ' . $fields_get . ' FROM users_info 
				INNER JOIN users ON ui_uid = uid 
				INNER JOIN company ON ui_company = com_id ' . $df_filter .
				$hw_inner .
				$where;

		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}

	function add( $name, $pass, $mail, $type )
	{
		$fields = array( 'name', 'pass', 'mail', 'type' );
		$values = array( strtolower( $name ), get_password_hash( $pass ), strtolower( $mail ), $type );
		
		$this->db->set_qd( $values );
		
		return $this->db->query( SQL::make_insert_pdo( 'users', $fields, '', 'u' ) );
	}
	
	function edit_mail( $uid, $mail )
	{
		$this->db->set_qd( array( $mail, $uid ) );
		
		$this->db->query( SQL::make_update_pdo( 'users', array( 'umail', 'uid' ), 'uid' ) );
	}
	
	function edit_password( $uid, $pass )
	{
		$this->db->set_qd( array( get_password_hash( $pass ), $uid ) );
		
		$this->db->query( SQL::make_update_pdo( 'users', array( 'upass', 'uid' ), 'uid' ) );
	}
	
	function edit_company( $uid, $com_id )
	{
		$this->db->set_qd( array( $com_id, $uid ) );
		
		$this->db->query( SQL::make_update_pdo( 'users_info', array( 'ui_company', 'ui_uid' ), 'ui_uid' ) );
	}
	
	function edit_city( $uid, $location_id )
	{
		$this->db->set_qd( array( $location_id, $uid ) );
		
		$this->db->query( SQL::make_update_pdo( 'users_info', array( 'ui_city', 'ui_uid' ), 'ui_uid' ) );
	}

	function add_user_info( $uid, $company, $name, $lastname, $phone, $address, $city, $support, $passkey, $observations, $type = 0 )
	{
		$fields = array( 'uid', 'company', 'name', 'lastname', 'phone', 'address', 'city', 'support', 'passkey', 'observations', 'type' );
		$values = array( $uid, $company, $name, $lastname, $phone, $address, $city, $support, $passkey, $observations, $type );
		
		$this->db->set_qd( $values );
		
		return $this->db->query( SQL::make_insert_pdo( 'users_info', $fields, '', 'ui_' ) );
	}

	function create( $form, $com_id, $location_id )
	{
		$this->db->trans_start();
		
		$this->add( $form['uname'], $form['upass'], $form['umail'], USER_TYPE_USER );
		
		$uid = $this->db->insert_id();
		
		$this->add_user_info( $uid, $com_id, $form['name'], $form['lastname'], $form['phone'], $form['address'], $location_id, $form['support'], $form['passkey'], $form['observations'], isset( $form['ui_type'] ) ? $form['ui_type'] : 0 );
		
		$this->db->trans_complete();
		
		return $uid;
	}
	
	function update( $form, $com_id = NULL, $location_id = NULL )
	{
		$this->db->trans_start();
		
		$this->edit_mail( $form['uid'], $form['umail'] );
		
		if ( !empty( $form['upass'] ) )
		{
			$this->edit_password( $form['uid'], $form['upass'] );
		}
		
		if ( NULL != $com_id )
		{
			$this->edit_company( $form['uid'], $com_id );
		}
		
		if ( NULL != $location_id )
		{
			$this->edit_city( $form['uid'], $location_id );
		}
		
		if ( isset( $form['name'] ) && isset( $form['lastname'] ) )
		{
			$this->update_user_info( $form['uid'], $form['name'], $form['lastname'], $form['phone'], $form['address'], $form['support'], $form['passkey'], $form['observations']/*, $form['payfreq'], $form['price'], $form['paystart'], $form['debt_tolerance']*/ );
		}
		
		$this->db->trans_complete();
	}
	
	function update_name_and_phone( $uid, $name, $phone )
	{
		$fields = array( 'name', 'lastname', 'phone', 'uid' );
		$values = array( $name, '', $phone, $uid );
		
		return $this->db->query( SQL::make_update_pdo( 'users_info', $fields, 'uid', '', 'ui_' ), $values );
	}
	
	function update_user_info( $uid, $name, $lastname, $phone, $address, $support, $passkey, $observations/*, $payfreq, $price, $paystart, $debt_tolerance*/ )
	{
		$fields = array( 'name', 'lastname', 'phone', 'address', 'support', 'passkey', 'observations', 'uid'/*, 'payfreq', 'price', 'paystart', 'debt_tolerance'*/ );
		$values = array( $name, $lastname, $phone, $address, $support, $passkey, $observations, $uid/*, $payfreq, $price, $paystart, $debt_tolerance*/ );
		
		$this->db->set_qd( $values );
		
		return $this->db->query( SQL::make_update_pdo( 'users_info', $fields, 'uid', '', 'ui_' ) );
	}
	
	function user_name_exists_off_uid( $uid, $name )
	{
		return $this->db->get_var( 'SELECT COUNT(uname) as users_name_count FROM users WHERE uid != ? AND uname = ?', array( $uid, strtolower( $name ) ) );
	}
	
	function delete( $uid )
	{
		$this->db->trans_start();
		
		$this->db->query( 'UPDATE hardware SET hw_user = 0 WHERE hw_user IN ( SELECT ui_id FROM users_info WHERE ui_uid = ? )', array( $uid ) );
		
		$this->db->query( 'UPDATE avl_hardware SET ahw_uid = NULL WHERE ahw_uid = ?', array( $uid ) );
		
		$this->db->query( 'UPDATE keychain SET key_uid = NULL WHERE key_uid = ?', array( $uid ) );
		
		$this->db->query( 'UPDATE rfid_user SET urfid_uid = NULL WHERE urfid_uid = ?', array( $uid ) );
		
		$this->db->query( SQL::make_delete_pdo( 'users_info', 'ui_uid' ), array( $uid ) );
		
		$this->db->query( SQL::make_delete_pdo( 'users', 'uid' ), array( $uid ) );
		
		$this->db->trans_complete();
	}
	
	function exists_name( $name )
	{
		return $this->db->get_var( 'SELECT 1 FROM users WHERE uname = ? LIMIT 1', array( strtolower( $name ) ) );
	}
	
	public function set_pass_recover( $email, $token, $expire_in_days = 3 )
	{
		$sql = 'UPDATE users SET upass_recover_token = ?, upass_recover_expiration = (' . SQL::get_days_future($expire_in_days) . ') WHERE umail = ?';
		
		return $this->db->query( $sql, array( $token, $email ) );
	}
	
	public function reset_pass_recover( $uid )
	{
		$this->db->query( 'UPDATE users SET upass_recover_token = NULL, upass_recover_expiration = NULL WHERE uid = ?', array( $uid ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$res = $this->db->get_results( 'SELECT uid FROM users INNER JOIN users_info ON ui_uid = uid WHERE ui_company = ?', ARRAY_A, array( $com_id ) );
		
		if ( isset( $res ) )
		{
			foreach ( $res as $row )
			{
				$this->delete( $row['uid'] );
			}
		}
	}
	
	public function flag_as_dshield_user( $uid )
	{
		$this->db->query( 'UPDATE users_info SET ui_type = ' . UserInfoType::USER_INFO_TYPE_DSHIELD . ' WHERE ui_uid = ?', array( $uid ) );
	}
}
