<?php

class TestsLogCompanyGroup_model extends CI_Model
{
	public function get_tests_from_time_range_query( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		$filter = SQL::get_or_filter( $filter_company, 'tlcg_com_id' );
		
		$filter_series = '(' .SQL::get_or_filter( $filter_company, 'hwg_company' ) . ')';
		
		$filter_series = '' != $filter_series ? $filter_series : 'TRUE';
		
		$filter_groups = SQL::get_or_filter( $filter_groups, 'hwg_id' );
		
		if ( '' != $filter_groups )
		{
			$filter_series .= ' AND ' . $filter_groups;
		}
		
		if ( '' != $filter )
		{
			$filter = 'AND (' . $filter . ')';
		}
		
		$c = count( $filter_company );
		
		if ( 0 == $c || $c > 1 )
		{
			$interval	= 300;
		}
		else
		{
			$interval	=  load_model('Company_model')->get_freq( $filter_company[0] ) * 60;
		}
		
		$start_time	= floor( $start_time / $interval ) * $interval;
		
		$series_sql = "( SELECT	hwg_company AS com_id, 
						generate_series AS time, 
						0 AS total, 
						hwg_name AS type,
						(SELECT COUNT(hwgl_hw_id) FROM hardware_group_link INNER JOIN hardware ON hw_id = hwgl_hw_id WHERE hwgl_group = hwg_id) AS total_count
				FROM generate_series( {$start_time} , {$end_time}, {$interval} )
				INNER JOIN hardware_group ON $filter_series
				GROUP BY hwg_company, generate_series, hwg_name, hwg_id
				ORDER BY generate_series ASC, hwg_name ASC ) AS base_series";
		
		$real_sql = "( SELECT	tlcg_com_id AS com_id, 
						tlcg_from_time AS time, 
						SUM(tlcg_tests_count) AS total, 
						hwg_name AS type,
						(SELECT COUNT(hwgl_hw_id) FROM hardware_group_link INNER JOIN hardware ON hw_id = hwgl_hw_id WHERE hwgl_group = hwg_id) AS total_count
				FROM tests_log_company_group
				INNER JOIN hardware_group ON hwg_id = tlcg_group
				WHERE tlcg_from_time >= $start_time AND tlcg_from_time < $end_time $filter
				GROUP BY tlcg_com_id, tlcg_from_time, hwg_name, hwg_id
				ORDER BY tlcg_from_time ASC, hwg_name ASC ) AS tests_log_company_group";
		
		$full_sql	=  "SELECT base_series.com_id, 
								base_series.time, 
								COALESCE(SUM(tests_log_company_group.total),0) AS total, 
								base_series.type, 
								COALESCE(tests_log_company_group.total_count,base_series.total_count,0) AS total_count
						FROM {$series_sql}
						LEFT JOIN {$real_sql} ON 
								base_series.time = tests_log_company_group.time AND
								base_series.com_id = tests_log_company_group.com_id AND 
								base_series.type = tests_log_company_group.type
						GROUP BY base_series.com_id, base_series.time, base_series.type, COALESCE(tests_log_company_group.total_count,base_series.total_count,0)";
		
		return $full_sql;
	}
	
	public function get_tests_from_time_range( $start_time, $end_time, $filter_company = NULL )
	{
		return $this->db->get_results( $this->get_tests_from_time_range_query( $start_time, $end_time, $filter_company ), ARRAY_A );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM tests_log_company_group WHERE tlcg_com_id = ?', array( $com_id ) );
	}
}
