<?php

class TestsLogCompany_model extends CI_Model
{
	public function get_tests_from_time_range_query( $start_time, $end_time, $filter_company = NULL )
	{
		$filter = SQL::get_or_filter( $filter_company, 'tlc_com_id' );
		
		$filter_series = SQL::get_or_filter( $filter_company, 'com_id' );
		
		$filter_series = '' != $filter_series ? $filter_series : 'TRUE';
		
		if ( '' != $filter )
		{
			$filter = 'AND (' . $filter . ')';
		}
		
		$c = NULL != $filter_company ? count( $filter_company ) : 0;
		
		if ( 0 == $c || $c > 1 )
		{
			$interval	= 300;
		}
		else
		{
			$interval	=  load_model('Company_model')->get_freq( $filter_company[0] ) * 60;
		}
		
		$start_time	= floor( $start_time / $interval ) * $interval;
		
		$series_sql = "( SELECT	com_id AS com_id,  
						generate_series AS time, 
						0 AS total, 
						com_name AS type,
						0 AS total_count
				FROM generate_series( {$start_time} , {$end_time}, {$interval} )
				INNER JOIN company ON $filter_series
				GROUP BY com_id, generate_series, com_name
				ORDER BY generate_series ASC, com_name ASC ) AS base_series";
		
		
		$real_sql = "( SELECT tlc_com_id AS com_id, 
						tlc_from_time AS time, 
						SUM(tlc_tests_count) AS total, 
						com_name AS type,
						(SELECT COUNT(hw_id) FROM hardware WHERE hw_company = com_id) AS total_count 
				FROM tests_log_company
				INNER JOIN company ON tlc_com_id = com_id
				WHERE tlc_from_time >= $start_time AND tlc_from_time < $end_time $filter
				GROUP BY tlc_com_id, tlc_from_time, com_name, com_id
				ORDER BY tlc_from_time ASC, com_name ASC ) AS tests_log_company";
		
		$full_sql	=  "SELECT base_series.com_id, 
								base_series.time, 
								COALESCE(tests_log_company.total,0) AS total, 
								base_series.type, 
								COALESCE(tests_log_company.total_count,0) AS total_count
						FROM {$series_sql}
						LEFT JOIN {$real_sql} ON base_series.time = tests_log_company.time";
		
		return $full_sql;
	}
	
	public function get_tests_from_time_range_total_rows( $start_time, $end_time, $filter_company )
	{
		$sql = 'SELECT COUNT(DISTINCT q1.time) FROM (' . $this->get_tests_from_time_range_query( $start_time, $end_time, $filter_company ) . ') AS q1';
		return $this->db->get_var( $sql );
	}
	
	public function get_tests_from_time_range( $start_time, $end_time, $filter_company = NULL )
	{
		return $this->db->get_results( $this->get_tests_from_time_range_query( $start_time, $end_time, $filter_company ), ARRAY_A );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM tests_log_company WHERE tlc_com_id = ?', array( $com_id ) );
	}
}
