<?php
require_once( MODEL_PATH . 'hardware_model.php' );
require_once( FRAMES_PATH . 'frame_utils.php' );

class TestStateProgressive
{
	const EXCELLENT	= 'excellent';
	const GOOD_7	= 'good_7';
	const GOOD_8	= 'good_8';
	const GOOD_9	= 'good_9';
	const GOOD_10	= 'good_10';
	const LOW_1		= 'low_1';
	const LOW_2		= 'low_2';
	const LOW_3		= 'low_3';
	const LOW_4		= 'low_4';
	const LOW_5		= 'low_5';
	const LOW_6		= 'low_6';
	const DEAD		= 'dead';
}

class TestsLog_model extends CI_Model
{
	private function get_tests_from_time_range_query( $table, $start_time, $end_time, $agroupation )
	{
		$grouping = !empty( $agroupation ) ? "GROUP BY $agroupation" : '';
		
		$sql = "SELECT hw_company, com_name, tl_from_time, SUM(tl_tests_count) as tl_test_sum 
							FROM $table 
							INNER JOIN hardware ON hw_id = tl_hw_id
							INNER JOIN company ON com_id = hw_company
							WHERE tl_from_time >= $start_time AND tl_from_time < $end_time 
							$grouping
							ORDER BY tl_from_time ASC, hw_company ASC";
		
		return $sql;
	}
	
	private function get_table_name( $start_time, $end_time, &$query_both )
	{
		$table		= 'tests_log';
		$now		= time();
		$query_both	= FALSE;
		
		if ( $now - $start_time > TESTS_LOG_TIMEOUT_SECONDS )
		{
			// So, if the range is always in the tl history range, use that table
			if ( $now - $end_time > TESTS_LOG_TIMEOUT_SECONDS )
			{
				$table	= 'tests_log_history';
			}
			// Otherwise we need to make two queries
			else
			{
				$query_both	= TRUE;
			}
		}
		
		return $table;
	}
	
	public function get_tests_from_time_range( $start_time, $end_time, $agroupation = 'hw_company, com_name, tl_from_time' )
	{
		$db = db_get();
		
		$query_both	= FALSE;
		$table		= self::get_table_name( $start_time, $end_time, $query_both );
		
		$res	= $db->get_results( self::get_tests_from_time_range_query( $table, $start_time, $end_time, $agroupation ), ARRAY_A );
		
		if ( $query_both )
		{
			$old_tests	= $db->get_results( self::get_tests_from_time_range_query( 'tests_log_history', $start_time, $end_time, $agroupation ), ARRAY_A );
			
			if ( null != $old_tests )
			{
				$res	= array_merge( $res, $old_tests );
			}
		}
		
		return $res;
	}
	
	private function get_tests_state_by_hour_sql( $start_time, $end_time, $test_state = '', $filter_company = NULL )
	{
		$query_both	= FALSE;
		$table		= self::get_table_name( $start_time, $end_time, $query_both );
		$test_sql	= 'TRUE';
		
		switch( $test_state )
		{
			case TestState::DEAD:
			{
				$test_sql	= 'tl_tests_count < 1';
				break;
			}
			case TestState::LOW:
			{
				$test_sql	= 'tl_tests_count >= 1 AND tl_tests_count < 7';
				break;
			}
			case TestState::GOOD:
			{
				$test_sql	= 'tl_tests_count >= 7 AND tl_tests_count <= 10';
				break;
			}
			case TestState::EXCELLENT:
			{
				$test_sql	= 'tl_tests_count >= 11';
				break;
			}
		}
		
		$filter = Hardware_model::get_company_filter( $filter_company );
		
		if ( '' != $filter )
		{
			$filter = 'AND (' . $filter . ')';
		}
		
		$sql = "SELECT tl_from_time, COUNT(hw_id) AS count
				FROM hardware
				LEFT JOIN $table ON tl_hw_id = hw_id AND tl_from_time >= $start_time AND tl_from_time <= $end_time
				WHERE $test_sql $filter
				GROUP BY tl_from_time
				ORDER BY tl_from_time ASC";
		
		if ( $query_both )
		{
			$sql = '(' . $sql . ') UNION ALL (' . str_replace( 'tests_log', 'tests_log_history', $sql ) . ')';
		}
		
		return $sql;
	}
	
	private function get_tests_state_by_hour( $start_time, $end_time, $test_state = '', $filter_company = NULL )
	{
		return db_get()->get_results( self::get_tests_state_by_hour_sql( $start_time, $end_time, $test_state, $filter_company ), ARRAY_A );
	}
	
	public function get_tests_states_by_hour( $start_time, $end_time, $filter_company = NULL )
	{
		$sql = "SELECT
					COALESCE(LOW.tl_from_time, GOOD.tl_from_time, EXCELLENT.tl_from_time) AS tl_from_time, 
					COALESCE(MAX(LOW.COUNT),0) AS low_count, 
					COALESCE(MAX(GOOD.COUNT),0) AS good_count, 
					COALESCE(MAX(EXCELLENT.COUNT),0) AS excellent_count, 
					COALESCE(TOTAL.count, 0) AS total_count
				FROM 
				(". Hardware_model::get_count_sql( $filter_company ) . ") AS TOTAL,
				(". self::get_tests_state_by_hour_sql( $start_time, $end_time, TestState::LOW, $filter_company ) . ") AS LOW
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql( $start_time, $end_time, TestState::GOOD, $filter_company ) . ") AS GOOD ON GOOD.tl_from_time = LOW.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql( $start_time, $end_time, TestState::EXCELLENT, $filter_company ) . ") AS EXCELLENT ON EXCELLENT.tl_from_time = LOW.tl_from_time
				GROUP BY COALESCE(LOW.tl_from_time, GOOD.tl_from_time, EXCELLENT.tl_from_time), TOTAL.count
				ORDER BY COALESCE(LOW.tl_from_time, GOOD.tl_from_time, EXCELLENT.tl_from_time)";
		
		$res = db_get()->get_results( $sql, ARRAY_A );
		
		return $res;
	}
	
	private function get_tests_state_by_hour_sql_prog( $start_time, $end_time, $test_state = '', $filter_company = NULL, $filter_groups = NULL )
	{
		$query_both	= FALSE;
		$table		= self::get_table_name( $start_time, $end_time, $query_both );
		$test_sql	= 'TRUE';
		
		switch( $test_state )
		{
			case TestStateProgressive::DEAD:		$test_sql	= 'tl_tests_count < 1';		break;
			case TestStateProgressive::LOW_1:		$test_sql	= 'tl_tests_count = 1';		break;
			case TestStateProgressive::LOW_2:		$test_sql	= 'tl_tests_count = 2';		break;
			case TestStateProgressive::LOW_3:		$test_sql	= 'tl_tests_count = 3';		break;
			case TestStateProgressive::LOW_4:		$test_sql	= 'tl_tests_count = 4';		break;
			case TestStateProgressive::LOW_5:		$test_sql	= 'tl_tests_count = 5';		break;
			case TestStateProgressive::LOW_6:		$test_sql	= 'tl_tests_count = 6';		break;
			case TestStateProgressive::GOOD_7:		$test_sql	= 'tl_tests_count = 7';		break;
			case TestStateProgressive::GOOD_8:		$test_sql	= 'tl_tests_count = 8';		break;
			case TestStateProgressive::GOOD_9:		$test_sql	= 'tl_tests_count = 9';		break;
			case TestStateProgressive::GOOD_10:		$test_sql	= 'tl_tests_count = 10';	break;
			case TestStateProgressive::EXCELLENT:	$test_sql	= 'tl_tests_count >= 11';	break;
		}
		
		$filter = Hardware_model::get_company_filter( $filter_company );
		
		if ( '' != $filter )
		{
			$filter = 'AND (' . $filter . ')';
		}
		
		$groups_filter = '';
		
		if ( '' != $filter_groups )
		{
			$groups_filter	= 'INNER JOIN hardware_group_link ON hw_id = hwgl_hw_id AND ' . $filter_groups;
		}
		
		$sql = "SELECT tl_from_time, COUNT(hw_id) AS count
				FROM hardware
				LEFT JOIN $table ON tl_hw_id = hw_id AND tl_from_time >= $start_time AND tl_from_time <= $end_time 
				$groups_filter
				WHERE $test_sql $filter
				GROUP BY tl_from_time
				ORDER BY tl_from_time ASC";
		
		if ( $query_both )
		{
			$sql = '(' . $sql . ') UNION ALL (' . str_replace( 'tests_log', 'tests_log_history', $sql ) . ')';
		}
		
		return $sql;
	}
	
	public function get_tests_states_by_hour_prog( $start_time, $end_time, $filter_company = NULL, $filter_groups = NULL )
	{
		$sql = "SELECT
					COALESCE(LOW_1.tl_from_time,LOW_2.tl_from_time,LOW_3.tl_from_time,LOW_4.tl_from_time,LOW_5.tl_from_time,LOW_6.tl_from_time,GOOD_7.tl_from_time,GOOD_8.tl_from_time,GOOD_9.tl_from_time,GOOD_10.tl_from_time,EXCELLENT.tl_from_time) AS tl_from_time, 
					COALESCE(MAX(LOW_1.COUNT),0) AS low_1_count, 
					COALESCE(MAX(LOW_2.COUNT),0) AS low_2_count, 
					COALESCE(MAX(LOW_3.COUNT),0) AS low_3_count, 
					COALESCE(MAX(LOW_4.COUNT),0) AS low_4_count, 
					COALESCE(MAX(LOW_5.COUNT),0) AS low_5_count, 
					COALESCE(MAX(LOW_6.COUNT),0) AS low_6_count, 
					COALESCE(MAX(GOOD_7.COUNT),0) AS good_7_count, 
					COALESCE(MAX(GOOD_8.COUNT),0) AS good_8_count, 
					COALESCE(MAX(GOOD_9.COUNT),0) AS good_9_count, 
					COALESCE(MAX(GOOD_10.COUNT),0) AS good_10_count, 
					COALESCE(MAX(EXCELLENT.COUNT),0) AS excellent_count, 
					COALESCE(TOTAL.count, 0) AS total_count
				FROM 
				(". Hardware_model::get_count_sql( $filter_company ) . ") AS TOTAL,
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::LOW_1, $filter_company, $filter_groups ) . ") AS LOW_1
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::LOW_2, $filter_company, $filter_groups ) . ") AS LOW_2 ON LOW_2.tl_from_time = LOW_1.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::LOW_3, $filter_company, $filter_groups ) . ") AS LOW_3 ON LOW_3.tl_from_time = LOW_2.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::LOW_4, $filter_company, $filter_groups ) . ") AS LOW_4 ON LOW_4.tl_from_time = LOW_3.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::LOW_5, $filter_company, $filter_groups ) . ") AS LOW_5 ON LOW_5.tl_from_time = LOW_4.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::LOW_6, $filter_company, $filter_groups ) . ") AS LOW_6 ON LOW_6.tl_from_time = LOW_5.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::GOOD_7, $filter_company, $filter_groups ) . ") AS GOOD_7 ON GOOD_7.tl_from_time = LOW_6.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::GOOD_8, $filter_company, $filter_groups ) . ") AS GOOD_8 ON GOOD_8.tl_from_time = GOOD_7.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::GOOD_9, $filter_company, $filter_groups ) . ") AS GOOD_9 ON GOOD_9.tl_from_time = GOOD_8.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestStateProgressive::GOOD_10, $filter_company, $filter_groups ) . ") AS GOOD_10 ON GOOD_10.tl_from_time = GOOD_9.tl_from_time
				FULL OUTER JOIN 
				(". self::get_tests_state_by_hour_sql_prog( $start_time, $end_time, TestState::EXCELLENT, $filter_company, $filter_groups ) . ") AS EXCELLENT ON EXCELLENT.tl_from_time = LOW_1.tl_from_time
				GROUP BY COALESCE(LOW_1.tl_from_time,LOW_2.tl_from_time,LOW_3.tl_from_time,LOW_4.tl_from_time,LOW_5.tl_from_time,LOW_6.tl_from_time,GOOD_7.tl_from_time,GOOD_8.tl_from_time,GOOD_9.tl_from_time,GOOD_10.tl_from_time,EXCELLENT.tl_from_time), TOTAL.count
				ORDER BY COALESCE(LOW_1.tl_from_time,LOW_2.tl_from_time,LOW_3.tl_from_time,LOW_4.tl_from_time,LOW_5.tl_from_time,LOW_6.tl_from_time,GOOD_7.tl_from_time,GOOD_8.tl_from_time,GOOD_9.tl_from_time,GOOD_10.tl_from_time,EXCELLENT.tl_from_time)";
		
		$res = db_get()->get_results( $sql, ARRAY_A );
		
		return $res;
	}
}
