<?php

class Test_model extends CI_Model
{
	public static function get_company_filter( $filter_company = NULL, $field_name = 'hw_company' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function add( $com_id, $hw_id, $timestamp )
	{
		$this->db->query( SQL::make_insert_pdo( 'test', array( 'com_id', 'hw_id', 'timestamp' ), '', 'test_' ), array( $com_id, $hw_id, $timestamp ) );
	}
	
	public function get_all( $time_start, $time_end, $filter_company = NULL, $filter = NULL )
	{
		$where		= self::get_company_filter( $filter_company );
		SQL::prepare_filter( $where, SQL::build_query_filter( $filter ), FALSE );
		
		$sql = 'SELECT	hw_id,
						hw_name,
						hw_lat,
						hw_long,
						hw_code,
						hw_serial,
						hw_icon,
						hw_inst_time,
						hw_imei,
						hw_core,
						hw_address,
						hw_setup_signal_filtered,
						hw_inst_time_3g,
						hw_setup_signal_3g,
						hw_setup_signal_total_3g,
						hw_setup_signal_total_xbee,
						ui_name, 
						ui_lastname, 
						loc_name,
						com_hw_report_freq, 
						com_hw_state_low, 
						com_hw_state_good, 
						( SELECT string_agg(hwg_name, \'~\') FROM hardware_group_link INNER JOIN hardware_group ON hwg_id = hwgl_group WHERE hwgl_hw_id = hw_id ) AS hw_groups,
						( SELECT COUNT(*) FROM test WHERE test_timestamp >= ' . $time_start . ' AND test_timestamp <= ' . $time_end . ' AND test_hw_id = hw_id ) AS count
				FROM hardware
				LEFT JOIN users_info ON hw_user = ui_id
				INNER JOIN company ON hw_df_company = com_df_id AND hw_df_receiver = com_rec_id
				INNER JOIN locations ON hw_city = loc_id ' . 
				$where;
		
		return $this->db->get_results( $sql, ARRAY_A );
	}
	
	public function get_hw_id( $time_start, $time_end, $hw_id, $filter = NULL )
	{
		if ( NULL == $filter ) $filter = array();
		
		$filter[] = array(	'field_name'	=>	'hw_id',
							'filter_val'	=>	$hw_id );
		
		return $this->get_all( $time_start, $time_end, NULL, $filter );
	}
	
	public function get_user_id( $time_start, $time_end, $user_id, $filter = NULL )
	{
		if ( NULL == $filter ) $filter = array();
		
		$filter[] = array(	'field_name'	=>	'hw_user',
							'filter_val'	=>	$user_id );
		
		return $this->get_all( $time_start, $time_end, NULL, $filter );
	}
}