<?php
class Template_model extends CI_Model
{
	protected $user;
	protected $type;
	protected $table_name;
	protected $table_namen;
	protected $abbr;
	protected $abbrn;
	protected $hw_id;
	protected $res				= null;
	
	protected $actions_fields	= array( 'var', 'code', 'id' );
	protected $events_fields	= array( 'var', 'code', 'partition', 'type', 'qualifier', 'zone', 'emergency', 'id' );
	protected $actions_abbr		= '';
	protected $events_abbr		= '';
	
	protected $cur_fields		= null;
	protected $extra_field		= null;
	protected $extra_field_val	= null;
	
	function __construct( $type, $hw_id = 0 )
	{
		$this->init( $type, $hw_id );
	}
	
	protected function fields_to_cs( $fields, $abbr )
	{
		$str = '';
		
		if ( isset( $fields ) && !empty( $fields ) )
		{
			foreach ( $fields AS $f )
			{
				$str .= $abbr . '_' . $f . ' AS ' . $f . ',';
			}
		}
		
		if ( '' != $str )
		{
			$str = substr( $str, 0, strlen( $str ) - 1 );
		}
		
		return $str;
	}
	
	protected function fields_to_cs_from_type( $type, $fabbr = NULL )
	{
		$fields = 'actions' == $type ? $this->actions_fields : $this->events_fields;
		$abbr = 'actions' == $type ? $this->actions_abbr : $this->events_abbr;
		
		if ( NULL != $fabbr )
		{
			$abbr = $fabbr;
			
			if ( 'cet' == $fabbr )
			{
				array_remove_value( $fields, 'notifications' );
				array_remove_value( $fields, 'filter_act' );
				array_remove_value( $fields, 'mail' );
			}
		}
		
		return $this->fields_to_cs( $fields, $abbr );
	}
	
	function init( $type, $hw_id = 0 )
	{
		$this->user			= User();
		$this->hw_id		= $hw_id;
		$this->type			= $type;
		$table_end			= $type.'_tpl';
		$table_endn			= '';
		
		if ( $this->hw_id != 0 && 'events' == $type )
		{
			array_pop( $this->events_fields );
			array_push( $this->events_fields, 'notifications' );
			array_push( $this->events_fields, 'filter_act' );
			array_push( $this->events_fields, 'mail' );
			array_push( $this->events_fields, 'id' );
		}
		
		if ( 'actions' == $type )
		{
			$this->cur_fields = $this->actions_fields;
			
			$table_endn = 'events_tpl';
		}
		else
		{
			$this->cur_fields = $this->events_fields;
			
			if ( $this->user->get_real_type() == USER_TYPE_USER )
			{
				$this->cur_fields = $this->actions_fields; // Users only can edit basic fields
			}
			
			$table_endn = 'actions_tpl';
		}

		if ( 0 != $hw_id )
		{
			$this->table_name 		= 'hardware_'.$table_end;
			$this->table_namen		= 'hardware_'.$table_endn;
			
			$this->actions_abbr		= 'hat';
			$this->events_abbr		= 'het';
			
			$this->extra_field		= 'hw_id';
			$this->extra_field_val	= $hw_id;
		}
		else
		{
			switch ( $this->user->get_type() )
			{
				case USER_TYPE_USER:
				{
					die();
				}
				case USER_TYPE_CPNY:
				case USER_TYPE_CPNY_RO:
				{
					$this->table_name 		= 'company_'.$table_end;
					$this->table_namen		= 'company_'.$table_endn;
					
					$this->actions_abbr		= 'cat';
					$this->events_abbr		= 'cet';

					$this->extra_field		= 'company_id';
					$this->extra_field_val	= $this->user->get_type_id();

					break;
				}
				case USER_TYPE_GOD:
				{
					$this->table_name 	= $table_end;
					$this->table_namen	= $table_endn;
					
					$this->actions_abbr	= 'at';
					$this->events_abbr	= 'et';
					
					break;
				}
			}
		}
		
		if ( 'actions' == $type )
		{
			$this->abbr 	= $this->actions_abbr;
			$this->abbrn	= $this->events_abbr;
		}
		else
		{
			$this->abbr 	= $this->events_abbr;
			$this->abbrn	= $this->actions_abbr;
		}
		
		$this->check_exists();
	}
	
	protected function check_exists()
	{
		$this->check_exists_step( $this->user->get_type() );
	}
	
	protected function check_exists_step( $type )
	{
		if ( 0 != $this->hw_id )
		{
			if ( 0 == $this->exists_for_hw( $this->table_name, $this->abbr, $this->hw_id ) )
			{
				if ( 'actions' == $this->type )
				{
					$this->create_actions_for_hw( $this->hw_id );
				}
				else if ( 'events' == $this->type )
				{
					$this->create_events_for_hw( $this->hw_id );
				}
			}
			
			if ( 0 == $this->exists_for_hw( $this->table_namen, $this->abbrn, $this->hw_id ) )
			{
				if ( 'actions' == $this->type )
				{
					$this->create_events_for_hw( $this->hw_id );
				}
				else if ( 'events' == $this->type )
				{
					$this->create_actions_for_hw( $this->hw_id );
				}
			}
		}
		else
		{
			switch ( $type )
			{
				case USER_TYPE_GOD:
				{
					if ( 	0 == $this->exists_for_god( 'actions_tpl' ) && 
							0 == $this->exists_for_god( 'events_tpl' ) )
					{
						$this->create_actions_for_god();
						$this->create_events_for_god();
					}
					
					break;
				}
				case USER_TYPE_CPNY:
				case USER_TYPE_CPNY_RO:
				{
					if (	0 == $this->exists_for_company( $this->table_name, $this->abbr, $this->user->get_type_id() ) && 
							0 == $this->exists_for_company( $this->table_namen, $this->abbrn, $this->user->get_type_id() ) )
					{
						$this->create_actions_for_company( $this->user->get_type_id() );
						$this->create_events_for_company( $this->user->get_type_id() );
					}
				
					break;
				}
			}
		}
	}
	
	function exists_for_hw( $table, $abbr, $hw_id )
	{
		return $this->db->get_var( 'SELECT COUNT(*) AS table_exists FROM '.$table.' WHERE '.$abbr.'_hw_id ='.$hw_id );
	}
	
	function exists_for_god( $table )
	{
		return $this->db->get_var( 'SELECT COUNT(*) AS table_exists FROM '.$table );
	}
	
	function exists_for_company( $table, $abbr, $company )
	{
		return $this->db->get_var( 'SELECT COUNT(*) AS table_exists FROM '.$table.' WHERE '.$abbr.'_company_id ='.$company );
	}

	function hw_get_company( $hw_id )
	{
		$this->db->set_qd( array( $hw_id ) );
		
		return $this->db->get_var( 'SELECT hw_company FROM hardware WHERE hw_id = ?' );
	}
	
	function create_actions_for_god()
	{
		$this->db->trans_start();
		
		for ( $i = 0; $i < 8; $i++ )
		{
			$fields = array( 'at_var', 'at_code');
			$values = array( 'empty', $i );
		
			$this->db->set_qd( $values );
		
			$this->db->query( SQL::make_insert_pdo( 'actions_tpl', $fields ) );
		}
		
		$this->db->trans_complete();
	}
	
	function create_events_for_god()
	{
		$this->db->trans_start();
		
		for ( $i = 0; $i < 8; $i++ )
		{
			$fields = array( 'et_var', 'et_code', 'et_partition', 'et_zone' );
			$values = array( 'empty', $i, $i, $i );
			
			$this->db->set_qd( $values );
			
			$this->db->query( SQL::make_insert_pdo( 'events_tpl', $fields ) );
		}
		
		$this->db->trans_complete();
	}

	function create_actions_for_hw( $hw_id )
	{
		$this->db->trans_start();
		
		$company = $this->hw_get_company( $hw_id );
		
		if ( isset( $company ) )
		{
			$res = $this->get_from_company( 'actions', $company, 'cat' );
			
			if ( !isset( $res ) )
			{
				$this->create_actions_for_company( $company );
				
				$res = $this->get_from_company( 'actions', $company, 'cat' );
			}
			
			if ( isset( $res ) )
			{
				foreach ( $res as $row )
				{	
					$fields = array( 'hat_var', 'hat_code', 'hat_hw_id' );
					$values = array( $row['var'], $row['code'], $hw_id );
					
					$this->db->set_qd( $values );
				
					$this->db->query( SQL::make_insert_pdo( 'hardware_actions_tpl', $fields ) );
				}
			}
		}
		
		$this->db->trans_complete();
	}
	
	function create_events_for_hw( $hw_id )
	{
		$this->db->trans_start();
		
		$company = $this->hw_get_company( $hw_id );
		
		if ( isset( $company ) )
		{
			$res = $this->get_from_company( 'events', $company, 'cet' );
			
			if ( isset( $res ) )
			{
				foreach ( $res as $row )
				{
					$fields = array( 'het_var', 'het_code', 'het_partition', 'het_zone', 'het_type', 'het_qualifier', 'het_emergency', 'het_hw_id' );
					$values = array( $row['var'], $row['code'], $row['partition'], $row['zone'], $row['type'], $row['qualifier'], $row['emergency'], $hw_id );
					
					$this->db->set_qd( $values );
					
					$this->db->query( SQL::make_insert_pdo( 'hardware_events_tpl', $fields ) );
				}
			}
		}
		
		$this->db->trans_complete();
	}
	
	function get_from_god( $type, $output = ARRAY_A )
	{
		$let = substr($type,0,1);
		$sql = 'SELECT ' . $this->fields_to_cs_from_type( $type, $let . 't' ) . ' FROM ' . $type . '_tpl ORDER BY ' . $let . 't_id ASC';
		
		return $this->db->get_results( $sql, $output );
	}

	function get_from_company( $type, $company, $abbr = NULL, $output = ARRAY_A )
	{
		$let = substr($type,0,1);
		$sql = 'SELECT ' . $this->fields_to_cs_from_type( $type, $abbr ) . ' FROM company_' . $type . '_tpl WHERE c' . $let . 't_company_id = ' . $company . ' ORDER BY c' . $let . 't_id ASC';
		
		return $this->db->get_results( $sql, $output );
	}
	
	function get_from_hw( $type, $hw_id, $output = ARRAY_A )
	{
		$let = substr($type,0,1);
		$sql = 'SELECT ' . $this->fields_to_cs_from_type( $type ) . ' FROM hardware_' . $type . '_tpl WHERE h' . $let . 't_hw_id = '.$hw_id.' ORDER BY h' . $let . 't_id ASC';
		
		return $this->db->get_results( $sql, $output );
	}

	function create_actions_for_company( $company )
	{
		$this->db->trans_start();
		
		$res = $this->get_from_god( 'actions' );
		
		foreach ( $res as $row )
		{
			$fields = array( 'cat_var', 'cat_code', 'cat_company_id' );
			$values = array( $row['var'], $row['code'], $company );
			
			$this->db->set_qd( $values );
		
			$this->db->query( SQL::make_insert_pdo( 'company_actions_tpl', $fields ) );
		}
		
		$this->db->trans_complete();
	}

	function create_events_for_company( $company )
	{
		$this->db->trans_start();
		
		$res = $this->get_from_god( 'events' );
		
		foreach ( $res as $row )
		{
			$fields = array( 'cet_var', 'cet_code', 'cet_partition', 'cet_zone', 'cet_type', 'cet_qualifier', 'cet_emergency', 'cet_company_id' );
			$values = array( $row['var'], $row['code'], $row['partition'], $row['zone'], $row['type'], $row['qualifier'], $row['emergency'], $company );
			
			$this->db->set_qd( $values );
			
			$this->db->query( SQL::make_insert_pdo( 'company_events_tpl', $fields ) );
		}
		
		$this->db->trans_complete();
	}

	function get_data() 
	{
		if ( 0 != $this->hw_id )
		{
			$this->res = $this->get_from_hw( $this->type, $this->hw_id );
		}
		else
		{
			switch ( $this->user->get_type() )
			{
				case USER_TYPE_USER:
				case USER_TYPE_CPNY:
				case USER_TYPE_CPNY_RO:
				{
					$this->res = $this->get_from_company( $this->type, $this->user->get_type_id() );
					
					break;
				}
				case USER_TYPE_GOD:
				{
					$this->res = $this->get_from_god( $this->type );
					
					break;
				}
			}
		}
		
		return $this->res;
	}
	
	public function delete_id( $id )
	{
		$this->db->query( 'DELETE FROM ' . $this->table_name . ' WHERE ' . $this->abbr . '_' . 'id = ?', array( $id ) ); 
	}
	
	public function update_all( $form )
	{
		$new_ids = array();
		
		$this->db->trans_start();
		
		$arr = form_to_array( $form, $this->cur_fields );
		
		foreach ( $arr as $row_id=>$row )
		{
			$tvals = array();
			
			foreach ( $this->cur_fields as $keys )
			{
				if ( 'id' != $keys )
				{
					if ( 'var' == $keys || 'mail' == $keys )
					{
						array_push( $tvals, $row[ $keys ] );
					}
					else if ( 'notifications' == $keys || 'filter_act' == $keys )
					{
						array_push( $tvals, isset( $row[ $keys ] ) ? 'true' : 'false' );
					}
					else if ( 'emergency' == $keys )
					{
						array_push( $tvals, isset( $row[$keys] ) ? 1 : 0 );
					}
					else
					{
						$val = $row[ $keys ];
						
						// Replace the asterisc for a value that represents 'anything'
						if ( '*' == $val )
						{
							if ( 'zone' == $keys )
							{
								$val = 'FFFFFF';
							}
							else if ( 'partition' == $keys )
							{
								$val = 'FFFFFF';
							}
						}
						
						array_push( $tvals, hexdec( $val ) );
					}
				}
			}
			
			if ( $row_id > 0 )
			{
				array_push( $tvals, $row_id );
				
				$values = $tvals;
				
				$this->db->query( SQL::make_update_pdo( $this->table_name, $this->cur_fields, 'id', '', $this->abbr . '_' ), $values );
			}
			else
			{
				$fields = $this->cur_fields;
				
				array_pop( $fields ); // Removes id from the fields, since is auto increment
				
				$values = $tvals;
				
				if ( null != $this->extra_field && null != $this->extra_field_val )
				{
					array_push( $fields, $this->extra_field );
					array_push( $values, $this->extra_field_val );
				}
				
				$this->db->query( SQL::make_insert_pdo( $this->table_name, $fields, '', $this->abbr . '_' ), $values );
				
				$new_ids[ abs($row_id) ] = $this->db->last_insert_id();
			}
		}
		
		$this->db->trans_complete();
		
		return $new_ids;
	}
	
	function delete_events_for_company( $company )
	{
		$this->db->query( 'DELETE FROM company_events_tpl WHERE cet_company_id = ?', array( $company ) );
	}

	function delete_events_for_god()
	{
		$this->db->query( 'TRUNCATE TABLE events_tpl' );
	}

	function copy_events_from_company_to_god( $company )
	{
		$this->db->trans_start();
		
		$this->delete_events_for_god();
		
		$res = $this->get_from_company( 'events', $company, 'cet', OBJECT );
		
		if ( null != $res )
		{
			foreach ( $res as $row )
			{
				$fields = array( 'et_var', 'et_code', 'et_partition', 'et_zone', 'et_type', 'et_qualifier', 'et_emergency' );
				$values = array( $row->var, $row->code, $row->partition, $row->zone, $row->type, $row->qualifier, $row->emergency );
				
				$this->db->query( SQL::make_insert_pdo( 'events_tpl', $fields ), $values );
			}
		}
		
		$this->db->trans_complete();
	}

	function copy_events_from_company_to_company( $company )
	{
		$this->db->trans_start();
		
		$coms	= $this->db->get_results( 'SELECT com_id, com_name FROM company ORDER BY com_name ASC' );
		$res	= $this->get_from_company( 'events', $company, 'cet', OBJECT );
		
		foreach( $coms as $com )
		{
			if ( $com->com_id != $company )
			{
				$this->delete_events_for_company( $com->com_id );
				
				foreach ( $res as $row )
				{
					$fields = array( 'cet_var', 'cet_code', 'cet_partition', 'cet_zone', 'cet_company_id', 'cet_type', 'cet_qualifier', 'cet_emergency' );
					$values = array( $row->var, $row->code, $row->partition, $row->zone, $com->com_id, $row->type, $row->qualifier, $row->emergency );
					
					$this->db->query( SQL::make_insert_pdo( 'company_events_tpl', $fields ), $values );
				}
			}
		}
		
		$this->db->trans_complete();
	}

	function migrate_events_from_company( $company )
	{
		$this->copy_events_from_company_to_god( $company );
		$this->copy_events_from_company_to_company( $company );
	}

	function copy_events_from_hw_to_company( $hw_id, $com_id )
	{
		$this->db->trans_start();
		
		$this->delete_events_for_company( $com_id );
		
		$res	= $this->get_from_hw( 'events', $hw_id, OBJECT );
		
		foreach ( $res as $row )
		{
			$fields = array( 'cet_var', 'cet_code', 'cet_partition', 'cet_zone', 'cet_qualifier', 'cet_type', 'cet_emergency', 'cet_company_id' );
			$values = array( $row->var, $row->code, $row->partition, $row->zone, $row->qualifier, $row->type, $row->emergency, $com_id );
			
			$this->db->query( SQL::make_insert_pdo( 'company_events_tpl', $fields ), $values );
		}
		
		$this->db->trans_complete();
	}
}
