<?php
class Software_model extends CI_Model
{
	function soft_update_add( $hash, $size, $com_id )
	{
		$keys	= array( 'hash'	, 'size', 'company' );
		$values	= array( $hash	, $size, $com_id );
		
		$this->db->query( SQL::make_insert_pdo( 'soft_receiver', $keys, '', 'sr_' ), $values );
		
		return $this->db->last_insert_id();
	}
	
	function soft_update_get_last( $com_id )
	{
		return $this->db->get_row( 'SELECT * FROM soft_receiver WHERE sr_company = ? ORDER BY sr_id DESC LIMIT 1', OBJECT, array( $com_id ) );
	}
	
	function soft_config_add( $hash, $size, $com_id )
	{
		$keys	= array( 'hash'	, 'size', 'company' );
		$values	= array( $hash	, $size, $com_id );
		
		$this->db->query( SQL::make_insert_pdo( 'soft_config', $keys, '', 'sc_' ), $values );
		
		return $this->db->last_insert_id();
	}
	
	function soft_config_get_last( $com_id )
	{
		return $this->db->get_row( 'SELECT * FROM soft_config WHERE sc_company = ? ORDER BY sc_id DESC LIMIT 1', OBJECT, array( $com_id ) );
	}
	
	function soft_json_config_add( $hash, $size, $com_id )
	{
		$keys	= array( 'hash'	, 'size', 'company' );
		$values	= array( $hash	, $size, $com_id );
		
		$this->db->query( SQL::make_insert_pdo( 'soft_json_config', $keys, '', 'sjc_' ), $values );
		
		return $this->db->last_insert_id();
	}
	
	function soft_json_config_get_last( $com_id )
	{
		return $this->db->get_row( 'SELECT * FROM soft_json_config WHERE sjc_company = ? ORDER BY sjc_id DESC LIMIT 1', OBJECT, array( $com_id ) );
	}
	
	function soft_script_add( $hash, $size, $com_id )
	{
		$keys	= array( 'hash'	, 'size', 'company' );
		$values	= array( $hash	, $size, $com_id );
		
		$this->db->query( SQL::make_insert_pdo( 'soft_script', $keys, '', 'ss_' ), $values );
		
		return $this->db->last_insert_id();
	}
	
	function soft_script_get_last( $com_id )
	{
		return $this->db->get_row( 'SELECT * FROM soft_script WHERE ss_company = ? ORDER BY ss_id DESC LIMIT 1', OBJECT, array( $com_id ) );
	}
	
	public function delete_from_company( $com_id )
	{
		$this->db->query( 'DELETE FROM soft_config WHERE sc_company = ?', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM soft_script WHERE ss_company = ?', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM soft_receiver WHERE sr_company = ?', array( $com_id ) );
		
		$this->db->query( 'DELETE FROM soft_json_config WHERE sjc_company = ?', array( $com_id ) );
	}
	
	public function get_receivers_by_company()
	{
		$sql = "SELECT com_id, com_name, com_report, sr.* 
				FROM company 
				LEFT JOIN ( SELECT DISTINCT ON (sr_company) sr_id, sr_hash, sr_size, sr_company FROM soft_receiver ORDER BY sr_company ASC, sr_id DESC ) AS sr ON sr.sr_company = com_id
				ORDER BY com_name ASC";
				
		$res = $this->db->get_results( $sql, ARRAY_A );
		
		
		if ( isset( $res ) )
		{
			foreach ( $res as &$row )
			{
				if ( isset( $row['com_report'] ) )
				{
					$row['report'] = json_decode( $row['com_report'] );
				}
				else
				{
					$row['report'] = array();
				}
			}
		}
		
		return $res;
	}
}
