<?php

class RfidVisitEvent_model extends CI_Model
{
	public static $fields = array( 'urfid_id', 'time_start', 'time_end', 'name', 'desc' );
	
	public function add( $urfid_id, $name, $start, $end, $desc = '' )
	{
		$values = array( $urfid_id, $start, $end, $name, $desc );
		
		$this->db->query( SQL::make_insert_pdo( 'rfid_visit_event', self::$fields, '', 'rve_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function update( $rve_id, $name, $start, $end, $desc = '' )
	{
		$this->db->trans_start();
		
		$this->db->query( SQL::make_update_pdo( 'rfid_visit_event', array( 'name', 'time_start', 'time_end', 'desc', 'id' ), 'id', '', 'rve_' ), array( $name, $start, $end, $desc, $rve_id ) );
		
		$this->db->query( SQL::make_update_pdo( 'rfid_visit', array( 'time_start', 'time_end', 'rve_id' ), 'rve_id', '', 'rv_' ), array( $start, $end, $rve_id ) );
		
		$this->db->trans_complete();
	}
	
	public function get( $rve_id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_visit_event INNER JOIN rfid_user ON urfid_id = rve_urfid_id WHERE rve_id = ?', ARRAY_A, array( $rve_id ) );
	}
	
	public function delete( $rve_id )
	{
		$this->db->trans_start();
		
		$this->db->query( 'DELETE FROM rfid_visit_event WHERE rve_id = ?', array( $rve_id ) );
		
		$this->db->query( 'DELETE FROM rfid_visit WHERE rv_rve_id = ?', array( $rve_id ) );
		
		$this->db->trans_complete();
	}
}
