<?php

class RfidVisit_model extends CI_Model
{
	public static $fields = array( 'urfid_id', 'time_start', 'time_end', 'rve_id', 'parent_urfid_id' );
	
	public function add( $urfid_id, $start, $end, $rve_id, $parent_urfid_id )
	{
		$values = array( $urfid_id, $start, $end, $rve_id, $parent_urfid_id );
		
		$this->db->query( SQL::make_insert_pdo( 'rfid_visit', self::$fields, '', 'rv_' ), $values );
		
		return $this->db->insert_id();
	}
	
	public function delete( $rv_id )
	{
		$this->db->query( 'DELETE FROM rfid_visit WHERE rv_id = ?', array( $rv_id ) );
	}
	
	public function create( $com_id, $name, $start, $end, $rve_id, $dni, $parent_urfid_id, $plots )
	{
		load_model('RfidUser_model');
		load_model('RfidUserPlot_model');
		
		$urfid_user = NULL;
		
		if ( isset( $dni ) && !empty( $dni ) )
		{
			$urfid_user = $this->RfidUser_model->get_by_dni( $dni, $com_id );
		}
		
		if ( NULL == $urfid_user )
		{
			$urfid_id = $this->RfidUser_model->add( RfIdUserType::GUEST, $com_id, $name, $dni, '', '', '' );
			
			$urfid_user = $this->RfidUser_model->get( $urfid_id );
		}
		
		if ( isset( $plots ) && !empty( $plots ) )
		{
			foreach ( $plots as $plot )
			{
				$this->RfidUserPlot_model->add_opt( $urfid_user['urfid_id'], $plot );
			}
		}
		
		return $this->add( $urfid_user['urfid_id'], $start, $end, $rve_id, $parent_urfid_id );
	}
	
	public function update( $rv_id, $name, $start, $end, $dni = NULL )
	{
		load_model('RfidUser_model');
		
		$rv = $this->get( $rv_id );
		
		if ( isset( $rv ) )
		{
			$urfid_id = $rv['rv_urfid_id'];
			
			$this->RfidUser_model->update_name( $urfid_id, $name );
			
			if ( NULL != $dni && !empty( $dni ) )
			{
				$this->RfidUser_model->update_dni( $urfid_id, $dni );
			}
			
			$this->db->query( SQL::make_update_pdo( 'rfid_visit', array( 'time_start', 'time_end', 'id' ), 'id', '', 'rv_' ), array( $start, $end, $rv['rv_id'] ) );
		}
	}
	
	public function get_last_event_id( $com_id )
	{
		return intval( $this->db->get_var( "SELECT COALESCE(rv_rve_id),0) AS max_id FROM rfid_visit INNER JOIN rfid_user ON urfid_id = rv_urfid_id  WHERE urfid_com_id = ?", array( $com_id ) ) );
	}
	
	public function get_next_event_id( $com_id )
	{
		return $this->get_last_event_id() + 1;
	}
	
	public function get( $rv_id )
	{
		return $this->db->get_row( 'SELECT * FROM rfid_visit INNER JOIN rfid_user ON rv_urfid_id = urfid_id WHERE rv_id = ? LIMIT 1', ARRAY_A, array( $rv_id ) );
	}
	
	public function get_event( $rve_id )
	{
		return $this->db->get_results( 'SELECT * FROM rfid_visit INNER JOIN rfid_user ON rv_urfid_id = urfid_id WHERE rv_rve_id = ? ORDER BY urfid_name ASC', ARRAY_A, array( $rve_id ) );
	}
	
	public static function get_company_filter( $filter_company = NULL, $field_name = 'urfid_com_id' )
	{
		return SQL::get_or_filter( $filter_company, $field_name );
	}
	
	public function count( $filter_company, $filter = '' )
	{
		return $this->get_all( $filter_company, $filter, NULL, 1, TRUE );
	}
	
	public function get_all( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $is_count = FALSE )
	{
		load_model('RfidEvent_model');
		
		$where		= self::get_company_filter( $filter_company );
		$fields		= $is_count ? 'COUNT(*)' : '*';
		
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql1 = '
		SELECT rv_id AS id, urfid_name AS name, rv_time_start AS time_start, rv_time_end AS time_end, rv_rve_id AS rve_id, rv_parent_urfid_id AS parent_urfid_id, rfid_user.*, urfid_plot
				FROM rfid_visit 
				INNER JOIN rfid_user ON urfid_id = rv_urfid_id ' . RfidEvent_model::$basic_join . ' WHERE rv_rve_id = 0';
		
		$sql2 = '
		SELECT rve_id AS id, rve_name AS name, rve_time_start AS time_start, rve_time_end AS time_end, rve_id, rve_urfid_id AS parent_urfid_id, rfid_user.*, urfid_plot
				FROM rfid_visit_event
				INNER JOIN rfid_user ON urfid_id = rve_urfid_id ' . RfidEvent_model::$basic_join;
		
		$sql = "SELECT $fields FROM ( ( $sql1 ) UNION ALL ( $sql2 ) ) AS res $where";
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function count_visits( $filter_company, $filter = '' )
	{
		return $this->get_visits( $filter_company, $filter, NULL, 1, TRUE );
	}
	
	public function get_visits( $filter_company = NULL, $filter = NULL, $per_page = NULL, $page_num = 1, $is_count = FALSE )
	{
		load_model('RfidEvent_model');
		
		$where		= self::get_company_filter( $filter_company );
		$fields		= $is_count ? 'COUNT(*)' : '*';
		SQL::prepare_filter( $where, $filter, $is_count );
		
		$sql1 = '
		SELECT rv_id AS id, urfid_name AS name, rv_time_start AS time_start, rv_time_end AS time_end, rv_rve_id AS rve_id, rv_parent_urfid_id AS parent_urfid_id, rfid_user.*, urfid_plot
				FROM rfid_visit 
				INNER JOIN rfid_user ON urfid_id = rv_urfid_id ' . RfidEvent_model::$basic_join;
		
		$sql = "SELECT $fields FROM ( $sql1 ) AS res $where";
		
		if ( NULL != $per_page )
		{
			$sql .= ' LIMIT '. (string)intval( $per_page ) .
					' OFFSET '.(string)intval( ($page_num-1)*$per_page );
		}
		
		if ( $is_count )
		{
			return $this->db->get_var( $sql );
		}
		else
		{
			return $this->db->get_results( $sql, ARRAY_A );
		}
	}
	
	public function allowed( $urfid_id )
	{
		return NULL != $this->db->get_var( 'SELECT 1 FROM rfid_visit WHERE rv_urfid_id = ? AND rv_time_start <= ' . SQL::unix_timestamp() . ' AND rv_time_end >= ' . SQL::unix_timestamp() . ' LIMIT 1', array( $urfid_id ) );
	}
}
