<?php
class RfidUserTypeHours_model extends CI_Model
{
	public function get( $user_type, $rc_type )
	{
		$this->db->set_qd( array( $user_type, $rc_type ) );
		
		return $this->db->get_results( 'SELECT * FROM rfid_user_type_hours WHERE ruth_user_type = ? AND ruth_rc_type = ?' );
	}
	
	public function delete( $user_type, $rc_type )
	{
		return $this->db->query( 'DELETE FROM rfid_user_type_hours WHERE ruth_user_type = ? AND ruth_rc_type = ?', array( $user_type, $rc_type ) );
	}
	
	public function add( $user_type, $rc_type, $day, $hour_init, $hour_end )
	{
		$fields = array( 'user_type', 'rc_type', 'day', 'init', 'end' );
		$values = array( $user_type, $rc_type, $day, $hour_init, $hour_end );
		
		return $this->db->query( SQL::make_insert_pdo( 'rfid_user_type_hours', $fields, '', 'ruth_' ), $values );
	}
	
	public function save( $user_type, $rc_type, $form )
	{
		load_helper('hours');
		
		$this->db->trans_start();
		
		$this->delete( $user_type, $rc_type );
		
		foreach( HoursSlot::$DAYS as $day=>$day_n )
		{
			foreach( HoursSlot::$TURNS as $turn=>$turn_n )
			{
				$ini = sprintf("hours_%s_%s_%s", $turn, $day, 'ini');
				$fin = sprintf("hours_%s_%s_%s", $turn, $day, 'fin');
				
				$hour_init	= $form[$ini];
				$hour_end	= $form[$fin];
				$start		= strtotime('1970-1-1 ' . $hour_init);
				$end		= strtotime('1970-1-1 ' . $hour_end);
				
				if ( $turn == 'noc' && $hour_end == '00:00' )
				{
					$end		= strtotime('1970-1-2 ' . $hour_end);
				}

				if ( '' != $hour_init && '' != $hour_end && $end > $start )
				{
					$this->add( $user_type, $rc_type, $day, $hour_init, $hour_end );
				}
			}
		}
		
		$this->db->trans_complete();
	}
	
	public function build_hour_table( $user_type, $rc_type )
	{
		$arr = array();
		
		$hours = $this->get( $user_type, $rc_type );
		
		if ( isset( $hours ) )
		{
			foreach ( $hours as $hour )
			{
				$arr[ 'hours_' . HoursSlot::turn_from_hour( $hour->ruth_init, true ) . '_' . $hour->ruth_day . '_ini' ] = substr( $hour->ruth_init, 0, 5 );
				$arr[ 'hours_' . HoursSlot::turn_from_hour( $hour->ruth_end, false ) . '_' . $hour->ruth_day . '_fin' ] = substr( $hour->ruth_end , 0, 5 );
			}
		}
		
		return $arr;
	}
	
	public function hours_exists( $user_type, $rc_type )
	{
		return $this->db->get_var( 'SELECT 1 FROM rfid_user_type_hours WHERE ruth_user_type = ? AND ruth_rc_type = ? LIMIT 1', array( $user_type, $rc_type ) );
	}
	
	public function hours_get_day( $user_type, $rc_type, $day = 'today' )
	{
		if ( $day == 'today' )
		{
			$day = day2str( date( 'w' ) );
		}
		
		return $this->db->get_results( 'SELECT * FROM rfid_user_type_hours WHERE ruth_user_type = ? AND ruth_rc_type = ? AND ruth_day = ?', ARRAY_A, array( $user_type, $rc_type, $day ) );
	}
	
	public function is_simple_access( $user_type, $rc_type )
	{
		$hours	= $this->hours_get_day( $user_type, $rc_type );
		$now	= time();
		
		if ( isset( $hours ) )
		{
			foreach ( $hours as $hour )
			{
				$ini = strtotime( date( 'Y-m-d ' . $hour['ruth_init'] ) );
				$end = strtotime( date( 'Y-m-d ' . $hour['ruth_end']  ) );
				
				if ( $now >= $ini && $now <= $end )
				{
					return TRUE;
				}
			}
		}
		
		return FALSE;
	}
}
